package com.yx.tcbj.center.api;

import com.dtyunxi.rest.RestResponse;
import com.yx.tcbj.center.api.dto.request.PcpItemReqDto;
import com.yx.tcbj.center.api.dto.response.ItemBrandAuthCheckRespDto;
import com.yx.tcbj.center.api.dto.response.ItemBrandAuthReqAddDto;
import com.yx.tcbj.center.api.dto.response.ItemBrandAuthReqDeleteDto;
import com.yx.tcbj.center.api.dto.response.ItemBrandAuthRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;


@Api(tags = {"品牌方机构控制品牌上架"})
@FeignClient(
        contextId = "com-yx-tcbj-center-api-ItemBrandAuth",
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/ItemBrandAuth",
        url = "${yundt.cube.center.item.api:}"
)
public interface ItemBrandAuthApi {

    @PostMapping("/add")
    @ApiOperation(value = "新增")
    RestResponse<ItemBrandAuthRespDto> add(@Valid @RequestBody ItemBrandAuthReqAddDto reqDto);

    @PostMapping("/delete")
    @ApiOperation(value = "删除")
    RestResponse<Integer> delete(@RequestBody ItemBrandAuthReqDeleteDto reqDto);

    @PostMapping("/queryList")
    @ApiOperation(value = "列表查询")
    RestResponse<List<ItemBrandAuthRespDto>> queryList(@RequestBody ItemBrandAuthReqAddDto reqDto);

    @PostMapping("/queryById")
    @ApiOperation(value = "查询byId")
    RestResponse<ItemBrandAuthRespDto> queryById(@RequestBody ItemBrandAuthReqAddDto reqDto);

    @PostMapping("/update")
    @ApiOperation(value = "更新byId")
    RestResponse<ItemBrandAuthRespDto> update(@RequestBody ItemBrandAuthReqAddDto reqDto);

    @PostMapping("/insertOrUpdate")
    @ApiOperation(value = "新增or更新byId")
    RestResponse<ItemBrandAuthRespDto> insertOrUpdate(@RequestBody ItemBrandAuthReqAddDto reqDto);

    @PostMapping("/insertOrUpdateBatch")
    @ApiOperation(value = "新增or更新byId批量")
    RestResponse<Void> insertOrUpdateBatch(@RequestBody List<ItemBrandAuthReqAddDto> reqDto);

    @PostMapping("/itemBrandAuthCheck")
    @ApiOperation(value = "查询商品是否被限制上架")
    RestResponse<ItemBrandAuthCheckRespDto> itemBrandAuthCheck(@RequestBody ItemBrandAuthReqAddDto reqDto);
}
