package com.yx.tcbj.center.api.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
* 货品Eo对象
*
* @author yuangui
* @since 2022-05-23
*/
@ApiModel(value = "PcpItemReqDto", description = "货品Eo对象")
public class PcpItemReqDto extends RequestDto{
    /**
    *  主键ID
    */
    @ApiModelProperty(name = "id", value = "主键ID")
    private Long id;
    /**
    *  分组ID
    */
    @ApiModelProperty(name = "groupId", value = "分组ID")
    private Long groupId;
    /**
    *  商品长编码
    */
    @ApiModelProperty(name = "longCode", value = "商品长编码")
    private String longCode;
    /**
    *  编码
    */
    @ApiModelProperty(name = "code", value = "编码")
    private String code;
    /**
    *  商品货号
    */
    @ApiModelProperty(name = "artNo", value = "商品货号")
    private String artNo;
    /**
    *  商品条码
    */
    @ApiModelProperty(name = "barCode", value = "商品条码")
    private String barCode;
    /**
    *  是否串码管理
    */
    @ApiModelProperty(name = "imeiCodeFlag", value = "是否串码管理")
    private String imeiCodeFlag;
    /**
    *  1-有效 0-无效
    */
    @ApiModelProperty(name = "itemStatus", value = "1-有效 0-无效")
    private Long itemStatus;
    /**
    *  商品剂型 1-粉剂
    */
    @ApiModelProperty(name = "itemDrug", value = "商品剂型 1-粉剂")
    private Long itemDrug;
    /**
    *  标准批文
    */
    @ApiModelProperty(name = "standardApproval", value = "标准批文")
    private String standardApproval;
    /**
    *  旧批文
    */
    @ApiModelProperty(name = "oldApproval", value = "旧批文")
    private String oldApproval;
    /**
    *  1-产品 2-赠品 3-促销物料
    */
    @ApiModelProperty(name = "itemType", value = "1-产品 2-赠品 3-促销物料")
    private Long itemType;
    /**
    *  名称
    */
    @ApiModelProperty(name = "name", value = "名称")
    private String name;
    /**
    *  单位
    */
    @ApiModelProperty(name = "unit", value = "单位")
    private String unit;
    /**
    *  NC单位ID
    */
    @ApiModelProperty(name = "unitId", value = "NC单位ID")
    private Long unitId;
    /**
    *  建议零售价
    */
    @ApiModelProperty(name = "recommendPrice", value = "建议零售价")
    private BigDecimal recommendPrice;
    /**
    *  品牌编码
    */
    @ApiModelProperty(name = "brandCode", value = "品牌编码")
    private String brandCode;
    /**
    *  品牌名称
    */
    @ApiModelProperty(name = "brandName", value = "品牌名称")
    private String brandName;
    /**
    *  产地
    */
    @ApiModelProperty(name = "placeOfOrigin", value = "产地")
    private String placeOfOrigin;
    /**
    *  线下安全库存
    */
    @ApiModelProperty(name = "offlineSafetyStock", value = "线下安全库存")
    private BigDecimal offlineSafetyStock;
    /**
    *  安全库存策略，0-关闭，1-开启
    */
    @ApiModelProperty(name = "safetyStockStrategy", value = "安全库存策略，0-关闭，1-开启")
    private Integer safetyStockStrategy;
    /**
    *  是否线下可售，0-否，1-是
    */
    @ApiModelProperty(name = "ifAvailableOffline", value = "是否线下可售，0-否，1-是")
    private Integer ifAvailableOffline;
    /**
    *  防超卖库存数
    */
    @ApiModelProperty(name = "avoidOversoldInventory", value = "防超卖库存数")
    private BigDecimal avoidOversoldInventory;
    /**
    *  单渠道共享数
    */
    @ApiModelProperty(name = "singleChannelShare", value = "单渠道共享数")
    private BigDecimal singleChannelShare;
    /**
    *  单渠道共享指定店铺
    */
    @ApiModelProperty(name = "singleChannelShopId", value = "单渠道共享指定店铺")
    private Long singleChannelShopId;
    /**
    *  库存检查配置
    */
    @ApiModelProperty(name = "checkConfigId", value = "库存检查配置")
    private Long checkConfigId;
    /**
    *  珠海仓托盘数量
    */
    @ApiModelProperty(name = "zhTrayNum", value = "珠海仓托盘数量")
    private Long zhTrayNum;
    /**
    *  拆包配置
    */
    @ApiModelProperty(name = "packageSplitId", value = "拆包配置")
    private Long packageSplitId;
    /**
    *  重量
    */
    @ApiModelProperty(name = "quantity", value = "重量")
    private BigDecimal quantity;
    /**
    *  大包系数
    */
    @ApiModelProperty(name = "bigRatio", value = "大包系数")
    private Long bigRatio;
    /**
    *  中包系数
    */
    @ApiModelProperty(name = "middleRatio", value = "中包系数")
    private Long middleRatio;
    /**
    *  小包系数
    */
    @ApiModelProperty(name = "smallRatio", value = "小包系数")
    private Long smallRatio;
    /**
    *  防伪码
    */
    @ApiModelProperty(name = "securityCode", value = "防伪码")
    private String securityCode;
    /**
    *  保质期单位
    */
    @ApiModelProperty(name = "expirationUnit", value = "保质期单位")
    private String expirationUnit;
    /**
    *  保质期
    */
    @ApiModelProperty(name = "expirationDate", value = "保质期")
    private String expirationDate;
    /**
    *  是否免检
    */
    @ApiModelProperty(name = "exemption", value = "是否免检")
    private String exemption;
    /**
    *  体积
    */
    @ApiModelProperty(name = "volume", value = "体积")
    private BigDecimal volume;
    /**
    *  长
    */
    @ApiModelProperty(name = "length", value = "长")
    private BigDecimal length;
    /**
    *  宽
    */
    @ApiModelProperty(name = "width", value = "宽")
    private BigDecimal width;
    /**
    *  高
    */
    @ApiModelProperty(name = "height", value = "高")
    private BigDecimal height;
    /**
    *  长单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm
    */
    @ApiModelProperty(name = "lengthUnit", value = "长单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm")
    private String lengthUnit;
    /**
    *  高单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm
    */
    @ApiModelProperty(name = "heightUnit", value = "高单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm")
    private String heightUnit;
    /**
    *  宽单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm
    */
    @ApiModelProperty(name = "widthUnit", value = "宽单位，单位可选mm/cm/dm/m（毫米/厘米/分米/米），默认cm")
    private String widthUnit;
    /**
    *  重量单位
    */
    @ApiModelProperty(name = "quantityUnit", value = "重量单位")
    private String quantityUnit;
    /**
    *  所属客户编码
    */
    @ApiModelProperty(name = "customerNo", value = "所属客户编码")
    private String customerNo;
    /**
    *  货品详情
    */
    @ApiModelProperty(name = "detail", value = "货品详情")
    private String detail;
    /**
    *  运费模板(面向运营)
    */
    @ApiModelProperty(name = "shippingTplId", value = "运费模板(面向运营)")
    private Long shippingTplId;
    /**
    *  增值税率
    */
    @ApiModelProperty(name = "taxRate", value = "增值税率")
    private Integer taxRate;
    /**
    *  毛重
    */
    @ApiModelProperty(name = "grossWeight", value = "毛重")
    private BigDecimal grossWeight;
    /**
    *  毛重单位
    */
    @ApiModelProperty(name = "grossWeightUnit", value = "毛重单位")
    private String grossWeightUnit;
    /**
    *  净重
    */
    @ApiModelProperty(name = "netWeight", value = "净重")
    private BigDecimal netWeight;
    /**
    *  净重单位
    */
    @ApiModelProperty(name = "netWeightUnit", value = "净重单位")
    private String netWeightUnit;
    /**
    *  规格
    */
    @ApiModelProperty(name = "specification", value = "规格")
    private String specification;

    /**
     *  生产厂商
     */
    @ApiModelProperty(name = "cfproducers",value = "生产厂商")
    private String cfproducers;


    public void setId(Long id){
    this.id = id;
    }
    public Long getId(){
    return this.id;
    }
    public void setGroupId(Long groupId){
    this.groupId = groupId;
    }
    public Long getGroupId(){
    return this.groupId;
    }
    public void setLongCode(String longCode){
    this.longCode = longCode;
    }
    public String getLongCode(){
    return this.longCode;
    }
    public void setCode(String code){
    this.code = code;
    }
    public String getCode(){
    return this.code;
    }
    public void setArtNo(String artNo){
    this.artNo = artNo;
    }
    public String getArtNo(){
    return this.artNo;
    }
    public void setBarCode(String barCode){
    this.barCode = barCode;
    }
    public String getBarCode(){
    return this.barCode;
    }
    public void setImeiCodeFlag(String imeiCodeFlag){
    this.imeiCodeFlag = imeiCodeFlag;
    }
    public String getImeiCodeFlag(){
    return this.imeiCodeFlag;
    }
    public void setItemStatus(Long itemStatus){
    this.itemStatus = itemStatus;
    }
    public Long getItemStatus(){
    return this.itemStatus;
    }
    public void setItemDrug(Long itemDrug){
    this.itemDrug = itemDrug;
    }
    public Long getItemDrug(){
    return this.itemDrug;
    }
    public void setStandardApproval(String standardApproval){
    this.standardApproval = standardApproval;
    }
    public String getStandardApproval(){
    return this.standardApproval;
    }
    public void setOldApproval(String oldApproval){
    this.oldApproval = oldApproval;
    }
    public String getOldApproval(){
    return this.oldApproval;
    }
    public void setItemType(Long itemType){
    this.itemType = itemType;
    }
    public Long getItemType(){
    return this.itemType;
    }
    public void setName(String name){
    this.name = name;
    }
    public String getName(){
    return this.name;
    }
    public void setUnit(String unit){
    this.unit = unit;
    }
    public String getUnit(){
    return this.unit;
    }
    public void setUnitId(Long unitId){
    this.unitId = unitId;
    }
    public Long getUnitId(){
    return this.unitId;
    }
    public void setRecommendPrice(BigDecimal recommendPrice){
    this.recommendPrice = recommendPrice;
    }
    public BigDecimal getRecommendPrice(){
    return this.recommendPrice;
    }
    public void setBrandCode(String brandCode){
    this.brandCode = brandCode;
    }
    public String getBrandCode(){
    return this.brandCode;
    }
    public void setBrandName(String brandName){
    this.brandName = brandName;
    }
    public String getBrandName(){
    return this.brandName;
    }
    public void setPlaceOfOrigin(String placeOfOrigin){
    this.placeOfOrigin = placeOfOrigin;
    }
    public String getPlaceOfOrigin(){
    return this.placeOfOrigin;
    }
    public void setOfflineSafetyStock(BigDecimal offlineSafetyStock){
    this.offlineSafetyStock = offlineSafetyStock;
    }
    public BigDecimal getOfflineSafetyStock(){
    return this.offlineSafetyStock;
    }
    public void setSafetyStockStrategy(Integer safetyStockStrategy){
    this.safetyStockStrategy = safetyStockStrategy;
    }
    public Integer getSafetyStockStrategy(){
    return this.safetyStockStrategy;
    }
    public void setIfAvailableOffline(Integer ifAvailableOffline){
    this.ifAvailableOffline = ifAvailableOffline;
    }
    public Integer getIfAvailableOffline(){
    return this.ifAvailableOffline;
    }
    public void setAvoidOversoldInventory(BigDecimal avoidOversoldInventory){
    this.avoidOversoldInventory = avoidOversoldInventory;
    }
    public BigDecimal getAvoidOversoldInventory(){
    return this.avoidOversoldInventory;
    }
    public void setSingleChannelShare(BigDecimal singleChannelShare){
    this.singleChannelShare = singleChannelShare;
    }
    public BigDecimal getSingleChannelShare(){
    return this.singleChannelShare;
    }
    public void setSingleChannelShopId(Long singleChannelShopId){
    this.singleChannelShopId = singleChannelShopId;
    }
    public Long getSingleChannelShopId(){
    return this.singleChannelShopId;
    }
    public void setCheckConfigId(Long checkConfigId){
    this.checkConfigId = checkConfigId;
    }
    public Long getCheckConfigId(){
    return this.checkConfigId;
    }
    public void setZhTrayNum(Long zhTrayNum){
    this.zhTrayNum = zhTrayNum;
    }
    public Long getZhTrayNum(){
    return this.zhTrayNum;
    }
    public void setPackageSplitId(Long packageSplitId){
    this.packageSplitId = packageSplitId;
    }
    public Long getPackageSplitId(){
    return this.packageSplitId;
    }
    public void setQuantity(BigDecimal quantity){
    this.quantity = quantity;
    }
    public BigDecimal getQuantity(){
    return this.quantity;
    }
    public void setBigRatio(Long bigRatio){
    this.bigRatio = bigRatio;
    }
    public Long getBigRatio(){
    return this.bigRatio;
    }
    public void setMiddleRatio(Long middleRatio){
    this.middleRatio = middleRatio;
    }
    public Long getMiddleRatio(){
    return this.middleRatio;
    }
    public void setSmallRatio(Long smallRatio){
    this.smallRatio = smallRatio;
    }
    public Long getSmallRatio(){
    return this.smallRatio;
    }
    public void setSecurityCode(String securityCode){
    this.securityCode = securityCode;
    }
    public String getSecurityCode(){
    return this.securityCode;
    }
    public void setExpirationUnit(String expirationUnit){
    this.expirationUnit = expirationUnit;
    }
    public String getExpirationUnit(){
    return this.expirationUnit;
    }
    public void setExpirationDate(String expirationDate){
    this.expirationDate = expirationDate;
    }
    public String getExpirationDate(){
    return this.expirationDate;
    }
    public void setExemption(String exemption){
    this.exemption = exemption;
    }
    public String getExemption(){
    return this.exemption;
    }
    public void setVolume(BigDecimal volume){
    this.volume = volume;
    }
    public BigDecimal getVolume(){
    return this.volume;
    }
    public void setLength(BigDecimal length){
    this.length = length;
    }
    public BigDecimal getLength(){
    return this.length;
    }
    public void setWidth(BigDecimal width){
    this.width = width;
    }
    public BigDecimal getWidth(){
    return this.width;
    }
    public void setHeight(BigDecimal height){
    this.height = height;
    }
    public BigDecimal getHeight(){
    return this.height;
    }
    public void setLengthUnit(String lengthUnit){
    this.lengthUnit = lengthUnit;
    }
    public String getLengthUnit(){
    return this.lengthUnit;
    }
    public void setHeightUnit(String heightUnit){
    this.heightUnit = heightUnit;
    }
    public String getHeightUnit(){
    return this.heightUnit;
    }
    public void setWidthUnit(String widthUnit){
    this.widthUnit = widthUnit;
    }
    public String getWidthUnit(){
    return this.widthUnit;
    }
    public void setQuantityUnit(String quantityUnit){
    this.quantityUnit = quantityUnit;
    }
    public String getQuantityUnit(){
    return this.quantityUnit;
    }
    public void setCustomerNo(String customerNo){
    this.customerNo = customerNo;
    }
    public String getCustomerNo(){
    return this.customerNo;
    }
    public void setDetail(String detail){
    this.detail = detail;
    }
    public String getDetail(){
    return this.detail;
    }
    public void setShippingTplId(Long shippingTplId){
    this.shippingTplId = shippingTplId;
    }
    public Long getShippingTplId(){
    return this.shippingTplId;
    }
    public void setTaxRate(Integer taxRate){
    this.taxRate = taxRate;
    }
    public Integer getTaxRate(){
    return this.taxRate;
    }
    public void setGrossWeight(BigDecimal grossWeight){
    this.grossWeight = grossWeight;
    }
    public BigDecimal getGrossWeight(){
    return this.grossWeight;
    }
    public void setGrossWeightUnit(String grossWeightUnit){
    this.grossWeightUnit = grossWeightUnit;
    }
    public String getGrossWeightUnit(){
    return this.grossWeightUnit;
    }
    public void setNetWeight(BigDecimal netWeight){
    this.netWeight = netWeight;
    }
    public BigDecimal getNetWeight(){
    return this.netWeight;
    }
    public void setNetWeightUnit(String netWeightUnit){
    this.netWeightUnit = netWeightUnit;
    }
    public String getNetWeightUnit(){
    return this.netWeightUnit;
    }
    public void setSpecification(String specification){
    this.specification = specification;
    }
    public String getSpecification(){
    return this.specification;
    }

    public String getCfproducers() {
        return cfproducers;
    }

    public void setCfproducers(String cfproducers) {
        this.cfproducers = cfproducers;
    }
}
