/*
 * @(#)ItemSkuExcludeReqDto.java 1.0 2021年10月17日
 *
 *  Copyright (c) 2016, YUNXI. All rights reserved.
 *  YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.yx.tcbj.center.api.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * <p>Title:ItemSkuExcludeReqDto</p>
 * <p>Description: </p>
 *
 * @author 顼阳
 * @date 2021/10/17 4:20 下午
 * @since 0.1.0
 */
@ApiModel(value = "ItemSkuExcludeReqDto", description = "商品排除搜索")
public class ItemSkuExcludeReqDto {

    @ApiModelProperty(name = "outSkuIds", value = "排除skuid")
    private List<Long> outSkuIds;
    @ApiModelProperty(name = "skuIds", value = "包含skuid")
    private List<Long> skuIds;
    @ApiModelProperty(name = "itemName", value = "类似搜索")
    private String itemName;
    @ApiModelProperty(name = "itemCode", value = "类似搜索")
    private String itemCode;
    @ApiModelProperty(name = "itemCodes", value = "商品编码类似搜索")
    private List<String> itemCodes;
    @ApiModelProperty(name = "skuCode", value = "类似搜索")
    private String skuCode;
    @ApiModelProperty(name = "dirIds", value = "包含目录")
    private List<Long> dirIds;
    @ApiModelProperty(name = "backDirIds", value = "排除目录")
    private List<Long> backDirIds;
    @ApiModelProperty(name = "sellerIds", value = "卖家")
    private List<Long> sellerIds;
    private Integer pageNum;
    private Integer pageSize;
    private Integer busType;
    private Long instanceId;
    private Long tenantId;
    private Long shopId;
    @ApiModelProperty(name = "brandId", value = "品牌")
    private Long brandId;
    @ApiModelProperty(name = "excludeShopIds", value = "排除商品")
    private List<Long> excludeShopIds;
    private Integer subType;
    private Long orgId;

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public List<Long> getOutSkuIds() {
        return outSkuIds;
    }

    public void setOutSkuIds(List<Long> outSkuIds) {
        this.outSkuIds = outSkuIds;
    }

    public List<Long> getSkuIds() {
        return skuIds;
    }

    public void setSkuIds(List<Long> skuIds) {
        this.skuIds = skuIds;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getItemCode() {
        return itemCode;
    }

    public void setItemCode(String itemCode) {
        this.itemCode = itemCode;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public List<Long> getDirIds() {
        return dirIds;
    }

    public void setDirIds(List<Long> dirIds) {
        this.dirIds = dirIds;
    }

    public List<Long> getBackDirIds() {
        return backDirIds;
    }

    public void setBackDirIds(List<Long> backDirIds) {
        this.backDirIds = backDirIds;
    }

    public List<Long> getSellerIds() {
        return sellerIds;
    }

    public void setSellerIds(List<Long> sellerIds) {
        this.sellerIds = sellerIds;
    }

    public Integer getPageNum() {
        return pageNum;
    }

    public void setPageNum(Integer pageNum) {
        this.pageNum = pageNum;
    }

    public Integer getPageSize() {
        return pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public Integer getBusType() {
        return busType;
    }

    public void setBusType(Integer busType) {
        this.busType = busType;
    }

    public Long getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public List<Long> getExcludeShopIds() {
        return excludeShopIds;
    }

    public void setExcludeShopIds(List<Long> excludeShopIds) {
        this.excludeShopIds = excludeShopIds;
    }

    public Integer getSubType() {
        return subType;
    }

    public void setSubType(Integer subType) {
        this.subType = subType;
    }

    public List<String> getItemCodes() {
        return itemCodes;
    }

    public void setItemCodes(List<String> itemCodes) {
        this.itemCodes = itemCodes;
    }
}
