package com.yx.tcbj.center.api;

import com.dtyunxi.rest.RestResponse;
import com.yx.tcbj.center.api.dto.request.ItemBrandAuthCheckItemsReqDto;
import com.yx.tcbj.center.api.dto.response.ItemBrandAuthCheckItemsRespDto;
import com.yx.tcbj.center.api.dto.response.ItemBrandAuthCheckRespDto;
import com.yx.tcbj.center.api.dto.request.ItemBrandAuthAddReqDto;
import com.yx.tcbj.center.api.dto.request.ItemBrandAuthDeleteReqDto;
import com.yx.tcbj.center.api.dto.response.ItemBrandAuthRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;


@Api(tags = {"品牌方机构控制品牌上架"})
@FeignClient(
        contextId = "com-yx-tcbj-center-api-ItemBrandAuth",
        name = "${yundt.cube.center.item.api.name:yundt-cube-center-item}",
        path = "/v1/ItemBrandAuth",
        url = "${yundt.cube.center.item.api:}"
)
public interface ItemBrandAuthApi {

    @PostMapping("/add")
    @ApiOperation(value = "新增")
    RestResponse<ItemBrandAuthRespDto> add(@Valid @RequestBody ItemBrandAuthAddReqDto reqDto);

    @PostMapping("/delete")
    @ApiOperation(value = "删除")
    RestResponse<Integer> delete(@RequestBody ItemBrandAuthDeleteReqDto reqDto);

    @PostMapping("/queryList")
    @ApiOperation(value = "列表查询")
    RestResponse<List<ItemBrandAuthRespDto>> queryList(@RequestBody ItemBrandAuthAddReqDto reqDto);

    @PostMapping("/queryById")
    @ApiOperation(value = "查询byId")
    RestResponse<ItemBrandAuthRespDto> queryById(@RequestBody ItemBrandAuthAddReqDto reqDto);

    @PostMapping("/update")
    @ApiOperation(value = "更新byId")
    RestResponse<ItemBrandAuthRespDto> update(@RequestBody ItemBrandAuthAddReqDto reqDto);

    @PostMapping("/insertOrUpdate")
    @ApiOperation(value = "新增or更新byId")
    RestResponse<ItemBrandAuthRespDto> insertOrUpdate(@RequestBody ItemBrandAuthAddReqDto reqDto);

    @PostMapping("/insertOrUpdateBatch")
    @ApiOperation(value = "新增or更新byId批量")
    RestResponse<Void> insertOrUpdateBatch(@RequestBody List<ItemBrandAuthAddReqDto> reqDto);

    @PostMapping("/itemBrandAuthCheck")
    @ApiOperation(value = "查询商品是否被限制上架")
    RestResponse<ItemBrandAuthCheckRespDto> itemBrandAuthCheck(@Valid @RequestBody ItemBrandAuthAddReqDto reqDto);

    @PostMapping("/itemBrandAuthCheckItems")
    @ApiOperation(value = "商品列表按授权配置过滤")
    RestResponse<ItemBrandAuthCheckItemsRespDto> itemBrandAuthCheckItems(@Valid @RequestBody ItemBrandAuthCheckItemsReqDto reqDto);

    @PostMapping("/checkBrandsExist")
    @ApiOperation(value = "校验品牌是否存在")
    RestResponse<List<String>> checkBrandsExist(@RequestBody List<String> brandNames);

    @GetMapping("/queryBrandsByName")
    @ApiOperation(value = "根据品牌名称查询品牌信息")
    RestResponse<List<com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BrandRespDto>> queryBrandsByName(@RequestParam("brandName") String brandName);
}
