/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.impl;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemStorageRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemExceptionCode;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.ItemConstant;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.ItemType;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemMainReqDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.util.ItemStorageUtils;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemPresentService;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemMediasDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemSkuDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemStorageDas;
import com.dtyunxi.yundt.cube.center.item.dao.das.ItemChannelDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.ItemChannelEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemMediasEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemMediasEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemSkuEo;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class IItemPresentServiceImpl
implements IItemPresentService {
    @Resource
    private ItemDas itemDas;
    @Resource
    private ItemChannelDas itemChannelDas;
    @Resource
    private ItemMediasDas itemMediasDas;
    @Resource
    private ItemStorageUtils itemStorageUtils;
    @Resource
    private ItemSkuDas itemSkuDas;
    @Resource
    private ItemStorageDas itemStorageDas;
    @Resource
    private ICacheService cacheService;

    @Override
    public PageInfo<ItemRespDto> presentItemPage(ItemMainReqDto mainReqDto) {
        ExtQueryChainWrapper sqlFilterList = this.itemDas.filter();
        this.setQueryCondition((ExtQueryChainWrapper<ItemEo>)sqlFilterList, mainReqDto);
        PageInfo eoPageInfo = sqlFilterList.page(mainReqDto.getPage(), mainReqDto.getSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemRespDto.class);
        List<Long> itemIds = dtoList.stream().map(ItemRespDto::getId).collect(Collectors.toList());
        Map<Long, List<ItemStorageRespDto>> itemStorageRespDtoMap = this.getItemStorageByItemIds(itemIds);
        Collection channelEoList = null;
        Collection itemSkuEoList = null;
        List itemMediasEoList = new ArrayList();
        if (!CollectionUtils.isEmpty(itemIds)) {
            channelEoList = ((ExtQueryChainWrapper)this.itemChannelDas.filter().in((Object)"item_id", itemIds)).list();
            itemSkuEoList = ((ExtQueryChainWrapper)this.itemSkuDas.filter().in((Object)"item_id", itemIds)).list();
            itemMediasEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemMediasDas.filter().in((Object)"item_id", itemIds)).eq((Object)"file_type", (Object)0)).list();
        }
        Map<Object, Object> channelEoMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(channelEoList)) {
            channelEoMap = channelEoList.stream().collect(Collectors.groupingBy(ItemChannelEo::getItemId));
        }
        Map<Object, Object> itemSkuEoMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(itemSkuEoList)) {
            itemSkuEoMap = itemSkuEoList.stream().collect(Collectors.groupingBy(StdItemSkuEo::getItemId));
        }
        Map<Long, List<ItemMediasEo>> itemMediasMap = ((List)Optional.ofNullable(itemMediasEoList).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(StdItemMediasEo::getItemId));
        if (!CollectionUtils.isEmpty(dtoList)) {
            Map<Object, Object> finalChannelEoMap = channelEoMap;
            Map<Object, Object> finalItemSkuEoMap = itemSkuEoMap;
            dtoList.stream().forEach(v -> {
                if (!CollectionUtils.isEmpty((Map)finalChannelEoMap) && finalChannelEoMap.get(v.getId()) != null) {
                    List itemChannelEos = (List)finalChannelEoMap.get(v.getId());
                    List platforms = itemChannelEos.stream().map(ItemChannelEo::getPlatformName).distinct().collect(Collectors.toList());
                    List platformIds = itemChannelEos.stream().map(ItemChannelEo::getPlatformId).distinct().collect(Collectors.toList());
                    v.setPlatforms(Joiner.on((String)",").join(platforms));
                    v.setPlatformIds(Joiner.on((String)",").join(platformIds));
                    v.setPlatformNames(Joiner.on((String)",").join(platforms));
                }
                if (itemMediasMap.containsKey(v.getId())) {
                    List itemMediasEo = (List)itemMediasMap.get(v.getId());
                    v.setMainPic(((ItemMediasEo)itemMediasEo.get(0)).getPath1());
                }
                v.setItemId(v.getId());
                v.setItemCode(v.getCode());
                v.setItemName(v.getName());
                if (!CollectionUtils.isEmpty((Map)itemStorageRespDtoMap)) {
                    List storageRespDtos = (List)itemStorageRespDtoMap.get(v.getItemId());
                    v.setAvaNum(Long.valueOf(CollectionUtils.isEmpty((Collection)storageRespDtos) ? 0L : ((ItemStorageRespDto)storageRespDtos.get(0)).getBalance()));
                }
                if (!CollectionUtils.isEmpty((Map)finalItemSkuEoMap)) {
                    ArrayList skuRespDtoList = new ArrayList();
                    List skuEoList = (List)finalItemSkuEoMap.get(v.getId());
                    CubeBeanUtils.copyCollection(skuRespDtoList, (Collection)skuEoList, ItemSkuRespDto.class);
                    Long skuId = CollectionUtils.isEmpty(skuRespDtoList) ? null : ((ItemSkuRespDto)skuRespDtoList.get(0)).getId();
                    Long avaNum = this.itemStorageUtils.queryItemStorage(v.getShopId(), skuId);
                    if (avaNum == null || avaNum == 0L) {
                        v.setAvaNum(Long.valueOf(!CollectionUtils.isEmpty(skuRespDtoList) ? (((ItemSkuRespDto)skuRespDtoList.get(0)).getInventoryQuantity() == null ? 0L : ((ItemSkuRespDto)skuRespDtoList.get(0)).getInventoryQuantity()) : 0L));
                    } else {
                        v.setAvaNum(avaNum);
                    }
                    v.setItemSkuList(skuRespDtoList);
                }
                v.setShopId(v.getShopId() == null ? ItemConstant.SHOP_ID : v.getShopId());
            });
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    private void setQueryCondition(ExtQueryChainWrapper<ItemEo> sqlFilterList, ItemMainReqDto mainReqDto) {
        if (StringUtils.isNotBlank((CharSequence)mainReqDto.getItemName())) {
            sqlFilterList.like((Object)"name", (Object)("%" + mainReqDto.getItemName() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)mainReqDto.getItemCode())) {
            sqlFilterList.like((Object)"code", (Object)("%" + mainReqDto.getItemCode() + "%"));
        }
        if (!CollectionUtils.isEmpty((Collection)mainReqDto.getItemCodes())) {
            sqlFilterList.in((Object)"code", (Collection)mainReqDto.getItemCodes());
        }
        if (null != mainReqDto.getDirId()) {
            sqlFilterList.eq((Object)"dir_id", (Object)mainReqDto.getDirId());
        }
        if (StringUtils.isNotBlank((CharSequence)mainReqDto.getProdLargeClass())) {
            sqlFilterList.like((Object)"prod_large_class", (Object)("%" + mainReqDto.getProdLargeClass() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)mainReqDto.getProdLargeCode())) {
            sqlFilterList.like((Object)"prod_large_code", (Object)("%" + mainReqDto.getProdLargeCode() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)mainReqDto.getProdSecClassify())) {
            sqlFilterList.like((Object)"prod_sec_classify", (Object)("%" + mainReqDto.getProdSecClassify() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)mainReqDto.getProdSecCode())) {
            sqlFilterList.like((Object)"prod_sec_code", (Object)("%" + mainReqDto.getProdSecCode() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)mainReqDto.getProdThrClassify())) {
            sqlFilterList.like((Object)"prod_thr_classify", (Object)("%" + mainReqDto.getProdThrClassify() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)mainReqDto.getProdThrCode())) {
            sqlFilterList.like((Object)"prod_thr_code", (Object)("%" + mainReqDto.getProdThrCode() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)mainReqDto.getProdClassCode())) {
            sqlFilterList.like((Object)"prod_class_code", (Object)("%" + mainReqDto.getProdClassCode() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)mainReqDto.getProdClassName())) {
            sqlFilterList.like((Object)"prod_class_name", (Object)("%" + mainReqDto.getProdClassName() + "%"));
        }
        if (mainReqDto.getDirPrefixId() != null) {
            sqlFilterList.eq((Object)"dir_prefix_id", (Object)mainReqDto.getDirPrefixId());
        }
        if (StringUtils.isNotBlank((CharSequence)mainReqDto.getAddBeginTime())) {
            sqlFilterList.ge((Object)"add_time", (Object)mainReqDto.getAddBeginTime());
        }
        if (StringUtils.isNotBlank((CharSequence)mainReqDto.getAddEndTime())) {
            sqlFilterList.le((Object)"add_time", (Object)mainReqDto.getAddEndTime());
        }
        if ("promote".equals(mainReqDto.getForward())) {
            sqlFilterList.eq((Object)"status", (Object)ItemStatus.ON_LINE.getStatus());
        } else {
            sqlFilterList.eq((Object)"type", (Object)ItemType.GIF_ITEM.getStatus());
            sqlFilterList.orderByDesc((Object)"add_time");
        }
        if (StringUtils.isNotBlank((CharSequence)mainReqDto.getKeyword())) {
            StringBuilder sql = new StringBuilder();
            sql.append(" ( ");
            sql.append("code like '%" + mainReqDto.getKeyword() + "%' or name like '%" + mainReqDto.getKeyword() + "%'");
            sql.append(")");
            sqlFilterList.apply(sql.toString(), new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)mainReqDto.getGasClass())) {
            sqlFilterList.eq((Object)"gas_class", (Object)mainReqDto.getGasClass());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void putUpPresent(List<Long> itemIds) {
        itemIds.stream().forEach(v -> {
            ItemEo itemEo = new ItemEo();
            itemEo.setId(v);
            itemEo.setType(ItemType.GIF_ITEM.getStatus());
            itemEo.setAddTime(new Date());
            this.itemDas.updateSelective((BaseEo)itemEo);
        });
        this.cacheService.delCacheByPattern("item_trade_", "*");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long deletePresent(Long itemId) {
        ItemEo itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(itemId);
        if (itemEo == null) {
            throw new BizException(ItemExceptionCode.NON_EXIST_ITEM.getCode(), ItemExceptionCode.NON_EXIST_ITEM.getMsg());
        }
        itemEo.setType(ItemType.GENERAL_ITEM.getStatus());
        this.itemDas.updateSelective((BaseEo)itemEo);
        this.cacheService.delCacheByPattern("item_trade_", "*");
        return itemEo.getId();
    }

    @Override
    public PageInfo<ItemRespDto> queryByPage(ItemMainReqDto mainReqDto) {
        ExtQueryChainWrapper sqlFilterList = (ExtQueryChainWrapper)this.itemDas.filter().orderByDesc((Object)"update_time");
        if (StringUtils.isNotBlank((CharSequence)mainReqDto.getItemName())) {
            sqlFilterList.like((Object)"name", (Object)("%" + mainReqDto.getItemName() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)mainReqDto.getItemCode())) {
            if (mainReqDto.getItemCode().contains(",")) {
                Object[] codes = mainReqDto.getItemCode().split(",");
                sqlFilterList.in((Object)"code", codes);
            } else {
                sqlFilterList.like((Object)"code", (Object)("%" + mainReqDto.getItemCode() + "%"));
            }
        }
        if (null != mainReqDto.getDirId()) {
            sqlFilterList.eq((Object)"dir_id", (Object)mainReqDto.getDirId());
        }
        if (null != mainReqDto.getDirPrefixId()) {
            sqlFilterList.eq((Object)"dir_prefix_id", (Object)mainReqDto.getDirPrefixId());
        }
        if (null != mainReqDto.getUpdateBeginTime()) {
            sqlFilterList.ge((Object)"update_time", (Object)mainReqDto.getUpdateBeginTime());
        }
        if (null != mainReqDto.getUpdateEndTime()) {
            sqlFilterList.le((Object)"update_time", (Object)mainReqDto.getUpdateBeginTime());
        }
        sqlFilterList.ne((Object)"type", (Object)ItemType.COMB_ITEM.getStatus());
        sqlFilterList.ne((Object)"type", (Object)ItemType.GIF_ITEM.getStatus());
        PageInfo eoPageInfo = sqlFilterList.page(mainReqDto.getPage(), mainReqDto.getSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    private Map<Long, List<ItemStorageRespDto>> getItemStorageByItemIds(List<Long> itemIds) {
        Map<Long, List<ItemStorageRespDto>> itemStorageRespDtoMap = new HashMap<Long, List<ItemStorageRespDto>>(16);
        if (!CollectionUtils.isEmpty(itemIds)) {
            List itemStorageEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemStorageDas.filter().in((Object)"item_id", itemIds)).orderByDesc((Object)"update_time")).list();
            if (CollectionUtils.isEmpty((Collection)itemStorageEos)) {
                return itemStorageRespDtoMap;
            }
            ArrayList itemStorageRespDtos = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)itemStorageRespDtos, (Collection)itemStorageEos, ItemStorageRespDto.class);
            itemStorageRespDtoMap = itemStorageRespDtos.stream().collect(Collectors.groupingBy(ItemStorageRespDto::getItemId));
        }
        return itemStorageRespDtoMap;
    }
}

