/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.google.common.base.Throwables;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.commons.exceptions.ExceptionCode;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.dto.response.EmpowerPlatformRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.query.IEmpowerPlatformQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.ChannelStatus;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.ItemRelationState;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.ItemType;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.RelationType;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemChannelRelationReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemComparisonRelationReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemExtRelationComparisonReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemRelationQueryConditionReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemCenterListRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemComparisonRelationRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemExtRelationComparisonRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemRelationExcelRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemRelationInfoRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemSkuPriceRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.RItemBundleRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.util.EasyPoiExportUtil;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemExtRelationComparisonService;
import com.dtyunxi.yundt.cube.center.item.biz.utils.Assert;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemSkuDas;
import com.dtyunxi.yundt.cube.center.item.dao.das.ItemExtRelationComparisonDas;
import com.dtyunxi.yundt.cube.center.item.dao.das.ItemShopPlatformRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.das.RItemBundleDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.ItemExtRelationComparisonEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.ItemShopPlatformRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.RItemBundleEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.vo.ItemRelationQueryReqVo;
import com.dtyunxi.yundt.cube.center.item.dao.vo.ItemSkuPriceRespVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ItemExtRelationComparisonServiceImpl
implements IItemExtRelationComparisonService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ItemExtRelationComparisonDas itemExtRelationComparisonDas;
    @Resource
    private ItemDas itemDas;
    @Resource
    private ItemShopPlatformRelationDas platformRelationDas;
    @Resource
    private ItemSkuDas itemSkuDas;
    @Resource
    private IEmpowerPlatformQueryApi platformQueryApi;
    @Resource
    private ILockService lockService;
    @Resource
    private RItemBundleDas rItemBundleDas;

    @Override
    public Long addItemRelationComparison(ItemExtRelationComparisonReqDto addReqDto) {
        this.addItemRelationRepeatCheck(addReqDto);
        ItemExtRelationComparisonEo itemExtRelationComparisonEo = new ItemExtRelationComparisonEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)itemExtRelationComparisonEo);
        this.itemExtRelationComparisonDas.insert((BaseEo)itemExtRelationComparisonEo);
        return itemExtRelationComparisonEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addComparisonRelation(ItemComparisonRelationReqDto relationReqDto) {
        ItemExtRelationComparisonEo comparisonEo = new ItemExtRelationComparisonEo();
        try {
            if (relationReqDto.getId() != null && relationReqDto.getId() > 0L) {
                comparisonEo = (ItemExtRelationComparisonEo)this.itemExtRelationComparisonDas.selectByPrimaryKey(relationReqDto.getId());
            }
            comparisonEo.setItemCode(relationReqDto.getCode());
            comparisonEo.setSkuCode(relationReqDto.getCode());
            List itemShopPlatformsList = relationReqDto.getItemShopPlatforms();
            ArrayList relationEoList = new ArrayList();
            if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)itemShopPlatformsList)) {
                List platformNames = itemShopPlatformsList.stream().map(ItemComparisonRelationReqDto.ItemShopPlatforms::getPlatformName).distinct().collect(Collectors.toList()).stream().filter(c -> StringUtils.isNotBlank((CharSequence)c)).collect(Collectors.toList());
                List shopCodes = itemShopPlatformsList.stream().map(ItemComparisonRelationReqDto.ItemShopPlatforms::getShopCode).distinct().collect(Collectors.toList()).stream().filter(c -> StringUtils.isNotBlank((CharSequence)c)).collect(Collectors.toList());
                List shopNames = itemShopPlatformsList.stream().map(ItemComparisonRelationReqDto.ItemShopPlatforms::getShopName).distinct().collect(Collectors.toList()).stream().filter(c -> StringUtils.isNotBlank((CharSequence)c)).collect(Collectors.toList());
                comparisonEo.setChannelCode(org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)relationReqDto.getChannelCodes()) ? String.join((CharSequence)",", relationReqDto.getChannelCodes()) : null);
                comparisonEo.setChannelName(org.apache.commons.collections.CollectionUtils.isNotEmpty(platformNames) ? String.join((CharSequence)",", platformNames) : null);
                comparisonEo.setShopCode(org.apache.commons.collections.CollectionUtils.isNotEmpty(shopCodes) ? String.join((CharSequence)",", shopCodes) : null);
                comparisonEo.setShopName(org.apache.commons.collections.CollectionUtils.isNotEmpty(shopNames) ? String.join((CharSequence)",", shopNames) : null);
                comparisonEo.setSkuCode(relationReqDto.getCode());
                comparisonEo.setRelationType(RelationType.PROD_ITEM.getStatus());
                comparisonEo.setChannelStatus(ChannelStatus.OPEN.getStatus());
                List channelItemCodes = itemShopPlatformsList.stream().map(ItemComparisonRelationReqDto.ItemShopPlatforms::getChannelItemCode).distinct().collect(Collectors.toList()).stream().filter(c -> StringUtils.isNotBlank((CharSequence)c)).collect(Collectors.toList());
                List channelItemNames = itemShopPlatformsList.stream().map(ItemComparisonRelationReqDto.ItemShopPlatforms::getChannelItemName).distinct().collect(Collectors.toList()).stream().filter(c -> StringUtils.isNotBlank((CharSequence)c)).collect(Collectors.toList());
                comparisonEo.setChannelItemCode(org.apache.commons.collections.CollectionUtils.isNotEmpty(channelItemCodes) ? String.join((CharSequence)",", channelItemCodes) : null);
                comparisonEo.setChannelItemName(org.apache.commons.collections.CollectionUtils.isNotEmpty(channelItemNames) ? String.join((CharSequence)",", channelItemNames) : null);
                comparisonEo.setChannelSkuCode(org.apache.commons.collections.CollectionUtils.isNotEmpty(channelItemCodes) ? String.join((CharSequence)",", channelItemCodes) : null);
                if (relationReqDto.getId() != null && relationReqDto.getId() > 0L) {
                    this.itemExtRelationComparisonDas.updateSelective((BaseEo)comparisonEo);
                } else {
                    this.itemExtRelationComparisonDas.insert((BaseEo)comparisonEo);
                }
                ItemExtRelationComparisonEo finalComparisonEo = comparisonEo;
                itemShopPlatformsList.forEach(v -> {
                    ItemShopPlatformRelationEo relationEo = new ItemShopPlatformRelationEo();
                    relationEo.setComparisonId(finalComparisonEo.getId());
                    relationEo.setChannelCode(v.getPlatformCode());
                    relationEo.setChannelName(v.getPlatformName());
                    relationEo.setChannelItemCode(v.getChannelItemCode());
                    relationEo.setChannelItemName(v.getChannelItemName());
                    relationEo.setShopId(v.getShopId());
                    relationEo.setShopCode(v.getShopCode());
                    relationEo.setShopName(v.getShopName());
                    relationEo.setSkuId(relationReqDto.getCode());
                    relationEoList.add(relationEo);
                });
                ItemShopPlatformRelationEo platformRelationEo = new ItemShopPlatformRelationEo();
                platformRelationEo.setComparisonId(comparisonEo.getId());
                this.platformRelationDas.delete((BaseEo)platformRelationEo);
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(relationEoList)) {
                    this.platformRelationDas.insertBatch(relationEoList);
                }
            }
        }
        catch (Exception e) {
            throw new BizException(Throwables.getStackTraceAsString((Throwable)e));
        }
        return comparisonEo.getId();
    }

    @Override
    public void modifyItemRelationComparison(ItemExtRelationComparisonReqDto modifyReqDto) {
        this.updateItemRelationRepeatCheck(modifyReqDto);
        ItemExtRelationComparisonEo itemRelationComparisonEo = new ItemExtRelationComparisonEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)itemRelationComparisonEo);
        this.itemExtRelationComparisonDas.updateSelective((BaseEo)itemRelationComparisonEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeItemRelationComparison(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.itemExtRelationComparisonDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeItemRelationComparison(List<Long> ids) {
        this.itemExtRelationComparisonDas.logicDeleteByIds(ids);
    }

    @Override
    public ItemExtRelationComparisonRespDto queryById(Long id) {
        ItemExtRelationComparisonEo itemRelationComparisonEo = (ItemExtRelationComparisonEo)this.itemExtRelationComparisonDas.selectByPrimaryKey(id);
        ItemExtRelationComparisonRespDto itemRelationComparisonRespDto = new ItemExtRelationComparisonRespDto();
        DtoHelper.eo2Dto((BaseEo)itemRelationComparisonEo, (BaseVo)itemRelationComparisonRespDto);
        return itemRelationComparisonRespDto;
    }

    @Override
    public ItemComparisonRelationRespDto queryRelationById(Long id) {
        ItemComparisonRelationRespDto relationRespDto = new ItemComparisonRelationRespDto();
        ItemExtRelationComparisonEo comparisonEo = (ItemExtRelationComparisonEo)this.itemExtRelationComparisonDas.selectByPrimaryKey(id);
        if (comparisonEo == null) {
            return relationRespDto;
        }
        relationRespDto.setId(comparisonEo.getId());
        relationRespDto.setCode(comparisonEo.getItemCode());
        ItemEo it = new ItemEo();
        it.setCode(comparisonEo.getItemCode());
        ItemEo itemEo = (ItemEo)this.itemDas.selectOne((BaseEo)it);
        relationRespDto.setName(itemEo != null ? itemEo.getName() : null);
        ItemShopPlatformRelationEo relationEo = new ItemShopPlatformRelationEo();
        relationEo.setComparisonId(comparisonEo.getId());
        ArrayList itemShopPlatforms = new ArrayList();
        List relationEoList = this.platformRelationDas.select((BaseEo)relationEo);
        List channelCodes = relationEoList.stream().map(ItemShopPlatformRelationEo::getChannelCode).collect(Collectors.toList());
        RestResponse restResponse = this.platformQueryApi.queryByCodes(channelCodes);
        List platformRespDtos = (List)RestResponseHelper.extractData((RestResponse)restResponse);
        Map platformRespDtoMap = platformRespDtos.stream().collect(Collectors.toMap(EmpowerPlatformRespDto::getCode, Function.identity(), (k1, k2) -> k1));
        relationEoList.stream().forEach(v -> {
            ItemComparisonRelationRespDto.ItemShopPlatforms platforms = new ItemComparisonRelationRespDto.ItemShopPlatforms();
            platforms.setId(v.getId());
            platforms.setComparisonId(comparisonEo.getId());
            if (!CollectionUtils.isEmpty((Map)platformRespDtoMap)) {
                platforms.setPlatformId(platformRespDtoMap.get(v.getChannelCode()) != null ? String.valueOf(((EmpowerPlatformRespDto)platformRespDtoMap.get(v.getChannelCode())).getId()) : null);
            }
            platforms.setPlatformName(v.getChannelName());
            platforms.setShopId(v.getShopId());
            platforms.setShopCode(v.getShopCode());
            platforms.setShopName(v.getShopName());
            platforms.setSkuId(comparisonEo.getItemCode());
            platforms.setChannelItemCode(v.getChannelItemCode());
            platforms.setChannelItemName(v.getChannelItemName());
            itemShopPlatforms.add(platforms);
        });
        relationRespDto.setItemShopPlatforms(itemShopPlatforms);
        return relationRespDto;
    }

    @Override
    public PageInfo<ItemExtRelationComparisonRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ItemExtRelationComparisonReqDto itemRelationComparisonReqDto = (ItemExtRelationComparisonReqDto)JSON.parseObject((String)filter, ItemExtRelationComparisonReqDto.class);
        ItemExtRelationComparisonEo itemRelationComparisonEo = new ItemExtRelationComparisonEo();
        DtoHelper.dto2Eo((BaseVo)itemRelationComparisonReqDto, (BaseEo)itemRelationComparisonEo);
        PageInfo eoPageInfo = this.itemExtRelationComparisonDas.selectPage((BaseEo)itemRelationComparisonEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemExtRelationComparisonRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<ItemExtRelationComparisonRespDto> queryRelationByShopList(List<String> shopCodes) {
        ExtQueryChainWrapper sqlFilterList = this.itemExtRelationComparisonDas.filter();
        ArrayList<ItemExtRelationComparisonRespDto> dtoList = new ArrayList<ItemExtRelationComparisonRespDto>();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(shopCodes)) {
            sqlFilterList.in((Object)"shop_code", shopCodes);
        }
        List comparisonEoList = sqlFilterList.list();
        CubeBeanUtils.copyCollection(dtoList, (Collection)comparisonEoList, ItemExtRelationComparisonRespDto.class);
        return dtoList;
    }

    @Override
    public PageInfo<ItemRelationInfoRespDto> queryItemRelationByPage(ItemRelationQueryConditionReqDto queryConditionReqDto) {
        ItemRelationQueryReqVo reqVo = new ItemRelationQueryReqVo();
        CubeBeanUtils.copyProperties((Object)reqVo, (Object)queryConditionReqDto, (String[])new String[0]);
        PageInfo comparsionRespVoPageInfo = this.itemExtRelationComparisonDas.queryItemRelationPage(reqVo, queryConditionReqDto.getPageNum(), queryConditionReqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)comparsionRespVoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)comparsionRespVoPageInfo.getList())) {
            List shelfListRespDtoList = comparsionRespVoPageInfo.getList().stream().map(v -> {
                ItemRelationInfoRespDto respDto = new ItemRelationInfoRespDto();
                CubeBeanUtils.copyProperties((Object)respDto, (Object)v, (String[])new String[0]);
                if (StringUtils.isNotBlank((CharSequence)respDto.getSkuCode())) {
                    respDto.setRelationState(ItemRelationState.YES.getCode());
                } else {
                    respDto.setRelationState(ItemRelationState.NO.getCode());
                }
                return respDto;
            }).collect(Collectors.toList());
            dtoPageInfo.setList(shelfListRespDtoList);
        }
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteRelationById(Long id) {
        this.itemExtRelationComparisonDas.logicDeleteById(id);
        ItemShopPlatformRelationEo platformRelationEo = new ItemShopPlatformRelationEo();
        platformRelationEo.setComparisonId(id);
        this.platformRelationDas.logicDelete((BaseEo)platformRelationEo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addChannelItemRelation(List<ItemChannelRelationReqDto> channelRelationReqDtos) {
        ArrayList<ItemShopPlatformRelationEo> relationEoList = new ArrayList<ItemShopPlatformRelationEo>();
        ArrayList<ItemExtRelationComparisonEo> comparisonEoList = new ArrayList<ItemExtRelationComparisonEo>();
        for (ItemChannelRelationReqDto v : channelRelationReqDtos) {
            Mutex mutex = null;
            try {
                mutex = this.lockService.lock("SYNC_ITEM_RELATION", v.getChannelCode() + "_" + v.getChannelItemCode(), 5);
                if (null == mutex) {
                    this.logger.error("\u5546\u54c1\u540c\u6b65\u5173\u7cfb\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25\uff1a{},{}", (Object)v.getChannelCode(), (Object)v.getChannelItemCode());
                } else {
                    String channelCode = v.getChannelCode();
                    String channelName = v.getChannelName();
                    String shopCode = v.getShopCode();
                    String shopName = v.getShopName();
                    List relationRespVos = this.itemExtRelationComparisonDas.getItemShopRelation(v.getChannelCode(), v.getChannelItemCode(), v.getShopCode(), v.getItemCode());
                    if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)relationRespVos)) {
                        Long id = IdGenrator.getDistributedId();
                        ItemExtRelationComparisonEo comparisonEo = new ItemExtRelationComparisonEo();
                        CubeBeanUtils.copyProperties((Object)comparisonEo, (Object)v, (String[])new String[0]);
                        comparisonEo.setId(id);
                        comparisonEo.setChannelItemCode(v.getChannelItemCode());
                        comparisonEo.setChannelItemName(v.getChannelItemName());
                        comparisonEo.setChannelSkuCode(v.getChannelItemCode());
                        comparisonEo.setItemCode(v.getItemCode());
                        comparisonEo.setSkuCode(v.getItemCode());
                        comparisonEo.setChannelStatus(ChannelStatus.OPEN.getStatus());
                        comparisonEo.setRelationType(RelationType.PROD_ITEM.getStatus());
                        comparisonEo.setChannel(v.getChannelCode());
                        comparisonEo.setShopCode(shopCode);
                        comparisonEo.setShopName(shopName);
                        comparisonEo.setChannelCode(channelCode);
                        comparisonEo.setChannelName(channelName);
                        comparisonEoList.add(comparisonEo);
                        ItemShopPlatformRelationEo relationEo = new ItemShopPlatformRelationEo();
                        relationEo.setComparisonId(id);
                        relationEo.setChannelCode(v.getChannelCode());
                        relationEo.setChannelItemCode(v.getChannelItemCode());
                        relationEo.setChannelItemName(v.getChannelItemName());
                        if (StringUtils.isNotBlank((CharSequence)v.getChannelName())) {
                            relationEo.setChannelName(v.getChannelName());
                        } else {
                            relationEo.setChannelName(channelName);
                        }
                        relationEo.setShopCode(v.getShopCode());
                        relationEo.setItemCode(v.getItemCode());
                        relationEo.setShopId(v.getShopId());
                        relationEo.setShopName(v.getShopName());
                        relationEo.setSkuId(v.getItemCode());
                        relationEoList.add(relationEo);
                    }
                }
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(comparisonEoList)) {
                    this.itemExtRelationComparisonDas.insertBatch(comparisonEoList);
                    this.platformRelationDas.insertBatch(relationEoList);
                }
                this.lockService.unlock(mutex);
            }
            catch (Exception e) {
                this.logger.error("\u5546\u54c1\u6620\u5c04\u6570\u636e\u5b58\u50a8\u5931\u8d25\uff1a{}", (Object)Throwables.getStackTraceAsString((Throwable)e));
            }
            finally {
                this.lockService.unlock(mutex);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void relationImport(List<ItemComparisonRelationReqDto> comparisonReqDtos) {
        this.logger.info("\u5546\u54c1\u6620\u5c04\u5bfc\u5165\u53c2\u6570\uff1a" + JSON.toJSONString(comparisonReqDtos));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(comparisonReqDtos)) {
            ArrayList relationEoList = new ArrayList();
            comparisonReqDtos.forEach(v -> {
                List itemShopPlatforms = v.getItemShopPlatforms();
                List channelItemCodes = itemShopPlatforms.stream().map(ItemComparisonRelationReqDto.ItemShopPlatforms::getChannelItemCode).collect(Collectors.toList()).stream().filter(s -> StringUtils.isNotBlank((CharSequence)s)).collect(Collectors.toList());
                List channelItemNames = itemShopPlatforms.stream().map(ItemComparisonRelationReqDto.ItemShopPlatforms::getChannelItemName).collect(Collectors.toList()).stream().filter(s -> StringUtils.isNotBlank((CharSequence)s)).collect(Collectors.toList());
                List channelCodes = itemShopPlatforms.stream().map(ItemComparisonRelationReqDto.ItemShopPlatforms::getPlatformCode).collect(Collectors.toList()).stream().filter(s -> StringUtils.isNotBlank((CharSequence)s)).collect(Collectors.toList());
                List channelNames = itemShopPlatforms.stream().map(ItemComparisonRelationReqDto.ItemShopPlatforms::getPlatformName).collect(Collectors.toList()).stream().filter(s -> StringUtils.isNotBlank((CharSequence)s)).collect(Collectors.toList());
                List shopCodes = itemShopPlatforms.stream().map(ItemComparisonRelationReqDto.ItemShopPlatforms::getShopCode).collect(Collectors.toList()).stream().filter(s -> StringUtils.isNotBlank((CharSequence)s)).collect(Collectors.toList());
                List shopNames = itemShopPlatforms.stream().map(ItemComparisonRelationReqDto.ItemShopPlatforms::getShopName).collect(Collectors.toList()).stream().filter(s -> StringUtils.isNotBlank((CharSequence)s)).collect(Collectors.toList());
                Long comparisonId = IdGenrator.getDistributedId();
                for (ItemComparisonRelationReqDto.ItemShopPlatforms i : itemShopPlatforms) {
                    ItemShopPlatformRelationEo platformRelationEo = new ItemShopPlatformRelationEo();
                    List platformRelationEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.platformRelationDas.filter().eq((Object)"channel_item_code", (Object)i.getChannelItemCode())).eq((Object)"channel_code", (Object)i.getPlatformCode())).list();
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)platformRelationEos)) {
                        platformRelationEo = (ItemShopPlatformRelationEo)platformRelationEos.get(0);
                        ItemShopPlatformRelationEo relationEoQuery = new ItemShopPlatformRelationEo();
                        relationEoQuery.setComparisonId(platformRelationEo.getComparisonId());
                        this.platformRelationDas.delete((BaseEo)relationEoQuery);
                        comparisonId = platformRelationEo.getComparisonId();
                    }
                    ItemShopPlatformRelationEo shopPlatformRelationEo = new ItemShopPlatformRelationEo();
                    shopPlatformRelationEo.setComparisonId(comparisonId);
                    shopPlatformRelationEo.setChannelCode(i.getPlatformCode());
                    shopPlatformRelationEo.setChannelName(i.getPlatformName());
                    shopPlatformRelationEo.setChannelItemCode(i.getChannelItemCode());
                    shopPlatformRelationEo.setChannelItemName(i.getChannelItemName());
                    shopPlatformRelationEo.setShopId(i.getShopId());
                    shopPlatformRelationEo.setShopCode(i.getShopCode());
                    shopPlatformRelationEo.setShopName(i.getShopName());
                    shopPlatformRelationEo.setItemCode(v.getCode());
                    shopPlatformRelationEo.setSkuId(v.getCode());
                    relationEoList.add(shopPlatformRelationEo);
                }
                ItemExtRelationComparisonEo comparisonEo = (ItemExtRelationComparisonEo)((ExtQueryChainWrapper)this.itemExtRelationComparisonDas.filter().eq((Object)"id", (Object)comparisonId)).one();
                boolean flag = false;
                if (comparisonEo == null) {
                    comparisonEo = new ItemExtRelationComparisonEo();
                    flag = true;
                }
                comparisonEo.setId(comparisonId);
                comparisonEo.setItemCode(v.getCode());
                comparisonEo.setSkuCode(v.getCode());
                comparisonEo.setChannelSkuCode(String.join((CharSequence)",", channelItemCodes));
                comparisonEo.setChannelItemCode(String.join((CharSequence)",", channelItemCodes));
                comparisonEo.setChannelItemName(String.join((CharSequence)",", channelItemNames));
                comparisonEo.setChannelStatus(ChannelStatus.OPEN.getStatus());
                comparisonEo.setChannelCode(String.join((CharSequence)",", channelCodes));
                comparisonEo.setChannelName(String.join((CharSequence)",", channelNames));
                comparisonEo.setShopCode(String.join((CharSequence)",", shopCodes));
                comparisonEo.setShopName(String.join((CharSequence)",", shopNames));
                comparisonEo.setRelationType(RelationType.PROD_ITEM.getStatus());
                if (flag) {
                    this.itemExtRelationComparisonDas.insert((BaseEo)comparisonEo);
                } else {
                    this.itemExtRelationComparisonDas.updateSelective((BaseEo)comparisonEo);
                }
                this.platformRelationDas.insertBatch(relationEoList);
            });
        }
    }

    @Override
    public PageInfo<ItemRelationInfoRespDto> exportRelation(ItemRelationQueryConditionReqDto queryConditionReqDto, Integer pageNum, Integer pageSize) {
        ItemRelationQueryReqVo reqVo = new ItemRelationQueryReqVo();
        CubeBeanUtils.copyProperties((Object)reqVo, (Object)queryConditionReqDto, (String[])new String[0]);
        PageInfo comparsionRespVoPageInfo = this.itemExtRelationComparisonDas.queryItemRelationPage(reqVo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)comparsionRespVoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (!org.apache.commons.collections.CollectionUtils.isEmpty((Collection)comparsionRespVoPageInfo.getList())) {
            List shelfListRespDtoList = comparsionRespVoPageInfo.getList().stream().map(v -> {
                ItemRelationInfoRespDto respDto = new ItemRelationInfoRespDto();
                CubeBeanUtils.copyProperties((Object)respDto, (Object)v, (String[])new String[0]);
                return respDto;
            }).collect(Collectors.toList());
            dtoPageInfo.setList(shelfListRespDtoList);
        }
        return dtoPageInfo;
    }

    @Override
    public String export(ItemRelationQueryConditionReqDto queryConditionReqDto) {
        Integer pageNum = queryConditionReqDto.getPageNum();
        Integer pageSize = queryConditionReqDto.getPageSize();
        String fileName = "/\u5546\u54c1\u6620\u5c04\u660e\u7ec6\u6570\u636e_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
        OssRegistryVo ossRegistryVo = (OssRegistryVo)SpringBeanUtil.getBean(OssRegistryVo.class);
        String url = ossRegistryVo.getEndpoint() + "/" + ossRegistryVo.getDir() + fileName + ".xls";
        ArrayList excelRespDtoList = new ArrayList();
        ItemRelationQueryReqVo reqVo = new ItemRelationQueryReqVo();
        CubeBeanUtils.copyProperties((Object)reqVo, (Object)queryConditionReqDto, (String[])new String[0]);
        try {
            PageInfo pageInfo;
            do {
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(pageInfo = this.itemExtRelationComparisonDas.queryItemRelationPage(reqVo, pageNum, pageSize)).getList())) {
                    pageInfo.getList().forEach(v -> {
                        ItemRelationExcelRespDto excelRespDto = new ItemRelationExcelRespDto();
                        excelRespDto.setCode(v.getCode());
                        excelRespDto.setName(v.getName());
                        excelRespDto.setProdLargeClass(v.getProdLargeClass());
                        excelRespDto.setProdSecClassify(v.getProdSecClassify());
                        excelRespDto.setProdThrClassify(v.getProdThrClassify());
                        excelRespDto.setProdClassCode(v.getProdClassCode());
                        excelRespDto.setPlatformName(v.getPlatformName());
                        excelRespDto.setShopName(v.getShopName());
                        excelRespDto.setShopCode(v.getShopCode());
                        excelRespDto.setChannelItemCode(v.getChannelItemCode());
                        excelRespDto.setChannelItemName(v.getChannelItemName());
                        excelRespDto.setSkuId(v.getSkuId());
                        excelRespDtoList.add(excelRespDto);
                    });
                }
                Integer n = pageNum;
                Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
            } while (pageNum <= pageInfo.getPages());
            EasyPoiExportUtil.getExportUrl(excelRespDtoList, ItemRelationExcelRespDto.class, null, fileName, "xls");
        }
        catch (Exception e) {
            this.logger.error("fileName: {}\u5bfc\u51fa\u5546\u54c1\u6620\u5c04\u660e\u7ec6\u5f02\u5e38: {}", (Object)fileName, (Object)e);
            throw new BizException("\u5bfc\u51fa\u5546\u54c1\u6620\u5c04\u660e\u7ec6\u5f02\u5e38:", e.getMessage());
        }
        return url;
    }

    @Override
    public List<ItemCenterListRespDto> getCenterItemByChannelItem(List<ItemChannelRelationReqDto> channelRelationReqDtos) {
        ArrayList itemCodes = Lists.newArrayList();
        ArrayList itemRelationComparisonEos = new ArrayList();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(channelRelationReqDtos)) {
            return new ArrayList<ItemCenterListRespDto>();
        }
        channelRelationReqDtos.stream().forEach(v -> {
            ItemExtRelationComparisonEo eo = new ItemExtRelationComparisonEo();
            eo.setChannelItemCode(v.getChannelItemCode());
            eo.setChannelCode(v.getChannelCode());
            List comparisonEoList = this.itemExtRelationComparisonDas.select((BaseEo)eo);
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)comparisonEoList)) {
                ItemExtRelationComparisonEo comparisonEo = new ItemExtRelationComparisonEo();
                DtoHelper.dto2Eo((BaseVo)v, (BaseEo)comparisonEo);
                comparisonEo.setChannelStatus(ChannelStatus.OPEN.getStatus());
                comparisonEo.setRelationType(RelationType.PROD_ITEM.getStatus());
                comparisonEo.setItemCode(v.getChannelItemCode());
                comparisonEo.setChannelSkuCode(v.getChannelItemCode());
                itemRelationComparisonEos.add(comparisonEo);
            }
            itemCodes.add(v.getChannelItemCode());
        });
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemRelationComparisonEos)) {
            this.itemExtRelationComparisonDas.insertBatch(itemRelationComparisonEos);
        }
        Map relationReqDtoMap = channelRelationReqDtos.stream().collect(Collectors.toMap(ItemChannelRelationReqDto::getChannelItemCode, Function.identity(), (k1, k2) -> k1));
        ItemEo itemEo = ItemEo.newInstance();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"code", (Object)itemCodes));
        itemEo.setSqlFilters(sqlFilterList);
        List itemEoList = this.itemDas.select((BaseEo)itemEo);
        ArrayList<ItemCenterListRespDto> centerListRespDtoList = new ArrayList<ItemCenterListRespDto>();
        itemEoList.stream().forEach(v -> {
            ItemCenterListRespDto respDto = new ItemCenterListRespDto();
            respDto.setItemCode(v.getCode());
            respDto.setItemName(v.getName());
            respDto.setChannelCode(((ItemChannelRelationReqDto)relationReqDtoMap.get(v.getCode())).getChannelCode());
            respDto.setChannelItemCode(((ItemChannelRelationReqDto)relationReqDtoMap.get(v.getCode())).getChannelItemCode());
            centerListRespDtoList.add(respDto);
        });
        return centerListRespDtoList;
    }

    @Override
    public void updateRelationStateNo(List<Long> ids) {
        this.itemExtRelationComparisonDas.updateRelationStateNo(ids);
    }

    @Override
    public List<ItemSkuPriceRespDto> queryItemSkuPriceByChnSkuCodeList(List<String> channelSkuCodeList) {
        ArrayList<ItemSkuPriceRespDto> retList = new ArrayList<ItemSkuPriceRespDto>();
        if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(channelSkuCodeList)) {
            throw new BizException("\u53c2\u6570\u5f02\u5e38channelSkuCodeList is Empty");
        }
        List voList = this.itemExtRelationComparisonDas.queryItemSkuPriceByChnSkuCodeList(channelSkuCodeList);
        voList.stream().forEach(vo -> {
            ItemSkuPriceRespDto dto = new ItemSkuPriceRespDto();
            CubeBeanUtils.copyProperties((Object)dto, (Object)vo, (String[])new String[0]);
            retList.add(dto);
        });
        return retList;
    }

    @Override
    public void updateOrInsertItemRelation(List<ItemExtRelationComparisonReqDto> reqDtoList) {
        if (!org.apache.commons.collections.CollectionUtils.isNotEmpty(reqDtoList)) {
            this.logger.error("updateOrInsertItemRelation:reqDtoList is empty ");
            throw new BizException("updateOrInsertItemRelation:reqDtoList is empty");
        }
        this.itemExtRelationComparisonDas.updateOrInsertItemRelation(reqDtoList);
    }

    @Override
    public List<ItemRelationInfoRespDto> queryByChannelItemCodes(List<String> channelItemCodes) {
        ItemRelationQueryReqVo reqVo = new ItemRelationQueryReqVo();
        reqVo.setChannelItemCodes(channelItemCodes);
        List comparsionRespVoList = this.itemExtRelationComparisonDas.queryItemRelationPage(reqVo);
        List<ItemRelationInfoRespDto> retList = comparsionRespVoList.stream().map(v -> {
            ItemRelationInfoRespDto respDto = new ItemRelationInfoRespDto();
            CubeBeanUtils.copyProperties((Object)respDto, (Object)v, (String[])new String[0]);
            if (StringUtils.isNotBlank((CharSequence)respDto.getSkuCode())) {
                respDto.setRelationState(ItemRelationState.YES.getCode());
            } else {
                respDto.setRelationState(ItemRelationState.NO.getCode());
            }
            return respDto;
        }).collect(Collectors.toList());
        return retList;
    }

    @Override
    public List<ItemSkuPriceRespDto> queryRelationByTypeCodeList(List<String> codeList, String codeType) {
        ArrayList<ItemSkuPriceRespDto> retList = new ArrayList<ItemSkuPriceRespDto>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(codeList)) {
            List itemBundleList;
            List voList = this.itemExtRelationComparisonDas.queryRelationByTypeCodeList(codeList, codeType);
            Map<Long, List<RItemBundleEo>> sonItemMap = null;
            List commItemIds = voList.stream().filter(i -> Objects.equals(ItemType.COMB_ITEM.getStatus(), i.getItemType())).map(ItemSkuPriceRespVo::getItemId).collect(Collectors.toList());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(commItemIds) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(itemBundleList = ((ExtQueryChainWrapper)this.rItemBundleDas.filter().in((Object)"item_id", commItemIds)).list()))) {
                sonItemMap = itemBundleList.stream().collect(Collectors.groupingBy(RItemBundleEo::getItemId));
            }
            for (ItemSkuPriceRespVo vo : voList) {
                ItemSkuPriceRespDto dto = new ItemSkuPriceRespDto();
                CubeBeanUtils.copyProperties((Object)dto, (Object)vo, (String[])new String[0]);
                if (sonItemMap != null) {
                    List<RItemBundleEo> tempList = sonItemMap.get(vo.getItemId());
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(tempList)) {
                        ArrayList bundleReqDtos = new ArrayList();
                        CubeBeanUtils.copyCollection(bundleReqDtos, tempList, RItemBundleRespDto.class);
                        dto.setBundleReqDtos(bundleReqDtos);
                    }
                } else {
                    this.logger.info("\u67e5\u8be2\u7ec4\u5408\u5546\u54c1\u4fe1\u606f:sonItemMap is empty ");
                }
                retList.add(dto);
            }
        } else {
            throw new BizException("\u53c2\u6570\u5f02\u5e38channelSkuCodeList is Empty");
        }
        return retList;
    }

    @Override
    public List<ItemSkuPriceRespDto> queryRelationByTypeCodeListNew(List<String> codeList, String codeType, String shopCode) {
        ArrayList<ItemSkuPriceRespDto> retList = new ArrayList<ItemSkuPriceRespDto>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(codeList)) {
            List itemBundleList;
            List voList = this.itemExtRelationComparisonDas.queryRelationByTypeCodeListNew(codeList, codeType, shopCode);
            Map<Long, List<RItemBundleEo>> sonItemMap = null;
            List commItemIds = voList.stream().filter(i -> Objects.equals(ItemType.COMB_ITEM.getStatus(), i.getItemType())).map(ItemSkuPriceRespVo::getItemId).collect(Collectors.toList());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(commItemIds) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(itemBundleList = ((ExtQueryChainWrapper)this.rItemBundleDas.filter().in((Object)"item_id", commItemIds)).list()))) {
                sonItemMap = itemBundleList.stream().collect(Collectors.groupingBy(RItemBundleEo::getItemId));
            }
            for (ItemSkuPriceRespVo vo : voList) {
                ItemSkuPriceRespDto dto = new ItemSkuPriceRespDto();
                CubeBeanUtils.copyProperties((Object)dto, (Object)vo, (String[])new String[0]);
                if (sonItemMap != null) {
                    List<RItemBundleEo> tempList = sonItemMap.get(vo.getItemId());
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(tempList)) {
                        ArrayList bundleReqDtos = new ArrayList();
                        CubeBeanUtils.copyCollection(bundleReqDtos, tempList, RItemBundleRespDto.class);
                        dto.setBundleReqDtos(bundleReqDtos);
                    }
                } else {
                    this.logger.info("\u67e5\u8be2\u7ec4\u5408\u5546\u54c1\u4fe1\u606f:sonItemMap is empty ");
                }
                retList.add(dto);
            }
        } else {
            throw new BizException("\u53c2\u6570\u5f02\u5e38channelSkuCodeList is Empty");
        }
        return retList;
    }

    @Override
    public List<ItemSkuPriceRespDto> queryRelationByItemKeysAndShopCode(List<String> channelItemKeyList, String shopCode) {
        ArrayList<ItemSkuPriceRespDto> retList = new ArrayList<ItemSkuPriceRespDto>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(channelItemKeyList)) {
            List itemBundleList;
            List voList = this.itemExtRelationComparisonDas.queryRelationByItemKeysAndShopCode(channelItemKeyList, shopCode);
            Map<Long, List<RItemBundleEo>> sonItemMap = null;
            List commItemIds = voList.stream().filter(i -> Objects.equals(ItemType.COMB_ITEM.getStatus(), i.getItemType())).map(ItemSkuPriceRespVo::getItemId).collect(Collectors.toList());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(commItemIds) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(itemBundleList = ((ExtQueryChainWrapper)this.rItemBundleDas.filter().in((Object)"item_id", commItemIds)).list()))) {
                sonItemMap = itemBundleList.stream().collect(Collectors.groupingBy(RItemBundleEo::getItemId));
            }
            for (ItemSkuPriceRespVo vo : voList) {
                ItemSkuPriceRespDto dto = new ItemSkuPriceRespDto();
                CubeBeanUtils.copyProperties((Object)dto, (Object)vo, (String[])new String[0]);
                if (sonItemMap != null) {
                    List<RItemBundleEo> tempList = sonItemMap.get(vo.getItemId());
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(tempList)) {
                        ArrayList bundleReqDtos = new ArrayList();
                        CubeBeanUtils.copyCollection(bundleReqDtos, tempList, RItemBundleRespDto.class);
                        dto.setBundleReqDtos(bundleReqDtos);
                    }
                } else {
                    this.logger.info("\u67e5\u8be2\u7ec4\u5408\u5546\u54c1\u4fe1\u606f:sonItemMap is empty ");
                }
                retList.add(dto);
            }
        } else {
            throw new BizException("\u53c2\u6570\u5f02\u5e38channelSkuCodeList is Empty");
        }
        return retList;
    }

    private void updateItemRelationRepeatCheck(ItemExtRelationComparisonReqDto dto) {
        Assert.isTrue((!this.itemRelationRepeatCheck(dto, false) ? 1 : 0) != 0, (String)ExceptionCode.FAIL.getCode(), (String)"\u6570\u636e\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
    }

    private void addItemRelationRepeatCheck(ItemExtRelationComparisonReqDto dto) {
        Assert.isTrue((!this.itemRelationRepeatCheck(dto, true) ? 1 : 0) != 0, (String)ExceptionCode.FAIL.getCode(), (String)"\u6570\u636e\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4");
    }

    private boolean itemRelationRepeatCheck(ItemExtRelationComparisonReqDto dto, boolean isAdd) {
        boolean flag = false;
        ExtQueryChainWrapper sqlWrapper = this.itemExtRelationComparisonDas.filter();
        String key = StrUtil.join((CharSequence)"", (Object[])new Object[]{StrUtil.isBlank((CharSequence)dto.getChannelSkuCode()) ? "" : dto.getChannelSkuCode(), StrUtil.isBlank((CharSequence)dto.getChannelSkuId()) ? "" : dto.getChannelSkuId(), StrUtil.isBlank((CharSequence)dto.getChannelItemCode()) ? "" : dto.getChannelItemCode(), StrUtil.isBlank((CharSequence)dto.getChannelItemId()) ? "" : dto.getChannelItemId()});
        if (StrUtil.isBlank((CharSequence)key)) {
            sqlWrapper.isNull((Object)"channel_item_key");
        } else {
            sqlWrapper.eq((Object)"channel_item_key", (Object)key);
        }
        if (StrUtil.isBlank((CharSequence)key)) {
            sqlWrapper.isNull((Object)"shop_code");
        } else {
            sqlWrapper.eq((Object)"shop_code", (Object)dto.getShopCode());
        }
        if (StrUtil.isBlank((CharSequence)dto.getChannelCode())) {
            sqlWrapper.isNull((Object)"channel_code");
        } else {
            sqlWrapper.eq((Object)"channel_code", (Object)dto.getChannelCode());
        }
        flag = isAdd ? sqlWrapper.count() > 0 : ((ExtQueryChainWrapper)((ExtQueryChainWrapper)sqlWrapper.eq((Object)"dr", (Object)0)).ne((Object)"id", (Object)dto.getId())).count() > 0;
        return flag;
    }
}

