/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.service.opensearch;

import com.dtyunxi.huieryun.opensearch.api.IIndicesMappingCacheService;
import com.dtyunxi.huieryun.opensearch.provider.es68.RestSearchClientUtils;
import com.dtyunxi.huieryun.opensearch.provider.es68.RestSearchService;
import com.dtyunxi.huieryun.opensearch.vo.GeoDistanceFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.GeoShapeFieldVo;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.OpenSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.module.context.api.IContext;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.geo.builders.PointBuilder;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.GeoDistanceQueryBuilder;
import org.elasticsearch.index.query.GeoShapeQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RestSearchExtService
extends RestSearchService {
    private static final Logger logger = LoggerFactory.getLogger(RestSearchExtService.class);
    @Resource
    private IContext context;
    @Resource
    private IIndicesMappingCacheService indicesMappingCacheService;
    @Resource
    private OpenSearchVo searchVo;
    private static volatile RestSearchExtService singleton = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public SearchResultVo search(OSSearchVo vo) {
        SearchResponse response;
        if (singleton == null) {
            Class<RestSearchExtService> clazz = RestSearchExtService.class;
            // MONITORENTER : com.dtyunxi.yundt.cube.center.item.biz.base.service.opensearch.RestSearchExtService.class
            if (singleton == null) {
                singleton = new RestSearchExtService();
                this.openSearchVo = this.searchVo;
                this.client = RestSearchClientUtils.createClient((OpenSearchVo)this.searchVo);
            }
            // MONITOREXIT : clazz
        }
        if (logger.isDebugEnabled()) {
            logger.debug("ES search \u641c\u7d22\u6570\u636e\u4f20\u5165\u53c2\u6570\uff1aindexName={},osSearchVo={}", (Object)vo.getIndexName(), (Object)JacksonUtil.toJson((Object)vo));
        }
        this.prepareIndexMapping(vo.getIndexName(), "_doc");
        BoolQueryBuilder boolQueryBuilder = this.buildBoolQuery(vo);
        if (vo.getQueryFields() != null && !vo.getQueryFields().isEmpty()) {
            this.addQuery(boolQueryBuilder, vo.getQueryFields());
        }
        if (vo.getGeoDistanceFields() != null && !vo.getGeoDistanceFields().isEmpty()) {
            this.addGeoDistanceQuery(vo.getGeoDistanceFields(), boolQueryBuilder);
        }
        if (vo.getGeoShapeFields() != null && !vo.getGeoShapeFields().isEmpty()) {
            this.addGeoShapeQuery(vo.getGeoShapeFields(), boolQueryBuilder);
        }
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().timeout(new TimeValue(3L, TimeUnit.SECONDS)).from(vo.getStartIndex()).size(vo.getPageSize()).explain(Boolean.valueOf(false)).fetchSource(vo.isFetchSource()).query((QueryBuilder)boolQueryBuilder);
        if (vo.getSortFields() != null && !vo.getSortFields().isEmpty()) {
            this.getMetaNameAndNestedFieldName(vo.getSortFields());
            this.addSort(vo.getSortFields(), sourceBuilder);
        }
        if (vo.getHighlightField() != null) {
            HighlightBuilder highlightBuilder = new HighlightBuilder().field(vo.getHighlightField());
            sourceBuilder.highlighter(highlightBuilder);
        }
        if (vo.getAggFields() != null && !vo.getAggFields().isEmpty()) {
            this.getMetaNameAndNestedFieldName(vo.getAggFields());
            this.addAgg(Objects.requireNonNull(vo.getAggFieldAsArray())).forEach(arg_0 -> ((SearchSourceBuilder)sourceBuilder).aggregation(arg_0));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("builder={}", (Object)sourceBuilder);
        }
        SearchRequest request = new SearchRequest(new String[]{vo.getIndexName()}).source(sourceBuilder);
        if (null != vo.getRouting()) {
            request.routing(vo.getRouting());
        }
        if (Objects.nonNull(this.context.userId())) {
            request.preference(this.context.userId().toString());
        }
        if (vo.isFetchSource()) {
            sourceBuilder.fetchSource(vo.getIncludeFields(), vo.getExcludeFields());
            if (vo.isUseScroll()) {
                TimeValue keepAlive = this.parseTimeValue(vo.getKeepAlive());
                request.scroll(keepAlive);
            }
        }
        this.beforeSearch(vo, request, boolQueryBuilder);
        logger.info("[searchRequest]>>>{}", (Object)request);
        try {
            response = this.client.search(request, RequestOptions.DEFAULT);
        }
        catch (IOException var7) {
            throw new RuntimeException("\u67e5\u8be2\u5f02\u5e38", var7);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("response={}", (Object)response);
        }
        SearchResultVo result = this.wrapSearchResultVo(vo, response);
        this.afterSearch(vo, response, result);
        return result;
    }

    protected void prepareIndexMapping(String indexName, String typeName) {
        Map mapping = this.indicesMappingCacheService.getMappingFromCache(indexName);
        if (mapping != null) {
            this.propertiesCache.set(mapping);
        } else {
            mapping = this.getIndexMapping(indexName, typeName);
            Map properties = (Map)mapping.get("properties");
            this.propertiesCache.set(properties);
            this.indicesMappingCacheService.putMappingToCache(indexName, properties);
        }
    }

    private void addGeoDistanceQuery(List<GeoDistanceFieldVo> geoDistanceFields, BoolQueryBuilder boolQueryBuilder) {
        geoDistanceFields.forEach(geoDistanceFieldVo -> {
            GeoPoint geoPoint = new GeoPoint(geoDistanceFieldVo.getLat(), geoDistanceFieldVo.getLon());
            DistanceUnit distanceUnit = DistanceUnit.valueOf((String)geoDistanceFieldVo.getDistanceUnit().name());
            GeoDistanceQueryBuilder geoDistanceQueryBuilder = QueryBuilders.geoDistanceQuery((String)geoDistanceFieldVo.getFieldName()).point(geoPoint).distance(geoDistanceFieldVo.getDistance(), distanceUnit).geoDistance(GeoDistance.PLANE);
            boolQueryBuilder.filter((QueryBuilder)geoDistanceQueryBuilder);
        });
    }

    private void addGeoShapeQuery(List<GeoShapeFieldVo> geoShapeFields, BoolQueryBuilder boolQueryBuilder) {
        geoShapeFields.forEach(geoShapeFieldVo -> {
            if (geoShapeFieldVo.getShapeType() == null) {
                logger.warn("GeoShapeFieldVo shapeType is null!");
            } else {
                PointBuilder shapeBuilder = null;
                switch (geoShapeFieldVo.getShapeType()) {
                    case POINT: {
                        GeoShapeFieldVo.PointType pointType = geoShapeFieldVo.getPointType();
                        shapeBuilder = new PointBuilder(pointType.getLon(), pointType.getLat());
                    }
                }
                GeoShapeQueryBuilder geoShapeQueryBuilder = null;
                try {
                    geoShapeQueryBuilder = QueryBuilders.geoShapeQuery((String)geoShapeFieldVo.getFieldName(), shapeBuilder).relation(ShapeRelation.valueOf((String)geoShapeFieldVo.getShapeRelation().name()));
                }
                catch (IOException var5) {
                    logger.error("", (Throwable)var5);
                }
                if (geoShapeQueryBuilder != null) {
                    boolQueryBuilder.filter((QueryBuilder)geoShapeQueryBuilder);
                }
            }
        });
    }
}

