/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.item.api.constants.ItemUnit;
import com.dtyunxi.yundt.cube.center.item.api.constants.LengthUnitEnum;
import com.dtyunxi.yundt.cube.center.item.api.dto.WmsStockReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.PcpItemQueryDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemUnitConversionRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemExtendService;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemUnitConversionService;
import com.dtyunxi.yundt.cube.center.item.biz.service.impl.AbstractPcpItemAdaptorServiceImpl;
import com.dtyunxi.yundt.cube.center.item.biz.util.LengthUnitUtils;
import com.dtyunxi.yundt.cube.center.item.biz.util.LogUtils;
import com.dtyunxi.yundt.cube.center.item.biz.util.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.item.biz.util.WeightUnitUtils;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemSkuDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.ItemExtendEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemSkuEo;
import com.github.pagehelper.PageInfo;
import icu.mhb.mybatisplus.plugln.core.JoinLambdaWrapper;
import icu.mhb.mybatisplus.plugln.core.JoinWrapper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service(value="mkldPcpItemAdaptorService")
public class MkldPcpItemAdaptorServiceImpl
extends AbstractPcpItemAdaptorServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(MkldPcpItemAdaptorServiceImpl.class);
    @Resource(name="${project.domain.prefix:tcbj}ItemExtendService")
    private IItemExtendService iItemExtendService;
    @Resource
    private ItemDas itemDas;
    @Resource
    private ItemSkuDas itemSkuDas;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IItemUnitConversionService conversionService;

    @Override
    public void publishItemSyncEvent(ItemExtendEo itemExtendEo) {
        List<ItemUnitConversionRespDto> conversionRespDtoList = this.conversionService.queryItemUnitById(itemExtendEo.getItemId());
        Optional.ofNullable(this.itemDas.selectOne((BaseEo)SqlFilterBuilder.create(ItemEo.class).eq("longCode", itemExtendEo.getItemCode()).eo())).ifPresent(itemEo -> this.commonsMqService.sendSingleMessage("ITEM_STOCK_SYNC_TAG", (Object)this.buildItemMqVo((ItemEo)itemEo, itemExtendEo, conversionRespDtoList)));
    }

    @Override
    public WmsStockReqDto publishItemSyncEventWms(ItemExtendEo itemExtendEo) {
        return null;
    }

    private WmsStockReqDto buildItemMqVo(ItemEo itemEo, ItemExtendEo itemExtendEo, List<ItemUnitConversionRespDto> conversionRespDtoList) {
        logger.info("publishItemSyncEvent ---------------> itemExtendEo = {}, conversionRespDtoList = {}", (Object)JSONObject.toJSONString((Object)itemExtendEo), (Object)JSONObject.toJSONString(conversionRespDtoList));
        WmsStockReqDto wmsStockReqDto = new WmsStockReqDto();
        BeanUtils.copyProperties((Object)itemEo, (Object)wmsStockReqDto);
        BeanUtils.copyProperties((Object)itemExtendEo, (Object)wmsStockReqDto, (String[])new String[]{"id"});
        wmsStockReqDto.setUnit(itemExtendEo.getBaseUnit());
        wmsStockReqDto.setBarCode(itemExtendEo.getSecurityCode());
        wmsStockReqDto.setDosageForm(itemExtendEo.getItemDrug());
        if (CollectionUtils.isNotEmpty(conversionRespDtoList)) {
            Map<String, List<ItemUnitConversionRespDto>> itemSkuEoMap = conversionRespDtoList.stream().collect(Collectors.groupingBy(ItemUnitConversionRespDto::getConversionUnit));
            if (StringUtils.isNotEmpty((CharSequence)ItemUnit.CV.getCode())) {
                if (CollectionUtils.isNotEmpty((Collection)itemSkuEoMap.get(ItemUnit.CV.getCode()))) {
                    List<ItemUnitConversionRespDto> itemUnitConversionRespDtos = itemSkuEoMap.get(ItemUnit.CV.getCode());
                    wmsStockReqDto.setConversionNum(itemUnitConversionRespDtos.get(0).getBaseUnitNum().toString());
                    wmsStockReqDto.setSaleUnit(itemExtendEo.getSaleUnit());
                    wmsStockReqDto.setGrossWeight(WeightUnitUtils.totalWeight(itemUnitConversionRespDtos.get(0).getGrossWeight(), itemUnitConversionRespDtos.get(0).getWeightUnit()));
                    wmsStockReqDto.setNetWeight(WeightUnitUtils.totalWeight(itemUnitConversionRespDtos.get(0).getNetWeight(), itemUnitConversionRespDtos.get(0).getWeightUnit()));
                    wmsStockReqDto.setLength(LengthUnitUtils.length(itemUnitConversionRespDtos.get(0).getLength(), itemUnitConversionRespDtos.get(0).getSizeUnit(), LengthUnitEnum.CM.getUnit()));
                    wmsStockReqDto.setWidth(LengthUnitUtils.length(itemUnitConversionRespDtos.get(0).getWidth(), itemUnitConversionRespDtos.get(0).getSizeUnit(), LengthUnitEnum.CM.getUnit()));
                    wmsStockReqDto.setHeight(LengthUnitUtils.length(itemUnitConversionRespDtos.get(0).getHeight(), itemUnitConversionRespDtos.get(0).getSizeUnit(), LengthUnitEnum.CM.getUnit()));
                }
            } else if (StringUtils.isNotEmpty((CharSequence)itemExtendEo.getSaleUnit())) {
                if (CollectionUtils.isNotEmpty((Collection)itemSkuEoMap.get(itemExtendEo.getSaleUnit()))) {
                    List<ItemUnitConversionRespDto> itemUnitConversionRespDtos = itemSkuEoMap.get(itemExtendEo.getSaleUnit());
                    wmsStockReqDto.setConversionNum(itemUnitConversionRespDtos.get(0).getBaseUnitNum().toString());
                    wmsStockReqDto.setSaleUnit(itemExtendEo.getSaleUnit());
                    wmsStockReqDto.setGrossWeight(WeightUnitUtils.totalWeight(itemUnitConversionRespDtos.get(0).getGrossWeight(), itemUnitConversionRespDtos.get(0).getWeightUnit()));
                    wmsStockReqDto.setNetWeight(WeightUnitUtils.totalWeight(itemUnitConversionRespDtos.get(0).getNetWeight(), itemUnitConversionRespDtos.get(0).getWeightUnit()));
                    wmsStockReqDto.setLength(LengthUnitUtils.length(itemUnitConversionRespDtos.get(0).getLength(), itemUnitConversionRespDtos.get(0).getSizeUnit(), LengthUnitEnum.CM.getUnit()));
                    wmsStockReqDto.setWidth(LengthUnitUtils.length(itemUnitConversionRespDtos.get(0).getWidth(), itemUnitConversionRespDtos.get(0).getSizeUnit(), LengthUnitEnum.CM.getUnit()));
                    wmsStockReqDto.setHeight(LengthUnitUtils.length(itemUnitConversionRespDtos.get(0).getHeight(), itemUnitConversionRespDtos.get(0).getSizeUnit(), LengthUnitEnum.CM.getUnit()));
                }
            } else if (CollectionUtils.isNotEmpty((Collection)itemSkuEoMap.get(itemExtendEo.getBaseUnit()))) {
                List<ItemUnitConversionRespDto> itemUnitConversionRespDtos = itemSkuEoMap.get(itemExtendEo.getBaseUnit());
                wmsStockReqDto.setConversionNum(itemUnitConversionRespDtos.get(0).getBaseUnitNum().toString());
                wmsStockReqDto.setSaleUnit(itemExtendEo.getBaseUnit());
                wmsStockReqDto.setGrossWeight(WeightUnitUtils.totalWeight(itemUnitConversionRespDtos.get(0).getGrossWeight(), itemUnitConversionRespDtos.get(0).getWeightUnit()));
                wmsStockReqDto.setNetWeight(WeightUnitUtils.totalWeight(itemUnitConversionRespDtos.get(0).getNetWeight(), itemUnitConversionRespDtos.get(0).getWeightUnit()));
                wmsStockReqDto.setLength(LengthUnitUtils.length(itemUnitConversionRespDtos.get(0).getLength(), itemUnitConversionRespDtos.get(0).getSizeUnit(), LengthUnitEnum.CM.getUnit()));
                wmsStockReqDto.setWidth(LengthUnitUtils.length(itemUnitConversionRespDtos.get(0).getWidth(), itemUnitConversionRespDtos.get(0).getSizeUnit(), LengthUnitEnum.CM.getUnit()));
                wmsStockReqDto.setHeight(LengthUnitUtils.length(itemUnitConversionRespDtos.get(0).getHeight(), itemUnitConversionRespDtos.get(0).getSizeUnit(), LengthUnitEnum.CM.getUnit()));
            }
        }
        wmsStockReqDto.setStorageCondition(itemExtendEo.getStorageCondition());
        logger.info("publishItemSyncEvent ---------------> wmsStockReqDto = {}", (Object)JSONObject.toJSONString((Object)wmsStockReqDto));
        return wmsStockReqDto;
    }

    @Override
    public PageInfo<PcpItemRespDto> queryByPage(PcpItemQueryDto queryDto) {
        logger.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(queryDto, "pageNum", "pageSize"));
        if (Objects.isNull(queryDto.getPageNum()) || Objects.isNull(queryDto.getPageSize())) {
            throw new BizException("\u5206\u9875\u9875\u6570\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JoinLambdaWrapper wrapper = ((JoinWrapper)((JoinWrapper)((JoinWrapper)((JoinWrapper)((JoinWrapper)((JoinWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)new JoinLambdaWrapper(ItemExtendEo.class).like(StringUtils.isNotBlank((CharSequence)queryDto.getLongCode()), ItemExtendEo::getItemCode, (Object)("%" + queryDto.getLongCode() + "%"))).like(Objects.nonNull(queryDto.getItemDrug()), ItemExtendEo::getItemDrug, (Object)queryDto.getItemDrug())).eq(BaseEo::getDr, (Object)0)).selectAll()).orderByDesc(BaseEo::getCreateTime)).leftJoin(ItemEo.class, StdItemEo::getLongCode, ItemExtendEo::getItemCode).like(StringUtils.isNotBlank((CharSequence)queryDto.getName()), StdItemEo::getName, (Object)("%" + queryDto.getName() + "%"))).eq(Objects.nonNull(queryDto.getItemType()), StdItemEo::getSubType, (Object)queryDto.getItemType())).eq(Objects.nonNull(queryDto.getItemStatus()), StdItemEo::getStatus, queryDto.getItemStatus())).eq(BaseEo::getDr, (Object)0)).selectAs(a -> a.add(StdItemEo::getSubType, "itemType").add(StdItemEo::getStatus, "itemStatus").add(StdItemEo::getName, "name").add(BaseEo::getId, "itemId"))).end().leftJoin(ItemSkuEo.class, StdItemSkuEo::getCode, ItemExtendEo::getItemCode).selectAs(a -> a.add(StdItemSkuEo::getBarCode, "barCode"))).end();
        IPage page = this.iItemExtendService.joinPage((IPage)new Page((long)queryDto.getPageNum().intValue(), (long)queryDto.getPageSize().intValue()), (Wrapper)wrapper, PcpItemRespDto.class);
        return this.getPcpItemRespDtoPageInfo(queryDto, (IPage<PcpItemRespDto>)page);
    }
}

