/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.mq;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.StorageChangeLogStatusEnum;
import com.dtyunxi.yundt.cube.center.item.biz.base.mq.vo.TradeOrderMessageVo;
import com.dtyunxi.yundt.cube.center.item.biz.base.util.ItemStorageUtils;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemStorageDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.StorageChangeLogDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemStorageEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StorageChangeLogEo;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@MQDesc(tag="VIRTUAL_TRADE_ORDER_STORAGE_CHANGE")
public class TradeOrderStatusProcess
implements IMessageProcessor {
    private Logger logger = LoggerFactory.getLogger(TradeOrderStatusProcess.class);
    @Resource
    private StorageChangeLogDas storageChangeLogDas;
    @Resource
    private ItemStorageDas virStorageDas;
    @Resource
    private ItemStorageUtils itemStorageUtils;
    private String wait = "wait_delivery";
    private String cancel = "cancel_delivery";

    @Transactional(rollbackFor={Exception.class})
    public MessageResponse process(Object message) {
        this.logger.info("\u83b7\u53d6\u5230\u4ea4\u6613\u4e2d\u5fc3mq\u6d88\u606f:{}", (Object)JSON.toJSONString((Object)message));
        MessageVo messageVo = (MessageVo)message;
        try {
            TradeOrderMessageVo tradeOrderMessageVo = (TradeOrderMessageVo)JSON.parseObject((String)String.valueOf(messageVo.getData()), TradeOrderMessageVo.class);
            if (tradeOrderMessageVo == null) {
                this.logger.info("\u65e0\u6cd5\u89e3\u6790\u51fa\u4ea4\u6613\u4e2d\u5fc3\u7684mq\u6d88\u606f\u5185\u5bb9");
                return MessageResponse.SUCCESS;
            }
            StorageChangeLogEo storageChangeLogEo = new StorageChangeLogEo();
            storageChangeLogEo.setOrderNo(tradeOrderMessageVo.getOrderNo());
            storageChangeLogEo.setInstanceId(tradeOrderMessageVo.getInstanceId());
            storageChangeLogEo.setTenantId(tradeOrderMessageVo.getTenantId());
            List storageChangeLogEoList = this.storageChangeLogDas.select((BaseEo)storageChangeLogEo);
            if (CollectionUtils.isEmpty((Collection)storageChangeLogEoList)) {
                this.logger.info("\u4e0d\u5b58\u5728\u4ea4\u6613\u8ba2\u5355\u53f7:{},\u5b9e\u4f8b:{},\u79df\u6237:{}\u7684\u5546\u54c1\u5e93\u5b58\u53d8\u66f4\u8bb0\u5f55\u6570\u636e", new Object[]{tradeOrderMessageVo.getOrderNo(), tradeOrderMessageVo.getInstanceId(), tradeOrderMessageVo.getTenantId()});
                return MessageResponse.SUCCESS;
            }
            for (StorageChangeLogEo changeLogEo : storageChangeLogEoList) {
                if (!changeLogEo.getStatus().equals(StorageChangeLogStatusEnum.PREEMPTION.getStatus())) {
                    return MessageResponse.SUCCESS;
                }
                ItemStorageEo itemStorageEo = new ItemStorageEo();
                itemStorageEo.setShelfId(changeLogEo.getShelfId());
                itemStorageEo.setInstanceId(changeLogEo.getInstanceId());
                itemStorageEo.setTenantId(changeLogEo.getTenantId());
                itemStorageEo = (ItemStorageEo)this.virStorageDas.selectOne((BaseEo)itemStorageEo);
                if (itemStorageEo == null) {
                    this.logger.info("\u67e5\u8be2\u4e0d\u5230\u5546\u54c1\u5e93\u5b58\u6570\u636e");
                    continue;
                }
                ItemStorageEo storageUpdateEo = new ItemStorageEo();
                storageUpdateEo.setId(itemStorageEo.getId());
                StorageChangeLogEo changeUpdateEo = new StorageChangeLogEo();
                changeUpdateEo.setId(changeLogEo.getId());
                if (this.wait.equals(tradeOrderMessageVo.getOrderStatus())) {
                    storageUpdateEo.setBalance(Long.valueOf(itemStorageEo.getBalance() - changeLogEo.getAppending()));
                    storageUpdateEo.setAppending(Long.valueOf(itemStorageEo.getAppending() - changeLogEo.getAppending()));
                    changeUpdateEo.setStatus(StorageChangeLogStatusEnum.CONFIRM.getStatus());
                } else {
                    if (!this.cancel.equals(tradeOrderMessageVo.getOrderStatus())) continue;
                    storageUpdateEo.setAppending(Long.valueOf(itemStorageEo.getAppending() - changeLogEo.getAppending()));
                    changeUpdateEo.setStatus(StorageChangeLogStatusEnum.CANCEL.getStatus());
                    this.logger.info("\u8ba2\u5355\u53d6\u6d88\u5546\u54c1\u5e93\u5b58\u56de\u6eda\u5f00\u59cb");
                    boolean result = this.itemStorageUtils.addItemStorage(changeLogEo.getShopId(), changeLogEo.getSkuId(), changeLogEo.getAppending());
                    this.logger.info("\u8ba2\u5355\u53d6\u6d88\u5546\u54c1\u5e93\u5b58\u56de\u6eda\u7ed3\u675f\uff0c\u56de\u6eda\u7ed3\u679c\uff1a{}", (Object)result);
                }
                this.virStorageDas.updateSelective((BaseEo)storageUpdateEo);
                this.storageChangeLogDas.updateSelective((BaseEo)changeUpdateEo);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return MessageResponse.ERROR;
        }
        return MessageResponse.SUCCESS;
    }
}

