/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.mq;

import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.google.common.base.Throwables;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.BatchItemStorageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemStorageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BatchItemStorageRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.ItemType;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.OrderRollBackDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.TobRollBackStockReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemTradeRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.RItemBundleRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemStorageService;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemExtService;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@MQDesc(topic="${yundt.cube.trade.topic:B2B_TOPIC}", tag="${yundt.cube.trade.tag.rollback.stock:B2B_ORDER_ROLLBACK_STOCK_TOPIC}")
public class ItemStorageProcess
implements IMessageProcessor<String> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ILockService lockService;
    @Resource
    private IItemStorageService itemStorageService;
    @Resource
    private IItemService itemService;
    @Resource
    private IItemExtService itemExtService;

    @Transactional(rollbackFor={Exception.class})
    public MessageResponse process(String message) {
        this.logger.info("\u8ba2\u5355\u5e93\u5b58\u56de\u6eda\u6d88\u606f\uff1a{}", (Object)message);
        TobRollBackStockReqDto tobRollBackStockReqDto = (TobRollBackStockReqDto)JSON.parseObject((String)message, TobRollBackStockReqDto.class);
        try {
            List orderItemList = tobRollBackStockReqDto.getOrderItemList();
            List<Long> itemIdList = orderItemList.stream().map(OrderRollBackDto::getItemId).collect(Collectors.toList());
            Map<Long, ItemDetailRespDto> itemDetails = this.queryItemDetails(itemIdList);
            List<Long> bundleItemIdList = orderItemList.stream().filter(tradeItem -> {
                Long itemId = tradeItem.getItemId();
                ItemDetailRespDto itemDetailRespDto = (ItemDetailRespDto)itemDetails.get(itemId);
                Integer itemType = itemDetailRespDto.getItem().getType();
                return ItemType.COMB_ITEM.getStatus().equals(itemType);
            }).map(tradeItem -> tradeItem.getItemId()).collect(Collectors.toList());
            Map<Long, ItemTradeRespDto> bundleItemsMap = this.queryBundleInfoByItemIds(bundleItemIdList);
            HashMap<Long, ItemStorageReqDto> itemStorageReqDtoMap = new HashMap<Long, ItemStorageReqDto>();
            for (OrderRollBackDto orderRollBackDto : orderItemList) {
                ItemStorageReqDto itemStorageReqDto;
                Long itemId = orderRollBackDto.getItemId();
                ItemDetailRespDto itemDetailRespDto = itemDetails.get(itemId);
                if (ItemType.COMB_ITEM.getStatus().equals(itemDetailRespDto.getItem().getType())) {
                    ItemTradeRespDto itemTradeRespDto = bundleItemsMap.get(itemId);
                    List bundleRespDtos = itemTradeRespDto.getBundleRespDtos();
                    for (RItemBundleRespDto itemBundleRespDto : bundleRespDtos) {
                        Long subItemId = itemBundleRespDto.getSubItemId();
                        Long subSkuId = itemBundleRespDto.getSubSkuId();
                        Integer num = itemBundleRespDto.getNum();
                        ItemStorageReqDto itemStorageReq = (ItemStorageReqDto)itemStorageReqDtoMap.get(subItemId);
                        if (itemStorageReq != null) {
                            itemStorageReq.setBalance(Long.valueOf(itemStorageReq.getBalance() + (long)(orderRollBackDto.getNum() * num)));
                            itemStorageReqDtoMap.put(subItemId, itemStorageReq);
                            continue;
                        }
                        itemStorageReqDto = new ItemStorageReqDto();
                        itemStorageReqDto.setBalance(Long.valueOf(Long.valueOf(orderRollBackDto.getNum().intValue()) * (long)num.intValue()));
                        itemStorageReqDto.setShopId(orderRollBackDto.getShopId());
                        itemStorageReqDto.setItemType(orderRollBackDto.getItemType());
                        itemStorageReqDto.setSkuId(subSkuId);
                        itemStorageReqDtoMap.put(subItemId, itemStorageReqDto);
                    }
                    continue;
                }
                ItemStorageReqDto itemStorageReq = (ItemStorageReqDto)itemStorageReqDtoMap.get(itemId);
                if (itemStorageReq != null) {
                    itemStorageReq.setBalance(Long.valueOf(itemStorageReq.getBalance() + (long)orderRollBackDto.getNum().intValue()));
                    itemStorageReqDtoMap.put(itemId, itemStorageReq);
                    continue;
                }
                itemStorageReqDto = new ItemStorageReqDto();
                itemStorageReqDto.setBalance(Long.valueOf(orderRollBackDto.getNum().intValue()));
                itemStorageReqDto.setShopId(orderRollBackDto.getShopId());
                itemStorageReqDto.setItemType(orderRollBackDto.getItemType());
                itemStorageReqDto.setSkuId(orderRollBackDto.getSkuId());
                itemStorageReqDtoMap.put(itemId, itemStorageReqDto);
            }
            ArrayList rollBackList = new ArrayList(itemStorageReqDtoMap.values());
            this.logger.info("\u5e93\u5b58\u56de\u6edatradeNo = {},rollBackList = {}", (Object)tobRollBackStockReqDto.getOrderNo(), (Object)JSON.toJSONString(rollBackList));
            if (CollectionUtils.isNotEmpty(rollBackList)) {
                BatchItemStorageReqDto batchItemStorageReqDto = new BatchItemStorageReqDto();
                batchItemStorageReqDto.setItemStorageReqDtoList(rollBackList);
                batchItemStorageReqDto.setOpt(BatchItemStorageReqDto.ADD);
                BatchItemStorageRespDto batchItemStorageRespDtoRestResponse = this.itemStorageService.batchOperatingItemStorage(batchItemStorageReqDto);
                this.logger.info("[\u5546\u54c1\u865a\u62df\u5e93\u5b58\u64cd\u4f5c\u6210\u529f\uff1abatchItemStorageReqDto={}]", (Object)JSON.toJSONString((Object)batchItemStorageReqDto));
            }
        }
        catch (Exception e) {
            this.logger.error("tradeNo={},\u5e93\u5b58\u56de\u6eda\u5931\u8d25", (Object)tobRollBackStockReqDto.getOrderNo(), (Object)e);
            throw new BizException(Throwables.getStackTraceAsString((Throwable)e));
        }
        return MessageResponse.SUCCESS;
    }

    public Map<Long, ItemDetailRespDto> queryItemDetails(List<Long> itemIdList) {
        HashMap itemDetailMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(itemIdList)) {
            return itemDetailMap;
        }
        itemIdList.forEach(itemId -> {
            ItemDetailRespDto itemDetailRespDto = this.itemService.queryItemDetail((Long)itemId, "attributes,sku,medias", null);
            itemDetailMap.put(itemId, itemDetailRespDto);
        });
        return itemDetailMap;
    }

    public Map<Long, ItemTradeRespDto> queryBundleInfoByItemIds(List<Long> itemIds) {
        HashMap<Long, ItemTradeRespDto> result = new HashMap<Long, ItemTradeRespDto>();
        for (Long itemId : itemIds) {
            ItemTradeRespDto itemTradeRespDto = this.itemExtService.queryById(itemId);
            result.put(itemId, itemTradeRespDto);
        }
        return result;
    }
}

