/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.apiimpl.query;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.dto.TreeDto;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.RootDirectoryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirectoryItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemExceptionCode;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.DirCategoryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.DirCategoryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemCategoryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.query.IICategoryQueryApi;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirectoryItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IDirectoryService;
import com.dtyunxi.yundt.cube.center.item.biz.base.util.QueryParamUtils;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemCategoryService;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirIndexEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class IItemCategoryQueryApiImpl
implements IICategoryQueryApi {
    @Resource
    IItemCategoryService categoryService;
    @Resource
    private IDirectoryItemService directoryItemService;
    @Resource
    private IDirectoryService directoryService;

    public RestResponse<List<ItemCategoryRespDto>> getCategoryList() {
        return new RestResponse(this.categoryService.getCategoryList());
    }

    public RestResponse<DirectoryItemRespDto> queryDirectoryByCode(String code) {
        return new RestResponse((Object)this.categoryService.queryDirectoryByCode(code));
    }

    public RestResponse<PageInfo<ItemRespDto>> getItemByDirCategory(DirCategoryReqDto reqDto) {
        return new RestResponse(this.categoryService.getItemByDirCategory(reqDto));
    }

    public RestResponse<List<ItemRespDto>> getBackDirCategory(DirCategoryReqDto reqDto) {
        return new RestResponse(this.categoryService.getBackDirCategory(reqDto));
    }

    public RestResponse<PageInfo<ItemRespDto>> getItemByFrontCategory(DirCategoryReqDto reqDto) {
        return new RestResponse(this.categoryService.getItemByFrontCategory(reqDto));
    }

    public RestResponse<PageInfo<ItemRespDto>> queryItemByDirCategoryId(Long dirId, Integer pageNum, Integer pageSize) {
        return new RestResponse(this.categoryService.queryItemByDirCategoryId(dirId, pageNum, pageSize));
    }

    public RestResponse<List<TreeDto<DirectoryItemRespDto>>> queryDirectoryTreeByFilter(String filter) {
        if (!StringUtils.isNotBlank((CharSequence)filter)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.EMPTY_PARAM_ERROR.getCode(), ItemExceptionCode.EMPTY_PARAM_ERROR.getMsg());
        }
        RootDirectoryReqDto reqDto = (RootDirectoryReqDto)JSON.parseObject((String)filter, RootDirectoryReqDto.class);
        DirIndexEo example = DirIndexEo.newInstance((Map)reqDto.getExtFields());
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)example);
        example.setInstanceId(null);
        example.setTenantId(null);
        QueryParamUtils.columnLike((BaseEo)example, "name", example.getName());
        List<DirIndexEo> directoryEos = this.directoryService.queryDirectory(example);
        ArrayList<Long> idsList = new ArrayList<Long>();
        for (DirIndexEo directoryEo : directoryEos) {
            idsList.add(directoryEo.getRootId());
        }
        List<TreeDto<DirectoryItemRespDto>> treeDtos = this.directoryItemService.queryDirByRootIds(idsList, null);
        return new RestResponse(treeDtos);
    }

    public RestResponse<List<DirCategoryRespDto>> queryParentCategorys(Long id) {
        return new RestResponse(this.categoryService.queryParentCategorys(id));
    }

    public RestResponse<List<DirCategoryRespDto>> queryChildCategorys(Long id) {
        return new RestResponse(this.categoryService.queryChildCategorys(id));
    }

    public RestResponse<List<DirectoryItemRespDto>> queryDirByCodes(List<String> codes) {
        return null;
    }
}

