/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.generate;

import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.item.biz.enus.GenerateCodeStrategyEnum;
import com.dtyunxi.yundt.cube.center.item.biz.service.generate.AbstractGenerateCodeService;
import com.dtyunxi.yundt.cube.center.item.biz.service.generate.IGenerateCodeService;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="generateCodeUtils")
public class GenerateCodeUtils {
    private static Logger logger = LoggerFactory.getLogger(AbstractGenerateCodeService.class);
    public static final String GENERATE_CODE_PRE = "I";
    public static final String GENERATE_CODE_SUF = "GenerateCodeServiceImpl";
    public static final String COMMON = "Common";
    public static final String ITEM_BUNDLE = "ItemBundle";
    @Autowired
    private List<IGenerateCodeService> generateCodeServices;
    private static Map<String, IGenerateCodeService> generateCodeServiceMap = Maps.newConcurrentMap();

    @PostConstruct
    public void initStrategy() {
        generateCodeServiceMap = this.generateCodeServices.stream().collect(Collectors.toMap(IGenerateCodeService::getGenerateCodeStrategy, Function.identity(), (k1, k2) -> k1));
    }

    public static IGenerateCodeService getStrategy(String generateCodeStrategy) {
        logger.info("getStrategy==>\u83b7\u53d6\u751f\u6210\u7f16\u7801\u7b56\u7565\u7c7b,generateCodeStrategy:{}", (Object)generateCodeStrategy);
        if (StringUtils.isBlank((CharSequence)generateCodeStrategy)) {
            return generateCodeServiceMap.get(GenerateCodeStrategyEnum.COMMMON.getCode());
        }
        String code = GenerateCodeStrategyEnum.getByCode(generateCodeStrategy);
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new BizException("\u3010%s\u3011\u7f16\u7801\u751f\u6210\u7b56\u7565\u6709\u8bef", generateCodeStrategy);
        }
        return generateCodeServiceMap.get(code);
    }
}

