/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.b2b.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.b2b.constants.ProhibiteItemOptEnum;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.BatchOptProhibiteSaleItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ProhibiteSaleItemReqDto;
import com.dtyunxi.yundt.cube.center.item.biz.b2b.service.IProhibiteSaleItemService;
import com.dtyunxi.yundt.cube.center.item.dao.b2b.das.ProhibiteSaleItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.b2b.ProhibiteSaleItemEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ProhibiteSaleItemServiceImpl
implements IProhibiteSaleItemService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ProhibiteSaleItemDas prohibiteSaleItemDas;

    @Override
    public Long addProhibiteSaleItem(ProhibiteSaleItemReqDto addReqDto) {
        ProhibiteSaleItemEo prohibiteSaleItemEo = new ProhibiteSaleItemEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)prohibiteSaleItemEo);
        this.prohibiteSaleItemDas.insert((BaseEo)prohibiteSaleItemEo);
        return prohibiteSaleItemEo.getId();
    }

    @Override
    public void batchOptProhibiteSaleItem(BatchOptProhibiteSaleItemReqDto batchOptProhibiteSaleItemReqDto) {
        this.verifyParam(batchOptProhibiteSaleItemReqDto);
        Long customerId = batchOptProhibiteSaleItemReqDto.getCustomerId();
        if (ProhibiteItemOptEnum.REV_SALE.getOptType().equals(batchOptProhibiteSaleItemReqDto.getOptType())) {
            Set itemIds = batchOptProhibiteSaleItemReqDto.getProhibiteSaleItemReqDtos().stream().map(ProhibiteSaleItemReqDto::getItemId).collect(Collectors.toSet());
            ProhibiteSaleItemEo prohibiteSaleItemEo = new ProhibiteSaleItemEo();
            prohibiteSaleItemEo.setCustomerId(customerId);
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ProhibiteSaleItemEo::getCustomerId, (Object)customerId)).in(ProhibiteSaleItemEo::getItemId, itemIds)).eq(BaseEo::getDr, (Object)0);
            this.prohibiteSaleItemDas.getMapper().delete((Wrapper)wrapper);
        } else {
            ProhibiteSaleItemEo queryEo = new ProhibiteSaleItemEo();
            queryEo.setCustomerId(customerId);
            List currProhibiteSaleItems = this.prohibiteSaleItemDas.select((BaseEo)queryEo);
            Set currItemIds = currProhibiteSaleItems.stream().map(ProhibiteSaleItemEo::getItemId).collect(Collectors.toSet());
            ArrayList prohibiteSaleItemEos = Lists.newArrayList();
            for (ProhibiteSaleItemReqDto prohibiteSaleItemReqDto : batchOptProhibiteSaleItemReqDto.getProhibiteSaleItemReqDtos()) {
                if (currItemIds.contains(prohibiteSaleItemReqDto.getItemId())) {
                    this.logger.info("\u5f53\u524d\u5546\u54c1\u5df2\u5b58\u5728\u7981\u552e\u8bb0\u5f55,\u672c\u6b21\u7981\u552e\u4e0d\u5904\u7406,\u5ba2\u6237id:{},\u5546\u54c1id:{}", (Object)customerId, (Object)prohibiteSaleItemReqDto.getItemId());
                    continue;
                }
                ProhibiteSaleItemEo prohibiteSaleItemEo = new ProhibiteSaleItemEo();
                DtoHelper.dto2Eo((BaseVo)prohibiteSaleItemReqDto, (BaseEo)prohibiteSaleItemEo);
                prohibiteSaleItemEo.setCustomerId(customerId);
                prohibiteSaleItemEos.add(prohibiteSaleItemEo);
            }
            if (CollectionUtil.isNotEmpty((Collection)prohibiteSaleItemEos)) {
                this.prohibiteSaleItemDas.insertBatch((List)prohibiteSaleItemEos);
            }
        }
    }

    @Override
    public List<ProhibiteSaleItemEo> queryByCustomerId(Long customerId) {
        if (customerId == null) {
            return Lists.newArrayList();
        }
        ProhibiteSaleItemEo prohibiteSaleItemEo = new ProhibiteSaleItemEo();
        prohibiteSaleItemEo.setCustomerId(customerId);
        return this.prohibiteSaleItemDas.select((BaseEo)prohibiteSaleItemEo);
    }

    private void verifyParam(BatchOptProhibiteSaleItemReqDto prohibiteSaleItemReqDtos) {
        if (CollectionUtil.isEmpty((Collection)prohibiteSaleItemReqDtos.getProhibiteSaleItemReqDtos())) {
            throw new BizException("\u542f\u552e/\u7981\u552e\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (ProhibiteSaleItemReqDto prohibiteSaleItemReqDto : prohibiteSaleItemReqDtos.getProhibiteSaleItemReqDtos()) {
            if (prohibiteSaleItemReqDto.getItemId() == null) {
                throw new BizException("\u5546\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (prohibiteSaleItemReqDto.getSkuId() != null) continue;
            throw new BizException("skuID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

