/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.util;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.TemplateExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.afterturn.easypoi.view.PoiBaseView;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.util.HttpUtil;
import com.dtyunxi.util.SpringBeanUtil;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ui.ModelMap;

public class EasyPoiExportUtil {
    private static final Logger logger = LoggerFactory.getLogger(EasyPoiExportUtil.class);
    private static IObjectStorageService objectStorageService;
    private static String bucketName;

    public static void exportSingleSheetExcel(String fileName, String title, String sheetName, Class<?> pojoClass, Collection<?> dataSet, HttpServletRequest request, HttpServletResponse response) {
        ModelMap modelMap = new ModelMap();
        ExportParams entity = new ExportParams(title, sheetName);
        modelMap.put((Object)"data", dataSet);
        modelMap.put((Object)"entity", pojoClass);
        modelMap.put((Object)"params", (Object)entity);
        modelMap.put((Object)"fileName", (Object)fileName);
        PoiBaseView.render((Map)modelMap, (HttpServletRequest)request, (HttpServletResponse)response, (String)"easypoiExcelView");
    }

    public static void exportManySheetsExcel(String fileName, Collection<?> dataSet, HttpServletRequest request, HttpServletResponse response) {
        ModelMap modelMap = new ModelMap();
        modelMap.put((Object)"mapList", dataSet);
        modelMap.put((Object)"fileName", (Object)fileName);
        PoiBaseView.render((Map)modelMap, (HttpServletRequest)request, (HttpServletResponse)response, (String)"easypoiExcelView");
    }

    public static <T> ExcelImportResult<T> importExcel(InputStream inputStream, Integer titleRows, Integer headerRows, Class pojoClass) {
        ImportParams params = new ImportParams();
        params.setTitleRows(titleRows.intValue());
        params.setHeadRows(headerRows.intValue());
        ExcelImportResult result = null;
        try {
            result = ExcelImportUtil.importExcelMore((InputStream)inputStream, (Class)pojoClass, (ImportParams)params);
            return result;
        }
        catch (NoSuchElementException var7) {
            throw new BusinessRuntimeException("excel\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        catch (Exception var8) {
            throw new BusinessRuntimeException(var8.getMessage());
        }
    }

    public static <T> ExcelImportResult<T> importExcel(InputStream inputStream, ImportParams params, Class pojoClass) {
        ExcelImportResult result = null;
        try {
            result = ExcelImportUtil.importExcelMore((InputStream)inputStream, (Class)pojoClass, (ImportParams)params);
            return result;
        }
        catch (NoSuchElementException var5) {
            throw new BusinessRuntimeException("excel\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        catch (Exception var6) {
            throw new BusinessRuntimeException(var6.getMessage());
        }
    }

    public static <T> ExcelImportResult<T> getImportResult(InputStream inputStream, Integer titleRows, Integer headerRows, Class pojoClass) {
        ImportParams params = new ImportParams();
        params.setTitleRows(titleRows.intValue());
        params.setHeadRows(headerRows.intValue());
        params.setKeyIndex((Integer)null);
        ExcelImportResult result = null;
        try {
            result = ExcelImportUtil.importExcelMore((InputStream)inputStream, (Class)pojoClass, (ImportParams)params);
            return result;
        }
        catch (NoSuchElementException var7) {
            throw new BusinessRuntimeException("excel\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        catch (Exception var8) {
            throw new BusinessRuntimeException(var8.getMessage());
        }
    }

    public static <T> ExcelImportResult<T> getImportResult(InputStream inputStream, Integer titleRows, Integer headerRows, Integer count, Class pojoClass) {
        ImportParams params = new ImportParams();
        params.setTitleRows(titleRows.intValue());
        params.setHeadRows(headerRows.intValue());
        params.setReadRows(count.intValue());
        params.setKeyIndex((Integer)null);
        ExcelImportResult result = null;
        try {
            result = ExcelImportUtil.importExcelMore((InputStream)inputStream, (Class)pojoClass, (ImportParams)params);
            return result;
        }
        catch (NoSuchElementException var8) {
            throw new BusinessRuntimeException("excel\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        catch (Exception var9) {
            throw new BusinessRuntimeException(var9.getMessage());
        }
    }

    public static String getExportSheetsUrl(Map<String, List> excelRespMap, Map<String, Class> classMap, String excelName, String suffix) {
        if (objectStorageService == null) {
            objectStorageService = (IObjectStorageService)SpringBeanUtil.getBean(IObjectStorageService.class);
        }
        if (bucketName == null) {
            bucketName = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.bucketName");
        }
        ArrayList sheetsList = new ArrayList();
        for (Map.Entry<String, List> entry : excelRespMap.entrySet()) {
            ExportParams exportParams = new ExportParams();
            exportParams.setSheetName(entry.getKey());
            HashMap<String, Object> exportMap = new HashMap<String, Object>();
            exportMap.put("title", exportParams);
            exportMap.put("entity", classMap.get(entry.getKey()));
            exportMap.put("data", entry.getValue());
            sheetsList.add(exportMap);
        }
        Workbook workbook = ExcelExportUtil.exportExcel(sheetsList, (ExcelType)ExcelType.HSSF);
        ByteArrayOutputStream fos = new ByteArrayOutputStream();
        String downloadUrl = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.endpoint");
        String fileName = excelName + "." + suffix;
        return EasyPoiExportUtil.getFileUrl(null, downloadUrl, workbook, fos, fileName);
    }

    public static <T> String getExportUrl(List<T> excelRespDtos, Class<T> tClass, String title, String excelName, String suffix) {
        if (objectStorageService == null) {
            objectStorageService = (IObjectStorageService)SpringBeanUtil.getBean(IObjectStorageService.class);
        }
        if (bucketName == null) {
            bucketName = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.bucketName");
        }
        String downloadUrl = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.endpoint");
        if (CollectionUtils.isEmpty(excelRespDtos)) {
            excelRespDtos = Lists.newArrayList();
        }
        ByteArrayOutputStream fos = null;
        String fileName = excelName + "." + suffix;
        ExportParams params = new ExportParams(title, "", ExcelType.HSSF);
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)params, tClass, (Collection)excelRespDtos);
        String url = EasyPoiExportUtil.getFileUrl(title, downloadUrl, workbook, fos, fileName);
        return url;
    }

    public static <T> String exportByTemplate(String templateUrl, List<T> excelRespDtos, String excelName, String suffix, String title) {
        if (objectStorageService == null) {
            objectStorageService = (IObjectStorageService)SpringBeanUtil.getBean(IObjectStorageService.class);
        }
        if (bucketName == null) {
            bucketName = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.bucketName");
        }
        String downloadUrl = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.endpoint");
        if (CollectionUtils.isEmpty(excelRespDtos)) {
            excelRespDtos = Lists.newArrayList();
        }
        TemplateExportParams params = new TemplateExportParams(templateUrl, new Integer[0]);
        HashMap map = new HashMap();
        ArrayList listMap = new ArrayList();
        excelRespDtos.forEach(dto -> {
            try {
                Map describe = BeanUtils.describe((Object)dto);
                listMap.add(describe);
            }
            catch (Exception var3) {
                logger.error("\u5bf9\u8c61\u8f6c\u6362\u6210map\u5f02\u5e38");
                var3.printStackTrace();
            }
        });
        map.put("maplist", listMap);
        Workbook workbook = ExcelExportUtil.exportExcel((TemplateExportParams)params, map);
        String url = "";
        ByteArrayOutputStream fos = null;
        String fileName = excelName + "." + suffix;
        url = EasyPoiExportUtil.getFileUrl(title, downloadUrl, workbook, fos, fileName);
        return url;
    }

    public static String exportByMap(String fileName, ExportParams params, List<ExcelExportEntity> entityList, List<Map<String, Object>> list) {
        if (objectStorageService == null) {
            objectStorageService = (IObjectStorageService)SpringBeanUtil.getBean(IObjectStorageService.class);
        }
        if (bucketName == null) {
            bucketName = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.bucketName");
        }
        String downloadUrl = SpringBeanUtil.getApplicationContext().getEnvironment().getProperty("huieryun.ossregistryvo.endpoint");
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)params, entityList, list);
        return EasyPoiExportUtil.getFileUrl(fileName, downloadUrl, workbook, null, fileName);
    }

    private static String getFileUrl(String title, String downloadUrl, Workbook workbook, ByteArrayOutputStream fos, String fileName) {
        String url;
        try {
            fos = new ByteArrayOutputStream();
            workbook.write((OutputStream)fos);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fos.toByteArray());
            objectStorageService.put(bucketName, fileName, (InputStream)byteArrayInputStream);
            url = downloadUrl + "/" + fileName;
        }
        catch (IOException var14) {
            logger.error(title + "\u5bfc\u51faexcel\u5f02\u5e38", (Object)var14.getMessage(), (Object)var14);
            throw new BusinessRuntimeException(title + "\u5bfc\u51faexcel\u5f02\u5e38");
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException var13) {
                logger.error("\u5173\u95ed\u6d41\u51fa\u73b0\u5f02\u5e38\uff1a{}", (Throwable)var13);
            }
        }
        return url;
    }

    public static <T> List<T> parseImportFile(String fileUrl, Class<T> clazz) {
        long startTime = System.currentTimeMillis();
        if (StringUtils.isBlank((CharSequence)fileUrl)) {
            throw new BizException("\u5bfc\u5165\u8def\u5f84\u4e0d\u5b58\u5728");
        }
        byte[] bytes = EasyPoiExportUtil.doGetRawData(fileUrl);
        Optional.ofNullable(bytes).orElseThrow(() -> new BizException("\u4e0b\u8f7d\u4e0d\u5230\u6587\u4ef6"));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        Optional.ofNullable(inputStream).orElseThrow(() -> new BizException("\u5bfc\u5165\u53c2\u6570\u6709\u8bef"));
        ExcelImportResult<T> data = EasyPoiExportUtil.importExcel(inputStream, 0, 1, clazz);
        logger.info("\u5bfc\u5165\u89e3\u6790excel\u6587\u4ef6, \u8017\u65f6={}", (Object)(System.currentTimeMillis() - startTime));
        return data.getList();
    }

    public static <T> List<T> parseImportFile(String fileUrl, Integer titleRows, Integer headerRows, Integer startSheetIndex, Integer startRows, Class<T> clazz) {
        long startTime = System.currentTimeMillis();
        if (StringUtils.isBlank((CharSequence)fileUrl)) {
            throw new BizException("\u5bfc\u5165\u8def\u5f84\u4e0d\u5b58\u5728");
        }
        byte[] bytes = EasyPoiExportUtil.doGetRawData(fileUrl);
        Optional.ofNullable(bytes).orElseThrow(() -> new BizException("\u4e0b\u8f7d\u4e0d\u5230\u6587\u4ef6"));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        Optional.ofNullable(inputStream).orElseThrow(() -> new BizException("\u5bfc\u5165\u53c2\u6570\u6709\u8bef"));
        ImportParams params = new ImportParams();
        params.setTitleRows(titleRows.intValue());
        params.setHeadRows(headerRows.intValue());
        params.setStartSheetIndex(startSheetIndex.intValue());
        params.setStartRows(startRows.intValue());
        ExcelImportResult<T> data = EasyPoiExportUtil.importExcel(inputStream, params, clazz);
        logger.info("\u5bfc\u5165\u89e3\u6790excel\u6587\u4ef6, \u8017\u65f6={}", (Object)(System.currentTimeMillis() - startTime));
        return data.getList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] doGetRawData(String url) {
        CloseableHttpClient httpClient = null;
        HttpGet httpGet = null;
        byte[] result = null;
        try {
            HttpEntity resEntity;
            httpClient = HttpUtil.createSSLClientDefault();
            httpGet = new HttpGet(url);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            if (response != null && (resEntity = response.getEntity()) != null) {
                result = EntityUtils.toByteArray((HttpEntity)resEntity);
            }
        }
        catch (Exception var14) {
            logger.error("HttpClientUtils.doGet\u62a5\u9519,url=" + url, (Throwable)var14);
        }
        finally {
            if (null != httpGet) {
                httpGet.abort();
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }
}

