/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.impl;

import com.aliyun.openservices.shade.com.google.common.base.Throwables;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.common.enums.ItemExtExceptionCode;
import com.dtyunxi.yundt.cube.center.item.api.dto.ItemInvoiceDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.ItemInvoiceExportDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ImportDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemInvoiceConditionReqDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.util.EasyPoiExportUtil;
import com.dtyunxi.yundt.cube.center.item.biz.service.ItemInvoiceService;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemSkuDas;
import com.dtyunxi.yundt.cube.center.item.dao.das.ItemInvoiceDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.ItemInvoiceEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemSkuEo;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ItemInvoiceServiceImpl
implements ItemInvoiceService {
    private static Logger logger = LoggerFactory.getLogger(ItemInvoiceServiceImpl.class);
    @Resource
    private ItemInvoiceDas itemInvoiceDas;
    @Resource
    private ItemSkuDas itemSkuDas;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addItemInvoice(ItemInvoiceDto addReqDto) {
        Assert.notNull((Object)addReqDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.notNull((Object)addReqDto.getItemCode(), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
        ItemSkuEo itemSkuEo = (ItemSkuEo)((ExtQueryChainWrapper)this.itemSkuDas.filter().eq((Object)"code", (Object)addReqDto.getItemCode())).one();
        ItemInvoiceEo itemInvoiceEo = new ItemInvoiceEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)itemInvoiceEo);
        this.checkAddItemInvoiceParam(itemInvoiceEo, itemSkuEo);
        ItemInvoiceEo oldItemInvoiceEo = (ItemInvoiceEo)((ExtQueryChainWrapper)this.itemInvoiceDas.filter().eq((Object)"item_code", (Object)itemInvoiceEo.getItemCode())).one();
        if (Objects.nonNull(oldItemInvoiceEo)) {
            itemInvoiceEo.setId(oldItemInvoiceEo.getId());
            this.itemInvoiceDas.updateSelective((BaseEo)itemInvoiceEo);
        } else {
            itemInvoiceEo.setId(null);
            this.itemInvoiceDas.insert((BaseEo)itemInvoiceEo);
        }
        return itemInvoiceEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchAddItemInvoice(List<ItemInvoiceDto> addReqDtos) {
        Assert.notEmpty(addReqDtos, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
        ArrayList<ItemInvoiceEo> itemInvoiceEos = new ArrayList<ItemInvoiceEo>();
        DtoHelper.dtoList2EoList(addReqDtos, itemInvoiceEos, ItemInvoiceEo.class);
        ArrayList<ItemInvoiceEo> updateItemInvoices = new ArrayList<ItemInvoiceEo>();
        this.checkItemCode(itemInvoiceEos, updateItemInvoices);
        logger.info("================>\u65b0\u589e{}\u6761\u8bb0\u5f55", (Object)itemInvoiceEos.size());
        this.itemInvoiceDas.insertBatch(itemInvoiceEos);
        logger.info("================>\u66f4\u65b0{}\u6761\u8bb0\u5f55", (Object)updateItemInvoices.size());
        if (CollectionUtils.isNotEmpty(updateItemInvoices)) {
            for (ItemInvoiceEo updateItemInvoice : updateItemInvoices) {
                this.itemInvoiceDas.updateSelective((BaseEo)updateItemInvoice);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyItemInvoice(ItemInvoiceDto modifyReqDto) {
        Assert.notNull((Object)modifyReqDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.notNull((Object)modifyReqDto.getId(), (String)"id\u4e0d\u53ef\u4e3a\u7a7a");
        ItemInvoiceEo itemInvoiceEo = new ItemInvoiceEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)itemInvoiceEo);
        if (Objects.nonNull(modifyReqDto.getItemCode())) {
            ItemInvoiceEo oldItemInvoiceEo = (ItemInvoiceEo)((ExtQueryChainWrapper)this.itemInvoiceDas.filter().eq((Object)"item_code", (Object)modifyReqDto.getItemCode())).one();
            if (Objects.nonNull(oldItemInvoiceEo) && !oldItemInvoiceEo.getId().equals(modifyReqDto.getId())) {
                throw new BizException(String.format("\u5546\u54c1\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff1a%s", modifyReqDto.getItemCode()));
            }
            ItemSkuEo itemSkuEo = (ItemSkuEo)((ExtQueryChainWrapper)this.itemSkuDas.filter().eq((Object)"code", (Object)modifyReqDto.getItemCode())).one();
            Assert.notNull((Object)itemSkuEo, (String)(modifyReqDto.getItemCode() + "\u8be5\u5546\u54c1\u7f16\u7801\u7684\u5546\u54c1\u4e0d\u5b58\u5728"));
            itemInvoiceEo.setItemName(itemSkuEo.getName());
        }
        this.itemInvoiceDas.updateSelective((BaseEo)itemInvoiceEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByIds(List<Long> ids) {
        Assert.notEmpty(ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        this.itemInvoiceDas.logicDeleteByIds(ids);
    }

    @Override
    public List<ItemInvoiceDto> queryByIds(List<Long> ids) {
        Assert.notEmpty(ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        List invoiceEos = ((ExtQueryChainWrapper)this.itemInvoiceDas.filter().in((Object)"id", ids)).list();
        ArrayList<ItemInvoiceDto> itemInvoiceDtos = new ArrayList<ItemInvoiceDto>();
        DtoHelper.eoList2DtoList((Collection)invoiceEos, itemInvoiceDtos, ItemInvoiceDto.class);
        return itemInvoiceDtos;
    }

    @Override
    public List<ItemInvoiceDto> queryByItemCodes(List<String> itemCodes) {
        Assert.notEmpty(itemCodes, (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
        List invoiceEos = ((ExtQueryChainWrapper)this.itemInvoiceDas.filter().in((Object)"item_code", itemCodes)).list();
        ArrayList<ItemInvoiceDto> itemInvoiceDtos = new ArrayList<ItemInvoiceDto>();
        DtoHelper.eoList2DtoList((Collection)invoiceEos, itemInvoiceDtos, ItemInvoiceDto.class);
        return itemInvoiceDtos;
    }

    @Override
    public PageInfo<ItemInvoiceDto> queryByPages(ItemInvoiceConditionReqDto reqDto) {
        Assert.notNull((Object)reqDto, (String)"\u67e5\u8be2\u6761\u4ef6\u4e0d\u53ef\u4e3a\u7a7a");
        PageInfo dtoPageInfo = new PageInfo();
        PageInfo<ItemInvoiceEo> eoPageInfo = this.queryDataByPages(reqDto);
        if (CollectionUtils.isNotEmpty((Collection)eoPageInfo.getList())) {
            ArrayList itemInvoiceDtos = new ArrayList();
            CubeBeanUtils.copyProperties((Object)dtoPageInfo, eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), itemInvoiceDtos, ItemInvoiceDto.class);
            dtoPageInfo.setList(itemInvoiceDtos);
        }
        return dtoPageInfo;
    }

    @Override
    public String export(ItemInvoiceConditionReqDto reqDto) {
        String url;
        Integer pageNum = 1;
        reqDto.setPageNum(pageNum);
        reqDto.setPageSize(Integer.valueOf(1000));
        String fileName = "/\u5546\u54c1\u5f00\u7968\u4fe1\u606f\u6570\u636e_" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmss");
        OssRegistryVo ossRegistryVo = (OssRegistryVo)SpringBeanUtil.getBean(OssRegistryVo.class);
        ArrayList<ItemInvoiceExportDto> excelRespDtoList = new ArrayList<ItemInvoiceExportDto>();
        try {
            PageInfo<ItemInvoiceEo> eoPageInfo;
            do {
                if (CollectionUtils.isNotEmpty((Collection)(eoPageInfo = this.queryDataByPages(reqDto)).getList())) {
                    for (ItemInvoiceEo itemInvoiceEo : eoPageInfo.getList()) {
                        ItemInvoiceExportDto exportDto = new ItemInvoiceExportDto();
                        BeanUtils.copyProperties((Object)itemInvoiceEo, (Object)exportDto);
                        excelRespDtoList.add(exportDto);
                    }
                }
                Integer n = pageNum;
                Integer n2 = pageNum = Integer.valueOf(pageNum + 1);
            } while (pageNum <= eoPageInfo.getPages());
            url = EasyPoiExportUtil.getExportUrl(excelRespDtoList, ItemInvoiceExportDto.class, null, fileName, "xls");
        }
        catch (Exception e) {
            logger.error("fileName: {}\u5bfc\u51fa\u5546\u54c1\u5f00\u7968\u4fe1\u606f\u5f02\u5e38: {}", (Object)fileName, (Object)e);
            throw new BizException("\u5bfc\u51fa\u5546\u54c1\u5f00\u7968\u4fe1\u606f\u5f02\u5e38:", e.getMessage());
        }
        return url;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String importItemInvoice(ImportDto importDto) {
        List<ItemInvoiceExportDto> excelReqDtoList = null;
        try {
            excelReqDtoList = EasyPoiExportUtil.parseImportFile(importDto.getUrl(), ItemInvoiceExportDto.class);
        }
        catch (Exception e) {
            logger.error(ItemExtExceptionCode.ITEM_BUNDLES_IMPORT_PARSING_ERROR.getMsg(), (Object)Throwables.getStackTraceAsString((Throwable)e));
            throw new BizException(ItemExtExceptionCode.ITEM_BUNDLES_IMPORT_PARSING_ERROR.getMsg(), e.getMessage());
        }
        return "0";
    }

    @Override
    public ItemInvoiceDto queryById(Long id) {
        ItemInvoiceDto itemInvoiceDto = new ItemInvoiceDto();
        ItemInvoiceEo itemInvoiceEo = (ItemInvoiceEo)this.itemInvoiceDas.selectByPrimaryKey(id);
        DtoHelper.eo2Dto((BaseEo)itemInvoiceEo, (BaseVo)itemInvoiceDto);
        return itemInvoiceDto;
    }

    public void checkItemCode(List<ItemInvoiceEo> itemInvoiceEos, List<ItemInvoiceEo> updateItemInvoices) {
        List<String> itemCodes = itemInvoiceEos.stream().map(ItemInvoiceEo::getItemCode).collect(Collectors.toList());
        List<List<String>> collectList = this.getIterate(itemCodes);
        ArrayList itemSkuEos = new ArrayList();
        ArrayList oldItemInvoiceEoList = new ArrayList();
        for (List<String> codes : collectList) {
            List itemInvoices;
            if (CollectionUtils.isEmpty(codes) || codes.size() < 1) break;
            List itemSkuEoList = ((ExtQueryChainWrapper)this.itemSkuDas.filter().in((Object)"code", codes)).list();
            if (CollectionUtils.isNotEmpty((Collection)itemSkuEoList)) {
                itemSkuEos.addAll(itemSkuEoList);
            }
            if (!CollectionUtils.isNotEmpty((Collection)(itemInvoices = ((ExtQueryChainWrapper)this.itemInvoiceDas.filter().in((Object)"item_code", codes)).list()))) continue;
            oldItemInvoiceEoList.addAll(itemInvoices);
        }
        Assert.notEmpty(itemSkuEos, (String)"\u5546\u54c1\u4e0d\u5b58\u5728");
        Map itemEoMap = itemSkuEos.stream().collect(Collectors.toMap(StdItemSkuEo::getCode, Function.identity(), (key1, key2) -> key2));
        Map<Object, Object> itemInvoiceEoMap = new HashMap();
        if (CollectionUtils.isNotEmpty(oldItemInvoiceEoList)) {
            itemInvoiceEoMap = oldItemInvoiceEoList.stream().collect(Collectors.toMap(ItemInvoiceEo::getItemCode, Function.identity(), (key1, key2) -> key2));
        }
        Iterator<ItemInvoiceEo> iterator = itemInvoiceEos.iterator();
        while (iterator.hasNext()) {
            ItemInvoiceEo invoiceEo = iterator.next();
            Assert.notNull((Object)invoiceEo.getItemCode(), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
            ItemSkuEo itemSkuEo = (ItemSkuEo)itemEoMap.get(invoiceEo.getItemCode());
            Assert.notNull((Object)invoiceEo, (String)"\u5546\u54c1\u5f00\u7968\u4fe1\u606f\u4e0d\u5b58\u5728");
            this.checkAddItemInvoiceParam(invoiceEo, itemSkuEo);
            ItemInvoiceEo itemInvoiceEo = (ItemInvoiceEo)itemInvoiceEoMap.get(invoiceEo.getItemCode());
            if (!Objects.nonNull(itemInvoiceEo)) continue;
            invoiceEo.setId(itemInvoiceEo.getId());
            updateItemInvoices.add(invoiceEo);
            iterator.remove();
        }
    }

    public void checkAddItemInvoiceParam(ItemInvoiceEo itemInvoiceEo, ItemSkuEo itemSkuEo) {
        Assert.notNull((Object)itemInvoiceEo.getTaxRate(), (String)"\u5f00\u7968\u7a0e\u7387\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.notNull((Object)itemInvoiceEo.getTaxCategoryCode(), (String)"\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e0d\u53ef\u4e3a\u7a7a");
        Assert.notNull((Object)itemSkuEo, (String)(itemInvoiceEo.getItemCode() + "\u8be5\u5546\u54c1\u7f16\u7801\u7684\u5546\u54c1\u4e0d\u5b58\u5728"));
        itemInvoiceEo.setItemName(itemSkuEo.getName());
        itemInvoiceEo.setCalcuUnit(itemSkuEo.getCalcuUnit());
    }

    private void queryCondition(ExtQueryChainWrapper<ItemInvoiceEo> sqlFilters, ItemInvoiceConditionReqDto reqDto) {
        if (StringUtils.isNotBlank((CharSequence)reqDto.getItemCode())) {
            sqlFilters.eq((Object)"item_code", (Object)reqDto.getItemCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getItemName())) {
            sqlFilters.eq((Object)"item_name", (Object)reqDto.getItemName());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getItemDisplayName())) {
            sqlFilters.eq((Object)"item_display_name", (Object)reqDto.getItemDisplayName());
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getTaxCategoryCode())) {
            sqlFilters.like((Object)"tax_category_code", (Object)("%" + reqDto.getTaxCategoryCode() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getItemType())) {
            sqlFilters.like((Object)"item_type", (Object)("%" + reqDto.getItemType() + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getPatentName())) {
            sqlFilters.like((Object)"patent_name", (Object)("%" + reqDto.getPatentName() + "%"));
        }
        if (Objects.nonNull(reqDto.getUpdateBeginTime())) {
            sqlFilters.ge((Object)"update_time", (Object)reqDto.getUpdateBeginTime());
        }
        if (Objects.nonNull(reqDto.getUpdateEndTime())) {
            sqlFilters.lt((Object)"update_time", (Object)reqDto.getUpdateEndTime());
        }
        if (Objects.nonNull(reqDto.getCreateBeginTime())) {
            sqlFilters.ge((Object)"create_time", (Object)reqDto.getCreateBeginTime());
        }
        if (Objects.nonNull(reqDto.getCreateEndTime())) {
            sqlFilters.lt((Object)"create_time", (Object)reqDto.getCreateEndTime());
        }
    }

    public PageInfo<ItemInvoiceEo> queryDataByPages(ItemInvoiceConditionReqDto reqDto) {
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)this.itemInvoiceDas.filter().orderByDesc((Object)"update_time");
        this.queryCondition((ExtQueryChainWrapper<ItemInvoiceEo>)sqlFilters, reqDto);
        PageInfo eoPageInfo = sqlFilters.page(reqDto.getPageNum(), reqDto.getPageSize());
        return eoPageInfo;
    }

    public List<List<String>> getIterate(List<String> itemCodes) {
        int length;
        ArrayList<List<String>> collectList = new ArrayList<List<String>>();
        int i = 0;
        for (length = itemCodes.size(); length > 1000; length -= 1000) {
            collectList.add(itemCodes.subList(i, i + 1000));
            i += 1000;
        }
        if (length > 0) {
            collectList.add(itemCodes.subList(i, i + length));
        }
        return collectList;
    }
}

