/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.mq.processor;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.SellerSkuPriceReqDto;
import com.dtyunxi.yundt.cube.center.item.biz.mq.MgPartnerProduct;
import com.dtyunxi.yundt.cube.center.item.biz.service.ISellerSkuPriceService;
import com.dtyunxi.yundt.cube.center.item.biz.service.query.IItemCenterQueryService;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IBizOrganizationQueryApi;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="GUANG", tag="tag")
public class PrintToJsonMessageProcessor
implements IMessageProcessor<MgPartnerProduct> {
    private static final Logger log = LoggerFactory.getLogger(PrintToJsonMessageProcessor.class);
    private final ObjectMapper om = new ObjectMapper();
    @Resource
    private ISellerSkuPriceService sellerSkuPriceService;
    @Resource
    private IBizOrganizationQueryApi bizOrganizationQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IItemCenterQueryService itemCenterQueryService;
    @Resource
    private IItemSkuQueryApi itemSkuQueryApi;

    public MessageResponse process(MgPartnerProduct mgPartnerProduct) {
        this.printProcessorInfo();
        try {
            String json = this.om.writeValueAsString((Object)mgPartnerProduct);
            log.info("\u76d1\u542c\u5668\u63a5\u6536\u5230\u6d88\u606f\uff1a{}", (Object)json);
            ArrayList codes = Lists.newArrayList();
            codes.add(mgPartnerProduct.getTenantId());
            OrganizationDto organizationDto = (OrganizationDto)((List)this.bizOrganizationQueryApi.queryInfoByCodeList((List)codes).getData()).get(0);
            Long orgId = organizationDto.getId();
            CustomerRespDto sellRespDto = (CustomerRespDto)this.customerQueryApi.queryByOrgInfoId(orgId).getData();
            Long sellerId = sellRespDto.getId();
            log.info("sellerId:{}", (Object)sellerId);
            if (sellerId == null) {
                throw new BizException("sellerId\u4e3a\u7a7a");
            }
            ArrayList thirdPartyIds = Lists.newArrayList();
            thirdPartyIds.add(mgPartnerProduct.getPartnerId());
            CustomerRespDto customerRespDto = (CustomerRespDto)((List)this.customerQueryApi.queryByThirdPartyIds((List)thirdPartyIds).getData()).get(0);
            Long customerId = customerRespDto.getId();
            log.info("customerId:{}", (Object)customerId);
            if (customerId == null) {
                throw new BizException("customerId\u4e3a\u7a7a");
            }
            Long itemId = this.itemCenterQueryService.queryByLongCode(mgPartnerProduct.getEasNo()).getId();
            log.info("itemId:{}", (Object)itemId);
            if (itemId == null) {
                throw new BizException("itemId\u4e3a\u7a7a");
            }
            Long skuId = ((ItemSkuRespDto)((List)this.itemSkuQueryApi.queryByItemId(itemId).getData()).get(0)).getId();
            log.info("skuId:{}", (Object)skuId);
            if (skuId == null) {
                throw new BizException("skuId\u4e3a\u7a7a");
            }
            SellerSkuPriceReqDto sellerSkuPriceReqDto = new SellerSkuPriceReqDto();
            sellerSkuPriceReqDto.setSellerId(sellerId);
            sellerSkuPriceReqDto.setCustomerId(customerId);
            sellerSkuPriceReqDto.setItemId(itemId);
            sellerSkuPriceReqDto.setSkuId(skuId);
            BigDecimal price = BigDecimal.valueOf(mgPartnerProduct.getPrice());
            sellerSkuPriceReqDto.setSupplyPrice(price);
            this.sellerSkuPriceService.updatePrice(sellerSkuPriceReqDto);
        }
        catch (JsonProcessingException e) {
            log.error("\u76d1\u542c\u5668\u63a5\u6536\u5230\u6d88\u606f, \u89e3\u6790\u4e3ajson\u5931\u8d25", (Throwable)e);
            e.printStackTrace();
        }
        return MessageResponse.SUCCESS;
    }

    protected void printProcessorInfo() {
        MQDesc mqDesc = this.getClass().getAnnotation(MQDesc.class);
        if (mqDesc == null) {
            log.info("ProcessorInfo: \u672a\u83b7\u53d6\u8be6\u7ec6\u4fe1\u606f");
            return;
        }
        String info = String.format("topic=%s, tag=%s, consumer=%s, msgType=%s", mqDesc.topic(), mqDesc.tag(), mqDesc.consumer(), mqDesc.msgType());
        log.info("ProcessorInfo: {}", (Object)info);
    }
}

