/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.constants.MutexLockEnum;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemDepartmentPriceReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.ItemDepartmentPriceRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemDepartmentPriceService;
import com.dtyunxi.yundt.cube.center.item.dao.das.ItemDepartmentPriceDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.ItemDepartmentPriceEo;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemDepartmentPriceServiceImpl
implements IItemDepartmentPriceService {
    private static Logger logger = LoggerFactory.getLogger(ItemDepartmentPriceServiceImpl.class);
    @Resource
    protected ILockService iLockService;
    @Resource
    private ItemDepartmentPriceDas itemDepartmentPriceDas;

    @Override
    public Long addItemDepartmentPrice(ItemDepartmentPriceReqDto addReqDto) {
        ItemDepartmentPriceEo itemDepartmentPriceEo = new ItemDepartmentPriceEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)itemDepartmentPriceEo);
        this.itemDepartmentPriceDas.insert((BaseEo)itemDepartmentPriceEo);
        return itemDepartmentPriceEo.getId();
    }

    @Override
    public void batchAddItemDepartmentPrice(List<ItemDepartmentPriceReqDto> priceReqDtoList) {
        ArrayList<ItemDepartmentPriceEo> priceEoList = new ArrayList<ItemDepartmentPriceEo>();
        if (CollectionUtils.isNotEmpty(priceReqDtoList)) {
            for (ItemDepartmentPriceReqDto addReqDto : priceReqDtoList) {
                ItemDepartmentPriceEo itemDepartmentPriceEo = new ItemDepartmentPriceEo();
                DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)itemDepartmentPriceEo);
                priceEoList.add(itemDepartmentPriceEo);
            }
        }
        if (CollectionUtils.isNotEmpty(priceEoList)) {
            this.itemDepartmentPriceDas.insertBatch(priceEoList);
        }
    }

    @Override
    public void modifyItemDepartmentPrice(ItemDepartmentPriceReqDto modifyReqDto) {
        ItemDepartmentPriceEo itemDepartmentPriceEo = new ItemDepartmentPriceEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)itemDepartmentPriceEo);
        this.itemDepartmentPriceDas.updateSelective((BaseEo)itemDepartmentPriceEo);
    }

    @Override
    public void batchModifyItemDepartmentPrice(List<ItemDepartmentPriceReqDto> priceReqDtoList) {
        ArrayList<ItemDepartmentPriceEo> priceEoList = new ArrayList<ItemDepartmentPriceEo>();
        if (CollectionUtils.isNotEmpty(priceReqDtoList)) {
            for (ItemDepartmentPriceReqDto modifyReqDto : priceReqDtoList) {
                ItemDepartmentPriceEo itemDepartmentPriceEo = this.queryItemPrice(modifyReqDto.getCode(), modifyReqDto.getDepartmentCode());
                if (StringUtils.isNotEmpty((CharSequence)modifyReqDto.getItemUnit())) {
                    itemDepartmentPriceEo.setItemUnit(modifyReqDto.getItemUnit());
                }
                if (null != modifyReqDto.getItemPrice()) {
                    itemDepartmentPriceEo.setItemPrice(modifyReqDto.getItemPrice());
                }
                priceEoList.add(itemDepartmentPriceEo);
            }
        }
        if (CollectionUtils.isNotEmpty(priceEoList)) {
            for (ItemDepartmentPriceEo priceEo : priceEoList) {
                this.itemDepartmentPriceDas.update((BaseEo)priceEo);
            }
        }
    }

    @Override
    public void batchConductItemDepartmentPrice(List<ItemDepartmentPriceReqDto> priceReqDtoList) {
        ArrayList<ItemDepartmentPriceEo> priceEoList = new ArrayList<ItemDepartmentPriceEo>();
        ArrayList<ItemDepartmentPriceEo> modifyEoList = new ArrayList<ItemDepartmentPriceEo>();
        if (CollectionUtils.isNotEmpty(priceReqDtoList)) {
            for (ItemDepartmentPriceReqDto reqDto : priceReqDtoList) {
                Mutex lock;
                block14: {
                    lock = null;
                    try {
                        String key = reqDto.getCode() + "_" + reqDto.getItemUnit() + "_" + reqDto.getDepartmentCode();
                        lock = this.iLockService.lock(MutexLockEnum.ITEM_PRICE.getKey(), key, 10, 10, TimeUnit.SECONDS);
                        ItemDepartmentPriceEo itemDepartmentPriceEo = this.queryItemPrice(reqDto.getCode(), reqDto.getDepartmentCode());
                        if (null != itemDepartmentPriceEo && null != itemDepartmentPriceEo.getId()) {
                            if (null != reqDto.getItemPrice()) {
                                itemDepartmentPriceEo.setItemPrice(reqDto.getItemPrice());
                            }
                            if (StringUtils.isNotEmpty((CharSequence)reqDto.getItemUnit())) {
                                itemDepartmentPriceEo.setItemUnit(reqDto.getItemUnit());
                            }
                            if (StringUtils.isNotEmpty((CharSequence)reqDto.getCreatePerson())) {
                                itemDepartmentPriceEo.setUpdatePerson(reqDto.getCreatePerson());
                            }
                            modifyEoList.add(itemDepartmentPriceEo);
                            break block14;
                        }
                        ItemDepartmentPriceEo priceEo = new ItemDepartmentPriceEo();
                        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)priceEo);
                        priceEoList.add(priceEo);
                    }
                    catch (Exception e) {
                        try {
                            logger.error("\u540c\u6b65\u51fa\u5382\u4ef7 \u5904\u7406\u5f02\u5e38 {}", (Object)e.getMessage());
                            throw new BizException("\u540c\u6b65\u51fa\u5382\u4ef7\u5931\u8d25");
                        }
                        catch (Throwable throwable) {
                            if (Objects.nonNull(lock)) {
                                this.iLockService.unlock(lock);
                            }
                            throw throwable;
                        }
                    }
                }
                if (!Objects.nonNull(lock)) continue;
                this.iLockService.unlock(lock);
            }
        }
        if (CollectionUtils.isNotEmpty(priceEoList)) {
            this.itemDepartmentPriceDas.insertBatch(priceEoList);
        }
        if (CollectionUtils.isNotEmpty(modifyEoList)) {
            for (ItemDepartmentPriceEo priceEo : modifyEoList) {
                this.itemDepartmentPriceDas.update((BaseEo)priceEo);
            }
        }
    }

    private ItemDepartmentPriceEo queryItemPrice(String code, String departmentCode) {
        ItemDepartmentPriceEo priceEo = new ItemDepartmentPriceEo();
        priceEo.setCode(code);
        priceEo.setDepartmentCode(departmentCode);
        return (ItemDepartmentPriceEo)this.itemDepartmentPriceDas.selectOne((BaseEo)priceEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeItemDepartmentPrice(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.itemDepartmentPriceDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ItemDepartmentPriceRespDto queryById(Long id) {
        ItemDepartmentPriceEo itemDepartmentPriceEo = (ItemDepartmentPriceEo)this.itemDepartmentPriceDas.selectByPrimaryKey(id);
        ItemDepartmentPriceRespDto itemDepartmentPriceRespDto = new ItemDepartmentPriceRespDto();
        DtoHelper.eo2Dto((BaseEo)itemDepartmentPriceEo, (BaseVo)itemDepartmentPriceRespDto);
        return itemDepartmentPriceRespDto;
    }

    @Override
    public PageInfo<ItemDepartmentPriceRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ItemDepartmentPriceReqDto itemDepartmentPriceReqDto = (ItemDepartmentPriceReqDto)JSON.parseObject((String)filter, ItemDepartmentPriceReqDto.class);
        ItemDepartmentPriceEo itemDepartmentPriceEo = new ItemDepartmentPriceEo();
        DtoHelper.dto2Eo((BaseVo)itemDepartmentPriceReqDto, (BaseEo)itemDepartmentPriceEo);
        PageInfo eoPageInfo = this.itemDepartmentPriceDas.selectPage((BaseEo)itemDepartmentPriceEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemDepartmentPriceRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public ItemDepartmentPriceRespDto queryItemPrice(Long id, String departmentCode) {
        ItemDepartmentPriceEo queryEo = new ItemDepartmentPriceEo();
        queryEo.setItemId(id);
        queryEo.setDepartmentCode(departmentCode);
        ItemDepartmentPriceEo itemDepartmentPriceEo = (ItemDepartmentPriceEo)this.itemDepartmentPriceDas.selectOne((BaseEo)queryEo);
        if (null != itemDepartmentPriceEo && null != itemDepartmentPriceEo.getId()) {
            ItemDepartmentPriceRespDto itemDepartmentPriceRespDto = new ItemDepartmentPriceRespDto();
            DtoHelper.eo2Dto((BaseEo)itemDepartmentPriceEo, (BaseVo)itemDepartmentPriceRespDto);
            return itemDepartmentPriceRespDto;
        }
        return null;
    }

    @Override
    public ItemDepartmentPriceRespDto queryItemPriceByCode(String code, String unit) {
        ItemDepartmentPriceEo queryEo = new ItemDepartmentPriceEo();
        queryEo.setCode(code);
        queryEo.setItemUnit(unit);
        List priceEoList = this.itemDepartmentPriceDas.select((BaseEo)queryEo);
        if (CollectionUtils.isNotEmpty((Collection)priceEoList)) {
            ArrayList<ItemDepartmentPriceRespDto> dtoList = new ArrayList<ItemDepartmentPriceRespDto>();
            for (ItemDepartmentPriceEo priceEo : priceEoList) {
                ItemDepartmentPriceRespDto itemDepartmentPriceRespDto = new ItemDepartmentPriceRespDto();
                DtoHelper.eo2Dto((BaseEo)priceEo, (BaseVo)itemDepartmentPriceRespDto);
                if (StringUtils.isNotEmpty((CharSequence)priceEo.getDepartmentCode())) {
                    itemDepartmentPriceRespDto.setDeptCode(Integer.valueOf(priceEo.getDepartmentCode()));
                }
                if (priceEo.getItemPrice().compareTo(BigDecimal.ZERO) <= 0) continue;
                dtoList.add(itemDepartmentPriceRespDto);
            }
            if (CollectionUtils.isNotEmpty(dtoList)) {
                ItemDepartmentPriceRespDto respDto = (ItemDepartmentPriceRespDto)dtoList.stream().sorted(Comparator.comparing(ItemDepartmentPriceRespDto::getDeptCode)).collect(Collectors.toList()).get(0);
                logger.info("respDto = {}", (Object)JSONObject.toJSONString((Object)respDto));
                return respDto;
            }
        }
        return null;
    }
}

