/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.impl;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.enums.SortOrder;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlOrderBy;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.CollectionItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.CollectionItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.CollectionRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.ICollectionItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.impl.CollectionServiceImpl;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.CollectionDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.CollectionItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.CollectionEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.CollectionItemEo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Primary
@Service
public class CollectionServiceImplExt
extends CollectionServiceImpl {
    @Resource
    private CollectionDas collectionDas;
    @Resource
    private CollectionItemDas collectionItemDas;
    @Resource
    private ICollectionItemService collectionItemService;
    @Resource
    private IContext context;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public RestResponse<CollectionRespDto> getCollection(Long tenantId, Long instanceId, String userSrc, String userSerial, String collectionType, Integer isCreate) {
        CollectionEo collection = new CollectionEo();
        collection.setTenantId(tenantId);
        collection.setUserSrc(userSrc);
        collection.setInstanceId(instanceId);
        collection.setUserSerial(userSerial);
        collection.setCollectionType(collectionType);
        CollectionEo result = this.get(collection, isCreate);
        CollectionRespDto collectionRespDto = new CollectionRespDto();
        if (result != null) {
            BeanUtils.copyProperties((Object)result, (Object)collectionRespDto);
            return new RestResponse((Object)collectionRespDto);
        }
        return new RestResponse(null);
    }

    @Override
    public RestResponse<CollectionItemRespDto> addCollectionItem(CollectionItemReqDto collectionItem) {
        CollectionItemEo collectionItemEo = new CollectionItemEo();
        CubeBeanUtils.copyProperties((Object)collectionItemEo, (Object)collectionItem, (String[])new String[0]);
        collectionItemEo = this.collectionItemService.addCollectionItem(collectionItemEo);
        CollectionItemRespDto collectionItemRespDto = new CollectionItemRespDto();
        if (collectionItemEo != null) {
            CubeBeanUtils.copyProperties((Object)collectionItemRespDto, (Object)collectionItemEo, (String[])new String[0]);
            collectionItemRespDto.setCollectItemId(collectionItemRespDto.getId());
        }
        return new RestResponse((Object)collectionItemRespDto);
    }

    @Override
    public RestResponse<Void> removeCollectionItem(Long id) {
        this.collectionItemService.removeCollectionItem(id);
        return new RestResponse();
    }

    @Override
    public RestResponse<Void> removeItem(String itemId, String shopId, Long collectId) {
        this.collectionItemService.removeItem(itemId, shopId, collectId);
        return new RestResponse();
    }

    @Override
    public Boolean queryCollected(Long itemId, Long shopId) {
        Long userId = this.context.userId();
        Boolean collected = false;
        if (userId != null) {
            PageInfo<CollectionItemRespDto> pageInfo = this.queryCollectionItem(userId, 1, 1000);
            List collectionItemRespDtos = pageInfo.getList();
            for (CollectionItemRespDto collectionItemRespDto : collectionItemRespDtos) {
                if (!itemId.toString().equals(collectionItemRespDto.getItemSerial()) || !shopId.toString().equals(collectionItemRespDto.getShopSerial())) continue;
                collected = true;
                break;
            }
        }
        return collected;
    }

    @Override
    public PageInfo<CollectionItemRespDto> queryCollectionItem(Long userId, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo = new PageInfo();
        ArrayList itemList = new ArrayList();
        CollectionEo collection = new CollectionEo();
        collection.setUserSerial(String.valueOf(userId));
        CollectionEo collectionEo = this.get(collection);
        if (collectionEo == null) {
            return pageInfo;
        }
        CollectionItemEo collectionItemEo = new CollectionItemEo();
        collectionItemEo.setCollectionId(collectionEo.getId());
        ArrayList sqlOrderBys = Lists.newArrayList();
        sqlOrderBys.add(new SqlOrderBy("update_time", SortOrder.DESC));
        collectionItemEo.setSqlOrderBys((List)sqlOrderBys);
        PageInfo collectionItemEoPageInfo = this.collectionItemDas.selectPage((BaseEo)collectionItemEo, pageNum, pageSize);
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)collectionItemEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        CubeBeanUtils.copyCollection(itemList, (Collection)collectionItemEoPageInfo.getList(), CollectionItemRespDto.class);
        pageInfo.setList(itemList);
        return pageInfo;
    }

    @Override
    public CollectionEo get(CollectionEo collection, Integer isCreate) {
        CollectionEo collectionEo = this.get(collection);
        if (collectionEo == null && isCreate.equals(1)) {
            collectionEo = new CollectionEo();
            collectionEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
            collectionEo.setInstanceId(collection.getInstanceId());
            collectionEo.setTenantId(collection.getTenantId());
            collectionEo.setUserSrc(collection.getUserSrc());
            collectionEo.setUserSerial(collection.getUserSerial());
            collectionEo.setCollectionType(collection.getCollectionType());
            this.collectionDas.insert((BaseEo)collectionEo);
        }
        return collectionEo;
    }

    @Override
    public CollectionEo get(CollectionEo collection) {
        return (CollectionEo)this.collectionDas.selectOne((BaseEo)collection);
    }
}

