/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.util;

import com.dtyunxi.yundt.cube.center.item.api.constants.WeightUnitEnum;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeightUnitUtils {
    private static Logger logger = LoggerFactory.getLogger(WeightUnitUtils.class);

    public static BigDecimal totalWeight(BigDecimal num, String unit) {
        return WeightUnitUtils.totalWeight(num, unit, WeightUnitEnum.KG.getUnit());
    }

    public static BigDecimal totalWeight(BigDecimal num, String unit, String toUnit) {
        logger.info("\u5355\u4f4d\u8f6c\u6362 num = {},unit = {},toUnit = {}", new Object[]{num, unit, toUnit});
        if (null == num || num.compareTo(BigDecimal.ZERO) < 0) {
            return BigDecimal.ZERO;
        }
        WeightUnitEnum unitEnum = WeightUnitEnum.getEnumByUnit((String)unit);
        if (null == unitEnum) {
            return BigDecimal.ZERO;
        }
        WeightUnitEnum toUnitEnum = WeightUnitEnum.getEnumByUnit((String)toUnit);
        if (null == toUnitEnum) {
            return BigDecimal.ZERO;
        }
        BigDecimal it = num.multiply(unitEnum.getConversionNum()).divide(unitEnum.getBaseNum(), 10, 6);
        BigDecimal toIt = toUnitEnum.getConversionNum().divide(toUnitEnum.getBaseNum(), 10, 6);
        BigDecimal totalWeight = it.divide(toIt, 10, 6).setScale(3, 1);
        logger.info("\u5355\u4f4d\u8f6c\u6362 totalWeight = {}", (Object)totalWeight);
        return totalWeight;
    }

    public static void main(String[] args) {
        BigDecimal totalWeight = WeightUnitUtils.totalWeight(new BigDecimal(1), "MG");
        System.out.println(totalWeight);
    }
}

