/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemStatus;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.DirItemRelativeReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemShelfQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfQueryReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ShelfReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirItemRelativeQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemAttributesRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemPriceRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.PointsDeductionRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ShelfIntegralRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ShelfQueryRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemBusinessRuntimeException;
import com.dtyunxi.yundt.cube.center.item.api.base.exception.ItemExceptionCode;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemAttributesService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemSearchService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IShelfCacheService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IShelfIntegralService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IShelfService;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirItemRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemMediasDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemPriceDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemSkuDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemStorageDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ShelfDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ShelfPointsDeductionDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.vo.ShelfItemSkuVo;
import com.dtyunxi.yundt.cube.center.item.dao.base.vo.ShelfItemVo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirItemRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemMediasEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemStorageEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ShelfEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ShelfPointsDeductionEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemMediasEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdShelfEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;

public class AbstractShelfServiceImpl
implements IShelfService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractShelfServiceImpl.class);
    @Resource
    private ShelfDas shelfDas;
    @Resource
    private ItemMediasDas itemMediasDas;
    @Resource
    private ItemPriceDas itemPriceDas;
    public static final String SHELF_ITEM = "SHELF_ITEM";
    @Resource
    private ShelfPointsDeductionDas shelfPointsDeductionDas;
    @Resource
    private ItemSkuDas itemSkuDas;
    @Resource
    private ItemStorageDas itemStorageDas;
    @Autowired
    private IShelfCacheService shelfCacheService;
    @Resource
    private IItemService itemService;
    @Resource
    private DirItemRelationDas dirItemRelationDas;
    @Resource
    private IItemSearchService itemSearchService;
    @Resource
    private IItemAttributesService itemAttributesService;
    @Autowired(required=false)
    private IShelfIntegralService shelfIntegralService;

    @Override
    public PageInfo<ItemShelfQueryRespDto> getItemShelfPage(ItemShelfQueryReqDto itemShelfQueryReqDto, Integer pageNum, Integer pageSize) {
        PageInfo pageInfo;
        LinkedList dtoList = Lists.newLinkedList();
        ShelfItemVo shelfItemVo = new ShelfItemVo();
        CubeBeanUtils.copyProperties((Object)shelfItemVo, (Object)itemShelfQueryReqDto, (String[])new String[0]);
        if (itemShelfQueryReqDto.getGroupBy() == null) {
            shelfItemVo.setGroupBy(Integer.valueOf(1));
        }
        if (ItemStatus.ITEM_SALE_OUT.getStatus().equals(itemShelfQueryReqDto.getItemStatus())) {
            shelfItemVo.setSellOut(Boolean.valueOf(true));
            shelfItemVo.setItemStatus(null);
        }
        if ((pageInfo = this.shelfDas.selectSelfItemByPage(shelfItemVo, pageNum, pageSize)) != null && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            List voList = pageInfo.getList();
            CubeBeanUtils.copyCollection((Collection)dtoList, (Collection)voList, ItemShelfQueryRespDto.class);
            List<Long> shopIdList = dtoList.stream().map(ItemShelfQueryRespDto::getShopId).distinct().collect(Collectors.toList());
            List<Long> itemIdList = dtoList.stream().map(ItemShelfQueryRespDto::getItemId).distinct().collect(Collectors.toList());
            Integer busType = itemShelfQueryReqDto.getBusType();
            Map<String, List<ItemShelfSkuRespDto>> itemShelfSkuRespDtoMap = this.queryItemShelfSkuMap(shopIdList, itemIdList, busType);
            Map<Object, Object> itemMediaMap = Maps.newHashMap();
            List itemMediasEoList = this.itemMediasDas.selectByItemIds(itemIdList);
            if (CollectionUtils.isNotEmpty((Collection)itemMediasEoList)) {
                itemMediaMap = itemMediasEoList.stream().collect(Collectors.groupingBy(StdItemMediasEo::getItemId));
            }
            HashMap finalItemMediaMap = itemMediaMap;
            HashSet brandIds = Sets.newHashSet();
            HashSet dirIds = Sets.newHashSet();
            for (ItemShelfQueryRespDto itemShelfQueryRespDto : dtoList) {
                if (Objects.nonNull(itemShelfQueryRespDto.getBrandId())) {
                    brandIds.add(itemShelfQueryRespDto.getBrandId());
                }
                dirIds.add(itemShelfQueryRespDto.getDirId());
            }
            List<ItemAttributesRespDto> itemAttributesRespDtos = this.itemAttributesService.queryItemAttrByItemIdList(itemIdList);
            HashMap<Long, List> dirListMap = new HashMap<Long, List>();
            for (ItemAttributesRespDto itemAttributesRespDto : itemAttributesRespDtos) {
                JSONObject jsonObject = JSON.parseObject((String)itemAttributesRespDto.getAttrs());
                JSONArray backDirListJson = jsonObject.getJSONArray("backDirList");
                List backDirList = backDirListJson.toJavaList(Long.class);
                dirListMap.put(itemAttributesRespDto.getItemId(), backDirList);
                dirIds.addAll(backDirList);
            }
            Map<Long, String> brandMap = this.itemService.getBrandMapByBrandIds(Lists.newArrayList((Iterable)brandIds));
            Map<Long, String> dirMap = this.itemService.getDirMapByDirIds(Lists.newArrayList((Iterable)dirIds));
            List<Long> itemIds = dtoList.stream().map(ItemShelfQueryRespDto::getItemId).collect(Collectors.toList());
            List<Long> shopIds = dtoList.stream().map(ItemShelfQueryRespDto::getShopId).collect(Collectors.toList());
            List<Integer> busTypes = dtoList.stream().map(ItemShelfQueryRespDto::getBusType).distinct().collect(Collectors.toList());
            Map<String, List<DirItemRelativeQueryRespDto>> dirRelativeMap = this.itemService.queryItemDirRelativeBatch(itemIds, shopIds, busTypes).stream().collect(Collectors.groupingBy(o -> "" + o.getItemId() + o.getShopId() + o.getBusType()));
            dtoList.forEach(dto -> {
                Map<String, List<DirItemRelativeQueryRespDto>> itemFrontDirMap;
                List<DirItemRelativeQueryRespDto> itemFrontDirList;
                List itemMediasEos = (List)finalItemMediaMap.get(dto.getItemId());
                if (CollectionUtils.isNotEmpty((Collection)itemMediasEos)) {
                    dto.setImgPath(((ItemMediasEo)itemMediasEos.get(0)).getPath1());
                }
                DirItemRelativeReqDto dirItemRelativeReqDto = new DirItemRelativeReqDto();
                dirItemRelativeReqDto.setDirType("front");
                dirItemRelativeReqDto.setItemId(dto.getItemId());
                dirItemRelativeReqDto.setShopId(dto.getShopId());
                dirItemRelativeReqDto.setBusType(dto.getBusType());
                List dirItemRelativeQueryRespDtos = (List)dirRelativeMap.get("" + dto.getItemId() + dto.getShopId() + dto.getBusType());
                if (CollectionUtils.isNotEmpty((Collection)dirItemRelativeQueryRespDtos) && CollectionUtils.isNotEmpty(itemFrontDirList = (itemFrontDirMap = dirItemRelativeQueryRespDtos.stream().collect(Collectors.groupingBy(dirItemRelativeQueryRespDto -> dirItemRelativeQueryRespDto.getShopId() + dirItemRelativeQueryRespDto.getItemId() + ""))).get(dto.getShopId() + dto.getItemId() + ""))) {
                    dto.setFrontDirIdList(itemFrontDirList.stream().map(DirItemRelativeQueryRespDto::getDirId).distinct().collect(Collectors.toList()));
                    dto.setFrontDirNameList(itemFrontDirList.stream().map(DirItemRelativeQueryRespDto::getDirName).distinct().collect(Collectors.toList()));
                }
                List skuList = (List)itemShelfSkuRespDtoMap.get("" + dto.getShopId() + dto.getItemId());
                dto.setSkuList(skuList);
                if (Objects.nonNull(dto.getBrandId())) {
                    String brand = (String)brandMap.get(dto.getBrandId());
                    dto.setBrand(brand);
                }
                dto.setDirName((String)dirMap.get(dto.getDirId()));
                List dirIdList = (List)dirListMap.get(dto.getItemId());
                dto.setDirIdList(dirIdList);
                ArrayList<String> dirNameList = new ArrayList<String>();
                dto.setDirNameList(dirNameList);
                if (CollectionUtils.isNotEmpty((Collection)dirIdList)) {
                    for (Long dirId : dirIdList) {
                        String dirName = (String)dirMap.get(dirId);
                        dirNameList.add(dirName);
                    }
                }
            });
        }
        PageInfo resultPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)resultPageInfo, (Object)pageInfo, (String[])new String[]{"list", "navigatepageNums"});
        resultPageInfo.setList((List)dtoList);
        return resultPageInfo;
    }

    static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    @Override
    public List<ItemShelfSkuRespDto> queryShelfItemSkuList(Long shopId, Long itemId, Integer busType) {
        ArrayList itemShelfSkuRespDtoList = Lists.newArrayList();
        List list = this.shelfDas.selectSelfItemSkuList(shopId, itemId, busType);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            CubeBeanUtils.copyCollection((Collection)itemShelfSkuRespDtoList, (Collection)list, ItemShelfSkuRespDto.class);
            List skuIds = list.stream().map(ShelfItemSkuVo::getId).collect(Collectors.toList());
            List itemPriceEoList = this.itemPriceDas.selectBySkuIds(skuIds);
            ArrayList itemPriceRespDtoList = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)itemPriceEoList, (Collection)itemPriceRespDtoList, ItemPriceRespDto.class);
            Map group = itemPriceRespDtoList.stream().collect(Collectors.groupingBy(ItemPriceRespDto::getSkuId, Collectors.toList()));
            itemShelfSkuRespDtoList.forEach(sku -> sku.setItemPriceList((List)group.get(sku.getId())));
        }
        List<ItemShelfSkuRespDto> collect = itemShelfSkuRespDtoList.stream().filter(itemShelfSkuRespDto -> itemShelfSkuRespDto.getId() != null).filter(AbstractShelfServiceImpl.distinctByKey(itemShelfSkuRespDto -> itemShelfSkuRespDto.getId())).collect(Collectors.toList());
        return collect;
    }

    private Map<String, List<ItemShelfSkuRespDto>> queryItemShelfSkuMap(List<Long> shopIdList, List<Long> itemIdList, Integer busType) {
        Map<Object, Object> itemShelfSkuMap = Maps.newHashMap();
        List shelfEoList = this.shelfDas.selectByParam(shopIdList, itemIdList, null, busType);
        if (CollectionUtils.isNotEmpty((Collection)shelfEoList)) {
            List itemPriceEoList;
            List itemStorageEoList;
            List<ItemShelfSkuRespDto> itemShelfSkuRespDtoList = shelfEoList.stream().map(shelfEo -> {
                ItemShelfSkuRespDto itemShelfSkuRespDto = new ItemShelfSkuRespDto();
                itemShelfSkuRespDto.setShopId(shelfEo.getShopId());
                itemShelfSkuRespDto.setItemId(shelfEo.getItemId());
                itemShelfSkuRespDto.setId(shelfEo.getSkuId());
                itemShelfSkuRespDto.setPrice(shelfEo.getPrice());
                return itemShelfSkuRespDto;
            }).collect(Collectors.toList());
            List skuIdList = shelfEoList.stream().map(StdShelfEo::getSkuId).distinct().collect(Collectors.toList());
            List itemSkuEoList = this.itemSkuDas.selectItemSkuByIds(skuIdList);
            if (CollectionUtils.isNotEmpty((Collection)itemSkuEoList)) {
                Map itemSkuEoMap = itemSkuEoList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
                itemShelfSkuRespDtoList.forEach(itemShelfSkuRespDto -> {
                    ItemSkuEo itemSkuEo = (ItemSkuEo)itemSkuEoMap.get(itemShelfSkuRespDto.getId());
                    if (itemSkuEo != null) {
                        itemShelfSkuRespDto.setCode(itemSkuEo.getCode());
                        itemShelfSkuRespDto.setName(itemSkuEo.getName());
                        itemShelfSkuRespDto.setCspuid(itemSkuEo.getCspuid());
                        itemShelfSkuRespDto.setAttr(itemSkuEo.getAttr());
                        itemShelfSkuRespDto.setCargoCode(itemSkuEo.getCargoCode());
                    }
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)(itemStorageEoList = this.itemStorageDas.selectByParam(shopIdList, itemIdList, skuIdList)))) {
                Map<String, List<ItemStorageEo>> itemStorageEoMap = itemStorageEoList.stream().filter(itemStorageEo -> itemStorageEo.getShopId() != null && itemStorageEo.getItemId() != null && itemStorageEo.getSkuId() != null).collect(Collectors.groupingBy(itemStorageEo -> "" + itemStorageEo.getShopId() + itemStorageEo.getItemId() + itemStorageEo.getSkuId()));
                itemShelfSkuRespDtoList.forEach(itemShelfSkuRespDto -> {
                    List itemStorageEos = (List)itemStorageEoMap.get("" + itemShelfSkuRespDto.getShopId() + itemShelfSkuRespDto.getItemId() + itemShelfSkuRespDto.getId());
                    if (CollectionUtils.isNotEmpty((Collection)itemStorageEos)) {
                        itemShelfSkuRespDto.setBalance(((ItemStorageEo)itemStorageEos.get(0)).getBalance());
                    }
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)(itemPriceEoList = this.itemPriceDas.selectBySkuIds(skuIdList)))) {
                ArrayList itemPriceRespDtoList = Lists.newArrayList();
                DtoHelper.eoList2DtoList((Collection)itemPriceEoList, (Collection)itemPriceRespDtoList, ItemPriceRespDto.class);
                Map itemPriceRespDtoMap = itemPriceRespDtoList.stream().collect(Collectors.groupingBy(ItemPriceRespDto::getSkuId, Collectors.toList()));
                itemShelfSkuRespDtoList.forEach(itemShelfSkuRespDto -> itemShelfSkuRespDto.setItemPriceList((List)itemPriceRespDtoMap.get(itemShelfSkuRespDto.getId())));
            }
            itemShelfSkuMap = itemShelfSkuRespDtoList.stream().collect(Collectors.groupingBy(itemShelfSkuRespDto -> "" + itemShelfSkuRespDto.getShopId() + itemShelfSkuRespDto.getItemId()));
        }
        return itemShelfSkuMap;
    }

    @Override
    public Long countItemShelf(ItemShelfQueryReqDto itemShelfQueryReqDto) {
        ShelfItemVo shelfItemVo = new ShelfItemVo();
        CubeBeanUtils.copyProperties((Object)shelfItemVo, (Object)itemShelfQueryReqDto, (String[])new String[0]);
        if (ItemStatus.ITEM_SALE_OUT.getStatus().equals(itemShelfQueryReqDto.getItemStatus())) {
            shelfItemVo.setSellOut(Boolean.valueOf(true));
            shelfItemVo.setItemStatus(null);
        }
        return this.shelfDas.selectSelfItemCount(shelfItemVo);
    }

    @Override
    @Cacheable(value={"SHELF_ITEM"}, key="#itemShelfQueryReqDto.shopId+'_'+#itemShelfQueryReqDto.skuId+'_'+#itemShelfQueryReqDto.busType", unless="#result == null")
    public ItemShelfRespDto queryItemShelf(ShelfReqDto itemShelfQueryReqDto) {
        ShelfEo shelfEo = new ShelfEo();
        shelfEo.setSkuId(itemShelfQueryReqDto.getSkuId());
        shelfEo.setShopId(itemShelfQueryReqDto.getShopId());
        shelfEo.setBusType(itemShelfQueryReqDto.getBusType());
        List select = this.shelfDas.select((BaseEo)shelfEo);
        if (CollectionUtils.isNotEmpty((Collection)select)) {
            ItemShelfRespDto itemShelfSkuRespDto = new ItemShelfRespDto();
            ShelfEo shelf = (ShelfEo)select.get(0);
            BeanUtils.copyProperties((Object)shelf, (Object)itemShelfSkuRespDto);
            if (shelf.getBusType() != null && shelf.getBusType().equals(ItemBusTypeEnum.INTEGRAL.getType()) && null != this.shelfIntegralService) {
                ShelfIntegralRespDto shelfIntegralRespDto = this.shelfIntegralService.queryByShelfId(shelf.getId());
                itemShelfSkuRespDto.setShelfIntegral(shelfIntegralRespDto);
            }
            return itemShelfSkuRespDto;
        }
        return null;
    }

    @Override
    public void clearItemShelfCache(ShelfReqDto itemShelfQueryReqDto) {
        this.shelfCacheService.clearItemShelfCache(itemShelfQueryReqDto);
    }

    @Override
    public void removeItemShelf(Long id) {
        ShelfEo shelfEo = (ShelfEo)this.shelfDas.selectByPrimaryKey(id);
        if (Objects.isNull(shelfEo)) {
            throw new ItemBusinessRuntimeException(ItemExceptionCode.NON_EXIST_ITEM.getCode(), ItemExceptionCode.NON_EXIST_ITEM.getMsg());
        }
        this.shelfDas.logicDeleteByExample((BaseEo)shelfEo);
        List offDirItems = this.dirItemRelationDas.selectByParam(shelfEo.getShopId(), shelfEo.getItemId());
        if (CollectionUtils.isNotEmpty((Collection)offDirItems)) {
            offDirItems.forEach(dirItemRelationEo -> this.dirItemRelationDas.logicDeleteById(dirItemRelationEo.getId()));
            logger.info("\u540c\u6b65\u5220\u9664ES\u4e2d\u7684\u4e0a\u67b6\u4fe1\u606f: shelfId={}", (Object)id);
            Map<String, DirItemRelationEo> offDirItemMap = offDirItems.stream().collect(Collectors.toMap(dirItem -> dirItem.getItemId().toString() + dirItem.getShopId(), e -> e, (e1, e2) -> e1));
            offDirItemMap.forEach((k, dirItem) -> this.itemSearchService.index(dirItem.getSellerId(), dirItem.getItemId(), shelfEo.getBusType(), "OFF_SHELF"));
        }
    }

    @Override
    public void batchRemoveShelf(String ids) {
        String[] idList;
        for (String id : idList = ids.split(",")) {
            this.removeItemShelf(Long.valueOf(id));
        }
    }

    @Override
    public List<PointsDeductionRespDto> queryShelfItemPointsDeduction(Set<Long> shelfIds) {
        ArrayList list = Lists.newArrayList();
        ShelfPointsDeductionEo paramEo = ShelfPointsDeductionEo.newInstance();
        ArrayList sqlFilterList = Lists.newArrayList();
        SqlFilter sqlFilter = SqlFilter.in((String)"shelfId", shelfIds);
        sqlFilterList.add(sqlFilter);
        paramEo.setSqlFilters((List)sqlFilterList);
        List shelfPointsDeductionEos = this.shelfPointsDeductionDas.select((BaseEo)paramEo);
        if (CollectionUtils.isNotEmpty((Collection)shelfPointsDeductionEos)) {
            DtoHelper.eoList2DtoList((Collection)shelfPointsDeductionEos, (Collection)list, PointsDeductionRespDto.class);
        }
        return list;
    }

    @Override
    public List<ShelfQueryRespDto> queryShelfList(ShelfQueryReqDto shelfQueryReqDto) {
        ArrayList list = Lists.newArrayList();
        ShelfEo shelfParam = ShelfEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)shelfQueryReqDto, (BaseEo)shelfParam);
        ArrayList sqlFilters = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)shelfQueryReqDto.getItemIds())) {
            sqlFilters.add(SqlFilter.in((String)"item_id", (Object)shelfQueryReqDto.getItemIds()));
            shelfParam.setItemId(null);
        }
        if (CollectionUtils.isNotEmpty((Collection)shelfQueryReqDto.getShopIds())) {
            sqlFilters.add(SqlFilter.in((String)"shop_id", (Object)shelfQueryReqDto.getShopIds()));
            shelfParam.setShopId(null);
        }
        if (CollectionUtils.isNotEmpty((Collection)shelfQueryReqDto.getSkuIds())) {
            sqlFilters.add(SqlFilter.in((String)"sku_id", (Object)shelfQueryReqDto.getSkuIds()));
            shelfParam.setSkuId(null);
        }
        shelfParam.setSqlFilters((List)sqlFilters);
        List shelfEoList = this.shelfDas.select((BaseEo)shelfParam);
        if (CollectionUtils.isNotEmpty((Collection)shelfEoList)) {
            DtoHelper.eoList2DtoList((Collection)shelfEoList, (Collection)list, ShelfQueryRespDto.class);
        }
        return list;
    }

    @Override
    @Cacheable(value={"ITEM_SHELF_CACHE"}, key="#itemId", unless="#result== null")
    public List<ItemShelfRespDto> queryByItemId(Long itemId) {
        ShelfEo shelfEo = ShelfEo.newInstance();
        shelfEo.setItemId(itemId);
        List shelfEos = this.shelfDas.select((BaseEo)shelfEo);
        ArrayList shelfRespDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)shelfRespDtos, (Collection)shelfEos, ItemShelfRespDto.class);
        return shelfRespDtos;
    }

    @Override
    public Long newCountItemShelf(ItemShelfQueryReqDto itemShelfQueryReqDto) {
        ShelfItemVo shelfItemVo = new ShelfItemVo();
        CubeBeanUtils.copyProperties((Object)shelfItemVo, (Object)itemShelfQueryReqDto, (String[])new String[0]);
        return this.shelfDas.newSelectSelfItemCount(shelfItemVo);
    }

    @Override
    public List<ItemShelfRespDto> queryHomepageList(Integer type) {
        ArrayList result = Lists.newArrayList();
        ShelfEo shelfEo = ShelfEo.newInstance();
        ArrayList sqlFilters = Lists.newArrayList();
        if (ObjectUtil.isNotEmpty((Object)type)) {
            sqlFilters.add(SqlFilter.like((String)"home_page_display", (Object)("%" + type + "%")));
            shelfEo.setHomePageDisplay(null);
        }
        shelfEo.setSqlFilters((List)sqlFilters);
        List shelfEoList = this.shelfDas.select((BaseEo)shelfEo);
        if (CollectionUtils.isNotEmpty((Collection)shelfEoList)) {
            DtoHelper.eoList2DtoList((Collection)shelfEoList, (Collection)result, ItemShelfRespDto.class);
        }
        return result;
    }
}

