/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemApi;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemOffShelfReqListDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.OffItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.github.pagehelper.PageInfo;
import com.yx.tcbj.center.api.constants.ItemInterceptConfigEnum;
import com.yx.tcbj.center.api.constants.YesOrNoEnum;
import com.yx.tcbj.center.api.dto.request.ItemInterceptDetailReqDto;
import com.yx.tcbj.center.api.dto.response.ItemInterceptDetailRespDto;
import com.yx.tcbj.center.biz.service.IItemInterceptDetailService;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import com.yx.tcbj.center.dao.das.ItemInterceptDetailDas;
import com.yx.tcbj.center.dao.eo.ItemInterceptDetailEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class ItemInterceptDetailServiceImpl
implements IItemInterceptDetailService {
    @Resource
    private ItemInterceptDetailDas itemInterceptConfigDas;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IItemApi itemApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private ISellerExtQueryApi sellerExtQueryApi;

    @Override
    public Long addItemInterceptConfig(ItemInterceptDetailReqDto addReqDto) {
        Assert.isTrue((!StringUtils.isEmpty((Object)addReqDto.getOrganizationId()) ? 1 : 0) != 0, (String)"\u7ec4\u7ec7ID\u4e3a\u7a7a");
        Assert.isTrue((!ObjectUtils.isEmpty((Object)addReqDto.getInterceptType()) ? 1 : 0) != 0, (String)"\u914d\u7f6e\u7c7b\u578b\u4e3a\u7a7a");
        Assert.isTrue((!CollectionUtils.isEmpty((Collection)addReqDto.getInterceptContents()) ? 1 : 0) != 0, (String)"\u914d\u7f6e\u5185\u5bb9\u4e3a\u7a7a");
        CustomerRespDto customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryByOrgInfoId(addReqDto.getOrganizationId()));
        Assert.isTrue((!ObjectUtils.isEmpty((Object)customerRespDto) ? 1 : 0) != 0, (String)"\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728");
        ItemInterceptConfigEnum itemInterceptConfigEnum = ItemInterceptConfigEnum.enumOfCode((Integer)addReqDto.getInterceptType());
        Assert.isTrue((!ObjectUtils.isEmpty((Object)itemInterceptConfigEnum) ? 1 : 0) != 0, (String)"\u914d\u7f6e\u7c7b\u578b\u9519\u8bef");
        ItemInterceptDetailEo itemInterceptConfigEo = new ItemInterceptDetailEo();
        itemInterceptConfigEo.setOrganizationId(addReqDto.getOrganizationId());
        List itemInterceptConfigEos = this.itemInterceptConfigDas.selectList((BaseEo)itemInterceptConfigEo);
        if (!CollectionUtils.isEmpty((Collection)itemInterceptConfigEos)) {
            ItemInterceptDetailEo interceptConfig = (ItemInterceptDetailEo)itemInterceptConfigEos.stream().findFirst().get();
            if (!itemInterceptConfigEnum.getCode().equals(interceptConfig.getInterceptType())) {
                ItemInterceptDetailEo itemInterceptConfigWrapper = new ItemInterceptDetailEo();
                itemInterceptConfigWrapper.setOrganizationId(addReqDto.getOrganizationId());
                this.itemInterceptConfigDas.delete((BaseEo)itemInterceptConfigWrapper);
            }
        }
        if (YesOrNoEnum.NO.getCode().equals(addReqDto.getStatus())) {
            ItemInterceptDetailEo itemInterceptConfigWrapper = new ItemInterceptDetailEo();
            SqlFilter.in((String)"intercept_content", (Object)addReqDto.getInterceptContents());
            itemInterceptConfigWrapper.setOrganizationId(addReqDto.getOrganizationId());
            itemInterceptConfigWrapper.setInterceptType(addReqDto.getInterceptType());
            this.itemInterceptConfigDas.delete((BaseEo)itemInterceptConfigWrapper);
        } else {
            List collect = addReqDto.getInterceptContents().stream().map(c -> {
                ItemInterceptDetailEo itemInterceptConfig = new ItemInterceptDetailEo();
                DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)itemInterceptConfig);
                itemInterceptConfig.setInterceptContent(c);
                return itemInterceptConfig;
            }).collect(Collectors.toList());
            this.itemInterceptConfigDas.insertBatch(collect);
            CompletableFuture.runAsync(() -> {
                List<ItemRespDto> itemRespDtos = this.getItemRespDtos(addReqDto, itemInterceptConfigEnum);
                SellerRespDto sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)this.sellerExtQueryApi.querySellerByOrganizationId(customerRespDto.getOrgInfoId()));
                ShopDto shopDto = (ShopDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryByCode(sellerRespDto.getCode()));
                ArrayList offItemReqDtos = new ArrayList();
                itemRespDtos.forEach(itemOffShelfReqDto -> {
                    OffItemReqDto offItemReqDto = new OffItemReqDto();
                    offItemReqDto.setBusType(itemOffShelfReqDto.getBusType() == null ? ItemBusTypeEnum.ORDINARY.getType() : itemOffShelfReqDto.getBusType());
                    offItemReqDto.setItemId(itemOffShelfReqDto.getItemId());
                    offItemReqDto.setSkuId(itemOffShelfReqDto.getSkuId());
                    offItemReqDto.setShopId(shopDto.getId());
                    offItemReqDtos.add(offItemReqDto);
                });
                ItemOffShelfReqListDto itemOffShelfReqListDto = new ItemOffShelfReqListDto();
                itemOffShelfReqListDto.setOffItemReqDtos(offItemReqDtos);
                this.itemApi.offShelfItem(itemOffShelfReqListDto);
            });
        }
        return null;
    }

    private List<ItemRespDto> getItemRespDtos(ItemInterceptDetailReqDto addReqDto, ItemInterceptConfigEnum itemInterceptConfigEnum) {
        List itemRespDtos = Lists.newArrayList();
        if (itemInterceptConfigEnum.equals((Object)ItemInterceptConfigEnum.brand)) {
            ItemReqDto itemDto = new ItemReqDto();
            List brandIds = addReqDto.getInterceptContents().stream().map(c -> Long.valueOf(c)).collect(Collectors.toList());
            itemDto.setBrandIdList(brandIds);
            PageInfo itemRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryByPage(JSON.toJSONString((Object)itemDto), Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE)));
            itemRespDtos = itemRespDtoPageInfo.getList();
        } else {
            itemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryByItemIds(String.join((CharSequence)",", addReqDto.getInterceptContents())));
        }
        return itemRespDtos;
    }

    @Override
    public void modifyItemInterceptConfig(ItemInterceptDetailReqDto modifyReqDto) {
        ItemInterceptDetailEo itemInterceptConfigEo = new ItemInterceptDetailEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)itemInterceptConfigEo);
        this.itemInterceptConfigDas.updateSelective((BaseEo)itemInterceptConfigEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeItemInterceptConfig(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.itemInterceptConfigDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ItemInterceptDetailRespDto queryById(Long id) {
        ItemInterceptDetailEo itemInterceptConfigEo = (ItemInterceptDetailEo)this.itemInterceptConfigDas.selectByPrimaryKey(id);
        ItemInterceptDetailRespDto itemInterceptConfigRespDto = new ItemInterceptDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)itemInterceptConfigEo, (BaseVo)itemInterceptConfigRespDto);
        return itemInterceptConfigRespDto;
    }

    @Override
    public PageInfo<ItemInterceptDetailRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ItemInterceptDetailReqDto itemInterceptConfigReqDto = (ItemInterceptDetailReqDto)JSON.parseObject((String)filter, ItemInterceptDetailReqDto.class);
        ItemInterceptDetailEo itemInterceptConfigEo = new ItemInterceptDetailEo();
        DtoHelper.dto2Eo((BaseVo)itemInterceptConfigReqDto, (BaseEo)itemInterceptConfigEo);
        PageInfo eoPageInfo = this.itemInterceptConfigDas.selectPage((BaseEo)itemInterceptConfigEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemInterceptDetailRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

