/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.biz.apiimpl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopBaseDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.ShopToBListRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopExtQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IBizOrganizationQueryApi;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.api.ISellerSkuPriceApi;
import com.yx.tcbj.center.api.UpdateItemPirceCacheDto;
import com.yx.tcbj.center.api.dto.request.SellerSkuPriceReqDto;
import com.yx.tcbj.center.api.dto.response.ProductPriceRespDto;
import com.yx.tcbj.center.api.dto.response.SellerSkuPriceRespDto;
import com.yx.tcbj.center.biz.service.ISellerSkuPriceChangeLogService;
import com.yx.tcbj.center.biz.service.ISellerSkuPriceService;
import com.yx.tcbj.center.biz.service.query.IItemCenterQueryService;
import com.yx.tcbj.center.biz.util.ItemPriceCacheUtil;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import com.yx.tcbj.center.dao.eo.SellerSkuPriceChangeLogEo;
import com.yx.tcbj.center.dao.eo.SellerSkuPriceEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="sellerSkuPriceApi")
public class SellerSkuPriceApiImpl
implements ISellerSkuPriceApi {
    private static final Logger log = LoggerFactory.getLogger(SellerSkuPriceApiImpl.class);
    @Resource
    private ISellerSkuPriceService sellerSkuPriceService;
    @Resource
    private IBizOrganizationQueryApi bizOrganizationQueryApi;
    @Resource
    private IItemCenterQueryService itemCenterQueryService;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IItemSkuQueryApi itemSkuQueryApi;
    @Resource
    private ISellerSkuPriceChangeLogService sellerSkuPriceChangeLogService;
    @Resource
    private IShopExtQueryApi shopExtQueryApi;
    @Autowired
    private ItemPriceCacheUtil itemPriceCacheUtil;
    @Value(value="${item.price.log.level:3}")
    private Integer logLevel;

    public RestResponse<Long> addSellerSkuPrice(SellerSkuPriceReqDto addReqDto) {
        return new RestResponse((Object)this.sellerSkuPriceService.addSellerSkuPrice(addReqDto));
    }

    public RestResponse<Void> modifySellerSkuPrice(SellerSkuPriceReqDto modifyReqDto) {
        this.sellerSkuPriceService.modifySellerSkuPrice(modifyReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeSellerSkuPrice(String ids, Long instanceId) {
        this.sellerSkuPriceService.removeSellerSkuPrice(ids, instanceId);
        return RestResponse.VOID;
    }

    public SellerSkuPriceReqDto getSellerSkuPriceByProductPrice(ProductPriceRespDto productPriceDto) {
        List list;
        Long customerId = null;
        Long sellerId = null;
        Long orgId = null;
        String shopName = null;
        Long shopId = null;
        Long itemId = null;
        Long skuId = null;
        String errorMsg = null;
        ArrayList thirdPartyIds = Lists.newArrayList();
        thirdPartyIds.add(productPriceDto.getApplierId());
        List customerRespDtos = (List)this.customerQueryApi.queryByThirdPartyIds((List)thirdPartyIds).getData();
        if (CollectionUtils.isEmpty((Collection)customerRespDtos) || Objects.isNull(((CustomerRespDto)customerRespDtos.get(0)).getId())) {
            errorMsg = "customerRespDtos\u4e3a\u7a7a,\u5931\u8d25\u53c2\u6570:";
        } else {
            customerId = ((CustomerRespDto)customerRespDtos.get(0)).getId();
        }
        ArrayList codes = Lists.newArrayList();
        codes.add(productPriceDto.getSupplierId());
        List organizationDtos = (List)this.bizOrganizationQueryApi.queryInfoByCodeList((List)codes).getData();
        if (CollectionUtils.isEmpty((Collection)organizationDtos) || Objects.isNull(((OrganizationDto)organizationDtos.get(0)).getId())) {
            errorMsg = "organizationDtos\u4e3a\u7a7a,\u5931\u8d25\u53c2\u6570:";
        }
        if (StringUtils.isEmpty((CharSequence)errorMsg)) {
            orgId = ((OrganizationDto)organizationDtos.get(0)).getId();
            CustomerRespDto sellRespDto = (CustomerRespDto)this.customerQueryApi.queryByOrgInfoId(orgId).getData();
            if (Objects.isNull(sellRespDto) || Objects.isNull(sellRespDto.getId())) {
                errorMsg = "sellerId\u6216merchantId\u4e3a\u7a7a,\u5931\u8d25\u53c2\u6570:";
            } else {
                sellerId = sellRespDto.getId();
            }
        }
        if (StringUtils.isEmpty((CharSequence)errorMsg)) {
            ItemRespDto itemRespDto = this.itemCenterQueryService.queryByLongCode(productPriceDto.getEasNo());
            if (Objects.isNull(itemRespDto) || Objects.isNull(itemRespDto.getId())) {
                errorMsg = "itemId\u4e3a\u7a7a,\u5931\u8d25\u53c2\u6570:";
            } else {
                itemId = itemRespDto.getId();
            }
        }
        if (StringUtils.isEmpty((CharSequence)errorMsg)) {
            List itemSkuRespDtos = (List)this.itemSkuQueryApi.queryByItemId(itemId).getData();
            if (CollectionUtils.isEmpty((Collection)itemSkuRespDtos) || Objects.isNull(((ItemSkuRespDto)itemSkuRespDtos.get(0)).getId())) {
                errorMsg = "skuId\u4e3a\u7a7a,\u5931\u8d25\u53c2\u6570:";
            } else {
                skuId = ((ItemSkuRespDto)itemSkuRespDtos.get(0)).getId();
            }
        }
        if (StringUtils.isEmpty((CharSequence)errorMsg) && Objects.nonNull(orgId) && CollectionUtils.isNotEmpty((Collection)(list = (List)RestResponseHelper.extractData((RestResponse)this.shopExtQueryApi.queryShopListBySellerOrgId(orgId))))) {
            shopName = ((ShopBaseDto)list.get(0)).getName();
            shopId = ((ShopBaseDto)list.get(0)).getId();
        }
        SellerSkuPriceReqDto sellerSkuPriceReqDto = new SellerSkuPriceReqDto();
        if (StringUtils.isEmpty((CharSequence)errorMsg)) {
            sellerSkuPriceReqDto.setSellerId(sellerId);
            sellerSkuPriceReqDto.setCustomerId(customerId);
            sellerSkuPriceReqDto.setItemId(itemId);
            sellerSkuPriceReqDto.setSkuId(skuId);
            sellerSkuPriceReqDto.setRetailPrice(productPriceDto.getBasePrice());
            sellerSkuPriceReqDto.setSupplyPrice(productPriceDto.getResultPrice());
            sellerSkuPriceReqDto.setShopName(shopName);
            sellerSkuPriceReqDto.setShopId(shopId);
        } else {
            sellerSkuPriceReqDto.setErrorMsg(errorMsg);
        }
        return sellerSkuPriceReqDto;
    }

    public void getSellerSkuPriceByProductPrice(List<ProductPriceRespDto> productPriceDtoList, List<SellerSkuPriceReqDto> updateList, List<SellerSkuPriceEo> addList, List<SellerSkuPriceChangeLogEo> sellerSkuPriceChangeLogEoList) {
        String supplierId = productPriceDtoList.get(0).getSupplierId();
        Map<String, ShopDto> shopMap = this.itemPriceCacheUtil.getShopMap(supplierId);
        if (shopMap == null) {
            log.info("\u5546\u5bb6\u4fe1\u606fid\u4fe1\u606f\u4e3a\u7a7a");
            return;
        }
        List<String> thirdPartyIds = productPriceDtoList.stream().map(ProductPriceRespDto::getApplierId).distinct().collect(Collectors.toList());
        Map<String, Long> applierCustomerIdMap = this.itemPriceCacheUtil.getApplierCustomerIdMap(thirdPartyIds);
        List<String> easNoList = productPriceDtoList.stream().map(ProductPriceRespDto::getEasNo).distinct().collect(Collectors.toList());
        Map<String, UpdateItemPirceCacheDto> itemDataMap = this.itemPriceCacheUtil.getItemDataMap(easNoList);
        if (CollectionUtils.isEmpty(productPriceDtoList = productPriceDtoList.stream().filter(dto -> {
            if (itemDataMap.get(dto.getEasNo()) == null) {
                sellerSkuPriceChangeLogEoList.add(this.initSellerSkuPriceChangeLog((ProductPriceRespDto)dto, "error", "\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728"));
                return false;
            }
            return true;
        }).collect(Collectors.toList()))) {
            return;
        }
        addList.addAll(productPriceDtoList.parallelStream().map(productPriceDto -> {
            Long customerId = (Long)applierCustomerIdMap.get(productPriceDto.getApplierId());
            UpdateItemPirceCacheDto pirceCacheDto = (UpdateItemPirceCacheDto)itemDataMap.get(productPriceDto.getEasNo());
            ShopDto shopDto = (ShopDto)shopMap.get(productPriceDto.getSupplierId());
            if (customerId != null && pirceCacheDto != null && shopDto != null) {
                Long itemId = pirceCacheDto.getItemId();
                Long skuId = pirceCacheDto.getSkuId();
                String shopName = shopDto.getName();
                Long sellerId = shopDto.getSellerId();
                Long shopId1 = shopDto.getId();
                return this.initSellerSkuPriceReqDto(customerId, sellerId, shopName, shopId1, itemId, skuId, (ProductPriceRespDto)productPriceDto);
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private String getRouteKey(Map<String, Long> applierCustomerIdMap, Map<String, UpdateItemPirceCacheDto> itemDataMap, ProductPriceRespDto pro) {
        return applierCustomerIdMap.get(pro.getApplierId()) + "" + itemDataMap.get(pro.getEasNo()).getItemId();
    }

    private SellerSkuPriceEo initSellerSkuPriceReqDto(Long customerId, Long sellerId, String shopName, Long shopId, Long itemId, Long skuId, ProductPriceRespDto productPriceDto) {
        SellerSkuPriceEo sellerSkuPriceReqDto = new SellerSkuPriceEo();
        sellerSkuPriceReqDto.setSellerId(sellerId);
        sellerSkuPriceReqDto.setCustomerId(customerId);
        sellerSkuPriceReqDto.setItemId(itemId);
        sellerSkuPriceReqDto.setSkuId(skuId);
        sellerSkuPriceReqDto.setRetailPrice(productPriceDto.getBasePrice());
        sellerSkuPriceReqDto.setSupplyPrice(productPriceDto.getResultPrice());
        sellerSkuPriceReqDto.setShopName(shopName);
        sellerSkuPriceReqDto.setShopId(shopId);
        return sellerSkuPriceReqDto;
    }

    public RestResponse<Boolean> addPrice(ProductPriceRespDto productPriceDto) {
        Long num;
        SellerSkuPriceReqDto sellerSkuPriceReqDto = this.getSellerSkuPriceByProductPrice(productPriceDto);
        String errorMsg = sellerSkuPriceReqDto.getErrorMsg();
        if (StringUtils.isEmpty((CharSequence)errorMsg) && (num = this.sellerSkuPriceService.addSellerSkuPrice(sellerSkuPriceReqDto)) == 0L) {
            errorMsg = "\u63d2\u5165\u5931\u8d25,\u5931\u8d25\u53c2\u6570:";
        }
        this.sellerSkuPriceChangeLogService.add(this.initSellerSkuPriceChangeLog(productPriceDto, "INIT", errorMsg));
        log.info("\u5546\u54c1\u4ef7\u683c\u65b0\u589e\u6210\u529f");
        return RestResponse.TRUE;
    }

    public RestResponse<Boolean> updatePrice(ProductPriceRespDto productPriceDto) {
        Long num;
        SellerSkuPriceReqDto sellerSkuPriceReqDto = this.getSellerSkuPriceByProductPrice(productPriceDto);
        String errorMsg = sellerSkuPriceReqDto.getErrorMsg();
        if (StringUtils.isEmpty((CharSequence)errorMsg) && (num = this.sellerSkuPriceService.updatePrice(sellerSkuPriceReqDto)) == 0L) {
            errorMsg = "\u66f4\u65b0\u5931\u8d25,\u5931\u8d25\u53c2\u6570:";
        }
        this.sellerSkuPriceChangeLogService.add(this.initSellerSkuPriceChangeLog(productPriceDto, "UPDATE", errorMsg));
        log.info("\u5546\u54c1\u4ef7\u683c\u66f4\u65b0\u6210\u529f");
        return RestResponse.TRUE;
    }

    public RestResponse<Boolean> updatePriceList(List<ProductPriceRespDto> productPriceList) {
        ArrayList updateList = Lists.newArrayList();
        ArrayList addList = Lists.newArrayList();
        ArrayList sellerSkuPriceChangeLogEoList = Lists.newArrayList();
        this.getSellerSkuPriceByProductPrice(productPriceList, updateList, addList, sellerSkuPriceChangeLogEoList);
        if (CollectionUtils.isNotEmpty((Collection)addList)) {
            log.info("\u65b0\u589e\u4ef7\u683c\u6210\u529f\u7684\u6570\u91cf:{}", (Object)addList.size());
            this.sellerSkuPriceService.addBatchPriceEoList(addList);
        }
        log.info("\u5546\u54c1\u4ef7\u683c\u66f4\u65b0\u6210\u529f");
        return RestResponse.TRUE;
    }

    public void updatePriceExt(ProductPriceRespDto productPriceRespDto) {
        ArrayList updateList = Lists.newArrayList();
        ArrayList addList = Lists.newArrayList();
        ArrayList sellerSkuPriceChangeLogEoList = Lists.newArrayList();
        this.getSellerSkuPriceByProductPriceExt(productPriceRespDto, updateList, addList, sellerSkuPriceChangeLogEoList);
        if (CollectionUtils.isNotEmpty((Collection)updateList)) {
            log.info("\u66f4\u65b0\u4ef7\u683c\u6210\u529f\u7684\u6570\u91cf:{}", (Object)updateList.size());
            this.sellerSkuPriceService.updateBatchPrice(updateList);
        }
        if (CollectionUtils.isNotEmpty((Collection)addList)) {
            log.info("\u65b0\u589e\u4ef7\u683c\u6210\u529f\u7684\u6570\u91cf:{}", (Object)addList.size());
            this.sellerSkuPriceService.addBatchPriceList(addList);
        }
        this.savaLog(sellerSkuPriceChangeLogEoList);
        log.info("\u5546\u54c1\u4ef7\u683c\u66f4\u65b0\u6210\u529f");
    }

    private void savaLog(List<SellerSkuPriceChangeLogEo> sellerSkuPriceChangeLogEoList) {
        if (this.logLevel == 3) {
            log.info("\u5546\u54c1\u4ef7\u683c\u66f4\u65b0\u6210\u529f");
            return;
        }
        if (CollectionUtils.isNotEmpty(sellerSkuPriceChangeLogEoList)) {
            if (Objects.equals(this.logLevel, 1)) {
                sellerSkuPriceChangeLogEoList = sellerSkuPriceChangeLogEoList.stream().filter(s -> "error".equals(s.getActionType())).collect(Collectors.toList());
            } else if (Objects.equals(this.logLevel, 2)) {
                sellerSkuPriceChangeLogEoList = sellerSkuPriceChangeLogEoList.stream().filter(s -> !"error".equals(s.getActionType())).collect(Collectors.toList());
            }
            this.sellerSkuPriceChangeLogService.addBatch(sellerSkuPriceChangeLogEoList);
        }
    }

    private void getSellerSkuPriceByProductPriceExt(ProductPriceRespDto productPriceRespDto, List<SellerSkuPriceReqDto> updateList, List<SellerSkuPriceReqDto> addList, List<SellerSkuPriceChangeLogEo> sellerSkuPriceChangeLogEoList) {
        String errorMsg = "";
        String thirdPartyId = productPriceRespDto.getApplierId();
        if (thirdPartyId == null) {
            log.info("applierId\u4e3a\u7a7a");
            errorMsg = "applierId\u4e3a\u7a7a";
            SellerSkuPriceChangeLogEo sellerSkuPriceChangeLogEo = this.initSellerSkuPriceChangeLog(productPriceRespDto, "error", errorMsg);
            sellerSkuPriceChangeLogEoList.add(sellerSkuPriceChangeLogEo);
            return;
        }
        CustomerRespDto customerRespDto = this.itemPriceCacheUtil.getSmallCustomerDto(thirdPartyId);
        if (customerRespDto == null || customerRespDto.getId() == null) {
            log.info("\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a1");
            errorMsg = "\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a1";
            SellerSkuPriceChangeLogEo sellerSkuPriceChangeLogEo = this.initSellerSkuPriceChangeLog(productPriceRespDto, "error", errorMsg);
            sellerSkuPriceChangeLogEoList.add(sellerSkuPriceChangeLogEo);
            return;
        }
        String codes = productPriceRespDto.getSupplierId();
        OrganizationDto organizationDto = this.itemPriceCacheUtil.getBigCustomerOrgInfoDto(codes);
        if (organizationDto == null || organizationDto.getId() == null) {
            log.info("\u7ec4\u7ec7\u4fe1\u606f\u4e3a\u7a7a");
            errorMsg = "\u7ec4\u7ec7\u4fe1\u606f\u4e3a\u7a7a";
            SellerSkuPriceChangeLogEo sellerSkuPriceChangeLogEo = this.initSellerSkuPriceChangeLog(productPriceRespDto, "error", errorMsg);
            sellerSkuPriceChangeLogEoList.add(sellerSkuPriceChangeLogEo);
            return;
        }
        UpdateItemPirceCacheDto itemInfo = this.itemPriceCacheUtil.getItemInfoByLongCode(productPriceRespDto.getEasNo());
        if (itemInfo == null || itemInfo.getItemId() == null) {
            log.info("\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a");
            errorMsg = "\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a";
            SellerSkuPriceChangeLogEo sellerSkuPriceChangeLogEo = this.initSellerSkuPriceChangeLog(productPriceRespDto, "error", errorMsg);
            sellerSkuPriceChangeLogEoList.add(sellerSkuPriceChangeLogEo);
            return;
        }
        ShopToBListRespDto shopBaseDto = this.itemPriceCacheUtil.getShopDtoByOrgId(customerRespDto.getMerchantId());
        if (shopBaseDto == null || shopBaseDto.getId() == null) {
            log.info("\u5e97\u94fa\u4fe1\u606f\u4e0d\u5b58\u5728");
            errorMsg = "\u5e97\u94fa\u4fe1\u606f\u4e0d\u5b58\u5728";
            SellerSkuPriceChangeLogEo sellerSkuPriceChangeLogEo = this.initSellerSkuPriceChangeLog(productPriceRespDto, "error", errorMsg);
            sellerSkuPriceChangeLogEoList.add(sellerSkuPriceChangeLogEo);
            return;
        }
        SellerSkuPriceRespDto oldSellerSkuPriceDto = this.sellerSkuPriceService.queryListByCustomerIdAndItemId(customerRespDto.getId(), itemInfo.getItemId());
        SellerSkuPriceReqDto sellerSkuPriceReqDto = new SellerSkuPriceReqDto();
        String actionType = "UPDATE";
        if (StringUtils.isBlank((CharSequence)errorMsg)) {
            log.info("\u67e5\u8be2\u5bf9\u5e94\u5ba2\u6237\u4ef7\u683c\u6570\u91cf\u4e3a:{}", (Object)JacksonUtil.toJson((Object)oldSellerSkuPriceDto));
            log.info("\u6ca1\u6709\u5f02\u5e38\u4fe1\u606f");
            sellerSkuPriceReqDto.setSellerId(customerRespDto.getMerchantId());
            sellerSkuPriceReqDto.setCustomerId(customerRespDto.getId());
            sellerSkuPriceReqDto.setItemId(itemInfo.getItemId());
            sellerSkuPriceReqDto.setSkuId(itemInfo.getSkuId());
            sellerSkuPriceReqDto.setRetailPrice(productPriceRespDto.getBasePrice());
            sellerSkuPriceReqDto.setSupplyPrice(productPriceRespDto.getResultPrice());
            sellerSkuPriceReqDto.setShopName(shopBaseDto.getName());
            sellerSkuPriceReqDto.setShopId(shopBaseDto.getId());
            if (oldSellerSkuPriceDto == null) {
                actionType = "ADD";
                addList.add(sellerSkuPriceReqDto);
            } else {
                updateList.add(sellerSkuPriceReqDto);
            }
        } else {
            sellerSkuPriceReqDto.setErrorMsg(errorMsg);
        }
        sellerSkuPriceReqDto.setProductPriceRespDto(productPriceRespDto);
        SellerSkuPriceChangeLogEo sellerSkuPriceChangeLogEo = this.initSellerSkuPriceChangeLog(productPriceRespDto, actionType, errorMsg);
        sellerSkuPriceChangeLogEoList.add(sellerSkuPriceChangeLogEo);
    }

    public RestResponse<Boolean> addNewPrice(List<ProductPriceRespDto> productPriceRespDto) {
        SellerSkuPriceEo skuPriceEo;
        ItemRespDto itemRespDto = this.itemCenterQueryService.queryByLongCode(productPriceRespDto.get(0).getEasNo());
        if (Objects.nonNull(itemRespDto) && Objects.nonNull(skuPriceEo = this.sellerSkuPriceService.queryByItemId(itemRespDto.getId()))) {
            for (ProductPriceRespDto productPriceDto : productPriceRespDto) {
                Long num;
                SellerSkuPriceReqDto sellerSkuPriceReqDto = this.getSellerSkuPriceByProductPrice(productPriceDto);
                String errorMsg = sellerSkuPriceReqDto.getErrorMsg();
                if (StringUtils.isEmpty((CharSequence)errorMsg) && (num = this.sellerSkuPriceService.addSellerSkuPrice(sellerSkuPriceReqDto)) == 0L) {
                    errorMsg = "\u63d2\u5165\u5931\u8d25,\u5931\u8d25\u53c2\u6570:";
                }
                this.sellerSkuPriceChangeLogService.add(this.initSellerSkuPriceChangeLog(productPriceDto, "NEW_INIT", errorMsg));
            }
            log.info("\u5546\u54c1\u4ef7\u683c\u65b0\u589e\u6210\u529f");
            return RestResponse.TRUE;
        }
        return RestResponse.FALSE;
    }

    public SellerSkuPriceChangeLogEo initSellerSkuPriceChangeLog(ProductPriceRespDto productPriceDto, String actionType, String errorMsg) {
        SellerSkuPriceChangeLogEo log = new SellerSkuPriceChangeLogEo();
        log.setId(null);
        CubeBeanUtils.copyProperties((Object)log, (Object)productPriceDto, (String[])new String[0]);
        log.setActionType(actionType);
        if (!StringUtils.isEmpty((CharSequence)errorMsg)) {
            log.setErrorMsg(errorMsg + JSONObject.toJSON((Object)productPriceDto));
        }
        log.setCreateTime(new Date());
        return log;
    }
}

