/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerExtQueryApi;
import com.github.pagehelper.PageInfo;
import com.yx.tcbj.center.api.constants.ItemInterceptConfigEnum;
import com.yx.tcbj.center.api.constants.YesOrNoEnum;
import com.yx.tcbj.center.api.dto.request.ItemInterceptConfigReqDto;
import com.yx.tcbj.center.api.dto.request.ItemInterceptDetailReqDto;
import com.yx.tcbj.center.api.dto.response.ItemInterceptConfigRespDto;
import com.yx.tcbj.center.biz.service.IItemInterceptConfigService;
import com.yx.tcbj.center.biz.service.IItemInterceptDetailService;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import com.yx.tcbj.center.dao.das.ItemInterceptConfigDas;
import com.yx.tcbj.center.dao.eo.ItemInterceptConfigEo;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class ItemInterceptConfigServiceImpl
implements IItemInterceptConfigService {
    private static final Logger log = LoggerFactory.getLogger(ItemInterceptConfigServiceImpl.class);
    @Resource
    private ItemInterceptConfigDas itemInterceptConfigDas;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IItemInterceptDetailService itemInterceptDetailService;
    @Resource
    private ISellerExtQueryApi sellerExtQueryApi;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addItemInterceptConfig(ItemInterceptConfigReqDto addReqDto) {
        log.info("add intercept config params is {} . ", (Object)JSON.toJSONString((Object)addReqDto));
        Assert.isTrue((!StringUtils.isEmpty((Object)addReqDto.getOrganizationId()) ? 1 : 0) != 0, (String)"\u7ec4\u7ec7ID\u4e3a\u7a7a");
        Assert.isTrue((!ObjectUtils.isEmpty((Object)addReqDto.getInterceptType()) ? 1 : 0) != 0, (String)"\u914d\u7f6e\u7c7b\u578b\u4e3a\u7a7a");
        Assert.isTrue((!CollectionUtils.isEmpty((Collection)addReqDto.getInterceptContents()) ? 1 : 0) != 0, (String)"\u914d\u7f6e\u5185\u5bb9\u4e3a\u7a7a");
        SellerRespDto sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)this.sellerExtQueryApi.querySellerByOrganizationId(addReqDto.getOrganizationId()));
        Assert.isTrue((!ObjectUtils.isEmpty((Object)sellerRespDto) ? 1 : 0) != 0, (String)"\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728");
        ItemInterceptConfigEnum itemInterceptConfigEnum = ItemInterceptConfigEnum.enumOfCode((Integer)addReqDto.getInterceptType());
        Assert.isTrue((!ObjectUtils.isEmpty((Object)itemInterceptConfigEnum) ? 1 : 0) != 0, (String)"\u914d\u7f6e\u7c7b\u578b\u9519\u8bef");
        ItemInterceptConfigEo itemInterceptConfigEo = new ItemInterceptConfigEo();
        itemInterceptConfigEo.setOrganizationId(addReqDto.getOrganizationId());
        ItemInterceptConfigEo itemInterceptConfig = (ItemInterceptConfigEo)this.itemInterceptConfigDas.selectOne((BaseEo)itemInterceptConfigEo);
        if (ObjectUtils.isEmpty((Object)itemInterceptConfig)) {
            ItemInterceptConfigEo itemInterceptConfigResult = new ItemInterceptConfigEo();
            DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)itemInterceptConfigResult);
            itemInterceptConfigResult.setStatus(YesOrNoEnum.YES.getCode());
            itemInterceptConfigResult.setOrganizationName(sellerRespDto.getOrganizationName());
            int insert = this.itemInterceptConfigDas.insert((BaseEo)itemInterceptConfigEo);
            Assert.isTrue((insert > 0 ? 1 : 0) != 0, (String)"\u65b0\u589e\u5546\u5bb6\u4ea7\u54c1\u62e6\u622a\u914d\u7f6e\u5931\u8d25");
        } else {
            DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)itemInterceptConfig);
            int update = this.itemInterceptConfigDas.update((BaseEo)itemInterceptConfig);
            Assert.isTrue((update > 0 ? 1 : 0) != 0, (String)"\u4fee\u6539\u5546\u5bb6\u4ea7\u54c1\u62e6\u622a\u914d\u7f6e\u5931\u8d25");
        }
        ItemInterceptDetailReqDto itemInterceptDetailReqDto = new ItemInterceptDetailReqDto();
        CubeBeanUtils.copyProperties((Object)itemInterceptDetailReqDto, (Object)addReqDto, (String[])new String[0]);
        this.itemInterceptDetailService.addItemInterceptConfig(itemInterceptDetailReqDto);
        return null;
    }

    @Override
    public void modifyItemInterceptConfig(ItemInterceptConfigReqDto modifyReqDto) {
        ItemInterceptConfigEo itemInterceptConfigEo = new ItemInterceptConfigEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)itemInterceptConfigEo);
        this.itemInterceptConfigDas.updateSelective((BaseEo)itemInterceptConfigEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeItemInterceptConfig(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.itemInterceptConfigDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ItemInterceptConfigRespDto queryById(Long id) {
        ItemInterceptConfigEo itemInterceptConfigEo = (ItemInterceptConfigEo)this.itemInterceptConfigDas.selectByPrimaryKey(id);
        ItemInterceptConfigRespDto itemInterceptConfigRespDto = new ItemInterceptConfigRespDto();
        DtoHelper.eo2Dto((BaseEo)itemInterceptConfigEo, (BaseVo)itemInterceptConfigRespDto);
        return itemInterceptConfigRespDto;
    }

    @Override
    public PageInfo<ItemInterceptConfigRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ItemInterceptConfigReqDto itemInterceptConfigReqDto = (ItemInterceptConfigReqDto)JSON.parseObject((String)filter, ItemInterceptConfigReqDto.class);
        ItemInterceptConfigEo itemInterceptConfigEo = new ItemInterceptConfigEo();
        DtoHelper.dto2Eo((BaseVo)itemInterceptConfigReqDto, (BaseEo)itemInterceptConfigEo);
        PageInfo eoPageInfo = this.itemInterceptConfigDas.selectPage((BaseEo)itemInterceptConfigEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemInterceptConfigRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

