/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.ItemBusTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.OffItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemShelfService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemSkuService;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.ISellerExtQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.api.constants.ItemInterceptConfigEnum;
import com.yx.tcbj.center.api.constants.YesOrNoEnum;
import com.yx.tcbj.center.api.dto.request.ItemInterceptDetailReqDto;
import com.yx.tcbj.center.api.dto.response.ItemInterceptDetailRespDto;
import com.yx.tcbj.center.biz.service.IItemInterceptDetailService;
import com.yx.tcbj.center.dao.das.ItemInterceptDetailDas;
import com.yx.tcbj.center.dao.eo.ItemInterceptDetailEo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class ItemInterceptDetailServiceImpl
implements IItemInterceptDetailService {
    private static final Logger log = LoggerFactory.getLogger(ItemInterceptDetailServiceImpl.class);
    @Resource
    private ItemInterceptDetailDas itemInterceptDetailDas;
    @Resource
    private IItemShelfService itemShelfService;
    @Resource
    private IItemService itemService;
    @Resource
    private IItemSkuService iItemSkuService;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private ISellerExtQueryApi sellerExtQueryApi;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addItemInterceptConfig(ItemInterceptDetailReqDto addReqDto) {
        Assert.isTrue((!StringUtils.isEmpty((Object)addReqDto.getOrganizationId()) ? 1 : 0) != 0, (String)"\u7ec4\u7ec7ID\u4e3a\u7a7a");
        Assert.isTrue((!ObjectUtils.isEmpty((Object)addReqDto.getInterceptType()) ? 1 : 0) != 0, (String)"\u914d\u7f6e\u7c7b\u578b\u4e3a\u7a7a");
        Assert.isTrue((!CollectionUtils.isEmpty((Collection)addReqDto.getInterceptContents()) ? 1 : 0) != 0, (String)"\u914d\u7f6e\u5185\u5bb9\u4e3a\u7a7a");
        SellerRespDto sellerRespDto = (SellerRespDto)RestResponseHelper.extractData((RestResponse)this.sellerExtQueryApi.querySellerByOrganizationId(addReqDto.getOrganizationId()));
        Assert.isTrue((!ObjectUtils.isEmpty((Object)sellerRespDto) ? 1 : 0) != 0, (String)"\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728");
        ItemInterceptConfigEnum itemInterceptConfigEnum = ItemInterceptConfigEnum.enumOfCode((Integer)addReqDto.getInterceptType());
        Assert.isTrue((!ObjectUtils.isEmpty((Object)itemInterceptConfigEnum) ? 1 : 0) != 0, (String)"\u914d\u7f6e\u7c7b\u578b\u9519\u8bef");
        ItemInterceptDetailEo itemInterceptConfigEo = new ItemInterceptDetailEo();
        itemInterceptConfigEo.setOrganizationId(addReqDto.getOrganizationId());
        List itemInterceptConfigEos = this.itemInterceptDetailDas.selectList((BaseEo)itemInterceptConfigEo);
        if (!CollectionUtils.isEmpty((Collection)itemInterceptConfigEos)) {
            ItemInterceptDetailEo interceptConfig = (ItemInterceptDetailEo)itemInterceptConfigEos.stream().findFirst().get();
            if (!itemInterceptConfigEnum.getCode().equals(interceptConfig.getInterceptType())) {
                ItemInterceptDetailEo itemInterceptConfigWrapper = new ItemInterceptDetailEo();
                itemInterceptConfigWrapper.setOrganizationId(addReqDto.getOrganizationId());
                this.itemInterceptDetailDas.delete((BaseEo)itemInterceptConfigWrapper);
            }
        }
        if (YesOrNoEnum.NO.getCode().equals(addReqDto.getStatus())) {
            ItemInterceptDetailEo itemInterceptConfigWrapper = new ItemInterceptDetailEo();
            SqlFilter.in((String)"intercept_content", (Object)addReqDto.getInterceptContents());
            itemInterceptConfigWrapper.setOrganizationId(addReqDto.getOrganizationId());
            itemInterceptConfigWrapper.setInterceptType(addReqDto.getInterceptType());
            this.itemInterceptDetailDas.delete((BaseEo)itemInterceptConfigWrapper);
        } else {
            List collect = addReqDto.getInterceptContents().stream().map(c -> {
                ItemInterceptDetailEo itemInterceptConfig = new ItemInterceptDetailEo();
                DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)itemInterceptConfig);
                itemInterceptConfig.setInterceptContent(c);
                itemInterceptConfig.setOrganizationName(sellerRespDto.getOrganizationName());
                return itemInterceptConfig;
            }).collect(Collectors.toList());
            this.itemInterceptDetailDas.insertBatch(collect);
            CompletableFuture.runAsync(() -> {
                log.info("start off shelf item .");
                List<ItemRespDto> itemRespDtos = this.getItemRespDtos(addReqDto, itemInterceptConfigEnum);
                ShopDto shopDto = (ShopDto)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryByCode(sellerRespDto.getCode()));
                log.info("the shop basic info is {} .", (Object)JSON.toJSONString((Object)shopDto));
                ArrayList offItemReqDtos = new ArrayList();
                itemRespDtos.forEach(itemOffShelfReqDto -> {
                    OffItemReqDto offItemReqDto = new OffItemReqDto();
                    offItemReqDto.setBusType(itemOffShelfReqDto.getBusType() == null ? ItemBusTypeEnum.ORDINARY.getType() : itemOffShelfReqDto.getBusType());
                    offItemReqDto.setItemId(itemOffShelfReqDto.getItemId());
                    offItemReqDto.setSkuId(itemOffShelfReqDto.getSkuId());
                    offItemReqDto.setShopId(shopDto.getId());
                    offItemReqDtos.add(offItemReqDto);
                });
                log.info("req off shelf params is {} .", (Object)JSON.toJSONString(offItemReqDtos));
                this.itemShelfService.offShelfItem(offItemReqDtos);
                log.info("end off shelf item .");
            });
        }
        return null;
    }

    private List<ItemRespDto> getItemRespDtos(ItemInterceptDetailReqDto addReqDto, ItemInterceptConfigEnum itemInterceptConfigEnum) {
        ItemEo itemEo = new ItemEo();
        SqlFilter sqlFilter = itemInterceptConfigEnum.equals((Object)ItemInterceptConfigEnum.BRAND) ? SqlFilter.in((String)"brand_id", (Object)addReqDto.getInterceptContents()) : SqlFilter.in((String)"id", (Object)addReqDto.getInterceptContents());
        itemEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{sqlFilter}));
        List itemEos = this.itemService.queryItems(itemEo);
        ItemSkuEo itemSkuEo = new ItemSkuEo();
        itemSkuEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.in((String)"item_id", itemEos.stream().map(BaseEo::getId).collect(Collectors.toList()))}));
        List itemSkuEos = this.iItemSkuService.queryItemSku(itemSkuEo);
        Map<Long, Long> collect = itemSkuEos.stream().collect(Collectors.toMap(k -> k.getItemId(), v -> v.getId(), (k1, k2) -> k1));
        ArrayList itemRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)itemEos, (Collection)itemRespDtoList, ItemRespDto.class);
        itemRespDtoList.forEach(c -> c.setSkuId(collect.getOrDefault(c.getId(), 0L)));
        return itemRespDtoList;
    }

    @Override
    public void modifyItemInterceptConfig(ItemInterceptDetailReqDto modifyReqDto) {
        ItemInterceptDetailEo itemInterceptConfigEo = new ItemInterceptDetailEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)itemInterceptConfigEo);
        this.itemInterceptDetailDas.updateSelective((BaseEo)itemInterceptConfigEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeItemInterceptConfig(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.itemInterceptDetailDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public ItemInterceptDetailRespDto queryById(Long id) {
        ItemInterceptDetailEo itemInterceptConfigEo = (ItemInterceptDetailEo)this.itemInterceptDetailDas.selectByPrimaryKey(id);
        ItemInterceptDetailRespDto itemInterceptConfigRespDto = new ItemInterceptDetailRespDto();
        DtoHelper.eo2Dto((BaseEo)itemInterceptConfigEo, (BaseVo)itemInterceptConfigRespDto);
        return itemInterceptConfigRespDto;
    }

    @Override
    public PageInfo<ItemInterceptDetailRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ItemInterceptDetailReqDto itemInterceptConfigReqDto = (ItemInterceptDetailReqDto)JSON.parseObject((String)filter, ItemInterceptDetailReqDto.class);
        ItemInterceptDetailEo itemInterceptConfigEo = new ItemInterceptDetailEo();
        DtoHelper.dto2Eo((BaseVo)itemInterceptConfigReqDto, (BaseEo)itemInterceptConfigEo);
        PageInfo eoPageInfo = this.itemInterceptDetailDas.selectPage((BaseEo)itemInterceptConfigEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemInterceptDetailRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

