/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.tcbj.center.openapi.common.wms.request.WmsStockReqDto;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemEo;
import com.github.pagehelper.PageInfo;
import com.yx.tcbj.center.api.dto.request.PcpItemQueryDto;
import com.yx.tcbj.center.api.dto.request.PcpItemReqDto;
import com.yx.tcbj.center.api.dto.response.PcpItemRespDto;
import com.yx.tcbj.center.biz.service.IItemExtendService;
import com.yx.tcbj.center.biz.service.IPcpItemService;
import com.yx.tcbj.center.biz.util.LogUtils;
import com.yx.tcbj.center.biz.util.SqlFilterBuilder;
import com.yx.tcbj.center.dao.das.ItemExtDas;
import com.yx.tcbj.center.dao.das.ItemExtendDas;
import com.yx.tcbj.center.dao.eo.ItemExtendEo;
import com.yx.tcbj.center.dao.eo.PcpItemEo;
import icu.mhb.mybatisplus.plugln.core.JoinLambdaWrapper;
import icu.mhb.mybatisplus.plugln.core.JoinWrapper;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Primary
@Service(value="pcpItemServiceImpl")
public class PcpItemAdaptorServiceImpl
implements IPcpItemService {
    private static final Logger logger = LoggerFactory.getLogger(PcpItemAdaptorServiceImpl.class);
    @Resource
    private ItemExtendDas itemExtendDas;
    @Resource
    private ItemExtDas itemExtDas;
    @Resource
    private IItemExtendService iItemExtendService;
    @Resource
    private ItemDas itemDas;
    @Resource
    private ICommonsMqService commonsMqService;

    @Override
    public Long addPcpItem(PcpItemReqDto addReqDto) {
        Assert.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)addReqDto.getCode()), (String)"1", (String)"\u5546\u54c1\u7f16\u7801\u5f02\u5e38");
        PcpItemEo pcpItemEo = new PcpItemEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)pcpItemEo);
        ItemExtendEo extendEo = (ItemExtendEo)this.itemExtendDas.selectByLogicKey((Object)addReqDto.getCode());
        if (extendEo != null && extendEo.getId() != null) {
            BeanUtils.copyProperties((Object)addReqDto, (Object)extendEo);
            this.itemExtendDas.updateSelective((BaseEo)extendEo);
            return extendEo.getId();
        }
        ItemExtendEo itemExtendEo = new ItemExtendEo();
        itemExtendEo.setItemCode(addReqDto.getCode());
        BeanUtils.copyProperties((Object)addReqDto, (Object)itemExtendEo);
        this.itemExtendDas.insert((BaseEo)itemExtendEo);
        this.publishItemSyncEvent(itemExtendEo);
        return pcpItemEo.getId();
    }

    @Override
    public void publishItemSyncEvent(ItemExtendEo itemExtendEo) {
        Optional.ofNullable(this.itemDas.selectOne((BaseEo)SqlFilterBuilder.create(ItemEo.class).eq("longCode", itemExtendEo.getItemCode()).eo())).ifPresent(itemEo -> this.commonsMqService.sendSingleMessage("ITEM_STOCK_SYNC_TAG", (Object)this.buildItemMqVo((ItemEo)itemEo, itemExtendEo)));
    }

    private WmsStockReqDto buildItemMqVo(ItemEo itemEo, ItemExtendEo itemExtendEo) {
        WmsStockReqDto wmsStockReqDto = new WmsStockReqDto();
        BeanUtils.copyProperties((Object)itemEo, (Object)wmsStockReqDto);
        BeanUtils.copyProperties((Object)itemExtendEo, (Object)wmsStockReqDto, (String[])new String[]{"id"});
        return wmsStockReqDto;
    }

    @Override
    public void modifyPcpItem(PcpItemReqDto pcpItemReqDto) {
        if (StringUtils.isEmpty((CharSequence)pcpItemReqDto.getLongCode())) {
            return;
        }
        ItemExtendEo itemExtendEo = new ItemExtendEo();
        itemExtendEo.setItemCode(pcpItemReqDto.getLongCode());
        itemExtendEo = (ItemExtendEo)this.itemExtendDas.selectOne((BaseEo)itemExtendEo);
        if (Objects.isNull(itemExtendEo)) {
            return;
        }
        itemExtendEo.setExpirationDate(pcpItemReqDto.getExpirationDate());
        itemExtendEo.setExpirationUnit(pcpItemReqDto.getExpirationUnit());
        itemExtendEo.setCfproducers(pcpItemReqDto.getCfproducers());
        this.itemExtendDas.updateSelective((BaseEo)itemExtendEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePcpItem(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.itemExtendDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public PcpItemRespDto queryById(Long id) {
        ItemExtendEo itemEo = (ItemExtendEo)this.itemExtendDas.selectByPrimaryKey(id);
        if (itemEo == null || itemEo.getId() == null) {
            return null;
        }
        PcpItemRespDto pcpItemRespDto = new PcpItemRespDto();
        BeanUtils.copyProperties((Object)itemEo, (Object)pcpItemRespDto);
        ItemEo itemExtendEo = (ItemEo)((ExtQueryChainWrapper)this.itemDas.filter().eq((Object)"long_code", (Object)itemEo.getItemCode())).one();
        if (!Objects.isNull(itemExtendEo)) {
            pcpItemRespDto.setItemType(Long.valueOf(itemExtendEo.getType().longValue()));
            pcpItemRespDto.setItemStatus(Long.valueOf(itemExtendEo.getStatus().longValue()));
            BeanUtils.copyProperties((Object)itemExtendEo, (Object)pcpItemRespDto);
        }
        pcpItemRespDto.setId(id);
        return pcpItemRespDto;
    }

    @Override
    public PageInfo<PcpItemRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        return null;
    }

    @Override
    public PcpItemEo selectByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        if (Objects.isNull(id)) {
            throw new BizException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return null;
    }

    @Override
    public PageInfo<PcpItemRespDto> queryByPage(PcpItemQueryDto queryDto) {
        logger.info("\u5206\u9875\u67e5\u8be2\u53c2\u6570\uff1a[{}]", (Object)LogUtils.buildLogContent(queryDto, "pageNum", "pageSize"));
        if (Objects.isNull(queryDto.getPageNum()) || Objects.isNull(queryDto.getPageSize())) {
            throw new BizException("\u5206\u9875\u9875\u6570\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JoinLambdaWrapper wrapper = ((JoinWrapper)((JoinWrapper)((JoinWrapper)((JoinWrapper)((JoinWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)new JoinLambdaWrapper(ItemExtendEo.class).like(StringUtils.isNotBlank((CharSequence)queryDto.getLongCode()), ItemExtendEo::getItemCode, (Object)("%" + queryDto.getLongCode() + "%"))).eq(Objects.nonNull(queryDto.getItemDrug()), ItemExtendEo::getItemDrug, (Object)queryDto.getItemDrug())).eq(BaseEo::getDr, (Object)0)).selectAll()).orderByDesc(BaseEo::getCreateTime)).leftJoin(ItemEo.class, StdItemEo::getLongCode, ItemExtendEo::getItemCode).like(StringUtils.isNotBlank((CharSequence)queryDto.getName()), StdItemEo::getName, (Object)("%" + queryDto.getName() + "%"))).eq(Objects.nonNull(queryDto.getItemType()), StdItemEo::getType, (Object)queryDto.getItemType())).eq(Objects.nonNull(queryDto.getItemStatus()), StdItemEo::getStatus, (Object)queryDto.getItemStatus())).eq(BaseEo::getDr, (Object)0)).selectAs(a -> a.add(StdItemEo::getSubType, "itemType").add(StdItemEo::getStatus, "itemStatus").add(StdItemEo::getName, "name").add(StdItemEo::getLongCode, "barCode").add(BaseEo::getId, "itemId"))).end();
        IPage page = this.iItemExtendService.joinPage((IPage)new Page((long)queryDto.getPageNum().intValue(), (long)queryDto.getPageSize().intValue()), (Wrapper)wrapper, PcpItemRespDto.class);
        return this.getPcpItemRespDtoPageInfo(queryDto, (IPage<PcpItemRespDto>)page);
    }

    private PageInfo<PcpItemRespDto> getPcpItemRespDtoPageInfo(PcpItemQueryDto queryDto, IPage<PcpItemRespDto> page) {
        PageInfo pageInfo = new PageInfo(Optional.ofNullable(page.getRecords()).orElse(Lists.newArrayList()).stream().peek(d -> d.setLongCode(d.getItemCode())).collect(Collectors.toList()));
        pageInfo.setPageNum(queryDto.getPageNum().intValue());
        pageInfo.setPageSize(queryDto.getPageSize().intValue());
        pageInfo.setPages((int)page.getPages());
        pageInfo.setTotal(page.getTotal());
        return pageInfo;
    }

    @Override
    public PageInfo<PcpItemRespDto> queryByPageByCondition(PcpItemQueryDto queryDto) {
        return this.queryByPage(queryDto);
    }

    @Override
    public List<PcpItemEo> queryByParam(PcpItemQueryDto queryDto) {
        return null;
    }

    @Override
    public List<PcpItemRespDto> queryByItemCodes(List<String> itemCodes) {
        if (CollectionUtils.isEmpty(itemCodes)) {
            throw new BizException("\u5546\u54c1\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List items = this.itemDas.select((BaseEo)SqlFilterBuilder.create(ItemEo.class).in("code", itemCodes).eo());
        return this.getPcpItemRespDtos(items);
    }

    @Override
    public List<PcpItemRespDto> queryByItemLongCodes(List<String> itemLongCodes) {
        if (CollectionUtils.isEmpty(itemLongCodes)) {
            throw new BizException("\u5546\u54c1\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JoinLambdaWrapper wrapper = ((JoinWrapper)((JoinWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)new JoinLambdaWrapper(ItemExtendEo.class).in(ItemExtendEo::getItemCode, itemLongCodes)).selectAll()).orderByDesc(BaseEo::getCreateTime)).leftJoin(ItemEo.class, StdItemEo::getLongCode, ItemExtendEo::getItemCode).eq(BaseEo::getDr, (Object)0)).selectAs(a -> a.add(StdItemEo::getSubType, "itemType").add(StdItemEo::getStatus, "itemStatus").add(StdItemEo::getName, "name").add(StdItemEo::getLongCode, "barCode").add(BaseEo::getId, "itemId"))).end();
        return this.iItemExtendService.joinList((Wrapper)wrapper, PcpItemRespDto.class);
    }

    @Override
    public void pushWms(List<String> itemLongCodes) {
        ((ExtQueryChainWrapper)this.itemExtendDas.filter().in((Object)"itemCode", itemLongCodes)).list().forEach(this::publishItemSyncEvent);
    }

    private List<PcpItemRespDto> getPcpItemRespDtos(List<ItemEo> items) {
        if (CollectionUtils.isEmpty(items)) {
            return Lists.newArrayList();
        }
        Map extendMap = this.itemExtendDas.select((BaseEo)Objects.requireNonNull(SqlFilterBuilder.create(ItemExtendEo.class)).in("item_code", items.stream().map(StdItemEo::getLongCode).collect(Collectors.toSet())).eo()).stream().collect(Collectors.toMap(ItemExtendEo::getItemCode, Function.identity()));
        return items.stream().map(item -> this.buildPcpItemResp(extendMap, (ItemEo)item)).collect(Collectors.toList());
    }

    private PcpItemRespDto buildPcpItemResp(Map<String, ItemExtendEo> extendMap, ItemEo item) {
        PcpItemRespDto pcpItemRespDto = new PcpItemRespDto();
        BeanUtils.copyProperties((Object)item, (Object)pcpItemRespDto);
        pcpItemRespDto.setItemType(Long.valueOf(item.getType().longValue()));
        pcpItemRespDto.setItemStatus(Long.valueOf(item.getStatus().longValue()));
        ItemExtendEo itemExtendEo = extendMap.get(item.getLongCode());
        if (!Objects.isNull(itemExtendEo)) {
            BeanUtils.copyProperties((Object)itemExtendEo, (Object)pcpItemRespDto);
        }
        pcpItemRespDto.setId(item.getId());
        return pcpItemRespDto;
    }
}

