/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.b2b.service.query.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.b2b.constants.AuthItemRuleTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.b2b.constants.ProhibiteItemOptEnum;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.CustomerAuthItemPageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.CustomerAuthItemVo;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.AuthItemRuleRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.CustomerAuthItemNumRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.CustomerAuthItemRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.b2b.service.IAuthItemRuleService;
import com.dtyunxi.yundt.cube.center.item.biz.b2b.service.IProhibiteSaleItemService;
import com.dtyunxi.yundt.cube.center.item.biz.b2b.service.query.ICustomerAuthItemQueryService;
import com.dtyunxi.yundt.cube.center.item.dao.b2b.das.CustomerAuthItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.b2b.ProhibiteSaleItemEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomerAuthItemQueryServiceImpl
implements ICustomerAuthItemQueryService {
    private static final Logger logger = LoggerFactory.getLogger(CustomerAuthItemQueryServiceImpl.class);
    @Autowired
    private IAuthItemRuleService authItemRuleService;
    @Autowired
    private IProhibiteSaleItemService prohibiteSaleItemService;
    @Autowired
    private CustomerAuthItemDas customerAuthItemDas;

    @Override
    public RestResponse<PageInfo<CustomerAuthItemRespDto>> queryAuthItemPage(CustomerAuthItemPageReqDto customerAuthItemPageReqDto) {
        PageInfo resultPageInfo = new PageInfo();
        AuthItemRuleRespDto authItemRuleRespDto = this.authItemRuleService.queryByCustomerId(customerAuthItemPageReqDto.getCustomerId());
        if (Objects.equals(customerAuthItemPageReqDto.getSelectType(), 1)) {
            if (authItemRuleRespDto == null) {
                return new RestResponse((Object)resultPageInfo);
            }
            if (Objects.equals(AuthItemRuleTypeEnum.UN_AUTH.getRuleType(), authItemRuleRespDto.getAuthType())) {
                return new RestResponse((Object)resultPageInfo);
            }
            if (Objects.equals(AuthItemRuleTypeEnum.ITEM.getRuleType(), authItemRuleRespDto.getAuthType()) && CollectionUtil.isEmpty((Collection)authItemRuleRespDto.getCustomerAuthItemRespDtos())) {
                return new RestResponse((Object)resultPageInfo);
            }
        } else if (authItemRuleRespDto != null && AuthItemRuleTypeEnum.ALL_ITEM.getRuleType().equals(authItemRuleRespDto.getAuthType())) {
            return new RestResponse((Object)resultPageInfo);
        }
        Set<Long> prohibiteSaleSkuIds = new HashSet<Long>();
        if (Objects.equals(customerAuthItemPageReqDto.getSelectType(), 1)) {
            List prohibiteSaleItemEos = this.prohibiteSaleItemService.queryByCustomerId(customerAuthItemPageReqDto.getCustomerId());
            if (ProhibiteItemOptEnum.PROHIBITE_SALE.getOptType().equals(customerAuthItemPageReqDto.getProhibiteStatus()) && CollectionUtil.isEmpty((Collection)prohibiteSaleItemEos)) {
                return new RestResponse((Object)resultPageInfo);
            }
            prohibiteSaleSkuIds = prohibiteSaleItemEos.stream().map(ProhibiteSaleItemEo::getSkuId).collect(Collectors.toSet());
        }
        PageInfo<CustomerAuthItemVo> pageInfo = this.getAuthItemVoPageInfo(customerAuthItemPageReqDto, authItemRuleRespDto, prohibiteSaleSkuIds);
        CubeBeanUtils.copyProperties((Object)resultPageInfo, pageInfo, (String[])new String[]{"list"});
        if (pageInfo != null && CollectionUtil.isNotEmpty((Collection)pageInfo.getList())) {
            ArrayList customerAuthItemRespDtos = Lists.newArrayList();
            for (CustomerAuthItemVo customerAuthItemVo : pageInfo.getList()) {
                CustomerAuthItemRespDto customerAuthItemRespDto = new CustomerAuthItemRespDto();
                BeanUtil.copyProperties((Object)customerAuthItemVo, (Object)customerAuthItemRespDto, (String[])new String[0]);
                if (customerAuthItemPageReqDto.getSelectType() == 1) {
                    Integer prohibiteStatus = 1;
                    if (prohibiteSaleSkuIds.contains(customerAuthItemVo.getSkuId())) {
                        prohibiteStatus = 2;
                    }
                    customerAuthItemRespDto.setProhibiteStatus(prohibiteStatus);
                }
                customerAuthItemRespDtos.add(customerAuthItemRespDto);
            }
            resultPageInfo.setList((List)customerAuthItemRespDtos);
        }
        return new RestResponse((Object)resultPageInfo);
    }

    @Override
    public RestResponse<CustomerAuthItemNumRespDto> queryAuthItemNum(CustomerAuthItemPageReqDto customerAuthItemPageReqDto) {
        CustomerAuthItemNumRespDto numRespDto = new CustomerAuthItemNumRespDto(Long.valueOf(1L), Long.valueOf(1L));
        return new RestResponse((Object)numRespDto);
    }

    @Override
    public RestResponse<List<CustomerAuthItemRespDto>> queryAuthItemBySkuIds(List<Long> skuIds) {
        if (CollectionUtils.isEmpty(skuIds)) {
            return new RestResponse(new ArrayList());
        }
        try {
            List<CustomerAuthItemVo> customerAuthItemVos = this.getAuthItemVoListBySkuIds(skuIds);
            if (CollectionUtils.isEmpty(customerAuthItemVos)) {
                return new RestResponse(new ArrayList());
            }
            ArrayList<CustomerAuthItemRespDto> resultList = new ArrayList<CustomerAuthItemRespDto>();
            for (CustomerAuthItemVo vo : customerAuthItemVos) {
                CustomerAuthItemRespDto respDto = new CustomerAuthItemRespDto();
                BeanUtil.copyProperties((Object)vo, (Object)respDto, (String[])new String[0]);
                resultList.add(respDto);
            }
            return new RestResponse(resultList);
        }
        catch (Exception e) {
            logger.error("Error querying auth items by skuIds: {}", skuIds, (Object)e);
            return new RestResponse(new ArrayList());
        }
    }

    private PageInfo<CustomerAuthItemVo> getAuthItemVoPageInfo(CustomerAuthItemPageReqDto reqDto, AuthItemRuleRespDto authItemRuleRespDto, Set<Long> prohibiteSaleSkuIds) {
        List matchSkuIds = reqDto.getMatchSkuIds();
        if (CollectionUtils.isNotEmpty((Collection)matchSkuIds)) {
            logger.debug("Filtering by matchSkuIds: {}", (Object)matchSkuIds);
            List<Object> voList = this.getAuthItemVoListBySkuIds(matchSkuIds);
            if (reqDto.getCustomerId() != null) {
                voList = voList.stream().filter(vo -> Objects.equals(vo.getCustomerId(), reqDto.getCustomerId())).collect(Collectors.toList());
            }
            PageInfo pageInfo = new PageInfo();
            pageInfo.setList(voList);
            pageInfo.setTotal((long)voList.size());
            pageInfo.setPageNum(reqDto.getPageNum().intValue());
            pageInfo.setPageSize(reqDto.getPageSize().intValue());
            return pageInfo;
        }
        return this.createMockPageInfo(reqDto);
    }

    private List<CustomerAuthItemVo> getAuthItemVoListBySkuIds(List<Long> skuIds) {
        return this.createMockCustomerAuthItemVoList(skuIds);
    }

    private PageInfo<CustomerAuthItemVo> createMockPageInfo(CustomerAuthItemPageReqDto reqDto) {
        ArrayList list = new ArrayList();
        PageInfo pageInfo = new PageInfo();
        pageInfo.setList(list);
        pageInfo.setTotal(0L);
        pageInfo.setPageNum(reqDto.getPageNum().intValue());
        pageInfo.setPageSize(reqDto.getPageSize().intValue());
        return pageInfo;
    }

    private List<CustomerAuthItemVo> createMockCustomerAuthItemVoList(List<Long> skuIds) {
        return ((ExtQueryChainWrapper)this.customerAuthItemDas.filter().in((Object)"sku_id", skuIds)).list().stream().map(r -> (CustomerAuthItemVo)BeanUtil.copyProperties((Object)r, CustomerAuthItemVo.class, (String[])new String[0])).collect(Collectors.toList());
    }
}

