/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.biz.apiimpl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.BrandRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IBrandQueryApi;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.api.ItemBrandAuthApi;
import com.yx.tcbj.center.api.dto.request.ItemBrandAuthAddReqDto;
import com.yx.tcbj.center.api.dto.request.ItemBrandAuthCheckItemsReqDto;
import com.yx.tcbj.center.api.dto.request.ItemBrandAuthDeleteReqDto;
import com.yx.tcbj.center.api.dto.response.ItemBrandAuthCheckItemsRespDto;
import com.yx.tcbj.center.api.dto.response.ItemBrandAuthCheckRespDto;
import com.yx.tcbj.center.api.dto.response.ItemBrandAuthRespDto;
import com.yx.tcbj.center.biz.service.IItemBrandAuthService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="ItemBrandAuthApiImpl")
public class ItemBrandAuthApiImpl
implements ItemBrandAuthApi {
    private static final Logger logger = LoggerFactory.getLogger(ItemBrandAuthApiImpl.class);
    @Resource
    private IItemBrandAuthService itemBrandAuthService;
    @Resource
    private IBrandQueryApi brandQueryApi;

    public RestResponse<ItemBrandAuthRespDto> add(ItemBrandAuthAddReqDto reqDto) {
        return new RestResponse((Object)this.itemBrandAuthService.add(reqDto));
    }

    public RestResponse<Integer> delete(ItemBrandAuthDeleteReqDto reqDto) {
        return new RestResponse((Object)this.itemBrandAuthService.delete(reqDto));
    }

    public RestResponse<List<ItemBrandAuthRespDto>> queryList(ItemBrandAuthAddReqDto reqDto) {
        return new RestResponse(this.itemBrandAuthService.queryList(reqDto));
    }

    public RestResponse<ItemBrandAuthRespDto> queryById(ItemBrandAuthAddReqDto reqDto) {
        return new RestResponse((Object)this.itemBrandAuthService.queryById(reqDto));
    }

    public RestResponse<ItemBrandAuthRespDto> update(ItemBrandAuthAddReqDto reqDto) {
        return new RestResponse((Object)this.itemBrandAuthService.update(reqDto));
    }

    public RestResponse<ItemBrandAuthRespDto> insertOrUpdate(ItemBrandAuthAddReqDto reqDto) {
        return new RestResponse((Object)this.itemBrandAuthService.insertOrUpdate(reqDto));
    }

    public RestResponse<Void> insertOrUpdateBatch(List<ItemBrandAuthAddReqDto> reqDto) {
        return new RestResponse((Object)this.itemBrandAuthService.insertOrUpdateBatch(reqDto));
    }

    public RestResponse<ItemBrandAuthCheckRespDto> itemBrandAuthCheck(ItemBrandAuthAddReqDto reqDto) {
        return new RestResponse((Object)this.itemBrandAuthService.itemBrandAuthCheck(reqDto));
    }

    public RestResponse<ItemBrandAuthCheckItemsRespDto> itemBrandAuthCheckItems(ItemBrandAuthCheckItemsReqDto reqDto) {
        return new RestResponse((Object)this.itemBrandAuthService.itemBrandAuthCheckItems(reqDto));
    }

    public RestResponse<List<String>> checkBrandsExist(List<String> brandNames) {
        if (CollectionUtils.isEmpty(brandNames)) {
            return new RestResponse(new ArrayList());
        }
        try {
            List<String> brands = this.itemBrandAuthService.checkBrandsExist(brandNames);
            return new RestResponse(brands);
        }
        catch (Exception e) {
            logger.error("\u54c1\u724c\u9a8c\u8bc1\u5f02\u5e38", (Throwable)e);
            throw new BizException("\u54c1\u724c\u9a8c\u8bc1\u5f02\u5e38: " + e.getMessage());
        }
    }

    public RestResponse<List<BrandRespDto>> queryBrandsByName(String brandName) {
        try {
            List<BrandRespDto> brands = this.itemBrandAuthService.queryBrandsByNames(Lists.newArrayList((Object[])new String[]{brandName}));
            return new RestResponse(brands);
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u540d\u79f0\u67e5\u8be2\u54c1\u724c\u5f02\u5e38", (Throwable)e);
            throw new BizException("\u6839\u636e\u540d\u79f0\u67e5\u8be2\u54c1\u724c\u5f02\u5e38: " + e.getMessage());
        }
    }
}

