/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.biz.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemMediasReqDto;
import com.dtyunxi.yundt.cube.center.item.dao.b2b.das.ItemAuthDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemMediasDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemSkuDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.b2b.ItemAuthEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemMediasEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.api.dto.request.ItemExtendReqDto;
import com.yx.tcbj.center.api.dto.request.ItemReqDto;
import com.yx.tcbj.center.api.dto.response.ItemExtendRespDto;
import com.yx.tcbj.center.biz.service.IItemExtendService;
import com.yx.tcbj.center.biz.service.IPcpItemService;
import com.yx.tcbj.center.dao.das.ItemExtDas;
import com.yx.tcbj.center.dao.das.ItemExtendDas;
import com.yx.tcbj.center.dao.eo.ItemExtendEo;
import com.yx.tcbj.center.dao.mapper.ItemExtendMapper;
import icu.mhb.mybatisplus.plugln.base.service.impl.JoinServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ItemExtendServiceImpl
extends JoinServiceImpl<ItemExtendMapper, ItemExtendEo>
implements IItemExtendService {
    @Resource
    private ItemExtendDas itemExtendDas;
    @Resource
    private IPcpItemService pcpItemService;
    @Resource
    private ItemDas itemDas;
    @Resource
    private ItemMediasDas itemMediasDas;
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private ItemExtDas itemExtDas;
    @Resource
    private ItemSkuDas itemSkuDas;
    @Resource
    private ItemAuthDas itemAuthDas;

    @Override
    public Long addItemExtend(ItemExtendReqDto addReqDto) {
        long id;
        ItemExtendEo queryEo = (ItemExtendEo)this.itemExtendDas.selectByLogicKey((Object)addReqDto.getItemCode());
        if (queryEo != null && queryEo.getId() != null) {
            addReqDto.setId(queryEo.getId());
            this.modifyItemExtend(addReqDto);
            id = queryEo.getId();
        } else {
            ItemExtendEo itemExtendEo = new ItemExtendEo();
            DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)itemExtendEo);
            itemExtendEo.setSpecification(addReqDto.getSpecifications());
            this.itemExtendDas.insert((BaseEo)itemExtendEo);
            this.pcpItemService.publishItemSyncEvent(itemExtendEo);
            id = itemExtendEo.getId();
        }
        return id;
    }

    @Override
    public void modifyItemExtend(ItemExtendReqDto modifyReqDto) {
        ItemExtendEo itemExtendEo = new ItemExtendEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)itemExtendEo);
        itemExtendEo.setSpecification(modifyReqDto.getSpecifications());
        this.itemExtendDas.updateSelective((BaseEo)itemExtendEo);
        this.pcpItemService.publishItemSyncEvent(itemExtendEo);
    }

    @Override
    public void modifyPrice(ItemExtendReqDto modifyReqDto) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)modifyReqDto.getItemCode())) {
            throw new BizException("\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ItemExtendEo itemExtendEo1 = (ItemExtendEo)this.itemExtendDas.selectByLogicKey((Object)modifyReqDto.getItemCode());
        if (itemExtendEo1 == null) {
            ItemExtendEo itemExtendEo = new ItemExtendEo();
            itemExtendEo.setRecommendPrice(modifyReqDto.getRecommendPrice());
            itemExtendEo.setItemCode(modifyReqDto.getItemCode());
            this.itemExtendDas.insert((BaseEo)itemExtendEo);
            return;
        }
        ItemExtendEo itemExtendEo = new ItemExtendEo();
        itemExtendEo.setRecommendPrice(modifyReqDto.getRecommendPrice());
        itemExtendEo.setSqlFilters((List)Lists.newArrayList((Object[])new SqlFilter[]{SqlFilter.eq((String)"item_code", (Object)modifyReqDto.getItemCode())}));
        this.itemExtendDas.updateSelectiveSqlFilter((BaseEo)itemExtendEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeItemExtend(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.itemExtendDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public List<ItemExtendRespDto> queryParam(ItemExtendReqDto reqDto) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reqDto.getItemCode())) {
            queryWrapper.eq(ItemExtendEo::getItemCode, (Object)reqDto.getItemCode());
        }
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getItemCodeList())) {
            queryWrapper.in(ItemExtendEo::getItemCode, (Collection)reqDto.getItemCodeList());
        }
        queryWrapper.eq(BaseEo::getDr, (Object)"0");
        List list = this.itemExtendDas.getMapper().selectList((Wrapper)queryWrapper);
        ArrayList<ItemExtendRespDto> dtoList = new ArrayList<ItemExtendRespDto>();
        DtoHelper.eoList2DtoList((Collection)list, dtoList, ItemExtendRespDto.class);
        return dtoList;
    }

    @Override
    public ItemExtendRespDto queryById(Long id) {
        ItemExtendEo itemExtendEo = (ItemExtendEo)this.itemExtendDas.selectByPrimaryKey(id);
        ItemExtendRespDto itemExtendRespDto = new ItemExtendRespDto();
        DtoHelper.eo2Dto((BaseEo)itemExtendEo, (BaseVo)itemExtendRespDto);
        return itemExtendRespDto;
    }

    @Override
    public PageInfo<ItemExtendRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        ItemExtendReqDto itemExtendReqDto = (ItemExtendReqDto)JSON.parseObject((String)filter, ItemExtendReqDto.class);
        ItemExtendEo itemExtendEo = new ItemExtendEo();
        DtoHelper.dto2Eo((BaseVo)itemExtendReqDto, (BaseEo)itemExtendEo);
        PageInfo eoPageInfo = this.itemExtendDas.selectPage((BaseEo)itemExtendEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ItemExtendRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateSimpleItem(ItemReqDto itemDto) {
        String orgIdStr;
        if (Objects.isNull(itemDto.getId())) {
            throw new BizException("\u5546\u54c1Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ItemEo itemEo = (ItemEo)this.itemDas.selectByPrimaryKey(itemDto.getId());
        if (Objects.isNull(itemEo)) {
            throw new BizException("\u5546\u54c1\u67e5\u8be2\u4e3a\u7a7a");
        }
        List itemMediasEos = this.itemMediasDas.selectByItemId(itemEo.getId());
        if (CollectionUtils.isNotEmpty((Collection)itemMediasEos)) {
            for (ItemMediasEo itemMediasEo : itemMediasEos) {
                this.itemMediasDas.deleteById(itemMediasEo.getId());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)itemDto.getMedias())) {
            ArrayList mediasEos = Lists.newArrayList();
            List medias = itemDto.getMedias();
            for (ItemMediasReqDto itemMediasDto : medias) {
                ItemMediasEo itemMediasEo = new ItemMediasEo();
                itemMediasEo.setFileType(Integer.valueOf(1));
                itemMediasEo.setTitle(itemMediasDto.getTitle());
                itemMediasEo.setName(itemMediasDto.getName());
                itemMediasEo.setPath1(itemMediasDto.getPath1());
                itemMediasEo.setPath2(itemMediasDto.getPath2());
                itemMediasEo.setRemark(itemMediasDto.getRemark());
                itemMediasEo.setItemId(itemDto.getId());
                mediasEos.add(itemMediasEo);
            }
            this.itemMediasDas.insertBatch((List)mediasEos);
        }
        if (StrUtil.isNotBlank((CharSequence)itemDto.getExternalCode()) && StringUtils.isNotBlank((String)(orgIdStr = ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid")))) {
            List shopDtos;
            ShopQueryDto queryCondition = new ShopQueryDto();
            queryCondition.setOrganizationId(Long.valueOf(orgIdStr));
            RestResponse shopResp = this.shopQueryApi.queryShopList(queryCondition);
            if (shopResp != null && CollectionUtils.isNotEmpty((Collection)(shopDtos = (List)shopResp.getData()))) {
                ShopDto shopDto = (ShopDto)shopDtos.get(0);
                List itemSkuEos = this.itemSkuDas.selectByItemId(itemDto.getId());
                if (CollectionUtil.isNotEmpty((Collection)itemSkuEos)) {
                    List skuIds = itemSkuEos.stream().map(BaseEo::getId).collect(Collectors.toList());
                    List itemAuthEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.itemAuthDas.filter().eq((Object)"target_type", (Object)2)).eq((Object)"target_id", (Object)shopDto.getId())).in((Object)"business_id", skuIds)).list();
                    if (CollectionUtils.isNotEmpty((Collection)itemAuthEos)) {
                        for (ItemAuthEo itemAuthEo : itemAuthEos) {
                            itemAuthEo.setExternalCode(itemDto.getExternalCode());
                            this.itemAuthDas.update((BaseEo)itemAuthEo);
                        }
                    } else {
                        ArrayList addList = Lists.newArrayList();
                        for (ItemSkuEo itemSkuEo : itemSkuEos) {
                            ItemAuthEo itemAuthEo = new ItemAuthEo();
                            itemAuthEo.setTargetType(Integer.valueOf(2));
                            itemAuthEo.setTargetId(shopDto.getId());
                            itemAuthEo.setBusinessType("SKU");
                            itemAuthEo.setBusinessId(itemSkuEo.getId());
                            itemAuthEo.setStatus(Integer.valueOf(0));
                            itemAuthEo.setExternalCode(itemDto.getExternalCode());
                            addList.add(itemAuthEo);
                        }
                        this.itemAuthDas.insertBatch((List)addList);
                    }
                }
            }
        }
    }
}

