/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthConfigReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.ItemAuthReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.ItemAuthConfigRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.IItemSkuApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemBundleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.item.biz.b2b.service.ItemAuthConfigService;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemAttributesService;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.PropValueDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemAttributesEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.PropValueEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.api.dto.request.ItemProValue;
import com.yx.tcbj.center.api.dto.request.ItemSycnExtReqDto;
import com.yx.tcbj.center.biz.service.IItemSycnExtService;
import com.yx.tcbj.center.dao.das.ItemExtDas;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class IItemSycnExtServiceImpl
implements IItemSycnExtService {
    private static Logger logger = LoggerFactory.getLogger(IItemSycnExtServiceImpl.class);
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private IItemAttributesService iItemAttributesService;
    @Resource
    private PropValueDas propValueDas;
    @Resource(name="itemSkuApi")
    private IItemSkuApi iItemSkuApi;
    @Resource(name="itemSkuQueryApi")
    private IItemSkuQueryApi iItemSkuQueryApi;
    @Resource
    private ItemExtDas itemExtDas;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private ItemAuthConfigService itemAuthConfigService;

    @Override
    public void updateItem(List<ItemSycnExtReqDto> itemSycnExtReqDto) {
        if (CollectionUtils.isNotEmpty(itemSycnExtReqDto)) {
            itemSycnExtReqDto.stream().forEach(t -> {
                HashMap<String, Object> itemMap = new HashMap<String, Object>();
                itemMap.put("longCode", t.getLongCode());
                itemMap.put("bizType", 2);
                List itemRespDtos = ((PageInfo)this.itemQueryApi.queryByPage(JSONObject.toJSONString(itemMap), Integer.valueOf(1), Integer.valueOf(10)).getData()).getList();
                logger.info("\u67e5\u8be2\u5546\u54c1\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)itemRespDtos));
                if (CollectionUtils.isNotEmpty((Collection)itemRespDtos)) {
                    List attributesEos = this.iItemAttributesService.queryByItemIds((List)Lists.newArrayList((Object[])new Long[]{((ItemRespDto)itemRespDtos.get(0)).getId()}));
                    logger.info("\u67e5\u8be2Attributes\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)attributesEos));
                    if (CollectionUtils.isNotEmpty((Collection)attributesEos)) {
                        ItemAttributesEo itemAttributesEo = new ItemAttributesEo();
                        CubeBeanUtils.copyProperties((Object)itemAttributesEo, attributesEos.get(0), (String[])new String[0]);
                        logger.info("copy \u5546\u54c1attr\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)itemAttributesEo));
                        itemAttributesEo.setAttrs(t.getAttrs());
                        this.iItemAttributesService.modifyProp(itemAttributesEo);
                    }
                    List skuRespDtos = (List)this.iItemSkuQueryApi.queryBySkuCode((List)Lists.newArrayList((Object[])new String[]{t.getLongCode()})).getData();
                    logger.info("\u67e5\u8be2sku\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)skuRespDtos));
                    if (CollectionUtils.isNotEmpty((Collection)skuRespDtos)) {
                        ItemBundleReqDto itemBundleReqDtos = new ItemBundleReqDto();
                        CubeBeanUtils.copyProperties((Object)itemBundleReqDtos, skuRespDtos.get(0), (String[])new String[0]);
                        logger.info("copy sku\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)itemBundleReqDtos));
                        itemBundleReqDtos.setAttr(t.getSkuAttrs());
                        this.iItemSkuApi.modifyItemSku((List)Lists.newArrayList((Object[])new ItemBundleReqDto[]{itemBundleReqDtos}));
                    }
                }
            });
        } else {
            logger.info("\u5165\u53c2\u4e3a\u7a7a\uff01");
        }
    }

    @Override
    public boolean updateOrInsertItemAuth(List<ItemAuthReqDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            logger.info("\u65e0\u6570\u636e\u5904\u7406");
            return false;
        }
        Set targetIdSet = dtoList.stream().map(ItemAuthReqDto::getTargetId).collect(Collectors.toSet());
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByCustomerIds(new ArrayList(targetIdSet)));
        Map<Object, Object> customerInfoMap = new HashMap();
        List<Object> authConfigIdList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)customerRespDtos)) {
            customerInfoMap = customerRespDtos.stream().collect(Collectors.toMap(BaseRespDto::getId, Function.identity()));
            Set thirdParentPartyIdList = customerRespDtos.stream().map(CustomerRespDto::getThirdParentPartyId).collect(Collectors.toSet());
            ItemAuthConfigReqDto itemAuthConfigReqDto = new ItemAuthConfigReqDto();
            itemAuthConfigReqDto.setThirdPartyIdList(new ArrayList(thirdParentPartyIdList));
            List itemAuthConfigRespDtos = this.itemAuthConfigService.queryParam(itemAuthConfigReqDto);
            if (CollectionUtils.isNotEmpty((Collection)itemAuthConfigRespDtos)) {
                authConfigIdList = itemAuthConfigRespDtos.stream().map(ItemAuthConfigRespDto::getThirdPartyId).collect(Collectors.toList());
            }
        }
        ArrayList addList = Lists.newArrayList();
        for (ItemAuthReqDto itemAuthReqDto : dtoList) {
            if (Objects.equals(itemAuthReqDto.getTargetType(), 1)) {
                Long targetId = itemAuthReqDto.getTargetId();
                if (customerInfoMap.containsKey(targetId)) {
                    CustomerRespDto customerRespDto = (CustomerRespDto)customerInfoMap.get(targetId);
                    if (authConfigIdList.contains(customerRespDto.getThirdParentPartyId())) {
                        logger.info("\u5546\u54c1\u6388\u6743\u914d\u7f6e\u4e86\u6dfb\u52a0\u8425\u9500\u4e91id={}", (Object)targetId);
                        continue;
                    }
                } else {
                    logger.info("\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728={}", (Object)targetId);
                    continue;
                }
            }
            addList.add(itemAuthReqDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)addList)) {
            this.itemExtDas.updateOrInsertItemAuth((List)addList);
        }
        return true;
    }

    @Override
    public void addProValue(ItemProValue itemProValue) {
        if (Objects.isNull(itemProValue.getPropNameId()) || StringUtils.isEmpty((CharSequence)itemProValue.getName())) {
            logger.info("\u5c5e\u6027\u540did\u6216\u8005\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        PropValueEo propValueEo = new PropValueEo();
        propValueEo.setName(itemProValue.getName());
        propValueEo.setPropNameId(itemProValue.getPropNameId());
        List propValueEoList = this.propValueDas.select((BaseEo)propValueEo);
        if (CollectionUtils.isNotEmpty((Collection)propValueEoList)) {
            logger.info("\u5546\u54c1\u5c5e\u6027\u5df2\u7ecf\u5b58\u5728");
            return;
        }
        CubeBeanUtils.copyProperties((Object)propValueEo, (Object)itemProValue, (String[])new String[0]);
        this.propValueDas.insert((BaseEo)propValueEo);
    }
}

