/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.google.common.collect.Maps;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemPropGroupDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.DirsItemsRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemAttributesRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemDetailRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemMediasRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemPriceRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemPropRelationRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemShelfRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemAttributesService;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.DirItemRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemMediasDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemPriceDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemPropRelationDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemSkuDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ShelfDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.DirItemRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemAttributesEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemMediasEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemPriceEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemPropRelationEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ShelfEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemPropRelationEo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yx.tcbj.center.api.dto.request.ItemAuthExtractCodeReqDto;
import com.yx.tcbj.center.api.dto.request.ItemDetailBatchReqDto;
import com.yx.tcbj.center.api.dto.request.QueryByItemCodeWithOrgIdReqDto;
import com.yx.tcbj.center.api.dto.request.QueryBySkuCodeWithOrgIdReqDto;
import com.yx.tcbj.center.api.dto.request.ShelfExtReqDto;
import com.yx.tcbj.center.api.dto.response.ItemAuthExtractCodeRespDto;
import com.yx.tcbj.center.biz.service.IItemExtService;
import com.yx.tcbj.center.dao.das.ItemExtDas;
import com.yx.tcbj.center.dao.mapper.ItemExtMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ItemExtServiceImpl
implements IItemExtService {
    private static Logger logger = LoggerFactory.getLogger(ItemExtServiceImpl.class);
    @Autowired
    private ItemDas itemDas;
    @Autowired
    private ShelfDas shelfDas;
    @Autowired
    private ItemPropRelationDas itemPropRelationDas;
    @Autowired
    private ItemSkuDas itemSkuDas;
    @Autowired
    private ItemPriceDas itemPriceDas;
    @Autowired
    private IItemAttributesService iItemAttributesService;
    @Autowired
    private ItemMediasDas itemMediasDas;
    @Autowired
    private DirItemRelationDas dirItemRelationDas;
    @Autowired
    private DirDas dirDas;
    @Autowired
    private ItemExtDas itemExtDas;
    @Resource
    private ItemExtMapper itemExtMapper;

    @Override
    public List<ItemRespDto> queryByCodes(List<String> codes) {
        ItemEo itemEo = new ItemEo();
        LambdaQueryWrapper itemEoLambdaQueryWrapper = Wrappers.lambdaQuery((Object)itemEo);
        itemEoLambdaQueryWrapper.in(StdItemEo::getCode, codes);
        List itemEos = this.itemDas.getMapper().selectList((Wrapper)itemEoLambdaQueryWrapper);
        ArrayList itemRespDto = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)itemRespDto, (Collection)itemEos, ItemRespDto.class);
        return itemRespDto;
    }

    @Override
    public List<ItemShelfRespDto> queryItemShelf(ShelfExtReqDto shelfExtReqDto) {
        if (CollectionUtils.isEmpty((Collection)shelfExtReqDto.getShopIds()) || CollectionUtils.isEmpty((Collection)shelfExtReqDto.getSkuIds()) && CollectionUtils.isEmpty((Collection)shelfExtReqDto.getItemIds())) {
            logger.info("\u67e5\u8be2\u4e0a\u67b6\u5546\u54c1\u5165\u53c2\u9519\u8bef\uff1a{}", (Object)JSON.toJSONString((Object)shelfExtReqDto));
            return Lists.newArrayList();
        }
        ShelfEo shelfEo = ShelfEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)shelfExtReqDto, (BaseEo)shelfEo);
        ArrayList sqlFilters = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)shelfExtReqDto.getItemIds())) {
            sqlFilters.add(SqlFilter.in((String)"itemId", (Object)shelfExtReqDto.getItemIds()));
        }
        if (CollectionUtils.isNotEmpty((Collection)shelfExtReqDto.getSkuIds())) {
            sqlFilters.add(SqlFilter.in((String)"skuId", (Object)shelfExtReqDto.getSkuIds()));
        }
        if (CollectionUtils.isNotEmpty((Collection)shelfExtReqDto.getShopIds())) {
            sqlFilters.add(SqlFilter.in((String)"shopId", (Object)shelfExtReqDto.getShopIds()));
        }
        shelfEo.setSqlFilters((List)sqlFilters);
        List shelfEos = this.shelfDas.select((BaseEo)shelfEo);
        ArrayList shelfRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)shelfEos, (Collection)shelfRespDtoList, ItemShelfRespDto.class);
        return shelfRespDtoList;
    }

    @Override
    public List<ItemDetailRespDto> queryItemDetailByItemIds(ItemDetailBatchReqDto itemDetailBatchReqDto) {
        if (CollectionUtils.isEmpty((Collection)itemDetailBatchReqDto.getItemIds()) && CollectionUtils.isEmpty((Collection)itemDetailBatchReqDto.getItemCodes())) {
            return Lists.newArrayList();
        }
        String field = itemDetailBatchReqDto.getField();
        ItemEo itemEo = ItemEo.newInstance();
        ArrayList sqlFilters = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)itemDetailBatchReqDto.getItemIds())) {
            sqlFilters.add(SqlFilter.in((String)"id", (Object)itemDetailBatchReqDto.getItemIds()));
        }
        if (CollectionUtils.isNotEmpty((Collection)itemDetailBatchReqDto.getItemCodes())) {
            sqlFilters.add(SqlFilter.in((String)"code", (Object)itemDetailBatchReqDto.getItemCodes()));
        }
        itemEo.setSqlFilters((List)sqlFilters);
        List itemEos = this.itemDas.select((BaseEo)itemEo);
        if (CollectionUtils.isEmpty((Collection)itemEos)) {
            return Lists.newArrayList();
        }
        List itemIds = itemEos.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
        itemDetailBatchReqDto.setItemIds(itemIds);
        ItemPropRelationEo itemPropRelationEo = ItemPropRelationEo.newInstance();
        ArrayList propSqlFilters = Lists.newArrayList();
        propSqlFilters.add(SqlFilter.in((String)"item_id", (Object)itemDetailBatchReqDto.getItemIds()));
        itemPropRelationEo.setSqlFilters((List)propSqlFilters);
        List itemPropRelationEos = this.itemPropRelationDas.select((BaseEo)itemPropRelationEo);
        Map<Long, List<ItemPropRelationEo>> propMap = itemPropRelationEos.stream().collect(Collectors.groupingBy(StdItemPropRelationEo::getItemId));
        Map<Long, List<ItemSkuRespDto>> skuMap = this.queryItemSku(itemDetailBatchReqDto.getItemIds());
        HashMap attrMap = Maps.newHashMap();
        List itemAttributesEos = this.iItemAttributesService.queryByItemIds(itemDetailBatchReqDto.getItemIds());
        for (ItemAttributesEo itemAttributesEo : itemAttributesEos) {
            ItemAttributesRespDto attrRespDto = new ItemAttributesRespDto();
            DtoHelper.eo2Dto((BaseEo)itemAttributesEo, (BaseVo)attrRespDto);
            List attributesRespDtos = (List)attrMap.get(itemAttributesEo.getItemId());
            attributesRespDtos = CollectionUtils.isNotEmpty((Collection)attributesRespDtos) ? attributesRespDtos : Lists.newArrayList();
            attributesRespDtos.add(attrRespDto);
            attrMap.put(itemAttributesEo.getItemId(), attributesRespDtos);
        }
        HashMap mediasMap = Maps.newHashMap();
        ItemMediasEo itemMediasEo = new ItemMediasEo();
        ArrayList mediasSqlFilters = Lists.newArrayList();
        mediasSqlFilters.add(SqlFilter.in((String)"item_id", (Object)itemDetailBatchReqDto.getItemIds()));
        itemMediasEo.setSqlFilters((List)mediasSqlFilters);
        List itemMediasEos = this.itemMediasDas.select((BaseEo)itemMediasEo);
        for (ItemMediasEo mediasEo : itemMediasEos) {
            ItemMediasRespDto itemMediasRespDto = new ItemMediasRespDto();
            DtoHelper.eo2Dto((BaseEo)mediasEo, (BaseVo)itemMediasRespDto);
            List itemMediasRespDtos = (List)mediasMap.get(mediasEo.getItemId());
            itemMediasRespDtos = CollectionUtils.isNotEmpty((Collection)itemMediasRespDtos) ? itemMediasRespDtos : Lists.newArrayList();
            itemMediasRespDtos.add(itemMediasRespDto);
            mediasMap.put(mediasEo.getItemId(), itemMediasRespDtos);
        }
        HashSet shopDirIdSet = Sets.newHashSet();
        HashMap dirMap = Maps.newHashMap();
        DirItemRelationEo dirItemRelationEo = new DirItemRelationEo();
        ArrayList dirItemRelationSqlFilters = Lists.newArrayList();
        dirItemRelationSqlFilters.add(SqlFilter.in((String)"item_id", (Object)itemDetailBatchReqDto.getItemIds()));
        dirItemRelationEo.setSqlFilters((List)dirItemRelationSqlFilters);
        List dirItemRelationEos = this.dirItemRelationDas.select((BaseEo)dirItemRelationEo);
        for (DirItemRelationEo itemRelationEo : dirItemRelationEos) {
            DirsItemsRespDto dirsItemsRespDto = new DirsItemsRespDto();
            DtoHelper.eo2Dto((BaseEo)itemRelationEo, (BaseVo)dirsItemsRespDto);
            List dirsItemsRespDtos = (List)dirMap.get(itemRelationEo.getItemId());
            dirsItemsRespDtos = CollectionUtils.isNotEmpty((Collection)dirsItemsRespDtos) ? dirsItemsRespDtos : Lists.newArrayList();
            dirsItemsRespDtos.add(dirsItemsRespDto);
            dirMap.put(itemRelationEo.getItemId(), dirsItemsRespDtos);
            if (!Objects.equals("shop", dirsItemsRespDto.getDirType())) continue;
            shopDirIdSet.add(dirsItemsRespDto.getDirId());
        }
        Map<Object, Object> dirEoMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)shopDirIdSet)) {
            DirEo dirEo = DirEo.newInstance();
            ArrayList dirSqlFilters = Lists.newArrayList();
            dirSqlFilters.add(SqlFilter.in((String)"id", (Object)shopDirIdSet));
            dirEo.setSqlFilters((List)dirSqlFilters);
            List dirEos = this.dirDas.select((BaseEo)dirEo);
            dirEoMap = dirEos.stream().collect(Collectors.toMap(BaseEo::getId, e -> e, (e1, e2) -> e1));
        }
        ArrayList itemDetailDtos = Lists.newArrayList();
        for (ItemEo eo : itemEos) {
            DirEo dirEo;
            String propGroupInfo;
            ItemDetailRespDto itemDetailDto = new ItemDetailRespDto();
            List<ItemPropRelationEo> targetPropEos = propMap.get(eo.getId());
            if (CollectionUtils.isNotEmpty(targetPropEos)) {
                ArrayList propRespDtos = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)propRespDtos, targetPropEos, ItemPropRelationRespDto.class);
                itemDetailDto.setItemPropRelationRespDtos((List)propRespDtos);
            }
            if (StringUtils.isNotBlank((CharSequence)(propGroupInfo = eo.getPropGroupInfo()))) {
                List propGroupDtoList = JSON.parseArray((String)propGroupInfo, ItemPropGroupDto.class);
                itemDetailDto.setPropGroupDtoList(propGroupDtoList);
            }
            ItemRespDto itemDto = new ItemRespDto();
            DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)itemDto);
            if (StringUtils.isBlank((CharSequence)field)) {
                itemDetailDto.setItem(itemDto);
                itemDetailDtos.add(itemDetailDto);
                continue;
            }
            if (field.contains("sku")) {
                itemDetailDto.setItemSkuList(skuMap.get(eo.getId()));
            }
            if (field.contains("attributes")) {
                itemDetailDto.setItemAttributesList((List)attrMap.get(eo.getId()));
            }
            if (field.contains("medias")) {
                itemDetailDto.setItemMediasList((List)mediasMap.get(eo.getId()));
            }
            List dirsItemsRespDtos = (List)dirMap.get(eo.getId());
            itemDetailDto.setDirsItemsList(dirsItemsRespDtos);
            itemDetailDto.setItem(itemDto);
            if (StringUtils.isNotBlank((CharSequence)eo.getSaleChannel())) {
                itemDetailDto.setSaleChannels(Arrays.asList(eo.getSaleChannel().split("-")));
            }
            if (CollectionUtils.isNotEmpty((Collection)dirsItemsRespDtos) && (dirEo = (DirEo)dirEoMap.get(((DirsItemsRespDto)dirsItemsRespDtos.get(0)).getDirId())) != null) {
                itemDetailDto.setShopDirId(dirEo.getId());
                itemDetailDto.setShopDirName(dirEo.getName());
            }
            itemDetailDtos.add(itemDetailDto);
        }
        return itemDetailDtos;
    }

    private Map<Long, List<ItemSkuRespDto>> queryItemSku(List<Long> itemIds) {
        List itemSkuEoList = this.itemSkuDas.selectByItemIds(itemIds);
        List skuIdList = itemSkuEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
        HashMap itemPriceMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(skuIdList)) {
            List itemPriceEoList = this.itemPriceDas.selectBySkuIds(skuIdList);
            for (ItemPriceEo itemPriceEo : itemPriceEoList) {
                ItemPriceRespDto priceRespDto = new ItemPriceRespDto();
                DtoHelper.eo2Dto((BaseEo)itemPriceEo, (BaseVo)priceRespDto);
                List priceList = (List)itemPriceMap.get(priceRespDto.getSkuId());
                priceList = CollectionUtils.isEmpty((Collection)priceList) ? Lists.newArrayList() : priceList;
                priceList.add(priceRespDto);
                itemPriceMap.put(priceRespDto.getSkuId(), priceList);
            }
        }
        HashMap itemSkuDtoMap = Maps.newHashMap();
        for (ItemSkuEo itemSkuEo : itemSkuEoList) {
            ItemSkuRespDto itemSkuDto = new ItemSkuRespDto();
            DtoHelper.eo2Dto((BaseEo)itemSkuEo, (BaseVo)itemSkuDto);
            itemSkuDto.setItemPriceList((List)itemPriceMap.get(itemSkuDto.getId()));
            List mapSkuDtoList = (List)itemSkuDtoMap.get(itemSkuDto.getItemId());
            mapSkuDtoList = CollectionUtils.isEmpty((Collection)mapSkuDtoList) ? Lists.newArrayList() : mapSkuDtoList;
            mapSkuDtoList.add(itemSkuDto);
            itemSkuDtoMap.put(itemSkuDto.getItemId(), mapSkuDtoList);
        }
        return itemSkuDtoMap;
    }

    @Override
    public List<ItemAuthExtractCodeRespDto> queryExaractCodeByShelf(ItemAuthExtractCodeReqDto reqDto) {
        return this.itemExtDas.queryExaractCodeByShelf(reqDto);
    }

    @Override
    public List<ItemRespDto> queryByItemLongCodes(List<String> itemCodes) {
        return CollectionUtils.isEmpty(itemCodes) ? null : this.itemExtDas.queryByItemLongCodes(itemCodes);
    }

    @Override
    public ItemRespDto queryByItemCodeWithOrgId(QueryByItemCodeWithOrgIdReqDto req) {
        if (req.getOrgId() == null) {
            throw new BizException("queryByItemCodeWithOrgId \u67e5\u8be2Item\u5931\u8d25\uff0c\u54c1\u724c\u65b9\u673a\u6784id\u4e3a\u7a7a itemCode={}", req.getItemCode());
        }
        ItemEo itemEoSelect = new ItemEo();
        itemEoSelect.setCode(req.getItemCode());
        itemEoSelect.setOrganizationId(req.getOrgId());
        ItemEo itemEo = (ItemEo)this.itemDas.selectOne((BaseEo)itemEoSelect);
        ItemRespDto itemRespDto = new ItemRespDto();
        DtoHelper.eo2Dto((BaseEo)itemEo, (BaseVo)itemRespDto);
        return itemRespDto;
    }

    @Override
    public List<ItemSkuRespDto> queryBySkuCodeWithOrgId(QueryBySkuCodeWithOrgIdReqDto req) {
        if (req.getOrgId() == null) {
            throw new BizException("queryBySkuCodeWithOrgId \u67e5\u8be2ItemSku\u5931\u8d25\uff0c\u54c1\u724c\u65b9\u673a\u6784id\u4e3a\u7a7a skuCodes={}", JSONObject.toJSONString((Object)req.getSkuCodes()));
        }
        return this.itemExtMapper.queryBySkuCodeWithOrgId(req);
    }
}

