/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.b2b.service.query.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.item.api.b2b.constants.AuthItemRuleTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.b2b.constants.ProhibiteItemOptEnum;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.AuthItemRuleReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.CustomerAuthItemPageReqDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.request.CustomerAuthItemVo;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.AuthItemRuleRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.CustomerAuthItemNumRespDto;
import com.dtyunxi.yundt.cube.center.item.api.b2b.dto.response.CustomerAuthItemRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.b2b.service.IAuthItemRuleService;
import com.dtyunxi.yundt.cube.center.item.biz.b2b.service.IProhibiteSaleItemService;
import com.dtyunxi.yundt.cube.center.item.biz.b2b.service.query.ICustomerAuthItemQueryService;
import com.dtyunxi.yundt.cube.center.item.dao.b2b.das.CustomerAuthItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemSkuDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.b2b.ProhibiteSaleItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomerAuthItemQueryServiceImpl
implements ICustomerAuthItemQueryService {
    private static final Logger logger = LoggerFactory.getLogger(CustomerAuthItemQueryServiceImpl.class);
    @Autowired
    private IAuthItemRuleService authItemRuleService;
    @Autowired
    private IProhibiteSaleItemService prohibiteSaleItemService;
    @Autowired
    private CustomerAuthItemDas customerAuthItemDas;
    @Autowired
    private ItemDas itemDas;
    @Autowired
    private ItemSkuDas itemSkuDas;
    @Resource
    private HttpServletRequest request;

    @Override
    public RestResponse<PageInfo<CustomerAuthItemRespDto>> queryAuthItemPage(CustomerAuthItemPageReqDto customerAuthItemPageReqDto) {
        PageInfo resultPageInfo = new PageInfo();
        AuthItemRuleRespDto authItemRuleRespDto = this.authItemRuleService.queryByCustomerId(customerAuthItemPageReqDto.getCustomerId());
        if (Objects.equals(customerAuthItemPageReqDto.getSelectType(), 1)) {
            if (authItemRuleRespDto == null) {
                return new RestResponse((Object)resultPageInfo);
            }
            if (Objects.equals(AuthItemRuleTypeEnum.UN_AUTH.getRuleType(), authItemRuleRespDto.getAuthType())) {
                return new RestResponse((Object)resultPageInfo);
            }
            if (Objects.equals(AuthItemRuleTypeEnum.ITEM.getRuleType(), authItemRuleRespDto.getAuthType()) && CollectionUtil.isEmpty((Collection)authItemRuleRespDto.getCustomerAuthItemRespDtos())) {
                return new RestResponse((Object)resultPageInfo);
            }
        } else if (authItemRuleRespDto != null && AuthItemRuleTypeEnum.ALL_ITEM.getRuleType().equals(authItemRuleRespDto.getAuthType())) {
            return new RestResponse((Object)resultPageInfo);
        }
        Set<Long> prohibiteSaleSkuIds = new HashSet<Long>();
        if (Objects.equals(customerAuthItemPageReqDto.getSelectType(), 1)) {
            List prohibiteSaleItemEos = this.prohibiteSaleItemService.queryByCustomerId(customerAuthItemPageReqDto.getCustomerId());
            if (ProhibiteItemOptEnum.PROHIBITE_SALE.getOptType().equals(customerAuthItemPageReqDto.getProhibiteStatus()) && CollectionUtil.isEmpty((Collection)prohibiteSaleItemEos)) {
                return new RestResponse((Object)resultPageInfo);
            }
            prohibiteSaleSkuIds = prohibiteSaleItemEos.stream().map(ProhibiteSaleItemEo::getSkuId).collect(Collectors.toSet());
        }
        PageInfo<CustomerAuthItemVo> pageInfo = this.getAuthItemVoPageInfo(customerAuthItemPageReqDto, authItemRuleRespDto, prohibiteSaleSkuIds);
        CubeBeanUtils.copyProperties((Object)resultPageInfo, pageInfo, (String[])new String[]{"list"});
        if (pageInfo != null && CollectionUtil.isNotEmpty((Collection)pageInfo.getList())) {
            ArrayList customerAuthItemRespDtos = Lists.newArrayList();
            for (CustomerAuthItemVo customerAuthItemVo : pageInfo.getList()) {
                CustomerAuthItemRespDto customerAuthItemRespDto = new CustomerAuthItemRespDto();
                BeanUtil.copyProperties((Object)customerAuthItemVo, (Object)customerAuthItemRespDto, (String[])new String[0]);
                if (customerAuthItemPageReqDto.getSelectType() == 1) {
                    Integer prohibiteStatus = 1;
                    if (prohibiteSaleSkuIds.contains(customerAuthItemVo.getSkuId())) {
                        prohibiteStatus = 2;
                    }
                    customerAuthItemRespDto.setProhibiteStatus(prohibiteStatus);
                }
                customerAuthItemRespDtos.add(customerAuthItemRespDto);
            }
            resultPageInfo.setList((List)customerAuthItemRespDtos);
        }
        return new RestResponse((Object)resultPageInfo);
    }

    @Override
    public RestResponse<CustomerAuthItemNumRespDto> queryAuthItemNum(CustomerAuthItemPageReqDto customerAuthItemPageReqDto) {
        CustomerAuthItemNumRespDto numRespDto = new CustomerAuthItemNumRespDto(Long.valueOf(1L), Long.valueOf(1L));
        return new RestResponse((Object)numRespDto);
    }

    @Override
    public RestResponse<List<CustomerAuthItemRespDto>> queryAuthItemBySkuIds(List<Long> skuIds) {
        if (CollectionUtils.isEmpty(skuIds)) {
            return new RestResponse(new ArrayList());
        }
        try {
            List<CustomerAuthItemVo> customerAuthItemVos = this.getAuthItemVoListBySkuIds(skuIds);
            if (CollectionUtils.isEmpty(customerAuthItemVos)) {
                return new RestResponse(new ArrayList());
            }
            ArrayList<CustomerAuthItemRespDto> resultList = new ArrayList<CustomerAuthItemRespDto>();
            for (CustomerAuthItemVo vo : customerAuthItemVos) {
                CustomerAuthItemRespDto respDto = new CustomerAuthItemRespDto();
                BeanUtil.copyProperties((Object)vo, (Object)respDto, (String[])new String[0]);
                resultList.add(respDto);
            }
            logger.info("Found {} authorized customers for {} SKUs", (Object)resultList.size(), (Object)skuIds.size());
            return new RestResponse(resultList);
        }
        catch (Exception e) {
            logger.error("Error querying auth items by skuIds: {}", skuIds, (Object)e);
            return new RestResponse(new ArrayList());
        }
    }

    private PageInfo<CustomerAuthItemVo> getAuthItemVoPageInfo(CustomerAuthItemPageReqDto reqDto, AuthItemRuleRespDto authItemRuleRespDto, Set<Long> prohibiteSaleSkuIds) {
        List matchSkuIds = reqDto.getMatchSkuIds();
        if (CollectionUtils.isNotEmpty((Collection)matchSkuIds)) {
            logger.debug("Filtering by matchSkuIds: {}", (Object)matchSkuIds);
            List<Object> voList = this.getAuthItemVoListBySkuIds(matchSkuIds);
            if (reqDto.getCustomerId() != null) {
                voList = voList.stream().filter(vo -> Objects.equals(vo.getCustomerId(), reqDto.getCustomerId())).collect(Collectors.toList());
            }
            PageInfo pageInfo = new PageInfo();
            pageInfo.setList(voList);
            pageInfo.setTotal((long)voList.size());
            pageInfo.setPageNum(reqDto.getPageNum().intValue());
            pageInfo.setPageSize(reqDto.getPageSize().intValue());
            return pageInfo;
        }
        return this.createMockPageInfo(reqDto);
    }

    private List<CustomerAuthItemVo> getAuthItemVoListBySkuIds(List<Long> skuIds) {
        if (CollectionUtils.isEmpty(skuIds)) {
            return new ArrayList<CustomerAuthItemVo>();
        }
        List<Object> resultList = new ArrayList<CustomerAuthItemVo>();
        try {
            List<AuthItemRuleRespDto> categoryAuthCustomers;
            Map<Long, List<Long>> categorySkuMap;
            List<AuthItemRuleRespDto> allItemAuthCustomers;
            List specificItemAuthList = ((ExtQueryChainWrapper)this.customerAuthItemDas.filter().in((Object)"sku_id", skuIds)).list().stream().map(r -> (CustomerAuthItemVo)BeanUtil.copyProperties((Object)r, CustomerAuthItemVo.class, (String[])new String[0])).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(specificItemAuthList)) {
                resultList.addAll(specificItemAuthList);
                logger.debug("Found {} specific-item auth customers", (Object)specificItemAuthList.size());
            }
            if (CollectionUtils.isNotEmpty(allItemAuthCustomers = this.getAllItemAuthCustomers())) {
                for (AuthItemRuleRespDto authRule : allItemAuthCustomers) {
                    for (Long skuId : skuIds) {
                        CustomerAuthItemVo vo = new CustomerAuthItemVo();
                        vo.setSkuId(skuId);
                        vo.setCustomerId(authRule.getCustomerId());
                        vo.setCustomerName(authRule.getCustomerName());
                        resultList.add(vo);
                    }
                }
                logger.debug("Added {} all-item auth customers", (Object)allItemAuthCustomers.size());
            }
            if (CollectionUtils.isNotEmpty((categorySkuMap = this.getCategorySkuMap(skuIds)).keySet()) && CollectionUtils.isNotEmpty(categoryAuthCustomers = this.getCategoryAuthCustomers())) {
                for (AuthItemRuleRespDto authRule : categoryAuthCustomers) {
                    List<Long> authorizedCategoryIds = this.getAuthorizedCategoryIds(authRule);
                    if (CollectionUtils.isEmpty(authorizedCategoryIds)) continue;
                    for (Long categoryId : authorizedCategoryIds) {
                        List<Long> categorySkus = categorySkuMap.get(categoryId);
                        if (!CollectionUtils.isNotEmpty(categorySkus)) continue;
                        for (Long skuId : categorySkus) {
                            CustomerAuthItemVo vo = new CustomerAuthItemVo();
                            vo.setSkuId(skuId);
                            vo.setCustomerId(authRule.getCustomerId());
                            vo.setCustomerName(authRule.getCustomerName());
                            resultList.add(vo);
                        }
                    }
                }
                logger.debug("Added category auth customers for {} categories", (Object)categorySkuMap.size());
            }
            resultList = resultList.stream().collect(Collectors.collectingAndThen(Collectors.toMap(item -> item.getCustomerId() + "_" + item.getSkuId(), item -> item, (existing, replacement) -> existing), map -> new ArrayList(map.values())));
            logger.debug("Found total {} authorized customers for SKUs: {}", (Object)resultList.size(), skuIds);
            return resultList;
        }
        catch (Exception e) {
            logger.error("Error in getAuthItemVoListBySkuIds for skuIds: {}", skuIds, (Object)e);
            return resultList;
        }
    }

    public String getHeaderOrgId() {
        String organizationId = Optional.ofNullable(ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationId")).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).orElse((String)StringUtils.defaultIfBlank((CharSequence)ServiceContext.getContext().getAttachment("yes.req.cus.b2b.organizationid"), (CharSequence)this.request.getHeader("yes-req-cus-b2b-organizationId")));
        logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        return organizationId;
    }

    private List<AuthItemRuleRespDto> getAllItemAuthCustomers() {
        try {
            AuthItemRuleReqDto reqDto = new AuthItemRuleReqDto();
            reqDto.setAuthType(AuthItemRuleTypeEnum.ALL_ITEM.getRuleType());
            reqDto.setOrganizationId((Long)Optional.ofNullable(this.getHeaderOrgId()).map(Long::valueOf).orElse(null));
            reqDto.setPageNum(Integer.valueOf(1));
            reqDto.setPageSize(Integer.valueOf(10000));
            PageInfo response = this.authItemRuleService.queryByPage(reqDto);
            return response.getList();
        }
        catch (Exception e) {
            logger.error("Error getting all-item auth customers", (Throwable)e);
            return new ArrayList<AuthItemRuleRespDto>();
        }
    }

    private List<AuthItemRuleRespDto> getCategoryAuthCustomers() {
        try {
            AuthItemRuleReqDto reqDto = new AuthItemRuleReqDto();
            reqDto.setAuthType(AuthItemRuleTypeEnum.CATEGORY.getRuleType());
            reqDto.setPageNum(Integer.valueOf(1));
            reqDto.setPageSize(Integer.valueOf(10000));
            PageInfo response = this.authItemRuleService.queryByPage(reqDto);
            return response.getList();
        }
        catch (Exception e) {
            logger.error("Error getting category auth customers", (Throwable)e);
            return new ArrayList<AuthItemRuleRespDto>();
        }
    }

    private Map<Long, List<Long>> getCategorySkuMap(List<Long> skuIds) {
        HashMap<Long, List<Long>> categorySkuMap = new HashMap<Long, List<Long>>();
        try {
            Map<Long, Long> skuCategoryMap = this.getSkuCategoryMap(skuIds);
            if (CollectionUtils.isNotEmpty(skuCategoryMap.keySet())) {
                for (Map.Entry<Long, Long> entry : skuCategoryMap.entrySet()) {
                    Long skuId = entry.getKey();
                    Long categoryId = entry.getValue();
                    if (categoryId == null) continue;
                    List categorySkus = categorySkuMap.getOrDefault(categoryId, new ArrayList());
                    categorySkus.add(skuId);
                    categorySkuMap.put(categoryId, categorySkus);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error getting category-sku mapping for skuIds: {}", skuIds, (Object)e);
        }
        return categorySkuMap;
    }

    private Map<Long, Long> getSkuCategoryMap(List<Long> skuIds) {
        HashMap<Long, Long> skuCategoryMap = new HashMap<Long, Long>();
        try {
            if (CollectionUtils.isEmpty(skuIds)) {
                return skuCategoryMap;
            }
            List itemSkuEos = ((ExtQueryChainWrapper)this.itemSkuDas.filter().in((Object)"id", skuIds)).list();
            if (CollectionUtils.isEmpty((Collection)itemSkuEos)) {
                logger.warn("No item SKUs found for skuIds: {}", skuIds);
                return skuCategoryMap;
            }
            HashMap<Long, List> itemSkuMap = new HashMap<Long, List>();
            for (ItemSkuEo itemSkuEo : itemSkuEos) {
                if (itemSkuEo.getItemId() == null) continue;
                List itemSkus = itemSkuMap.getOrDefault(itemSkuEo.getItemId(), new ArrayList());
                itemSkus.add(itemSkuEo.getId());
                itemSkuMap.put(itemSkuEo.getItemId(), itemSkus);
            }
            if (itemSkuMap.isEmpty()) {
                logger.warn("No valid item IDs found in SKUs: {}", skuIds);
                return skuCategoryMap;
            }
            List itemEos = ((ExtQueryChainWrapper)this.itemDas.filter().in((Object)"id", itemSkuMap.keySet())).list();
            if (CollectionUtils.isEmpty((Collection)itemEos)) {
                logger.warn("No items found for item IDs: {}", itemSkuMap.keySet());
                return skuCategoryMap;
            }
            HashMap<Long, Long> itemCategoryMap = new HashMap<Long, Long>();
            for (ItemEo itemEo : itemEos) {
                if (itemEo.getDirId() == null) continue;
                itemCategoryMap.put(itemEo.getId(), itemEo.getDirId());
            }
            for (Map.Entry entry : itemSkuMap.entrySet()) {
                Long itemId = (Long)entry.getKey();
                List skus = (List)entry.getValue();
                Long categoryId = (Long)itemCategoryMap.get(itemId);
                if (categoryId == null || skus.isEmpty()) continue;
                for (Long skuId : skus) {
                    skuCategoryMap.put(skuId, categoryId);
                }
            }
            logger.debug("Found {} SKU-category mappings", (Object)skuCategoryMap.size());
        }
        catch (Exception e) {
            logger.error("Error getting sku-category mapping for skuIds: {}", skuIds, (Object)e);
        }
        return skuCategoryMap;
    }

    private List<Long> getAuthorizedCategoryIds(AuthItemRuleRespDto authRule) {
        List<Long> authorizedCategoryIds = new ArrayList<Long>();
        try {
            if (authRule != null && authRule.getCustomerAuthItemRespDtos() != null) {
                authorizedCategoryIds = authRule.getCustomerAuthItemRespDtos().stream().map(CustomerAuthItemRespDto::getDirId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                logger.debug("Found {} authorized categories for customer: {}", (Object)authorizedCategoryIds.size(), (Object)authRule.getCustomerId());
            }
        }
        catch (Exception e) {
            logger.error("Error getting authorized category IDs for customer: {}", (Object)(authRule != null ? authRule.getCustomerId() : null), (Object)e);
        }
        return authorizedCategoryIds;
    }

    private PageInfo<CustomerAuthItemVo> createMockPageInfo(CustomerAuthItemPageReqDto reqDto) {
        ArrayList list = new ArrayList();
        PageInfo pageInfo = new PageInfo();
        pageInfo.setList(list);
        pageInfo.setTotal(0L);
        pageInfo.setPageNum(reqDto.getPageNum().intValue());
        pageInfo.setPageSize(reqDto.getPageSize().intValue());
        return pageInfo;
    }

    private List<CustomerAuthItemVo> createMockCustomerAuthItemVoList(List<Long> skuIds) {
        return ((ExtQueryChainWrapper)this.customerAuthItemDas.filter().in((Object)"sku_id", skuIds)).list().stream().map(r -> (CustomerAuthItemVo)BeanUtil.copyProperties((Object)r, CustomerAuthItemVo.class, (String[])new String[0])).collect(Collectors.toList());
    }
}

