/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.dao.base.das;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.base.AbstractBaseDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.mapper.ShelfMapper;
import com.dtyunxi.yundt.cube.center.item.dao.base.vo.ShelfItemSkuVo;
import com.dtyunxi.yundt.cube.center.item.dao.base.vo.ShelfItemVo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ShelfEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

@Repository
public class ShelfDas
extends AbstractBaseDas<ShelfEo, String> {
    public List<ShelfEo> selectByParam(List<Long> shopIds, List<Long> itemIds, List<Long> skuIds, Integer busType) {
        if (CollectionUtils.isEmpty(shopIds) && CollectionUtils.isEmpty(itemIds) && CollectionUtils.isEmpty(skuIds)) {
            return Lists.newArrayList();
        }
        ShelfEo param = ShelfEo.newInstance();
        ArrayList sqlFilterList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(shopIds)) {
            sqlFilterList.add(SqlFilter.in((String)"shop_id", shopIds));
        }
        if (CollectionUtils.isNotEmpty(itemIds)) {
            sqlFilterList.add(SqlFilter.in((String)"item_id", itemIds));
        }
        if (CollectionUtils.isNotEmpty(skuIds)) {
            sqlFilterList.add(SqlFilter.in((String)"sku_id", skuIds));
        }
        if (busType != null) {
            param.setBusType(busType);
        }
        if (CollectionUtils.isNotEmpty((Collection)sqlFilterList)) {
            param.setSqlFilters((List)sqlFilterList);
        }
        return this.select((BaseEo)param);
    }

    public PageInfo<ShelfItemVo> selectSelfItemByPage(ShelfItemVo shelfItemVo, Integer pageNum, Integer pageSize) {
        ShelfMapper shelfMapper = (ShelfMapper)this.getMapper();
        if (pageNum != null && pageSize != null) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
        }
        List<ShelfItemVo> shelfItemVoList = shelfMapper.selectSelfItemByPage(shelfItemVo, pageNum, pageSize);
        return new PageInfo(shelfItemVoList);
    }

    public List<ShelfItemSkuVo> selectSelfItemSkuList(Long shopId, Long itemId, Integer busType) {
        ShelfMapper shelfMapper = (ShelfMapper)this.getMapper();
        return shelfMapper.selectSelfItemSkuList(shopId, itemId, busType);
    }

    public List<ShelfItemSkuVo> selectSelfItemSkuListByItemId(Long itemId) {
        ShelfMapper shelfMapper = (ShelfMapper)this.getMapper();
        return shelfMapper.selectSelfItemSkuListByItemId(itemId);
    }

    public List<ShelfItemSkuVo> selectSelfItemSkuListBySkuId(Long shopId, Long skuId) {
        ShelfMapper shelfMapper = (ShelfMapper)this.getMapper();
        return shelfMapper.selectSelfItemSkuListBySkuId(shopId, skuId);
    }

    public List<ShelfEo> selectByParam(Long shopId, Long itemId, Long skuId) {
        if (shopId == null && itemId == null && skuId == null) {
            return Lists.newArrayList();
        }
        ShelfEo param = ShelfEo.newInstance();
        if (shopId != null) {
            param.setShopId(shopId);
        }
        if (itemId != null) {
            param.setItemId(itemId);
        }
        if (skuId != null) {
            param.setSkuId(skuId);
        }
        return this.select((BaseEo)param);
    }

    public List<ShelfItemSkuVo> selectSelfItemSkuListBySkuIds(List<Long> skuIds) {
        ShelfMapper shelfMapper = (ShelfMapper)this.getMapper();
        return shelfMapper.selectSelfItemSkuListBySkuIds(skuIds);
    }

    public Long selectSelfItemCount(@Param(value="shelfItemVo") ShelfItemVo shelfItemVo) {
        ShelfMapper shelfMapper = (ShelfMapper)this.getMapper();
        return shelfMapper.selectSelfItems(shelfItemVo).size();
    }

    public List<ShelfItemVo> selectShelfList(ShelfItemVo shelfItemVo) {
        ShelfMapper shelfMapper = (ShelfMapper)this.getMapper();
        return shelfMapper.selectShelfList(shelfItemVo);
    }

    public List<ShelfItemVo> queryItemShelfSkuList(ShelfItemVo shelfItemVo) {
        ShelfMapper shelfMapper = (ShelfMapper)this.getMapper();
        return shelfMapper.queryItemShelfSkuList(shelfItemVo);
    }

    public Long newSelectSelfItemCount(ShelfItemVo shelfItemVo) {
        return ((ShelfMapper)this.getMapper()).newSelectSelfItems(shelfItemVo);
    }
}

