/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.promotion.biz.service.impl;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.ItemActivityTagExtDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.ItemActivityTagExtQueryReqDto;
import com.dtyunxi.yundt.cube.center.promotion.biz.service.IItemActivityTagBizExtService;
import com.dtyunxi.yundt.cube.center.promotion.biz.service.impl.ExternalApiHelp;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.tag.service.IItemActivityTagService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ItemActivityTagBizExtServiceImpl
implements IItemActivityTagBizExtService {
    private static final Logger log = LoggerFactory.getLogger(ItemActivityTagBizExtServiceImpl.class);
    @Resource
    private IItemActivityTagService itemActivityTagService;
    @Resource
    private ExternalApiHelp externalApiHelp;

    @Override
    public List<ItemActivityTagExtDto> queryList(ItemActivityTagExtQueryReqDto queryReqDto) {
        List<CustomerRespDto> customerRespDtos;
        List<ItemRespDto> itemRespDtos;
        List<ShopDto> shopDtoList;
        if (CollectionUtils.isNotEmpty((Collection)queryReqDto.getShopCodeList()) && CollectionUtils.isNotEmpty(shopDtoList = this.externalApiHelp.getShopByCodes(queryReqDto.getShopCodeList()))) {
            List shopIdList = shopDtoList.stream().map(ShopDto::getId).collect(Collectors.toList());
            queryReqDto.setShopIdList(shopIdList);
        }
        if (CollectionUtils.isNotEmpty((Collection)queryReqDto.getItemCodeList()) && CollectionUtils.isNotEmpty(itemRespDtos = this.externalApiHelp.getItemByCodes(queryReqDto.getItemCodeList()))) {
            List itemIdList = itemRespDtos.stream().map(ItemRespDto::getId).collect(Collectors.toList());
            queryReqDto.setItemIdList(itemIdList);
        }
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getThirdPartyId()) && CollectionUtils.isNotEmpty(customerRespDtos = this.externalApiHelp.getCustomerByThirdPartyIds(Lists.newArrayList((Object[])new String[]{queryReqDto.getThirdPartyId()})))) {
            queryReqDto.setCustomerId(customerRespDtos.get(0).getId());
        }
        List itemActivityTagDtos = this.itemActivityTagService.queryList((ItemActivityTagQueryReqDto)queryReqDto);
        ArrayList resultList = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)itemActivityTagDtos)) {
            return resultList;
        }
        CubeBeanUtils.copyCollection((Collection)resultList, (Collection)itemActivityTagDtos, ItemActivityTagExtDto.class);
        Set<Long> shopIdSet = resultList.stream().map(ItemActivityTagDto::getShopId).collect(Collectors.toSet());
        Set<Long> itemIdSet = resultList.stream().map(ItemActivityTagDto::getItemId).collect(Collectors.toSet());
        Set<Long> customerIdSet = resultList.stream().map(ItemActivityTagDto::getCustomerId).collect(Collectors.toSet());
        Map<Long, ShopDto> shopMap = this.externalApiHelp.getShopMapById(shopIdSet);
        Map<Long, ItemRespDto> itemMap = this.externalApiHelp.getItemMapById(itemIdSet);
        Map<Long, CustomerRespDto> customerMap = this.externalApiHelp.getCustomerMap(customerIdSet);
        for (ItemActivityTagExtDto extDto : resultList) {
            if (shopMap.containsKey(extDto.getShopId())) {
                extDto.setShopCode(shopMap.get(extDto.getShopId()).getCode());
            }
            if (itemMap.containsKey(extDto.getItemId())) {
                extDto.setItemCode(itemMap.get(extDto.getItemId()).getCode());
            }
            if (!customerMap.containsKey(extDto.getCustomerId())) continue;
            extDto.setThirdPartyId(customerMap.get(extDto.getCustomerId()).getThirdPartyId());
        }
        return resultList;
    }
}

