/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.promotion.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.util.SpringBeanUtil;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.ItemActivityTagExtDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.ItemActivityTagExtQueryReqDto;
import com.dtyunxi.yundt.cube.center.promotion.biz.service.IItemActivityTagBizExtService;
import com.dtyunxi.yundt.cube.center.promotion.biz.service.impl.ExternalApiHelp;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.TargetCustomerInfoDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.TargetCustomerType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.tag.service.IItemActivityTagService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ConditionDas;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ItemActivityTagBizExtServiceImpl
implements IItemActivityTagBizExtService {
    private static final Logger log = LoggerFactory.getLogger(ItemActivityTagBizExtServiceImpl.class);
    @Resource
    private IItemActivityTagService itemActivityTagService;
    @Resource
    private ExternalApiHelp externalApiHelp;
    @Resource
    private IActivityService activityService;
    @Resource
    private ConditionDas conditionDas;

    @Override
    public List<ItemActivityTagExtDto> queryList(ItemActivityTagExtQueryReqDto queryReqDto) {
        List<CustomerRespDto> customerRespDtos;
        List<ItemRespDto> itemRespDtos;
        List<ShopDto> shopDtoList;
        if (CollectionUtils.isNotEmpty((Collection)queryReqDto.getShopCodeList()) && CollectionUtils.isNotEmpty(shopDtoList = this.externalApiHelp.getShopByCodes(queryReqDto.getShopCodeList()))) {
            List shopIdList = shopDtoList.stream().map(ShopDto::getId).collect(Collectors.toList());
            queryReqDto.setShopIdList(shopIdList);
        }
        if (CollectionUtils.isNotEmpty((Collection)queryReqDto.getItemCodeList()) && CollectionUtils.isNotEmpty(itemRespDtos = this.externalApiHelp.getItemByCodes(queryReqDto.getItemCodeList()))) {
            List itemIdList = itemRespDtos.stream().map(ItemRespDto::getId).collect(Collectors.toList());
            queryReqDto.setItemIdList(itemIdList);
        }
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getThirdPartyId()) && CollectionUtils.isNotEmpty(customerRespDtos = this.externalApiHelp.getCustomerByThirdPartyIds(Lists.newArrayList((Object[])new String[]{queryReqDto.getThirdPartyId()})))) {
            queryReqDto.setCustomerId(customerRespDtos.get(0).getId());
        }
        List itemActivityTagDtos = this.itemActivityTagService.queryList((ItemActivityTagQueryReqDto)queryReqDto);
        log.info("\u6d3b\u52a8\u6807\u7b7e:{}", (Object)JSONObject.toJSONString((Object)itemActivityTagDtos));
        ArrayList resultList = Lists.newArrayList();
        itemActivityTagDtos = itemActivityTagDtos.stream().filter(r -> Objects.isNull(queryReqDto.getCustomerId()) || Objects.isNull(r.getCustomerId()) || queryReqDto.getCustomerId().equals(r.getCustomerId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(itemActivityTagDtos)) {
            return resultList;
        }
        CubeBeanUtils.copyCollection((Collection)resultList, itemActivityTagDtos, ItemActivityTagExtDto.class);
        Set<Long> shopIdSet = resultList.stream().map(ItemActivityTagDto::getShopId).collect(Collectors.toSet());
        Set<Long> itemIdSet = resultList.stream().map(ItemActivityTagDto::getItemId).collect(Collectors.toSet());
        Set<Long> customerIdSet = resultList.stream().map(ItemActivityTagDto::getCustomerId).collect(Collectors.toSet());
        Set activityIds = resultList.stream().map(ItemActivityTagDto::getActivityId).collect(Collectors.toSet());
        Map<Long, ShopDto> shopMap = this.externalApiHelp.getShopMapById(shopIdSet);
        Map<Long, ItemRespDto> itemMap = this.externalApiHelp.getItemMapById(itemIdSet);
        Map<Long, CustomerRespDto> customerMap = this.externalApiHelp.getCustomerMap(customerIdSet);
        List respDtoList = this.activityService.queryActivityListByIds((List)Lists.newArrayList(activityIds));
        Map<Object, Object> activityDtoMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)respDtoList)) {
            activityDtoMap = respDtoList.stream().collect(Collectors.toMap(ActivityRespDto::getId, Function.identity(), (k1, k2) -> k1));
        }
        ArrayList<ItemActivityTagExtDto> newResult = new ArrayList<ItemActivityTagExtDto>();
        for (ItemActivityTagExtDto extDto : resultList) {
            if (shopMap.containsKey(extDto.getShopId())) {
                extDto.setShopCode(shopMap.get(extDto.getShopId()).getCode());
            }
            if (itemMap.containsKey(extDto.getItemId())) {
                extDto.setItemCode(itemMap.get(extDto.getItemId()).getCode());
            }
            if (customerMap.containsKey(extDto.getCustomerId())) {
                extDto.setThirdPartyId(customerMap.get(extDto.getCustomerId()).getThirdPartyId());
            }
            if (!activityDtoMap.containsKey(extDto.getActivityId())) continue;
            extDto.setActivityTemplateId(((ActivityRespDto)activityDtoMap.get(extDto.getActivityId())).getActivityTemplateId());
            if (!this.matchCustomer((ActivityRespDto)activityDtoMap.get(extDto.getActivityId()), queryReqDto.getCustomerId())) continue;
            newResult.add(extDto);
        }
        return newResult;
    }

    private boolean matchCustomer(ActivityRespDto activityRespDto, Long customerId) {
        if (Objects.isNull(customerId)) {
            return true;
        }
        List conditionEos = ((ExtQueryChainWrapper)this.conditionDas.filter().eq((Object)"activity_id", (Object)activityRespDto.getId())).list();
        return conditionEos.stream().filter(r -> r.getConditionParams().contains("TargetCustomerCondition.type")).findFirst().map(r -> {
            log.info("condition\u5224\u65ad:{}", r);
            JSONObject parseObject = JSONObject.parseObject((String)r.getConditionParams());
            Integer type = parseObject.getInteger("TargetCustomerCondition.type");
            TargetCustomerType populationType = TargetCustomerType.getByType((Integer)type);
            if (null == populationType) {
                populationType = TargetCustomerType.ALL;
            }
            TargetCustomerInfoDto targetCustomerInfoDto = (TargetCustomerInfoDto)parseObject.getObject("TargetCustomerCondition.value", TargetCustomerInfoDto.class);
            switch (populationType) {
                case CATEGORY: {
                    return this.category(customerId, targetCustomerInfoDto);
                }
                case CROWD: {
                    return this.crowd(customerId, targetCustomerInfoDto);
                }
            }
            return true;
        }).orElse(true);
    }

    private boolean category(Long userId, TargetCustomerInfoDto value) {
        if (Objects.isNull(value)) {
            return true;
        }
        CustomerRespDto customerInfo = (CustomerRespDto)((ICustomerQueryApi)SpringBeanUtil.getBean(ICustomerQueryApi.class)).queryById(userId).getData();
        if (Objects.nonNull(customerInfo)) {
            Long customerTypeId = customerInfo.getCustomerTypeId();
            List regionCodeList = customerInfo.getRegionCodeList();
            List customerTypeIds = value.getCustomerTypeIds();
            List customerAreaCodes = value.getCustomerAreaCodes();
            List subAreaCodes = value.getSubAreaCodes();
            List blackCustomerIds = value.getBlackCustomerIds();
            if (CollectionUtils.isEmpty((Collection)subAreaCodes)) {
                subAreaCodes = customerAreaCodes;
            }
            if (!CollectionUtils.isEmpty((Collection)customerTypeIds) && !customerTypeIds.contains(customerTypeId)) {
                return false;
            }
            if (!CollectionUtils.isEmpty((Collection)subAreaCodes)) {
                regionCodeList.retainAll(subAreaCodes);
                if (CollectionUtils.isEmpty((Collection)regionCodeList)) {
                    return false;
                }
            }
            return CollectionUtils.isEmpty((Collection)blackCustomerIds) || !blackCustomerIds.contains(userId);
        }
        return true;
    }

    private boolean crowd(Long userId, TargetCustomerInfoDto value) {
        if (!Objects.isNull(value) && !CollectionUtils.isEmpty((Collection)value.getCustomerIds())) {
            return value.getCustomerIds().contains(userId);
        }
        return true;
    }
}

