/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.promotion.biz.service.impl;

import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.center.openapi.api.ICustomerServiceApi;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemSkuRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemQueryApi;
import com.dtyunxi.yundt.cube.center.item.api.base.query.IItemSkuQueryApi;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryReqDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.yx.tcbj.center.api.query.IItemExtQueryApi;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class ExternalApiHelp {
    @Resource
    private IShopQueryApi shopQueryApi;
    @Resource
    private IItemSkuQueryApi itemSkuQueryApi;
    @Resource
    private IItemExtQueryApi itemExtQueryApi;
    @Resource
    private IItemQueryApi itemQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerServiceApi customerServiceApi;

    public List<ShopDto> getShopByCodes(List<String> shopCodeList) {
        ShopQueryReqDto shopQueryDto = new ShopQueryReqDto();
        shopQueryDto.setCodes(shopCodeList);
        List shopDtoList = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryShopByCode(shopQueryDto));
        return shopDtoList;
    }

    public Map<Long, ShopDto> getShopMapById(Set<Long> shopIdSet) {
        List shopDtoList;
        Map<Long, Object> shopMap = new HashMap<Long, ShopDto>();
        if (CollectionUtils.isNotEmpty(shopIdSet) && CollectionUtils.isNotEmpty((Collection)(shopDtoList = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryByIdsOnPost(shopIdSet))))) {
            shopMap = shopDtoList.stream().collect(Collectors.toMap(ShopDto::getId, Function.identity(), (k1, k2) -> k1));
        }
        return shopMap;
    }

    public List<ItemRespDto> getItemByCodes(List<String> itemCodeList) {
        List itemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemExtQueryApi.queryByCodes(itemCodeList));
        return itemRespDtos;
    }

    public Map<Long, ItemRespDto> getItemMapById(Set<Long> itemIdSet) {
        String itemIds;
        List itemRespDtos;
        Map<Long, Object> itemMap = new HashMap<Long, ItemRespDto>();
        if (CollectionUtils.isNotEmpty(itemIdSet) && CollectionUtils.isNotEmpty((Collection)(itemRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.itemQueryApi.queryNewByItemIds(itemIds = itemIdSet.stream().map(Objects::toString).collect(Collectors.joining(","))))))) {
            itemMap = itemRespDtos.stream().collect(Collectors.toMap(ItemRespDto::getId, Function.identity(), (k1, k2) -> k1));
        }
        return itemMap;
    }

    public List<ItemSkuRespDto> getItemSkuCodes(List<String> skuCodeList) {
        List itemSkuRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.itemSkuQueryApi.queryBySkuCode(skuCodeList));
        return itemSkuRespDtoList;
    }

    public Map<Long, ItemSkuRespDto> getItemSkuMapById(Set<Long> skuIdSet) {
        List itemSkuRespDtoList;
        Map<Long, Object> itemSkuMap = new HashMap<Long, ItemSkuRespDto>();
        if (CollectionUtils.isNotEmpty(skuIdSet) && CollectionUtils.isNotEmpty((Collection)(itemSkuRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.itemSkuQueryApi.queryBySkuId(new ArrayList<Long>(skuIdSet)))))) {
            itemSkuMap = itemSkuRespDtoList.stream().collect(Collectors.toMap(ItemSkuRespDto::getId, Function.identity(), (k1, k2) -> k1));
        }
        return itemSkuMap;
    }

    public List<CustomerRespDto> getCustomerByThirdPartyIds(List<String> thirdPartyIds) {
        List organizationPartnersByIds = (List)RestResponseHelper.extractData((RestResponse)this.customerServiceApi.getOrganizationPartnersByIds(thirdPartyIds));
        if (CollectionUtils.isNotEmpty((Collection)organizationPartnersByIds.stream().map(r -> (String)r.get("ORG_ID")).distinct().collect(Collectors.toList()))) {
            thirdPartyIds = organizationPartnersByIds.stream().map(r -> (String)r.get("ORG_ID")).distinct().collect(Collectors.toList());
        }
        return (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryByThirdPartyIds(thirdPartyIds));
    }

    public Map<Long, CustomerRespDto> getCustomerMap(Set<Long> customerIdSet) {
        List customerRespDtos;
        Map<Long, Object> customerMap = new HashMap<Long, CustomerRespDto>();
        if (CollectionUtils.isNotEmpty(customerIdSet) && CollectionUtils.isNotEmpty((Collection)(customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerListByIds(new ArrayList<Long>(customerIdSet)))))) {
            customerMap = customerRespDtos.stream().collect(Collectors.toMap(BaseRespDto::getId, Function.identity(), (k1, k2) -> k1));
        }
        return customerMap;
    }
}

