/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.promotion.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.icommerce.utils.BeanCopierUtils;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemRespDto;
import com.dtyunxi.yundt.cube.center.promotion.api.constants.EngineActivityTypeTobEnum;
import com.dtyunxi.yundt.cube.center.promotion.api.constants.OverlapSourceEnum;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.BaseActivityTobDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.ActivityBizExtQueryReqDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.ActivityBizItemExtQueryReqDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.ItemActivityTagExtQueryReqDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.exchange.ExchangeActivityDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.exchange.ExchangeRuleContent;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.exchange.GExchange;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.response.ActivityListBizExtRespDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.response.ItemInfoBizExtRespDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.response.ShopExtDto;
import com.dtyunxi.yundt.cube.center.promotion.biz.service.IActivityBizExtService;
import com.dtyunxi.yundt.cube.center.promotion.biz.service.IExchangeBalanceAdvanceService;
import com.dtyunxi.yundt.cube.center.promotion.biz.service.impl.ExternalApiHelp;
import com.dtyunxi.yundt.cube.center.promotion.biz.utils.AssertUtils;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryDto;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IBizOrganizationQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryApi;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.request.SupportSingleItemDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.api.dto.response.NotSupportSingleItemDto;
import com.dtyunxi.yundt.icom.bundle.b2b.center.promotion.biz.activity.base.service.IItemActivityStockService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityExtDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ConditionReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response.PromotionCouponRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityType;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ConditionRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ExchangeBalanceStatementReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.response.ExchangeBalanceAccountRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.response.ExchangeBalanceStatementRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.model.ExcRuleContentDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.model.ExchangeRule;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.activity.base.service.query.IActivityExtQueryService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IActivityPreviewService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.center.activity.base.service.IConditionService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.exchange.account.service.IExchangeBalanceAccountService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.exchange.account.service.IExchangeBalanceStatementService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.fullreduction.enums.UnitEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.utils.BigDecimalUtils;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.activity.base.das.ConditionDas;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.ConditionEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.eo.activity.base.StdConditionEo;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.dao.exchange.account.das.ExchangeBalanceAccountDas;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityBizExtServiceImpl
implements IActivityBizExtService {
    private static final Logger log = LoggerFactory.getLogger(ActivityBizExtServiceImpl.class);
    @Autowired
    private IActivityPreviewService activityPreviewService;
    @Autowired
    private ExternalApiHelp externalApiHelp;
    @Autowired
    private IActivityExtQueryService activityExtQueryService;
    @Resource
    private ExchangeBalanceAccountDas exchangeBalanceAccountDas;
    @Resource
    private IExchangeBalanceAdvanceService exchangeBalanceAdvanceService;
    @Autowired
    private IConditionService conditionService;
    @Resource
    private IExchangeBalanceAccountService exchangeBalanceAccountService;
    @Autowired
    private ConditionDas conditionDas;
    @Autowired
    private IItemActivityStockService itemActivityStockService;
    @Resource
    private IExchangeBalanceStatementService exchangeBalanceStatementService;
    @Resource
    private IOrganizationQueryApi organizationQueryApi;
    @Resource
    private IBizOrganizationQueryApi bizOrganizationQueryApi;

    @Override
    public PromotionCouponRespDto queryActivityByItem(ItemActivityTagExtQueryReqDto itemActivityTagQueryReqDto) {
        List<CustomerRespDto> customerRespDtos;
        List<ItemRespDto> itemRespDtos;
        if (CollectionUtils.isNotEmpty((Collection)itemActivityTagQueryReqDto.getShopCodeList())) {
            ShopQueryDto shopQueryDto = new ShopQueryDto();
            shopQueryDto.setCodes(itemActivityTagQueryReqDto.getShopCodeList());
            List<ShopDto> shopDtoList = this.externalApiHelp.getShopByCodes(itemActivityTagQueryReqDto.getShopCodeList());
            if (CollectionUtils.isNotEmpty(shopDtoList)) {
                List shopIdList = shopDtoList.stream().map(ShopDto::getId).collect(Collectors.toList());
                itemActivityTagQueryReqDto.setShopIdList(shopIdList);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)itemActivityTagQueryReqDto.getItemCodeList()) && CollectionUtils.isNotEmpty(itemRespDtos = this.externalApiHelp.getItemByCodes(itemActivityTagQueryReqDto.getItemCodeList()))) {
            List itemIdList = itemRespDtos.stream().map(ItemRespDto::getId).collect(Collectors.toList());
            itemActivityTagQueryReqDto.setItemIdList(itemIdList);
        }
        if (StringUtils.isNotEmpty((CharSequence)itemActivityTagQueryReqDto.getThirdPartyId()) && CollectionUtils.isNotEmpty(customerRespDtos = this.externalApiHelp.getCustomerByThirdPartyIds(Lists.newArrayList((Object[])new String[]{itemActivityTagQueryReqDto.getThirdPartyId()})))) {
            itemActivityTagQueryReqDto.setCustomerId(customerRespDtos.get(0).getId());
        }
        return this.activityPreviewService.queryActivityByItem((ItemActivityTagQueryReqDto)itemActivityTagQueryReqDto);
    }

    @Override
    public List<ActivityListBizExtRespDto> queryExchangeActivityByCustomer(ActivityBizExtQueryReqDto queryReqDto) {
        return this.getActivityListBizExtRespDtos(queryReqDto, 1, 2000).getList();
    }

    @NotNull
    private PageInfo<ActivityListBizExtRespDto> getActivityListBizExtRespDtos(ActivityBizExtQueryReqDto queryReqDto, Integer pageNum, Integer pageSize) {
        List organizationDtos;
        AssertUtils.notEmpty(queryReqDto.getThirdPartyId(), "\u5ba2\u6237-\u7b2c\u4e09\u65b9id\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getShopCode())) {
            List<ShopDto> shopDtoList = this.externalApiHelp.getShopByCodes(Lists.newArrayList((Object[])new String[]{queryReqDto.getShopCode()}));
            AssertUtils.notEmpty(shopDtoList, "\u5e97\u94fa\u4fe1\u606f\u4e0d\u5b58\u5728");
            queryReqDto.setShopId(shopDtoList.get(0).getId());
        }
        CustomerRespDto customerRespDto = new CustomerRespDto();
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getThirdPartyId())) {
            List<CustomerRespDto> customerRespDtos = this.externalApiHelp.getCustomerByThirdPartyIds(Lists.newArrayList((Object[])new String[]{queryReqDto.getThirdPartyId()}));
            AssertUtils.notEmpty(customerRespDtos, "\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
            customerRespDto = customerRespDtos.get(0);
            log.info("\u83b7\u53d6\u5230\u5ba2\u6237\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)customerRespDto));
        }
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getOrgId()) && CollectionUtils.isNotEmpty((Collection)(organizationDtos = (List)RestResponseHelper.extractData((RestResponse)this.bizOrganizationQueryApi.getOrganizations((List)Lists.newArrayList((Object[])new String[]{queryReqDto.getOrgId()})))))) {
            queryReqDto.setOrganizationId(((OrganizationDto)organizationDtos.get(0)).getId());
        }
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getActivityTypeStr())) {
            EngineActivityTypeTobEnum engineActivityTypeTobEnum = EngineActivityTypeTobEnum.fromName((String)queryReqDto.getActivityTypeStr());
            AssertUtils.notNull(engineActivityTypeTobEnum, "\u6d3b\u52a8\u7c7b\u578b\u53c2\u6570\u4e0d\u6b63\u786e");
            queryReqDto.setActivityType(engineActivityTypeTobEnum.getName());
            queryReqDto.setActivityTemplateId(engineActivityTypeTobEnum.getCode());
        } else {
            ArrayList activityTemplateIds = OverlapSourceEnum.TIME_DISCOUNT.getCode().equals(queryReqDto.getOverlapSource()) ? Lists.newArrayList((Object[])new Long[]{ActivityType.FULL_PRESENT_TOB_ACTIVITY.getId(), ActivityType.OVERALL_REDUCTION_TOB_ACTIVITY.getId(), ActivityType.FULL_DISCOUNT_TOB_ACTIVITY.getId(), ActivityType.EXCHANGE_ACTIVITY.getId(), ActivityType.COUPON_TOB_ACTIVITY.getId()}) : (OverlapSourceEnum.EXCHANGE.getCode().equals(queryReqDto.getOverlapSource()) ? Lists.newArrayList((Object[])new Long[]{ActivityType.FULL_PRESENT_TOB_ACTIVITY.getId(), ActivityType.OVERALL_REDUCTION_TOB_ACTIVITY.getId(), ActivityType.FULL_DISCOUNT_TOB_ACTIVITY.getId(), ActivityType.TIME_DISCOUNT_TOB_ACTIVITY.getId(), ActivityType.COUPON_TOB_ACTIVITY.getId()}) : Lists.newArrayList((Object[])new Long[]{ActivityType.FULL_PRESENT_TOB_ACTIVITY.getId(), ActivityType.OVERALL_REDUCTION_TOB_ACTIVITY.getId(), ActivityType.FULL_DISCOUNT_TOB_ACTIVITY.getId(), ActivityType.TIME_DISCOUNT_TOB_ACTIVITY.getId(), ActivityType.EXCHANGE_ACTIVITY.getId(), ActivityType.COUPON_TOB_ACTIVITY.getId()}));
            queryReqDto.setActivityTemplateIds((List)activityTemplateIds);
        }
        if (CollectionUtils.isEmpty((Collection)queryReqDto.getActivityStatus())) {
            queryReqDto.setActivityStatus((List)Lists.newArrayList((Object[])new String[]{ActivityStatusEnum.ACTIVATE.getKey()}));
        } else {
            queryReqDto.setActivityStatus(queryReqDto.getActivityStatus());
        }
        log.info("\u67e5\u8be2\u6d3b\u52a8\u5165\u53c2={}", JSON.toJSON((Object)queryReqDto));
        PageInfo activityListRespDtoPageInfot = this.activityExtQueryService.queryActivityPage((ActivityExtDto)queryReqDto, pageNum, Integer.valueOf(1000));
        if (CollectionUtils.isEmpty((Collection)activityListRespDtoPageInfot.getList())) {
            return new PageInfo();
        }
        ArrayList<Long> acIds = new ArrayList<Long>();
        for (ActivityRespDto activityRespDto : activityListRespDtoPageInfot.getList()) {
            Boolean validateTargetCustomer = this.activityPreviewService.validateTargetCustomer(activityRespDto.getId(), customerRespDto.getId(), customerRespDto);
            log.info("\u6d3b\u52a8\u8fc7\u6ee4\u7ed3\u679c:{},{}", (Object)JSONObject.toJSONString((Object)activityRespDto), (Object)validateTargetCustomer);
            if (!validateTargetCustomer.booleanValue()) continue;
            acIds.add(activityRespDto.getId());
        }
        queryReqDto.setActivityIds(acIds);
        if (CollectionUtils.isEmpty(acIds)) {
            return new PageInfo();
        }
        PageInfo activityListRespDtoPageInfo = this.activityExtQueryService.queryActivityPage((ActivityExtDto)queryReqDto, pageNum, pageSize);
        log.info("\u67e5\u8be2\u6d3b\u52a8\u7ed3\u679c={}", JSON.toJSON((Object)activityListRespDtoPageInfo));
        List activityRespDtos = activityListRespDtoPageInfo.getList();
        if (CollectionUtils.isEmpty((Collection)activityRespDtos)) {
            return new PageInfo();
        }
        List<Long> activityIds = activityRespDtos.stream().map(ActivityRespDto::getId).distinct().collect(Collectors.toList());
        List<ConditionRespDto> conditionRespDtoList = this.queryConditions(activityIds, 1196944771412880296L);
        Map<Long, List<ConditionRespDto>> activityMap = conditionRespDtoList.stream().collect(Collectors.groupingBy(ConditionRespDto::getActivityId));
        ArrayList respDtoList = Lists.newArrayList();
        for (ActivityRespDto activityRespDto : activityRespDtos) {
            Boolean validateTargetCustomer = this.activityPreviewService.validateTargetCustomer(activityRespDto.getId(), customerRespDto.getId(), customerRespDto);
            if (!validateTargetCustomer.booleanValue()) continue;
            ActivityListBizExtRespDto activityListBizExtRespDto = new ActivityListBizExtRespDto();
            CubeBeanUtils.copyProperties((Object)activityListBizExtRespDto, (Object)activityRespDto, (String[])new String[0]);
            Long activityTemplateId = activityRespDto.getActivityTemplateId();
            if (Objects.equals(activityTemplateId, EngineActivityTypeTobEnum.EXCHANGE_ACTIVITY.getCode())) {
                List<ConditionRespDto> conditionList;
                ExchangeBalanceAccountRespDto exchangeBalanceAccountRespDto = this.exchangeBalanceAccountService.queryByActivityIdAndCustomerId(activityRespDto.getId(), customerRespDto.getId());
                if (Objects.nonNull(exchangeBalanceAccountRespDto)) {
                    activityListBizExtRespDto.setExchangeRemaining(exchangeBalanceAccountRespDto.getAvailableBalance());
                    activityListBizExtRespDto.setExchangeTotal(exchangeBalanceAccountRespDto.getTotalBalance());
                    activityListBizExtRespDto.setAdvanceTotal(exchangeBalanceAccountRespDto.getAdvanceTotalBalance());
                    activityListBizExtRespDto.setAdvanceRemaining(exchangeBalanceAccountRespDto.getAdvanceSurplusBalance());
                    activityListBizExtRespDto.setTotalAvailableBalance(exchangeBalanceAccountRespDto.getTotalAvailableBalance());
                    activityListBizExtRespDto.setAdvanceReturn(exchangeBalanceAccountRespDto.isAdvanceReturn());
                    activityListBizExtRespDto.setDiscountUnit(exchangeBalanceAccountRespDto.getDiscountUnit());
                    activityListBizExtRespDto.setAdvanceFreezeBalance(exchangeBalanceAccountRespDto.getAdvanceFreezeBalance());
                    activityListBizExtRespDto.setUseFreezeBalance(exchangeBalanceAccountRespDto.getUseFreezeBalance());
                    activityListBizExtRespDto.setAdvanceReturnedBalance(exchangeBalanceAccountRespDto.getAdvanceReturnedBalance());
                    activityListBizExtRespDto.setAddUseFreezeBalance(exchangeBalanceAccountRespDto.getAddUseFreezeBalance());
                    activityListBizExtRespDto.setUseLimit(BigDecimalUtils.subtract((BigDecimal)exchangeBalanceAccountRespDto.getTotalBalance(), (BigDecimal)exchangeBalanceAccountRespDto.getAvailableBalance()));
                    activityListBizExtRespDto.setUseAdvanceLimit(BigDecimalUtils.subtract((BigDecimal)exchangeBalanceAccountRespDto.getAdvanceTotalBalance(), (BigDecimal)exchangeBalanceAccountRespDto.getAdvanceSurplusBalance()));
                    List conditionEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.conditionDas.filter().eq((Object)"condition_template_id", (Object)1196944771412880296L)).eq((Object)"activity_id", (Object)exchangeBalanceAccountRespDto.getActivityId())).list();
                    Map<Long, ExchangeRule> conditionParamMap = conditionEos.stream().collect(Collectors.toMap(StdConditionEo::getActivityId, this::converter, (e1, e2) -> e1));
                    ExchangeRule exchangeRule = conditionParamMap.get(exchangeBalanceAccountRespDto.getActivityId());
                    if (exchangeRule != null && CollectionUtils.isNotEmpty((Collection)exchangeRule.getExcRuleContents())) {
                        ExcRuleContentDto excRuleContentDto = (ExcRuleContentDto)exchangeRule.getExcRuleContents().get(0);
                        activityListBizExtRespDto.setDiscountUnit(excRuleContentDto.getDiscountUnit());
                        if (UnitEnum.MONEY.getType().equals(excRuleContentDto.getDiscountUnit())) {
                            activityListBizExtRespDto.setDiscountUnitName("\u91d1\u989d");
                        } else {
                            activityListBizExtRespDto.setDiscountUnitName("\u6570\u91cf");
                        }
                    }
                }
                if (CollectionUtils.isNotEmpty(conditionList = activityMap.get(activityRespDto.getId()))) {
                    ExchangeActivityDto exchangeActivityDto = new ExchangeActivityDto();
                    this.parse(conditionList.get(0), exchangeActivityDto);
                    activityListBizExtRespDto.setExchangeActivityDtos(exchangeActivityDto);
                    if (CollectionUtils.isNotEmpty((Collection)exchangeActivityDto.getPromotionContents())) {
                        ExchangeRuleContent exchangeRuleContent = (ExchangeRuleContent)exchangeActivityDto.getPromotionContents().get(0);
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u6d3b\u52a8\u5546\u54c1\u603b");
                        stringBuffer.append(exchangeRuleContent.getUnit() == 1 ? "\u91d1\u989d" : "\u6570\u91cf");
                        stringBuffer.append("\u6ee1");
                        stringBuffer.append(exchangeRuleContent.getThreshold());
                        stringBuffer.append(exchangeRuleContent.getUnit() == 1 ? "\u5143" : "\u4ef6");
                        if (Objects.nonNull(exchangeRuleContent.getIsOrderScale()) && Objects.nonNull(exchangeRuleContent.getOrderScale())) {
                            stringBuffer.append("\u4e14\u8ba2\u5355\u91d1\u989d\u6ee1");
                            stringBuffer.append(exchangeRuleContent.getOrderScale());
                            stringBuffer.append("\u5143");
                        }
                        stringBuffer.append("\uff0c\u9001");
                        stringBuffer.append(exchangeRuleContent.getDiscount());
                        stringBuffer.append(exchangeRuleContent.getDiscountScale() == 2 ? "%" : "");
                        stringBuffer.append(exchangeRuleContent.getDiscountUnit() == 1 ? "\u5143" : "\u4ef6");
                        stringBuffer.append("\u6362\u8d2d\u989d\u5ea6;");
                        activityListBizExtRespDto.setPromotioncontents(stringBuffer.toString());
                    }
                }
            }
            respDtoList.add(activityListBizExtRespDto);
        }
        PageInfo pageInfo = (PageInfo)BeanUtil.copyProperties((Object)activityListRespDtoPageInfo, PageInfo.class, (String[])new String[0]);
        pageInfo.setList((List)respDtoList);
        return pageInfo;
    }

    private ExchangeRule converter(ConditionEo conditionEo) {
        JSONObject jsonObject = JSON.parseObject((String)conditionEo.getConditionParams());
        return (ExchangeRule)JSON.parseObject((String)jsonObject.getString("ExchangeCondition.rule"), ExchangeRule.class);
    }

    @Override
    public <T extends BaseActivityTobDto> void parse(ConditionRespDto conditionRespDto, T t) {
        ExchangeActivityDto exchangeActivityDto = (ExchangeActivityDto)t;
        JSONObject jsonObject = JSON.parseObject((String)conditionRespDto.getConditionParams());
        ExchangeRule exchangeRule = (ExchangeRule)JSON.parseObject((String)jsonObject.getString("ExchangeCondition.rule"), ExchangeRule.class);
        exchangeActivityDto.setPromotionMethod(exchangeRule.getPromotionMethod());
        exchangeActivityDto.setPromotionCondition(exchangeRule.getPromotionCondition());
        exchangeActivityDto.setThresholdType(exchangeRule.getThresholdType());
        exchangeActivityDto.setPromotionType(exchangeRule.getPromotionType());
        ArrayList exchangeRuleContents = new ArrayList();
        exchangeRule.getExcRuleContents().stream().forEach(contents -> {
            ExchangeRuleContent exchangeRuleContent = new ExchangeRuleContent();
            CubeBeanUtils.copyProperties((Object)exchangeRuleContent, (Object)contents, (String[])new String[0]);
            List exchangeItems = BeanCopierUtils.copyList((List)contents.getExchangeItems(), GExchange.class);
            exchangeRuleContent.setExchangeItems(exchangeItems);
            exchangeRuleContents.add(exchangeRuleContent);
        });
        exchangeActivityDto.setPromotionContents(exchangeRuleContents);
    }

    @Override
    public ShopExtDto queryShopByCode(String code) {
        AssertUtils.notEmpty(code, "\u5e97\u94fa\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List<ShopDto> shopDtoList = this.externalApiHelp.getShopByCodes(Lists.newArrayList((Object[])new String[]{code}));
        if (CollectionUtils.isEmpty(shopDtoList)) {
            return null;
        }
        ShopExtDto shopExtDto = new ShopExtDto();
        CubeBeanUtils.copyProperties((Object)shopExtDto, (Object)shopDtoList.get(0), (String[])new String[0]);
        return shopExtDto;
    }

    @Override
    public CustomerRespDto queryCustomerByCode(String code) {
        AssertUtils.notEmpty(code, "\u5ba2\u6237\u7b2c\u4e09\u65b9id\u4e0d\u80fd\u4e3a\u7a7a");
        List<CustomerRespDto> customerByThirdPartyIds = this.externalApiHelp.getCustomerByThirdPartyIds(Lists.newArrayList((Object[])new String[]{code}));
        if (CollectionUtils.isEmpty(customerByThirdPartyIds)) {
            return null;
        }
        CustomerRespDto shopExtDto = new CustomerRespDto();
        CubeBeanUtils.copyProperties((Object)shopExtDto, (Object)customerByThirdPartyIds.get(0), (String[])new String[0]);
        return shopExtDto;
    }

    @Override
    public List<ConditionRespDto> queryConditions(List<Long> acIds, long conditionTemplateId) {
        return acIds.parallelStream().flatMap(id -> {
            ConditionReqDto queryDto = new ConditionReqDto();
            queryDto.setActivityId(id);
            if (conditionTemplateId > 0L) {
                queryDto.setConditionTemplateId(Long.valueOf(conditionTemplateId));
            }
            return this.conditionService.queryConditionList(queryDto).stream();
        }).collect(Collectors.toList());
    }

    @Override
    public List<ItemInfoBizExtRespDto> querySkuSingleBuy(ActivityBizItemExtQueryReqDto queryReqDto) {
        List<CustomerRespDto> customerRespDtos;
        AssertUtils.notEmpty(queryReqDto.getItemCodeList(), "\u5546\u54c1\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List<ItemRespDto> itemByCodes = this.externalApiHelp.getItemByCodes(queryReqDto.getItemCodeList());
        AssertUtils.notEmpty(itemByCodes, "\u5546\u54c1SKU\u4fe1\u606f\u672a\u540c\u6b65\u5230\u7cfb\u7edf");
        CustomerRespDto customerRespDto = null;
        if (StringUtils.isNotEmpty((CharSequence)queryReqDto.getThirdPartyId()) && CollectionUtils.isNotEmpty(customerRespDtos = this.externalApiHelp.getCustomerByThirdPartyIds(Lists.newArrayList((Object[])new String[]{queryReqDto.getThirdPartyId()})))) {
            customerRespDto = customerRespDtos.get(0);
        }
        Map<Long, Integer> skuSingleBuyMap = this.getSkuSingleBuyMap(customerRespDto);
        ArrayList respDtoList = Lists.newArrayList();
        for (ItemRespDto itemRespDto : itemByCodes) {
            ItemInfoBizExtRespDto itemInfoBizExtRespDto = new ItemInfoBizExtRespDto();
            itemInfoBizExtRespDto.setItemCode(itemRespDto.getCode());
            itemInfoBizExtRespDto.setItemName(itemRespDto.getName());
            itemInfoBizExtRespDto.setSupportSingleBuy(Integer.valueOf(0));
            if (skuSingleBuyMap.containsKey(itemRespDto.getId())) {
                itemInfoBizExtRespDto.setSupportSingleBuy(skuSingleBuyMap.get(itemRespDto.getId()));
            }
            respDtoList.add(itemInfoBizExtRespDto);
        }
        return respDtoList;
    }

    @Override
    public PageInfo<ActivityListBizExtRespDto> queryExchangeActivityPage(ActivityBizExtQueryReqDto queryReqDto, Integer pageNum, Integer pageSize) {
        return this.getActivityListBizExtRespDtos(queryReqDto, pageNum, pageSize);
    }

    @Override
    public PageInfo<ExchangeBalanceStatementRespDto> queryExchangeBalanceStatementPage(ExchangeBalanceStatementReqDto exchangeBalanceStatementReqDto) {
        PageInfo exchangeBalanceStatementRespDtoPageInfo;
        CustomerRespDto customerRespDto = new CustomerRespDto();
        if (StringUtils.isNotEmpty((CharSequence)exchangeBalanceStatementReqDto.getThirdPartyId())) {
            List<CustomerRespDto> customerRespDtos = this.externalApiHelp.getCustomerByThirdPartyIds(Lists.newArrayList((Object[])new String[]{exchangeBalanceStatementReqDto.getThirdPartyId()}));
            AssertUtils.notEmpty(customerRespDtos, "\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
            customerRespDto = customerRespDtos.get(0);
            exchangeBalanceStatementReqDto.setCustomerId(customerRespDto.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(exchangeBalanceStatementRespDtoPageInfo = this.exchangeBalanceStatementService.queryByPage(exchangeBalanceStatementReqDto)).getList())) {
            for (ExchangeBalanceStatementRespDto exchangeBalanceStatementRespDto : exchangeBalanceStatementRespDtoPageInfo.getList()) {
                exchangeBalanceStatementRespDto.setBalanceType((String)StringUtils.defaultIfEmpty((CharSequence)exchangeBalanceStatementRespDto.getBalanceType(), (CharSequence)"exchange"));
            }
        }
        return exchangeBalanceStatementRespDtoPageInfo;
    }

    private Map<Long, Integer> getSkuSingleBuyMap(CustomerRespDto customerRespDto) {
        HashMap<Long, Integer> skuSingleBuyMap = new HashMap<Long, Integer>();
        SupportSingleItemDto supportSingleItemDto = new SupportSingleItemDto();
        supportSingleItemDto.setActivityStatus((List)Lists.newArrayList((Object[])new String[]{ActivityStatusEnum.NEW.getKey(), ActivityStatusEnum.READY.getKey(), ActivityStatusEnum.ACTIVATE.getKey()}));
        supportSingleItemDto.setCustomerRespDtos((List)Lists.newArrayList((Object[])new CustomerRespDto[]{customerRespDto}));
        supportSingleItemDto.setPageSize(Integer.valueOf(10000));
        PageInfo pageInfo = this.itemActivityStockService.queryCustomerSingleItemPage(supportSingleItemDto);
        if (CollectionUtils.isEmpty((Collection)pageInfo.getList())) {
            return skuSingleBuyMap;
        }
        for (NotSupportSingleItemDto itemDto : pageInfo.getList()) {
            if (skuSingleBuyMap.containsKey(itemDto.getItemId()) || !Objects.equals(itemDto.getSupportSingleBuy(), 1)) continue;
            skuSingleBuyMap.put(itemDto.getItemId(), itemDto.getSupportSingleBuy());
        }
        return skuSingleBuyMap;
    }
}

