/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.promotion.biz.apiimpl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerQueryApi;
import com.dtyunxi.yundt.cube.center.promotion.api.IExchangeBalanceAccountExtApi;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.ExchangeAccountUseExtReq;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.ExchangeBalanceRollBackExtReqDto;
import com.dtyunxi.yundt.cube.center.promotion.api.dto.ext.request.InitExchangeAccountExtReqDto;
import com.dtyunxi.yundt.cube.center.promotion.biz.service.impl.ExternalApiHelp;
import com.dtyunxi.yundt.cube.center.promotion.biz.utils.AssertUtils;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.enums.ExchangeBalanceTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ExchangeAccountUseReq;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ExchangeBalanceAccountReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ExchangeBalanceRollBackReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.ExchangeBalanceTurnoverReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.request.InitExchangeAccountReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.dto.response.ExchangeBalanceAccountRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.exchange.account.enums.TurnoverChangeTypeEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.exchange.account.service.IExchangeBalanceAccountService;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.biz.exchange.account.service.IExchangeBalanceTurnoverService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExchangeBalanceAccountExtApiImpl
implements IExchangeBalanceAccountExtApi {
    private static final Logger logger = LoggerFactory.getLogger(ExchangeBalanceAccountExtApiImpl.class);
    @Resource
    private IExchangeBalanceAccountService exchangeBalanceAccountService;
    @Resource
    private ExternalApiHelp externalApiHelp;
    @Resource
    private ILockService lockService;
    @Autowired
    private IExchangeBalanceTurnoverService exchangeBalanceTurnoverService;
    @Autowired
    private ICustomerQueryApi customerQueryApi;

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Long> initExchangeAccount(InitExchangeAccountExtReqDto extReqDto) {
        logger.info("initExchangeAccount==>{}", JSON.toJSON((Object)extReqDto));
        String thirdPartyId = extReqDto.getThirdPartyId();
        CustomerRespDto customerRespDto = null;
        if (Objects.isNull(extReqDto.getCustomerId())) {
            AssertUtils.notEmpty(thirdPartyId, "\u7b2c\u4e09\u65b9\u5ba2\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            List<CustomerRespDto> customerRespDtos = this.externalApiHelp.getCustomerByThirdPartyIds(Lists.newArrayList((Object[])new String[]{thirdPartyId}));
            AssertUtils.notEmpty(customerRespDtos, "\u5ba2\u6237\u4fe1\u606f\u672a\u540c\u6b65");
            customerRespDto = customerRespDtos.get(0);
        } else {
            customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryById(extReqDto.getCustomerId()));
            if (customerRespDto == null) {
                throw new BizException("\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u521d\u59cb\u5316\u6362\u8d2d\u989d\u5ea6\u7d2f\u8ba1\u8d26\u6237\u5931\u8d25");
            }
        }
        InitExchangeAccountReqDto initExchangeAccountReqDto = new InitExchangeAccountReqDto();
        initExchangeAccountReqDto.setCustomerId(customerRespDto.getId());
        initExchangeAccountReqDto.setActivityId(extReqDto.getActivityId());
        return this.initExchangeAccount(initExchangeAccountReqDto, customerRespDto);
    }

    private RestResponse<Long> initExchangeAccount(InitExchangeAccountReqDto initExchangeAccountReqDto, CustomerRespDto customerRespDto) {
        Long accountId = null;
        Long activityId = initExchangeAccountReqDto.getActivityId();
        Long customerId = initExchangeAccountReqDto.getCustomerId();
        String lockKey = activityId + "_" + customerId;
        Mutex lock = this.lockService.lock("mk_exchange_balance_account", lockKey, 1500, 1500, TimeUnit.MILLISECONDS);
        try {
            ExchangeBalanceAccountRespDto exchangeBalanceAccountRespDto = this.exchangeBalanceAccountService.queryByActivityIdAndCustomerId(activityId, customerId);
            if (exchangeBalanceAccountRespDto != null) {
                logger.info("\u6362\u8d2d\u989d\u5ea6\u7d2f\u8ba1\u8d26\u6237\u5df2\u521d\u59cb\u5316");
                RestResponse restResponse = new RestResponse((Object)exchangeBalanceAccountRespDto.getId());
                return restResponse;
            }
            ExchangeBalanceAccountReqDto accountReqDto = new ExchangeBalanceAccountReqDto();
            accountReqDto.setActivityId(activityId);
            accountReqDto.setCustomerId(customerId);
            accountReqDto.setCustomerCode(customerRespDto.getCode());
            accountReqDto.setCustomerName(customerRespDto.getName());
            accountReqDto.setOrganizationId(customerRespDto.getMerchantId());
            accountReqDto.setAvailableBalance(BigDecimal.ZERO);
            accountReqDto.setUsedBalance(BigDecimal.ZERO);
            accountReqDto.setOrganizationId(customerRespDto.getMerchantId());
            accountId = this.exchangeBalanceAccountService.addExchangeBalanceAccount(accountReqDto);
            ExchangeBalanceTurnoverReqDto initAccountTurnoverReqDto = new ExchangeBalanceTurnoverReqDto();
            initAccountTurnoverReqDto.setBalanceAccountId(accountId);
            initAccountTurnoverReqDto.setActivityId(activityId);
            initAccountTurnoverReqDto.setCustomerId(customerId);
            initAccountTurnoverReqDto.setCustomerCode(customerRespDto.getCode());
            initAccountTurnoverReqDto.setCustomerName(customerRespDto.getName());
            initAccountTurnoverReqDto.setOrderNo("");
            initAccountTurnoverReqDto.setChangeType(TurnoverChangeTypeEnum.INIT.getType());
            initAccountTurnoverReqDto.setBalanceType(ExchangeBalanceTypeEnum.EXCHANGE.getKey());
            this.exchangeBalanceTurnoverService.addExchangeBalanceTurnover(initAccountTurnoverReqDto);
        }
        catch (Exception var14) {
            logger.error("\u521d\u59cb\u5316\u6362\u8d2d\u989d\u5ea6\u7d2f\u8ba1\u8d26\u6237\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)var14));
            var14.printStackTrace();
            throw new BizException("\u521d\u59cb\u5316\u6362\u8d2d\u989d\u5ea6\u7d2f\u8ba1\u8d26\u6237\u5931\u8d25,\u539f\u56e0 " + var14.getMessage());
        }
        finally {
            this.lockService.unlock(lock);
        }
        return new RestResponse((Object)accountId);
    }

    public RestResponse<Void> useExchangeBalanceAccount(ExchangeAccountUseExtReq extReq) {
        logger.info("\u4f7f\u7528\u6362\u8d2d\u989d\u5ea6={}", (Object)JSON.toJSONString((Object)extReq));
        AssertUtils.notEmpty(extReq.getOrderNo(), "\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        String thirdPartyId = extReq.getThirdPartyId();
        CustomerRespDto customerRespDto = null;
        if (Objects.isNull(extReq.getCustomerId())) {
            AssertUtils.notEmpty(thirdPartyId, "\u7b2c\u4e09\u65b9\u5ba2\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            List<CustomerRespDto> customerRespDtos = this.externalApiHelp.getCustomerByThirdPartyIds(Lists.newArrayList((Object[])new String[]{thirdPartyId}));
            AssertUtils.notEmpty(customerRespDtos, "\u5ba2\u6237\u4fe1\u606f\u672a\u540c\u6b65");
            customerRespDto = customerRespDtos.get(0);
        } else {
            customerRespDto = (CustomerRespDto)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryById(extReq.getCustomerId()));
            if (customerRespDto == null) {
                throw new BizException("\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u521d\u59cb\u5316\u6362\u8d2d\u989d\u5ea6\u7d2f\u8ba1\u8d26\u6237\u5931\u8d25");
            }
        }
        InitExchangeAccountReqDto initExchangeAccountReqDto = new InitExchangeAccountReqDto();
        initExchangeAccountReqDto.setCustomerId(customerRespDto.getId());
        initExchangeAccountReqDto.setActivityId(extReq.getActivityId());
        Long id = (Long)RestResponseHelper.extractData(this.initExchangeAccount(initExchangeAccountReqDto, customerRespDto));
        ExchangeAccountUseReq exchangeAccountUseReq = new ExchangeAccountUseReq();
        exchangeAccountUseReq.setCustomerId(initExchangeAccountReqDto.getCustomerId());
        CubeBeanUtils.copyProperties((Object)exchangeAccountUseReq, (Object)extReq, (String[])new String[0]);
        exchangeAccountUseReq.setTurnoverChangeTypeEnum(this.getEnumByType(extReq.getTurnoverChangeTypeStr()));
        exchangeAccountUseReq.setBigBRequestFlag(extReq.getBigBRequestFlag());
        this.exchangeBalanceAccountService.useExchangeBalanceAccount(exchangeAccountUseReq);
        return RestResponse.VOID;
    }

    private TurnoverChangeTypeEnum getEnumByType(String type) {
        for (TurnoverChangeTypeEnum value : TurnoverChangeTypeEnum.values()) {
            if (!value.getType().equals(type)) continue;
            return value;
        }
        return null;
    }

    public RestResponse<Void> rollbackExchangeAccount(ExchangeBalanceRollBackExtReqDto extReqDto) {
        logger.info("\u56de\u6eda\u6362\u8d2d\u989d\u5ea6={}", (Object)JSON.toJSONString((Object)extReqDto));
        ExchangeBalanceRollBackReqDto rollBackReqDto = new ExchangeBalanceRollBackReqDto();
        rollBackReqDto.setTurnoverChangeTypeEnum(this.getEnumByType(extReqDto.getTurnoverChangeTypeStr()));
        rollBackReqDto.setOrderNo(extReqDto.getOrderNo());
        rollBackReqDto.setBigBRequestFlag(extReqDto.getBigBRequestFlag());
        this.exchangeBalanceAccountService.rollbackExchangeAccount(rollBackReqDto);
        return RestResponse.VOID;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> updExchangeBalanceAccount(ExchangeAccountUseExtReq extReq) {
        logger.info("\u66f4\u65b0\u6362\u8d2d\u989d\u5ea6={}", (Object)JSON.toJSONString((Object)extReq));
        AssertUtils.notEmpty(extReq.getOrderNo(), "\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        String thirdPartyId = extReq.getThirdPartyId();
        if (Objects.isNull(extReq.getCustomerId())) {
            AssertUtils.notEmpty(thirdPartyId, "\u7b2c\u4e09\u65b9\u5ba2\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            List<CustomerRespDto> customerRespDtos = this.externalApiHelp.getCustomerByThirdPartyIds(Lists.newArrayList((Object[])new String[]{thirdPartyId}));
            AssertUtils.notEmpty(customerRespDtos, "\u5ba2\u6237\u4fe1\u606f\u672a\u540c\u6b65");
            extReq.setCustomerId(customerRespDtos.get(0).getId());
        }
        ExchangeBalanceRollBackReqDto rollBackReqDto = new ExchangeBalanceRollBackReqDto();
        rollBackReqDto.setOrderNo(extReq.getOrderNo());
        rollBackReqDto.setTurnoverChangeTypeEnum(TurnoverChangeTypeEnum.CANCEL_ORDER);
        rollBackReqDto.setBigBRequestFlag(extReq.getBigBRequestFlag());
        this.exchangeBalanceAccountService.rollbackExchangeAccount(rollBackReqDto);
        ExchangeAccountUseReq exchangeAccountUseReq = new ExchangeAccountUseReq();
        CubeBeanUtils.copyProperties((Object)exchangeAccountUseReq, (Object)extReq, (String[])new String[0]);
        exchangeAccountUseReq.setTurnoverChangeTypeEnum(TurnoverChangeTypeEnum.UPDATE_ORDER);
        exchangeAccountUseReq.setBigBRequestFlag(extReq.getBigBRequestFlag());
        this.exchangeBalanceAccountService.useExchangeBalanceAccount(exchangeAccountUseReq);
        return RestResponse.VOID;
    }
}

