/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.rebate.biz.schedule;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.SingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.rebate.api.dto.response.ReturnsQuotaConfigGeneralRespDto;
import com.yx.tcbj.center.rebate.biz.service.IReturnsQuotaAccountService;
import com.yx.tcbj.center.rebate.biz.service.IReturnsQuotaConfigGeneralService;
import com.yx.tcbj.center.rebate.dao.das.ReturnsQuotaAccountDas;
import com.yx.tcbj.center.rebate.dao.das.ReturnsQuotaConfigGeneralDas;
import com.yx.tcbj.center.rebate.dao.das.ReturnsQuotaDas;
import com.yx.tcbj.center.rebate.dao.eo.ReturnsQuotaAccountEo;
import com.yx.tcbj.center.rebate.dao.eo.ReturnsQuotaEo;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="returnsQuotaYearSettlementEvent")
@Scope(value="prototype")
public class ReturnsQuotaYearSettlementEvent
extends SingleTupleScheduleEvent {
    private Logger logger = LoggerFactory.getLogger(ReturnsQuotaYearSettlementEvent.class);
    @Resource
    private ReturnsQuotaConfigGeneralDas returnsQuotaConfigGeneralDas;
    @Resource
    private ReturnsQuotaAccountDas returnsQuotaAccountDas;
    @Resource
    private ReturnsQuotaDas returnsQuotaDas;
    @Resource
    private IReturnsQuotaConfigGeneralService returnsQuotaConfigGeneralService;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IReturnsQuotaAccountService returnsQuotaAccountService;

    public void before(TaskMsg taskMsg) {
    }

    public boolean execute(TaskMsg taskMsg) {
        this.logger.info("\u89e6\u53d1\u9000\u8d27\u989d\u5ea6\u5e74\u5ea6\u7ed3\u7b97 params : {} .", (Object)JSON.toJSONString((Object)taskMsg));
        Map map = (Map)JSON.parseObject((String)taskMsg.getContent(), Map.class);
        this.task(null == map.get("orgId") ? null : map.get("orgId").toString(), null == map.get("customerId") ? null : Long.valueOf(map.get("customerId").toString()), null == map.get("nowDate") ? null : DateUtil.parseDate((String)map.get("nowDate").toString(), (String)"yyyy-MM-dd"));
        return true;
    }

    public void after(TaskMsg taskMsg) {
    }

    public void task(String orgId, Long customerId, Date nowDate) {
        List<ReturnsQuotaConfigGeneralRespDto> returnsQuotaConfigGeneralList = this.returnsQuotaConfigGeneralService.queryList(orgId);
        if (CollectionUtil.isEmpty(returnsQuotaConfigGeneralList)) {
            this.logger.info("\u65e0\u901a\u7528\u914d\u7f6e");
            return;
        }
        if (ObjectUtil.isNotEmpty((Object)customerId)) {
            this.logger.info("\u624b\u52a8\u7ed3\u8f6c\uff1a{}", (Object)customerId);
            this.taskExecute(returnsQuotaConfigGeneralList.get(0), Lists.newArrayList((Object[])new Long[]{customerId}), nowDate);
            return;
        }
        returnsQuotaConfigGeneralList.forEach(config -> {
            this.logger.info("\u5904\u7406\u914d\u7f6e\uff1a{}", (Object)JSON.toJSONString((Object)config));
            List customerIds = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.querySubCustomerIdListByOrgIds((List)Lists.newArrayList((Object[])new Long[]{config.getOrgId()})));
            if (CollectionUtil.isEmpty((Collection)customerIds)) {
                this.logger.info("\u65e0\u5ba2\u6237\u4fe1\u606f");
                return;
            }
            this.taskExecute((ReturnsQuotaConfigGeneralRespDto)config, customerIds, nowDate);
        });
    }

    private void taskExecute(ReturnsQuotaConfigGeneralRespDto configGeneral, List<Long> customerIds, Date nowDate) {
        List<ReturnsQuotaAccountEo> accountEoList;
        if (ObjectUtil.isEmpty((Object)nowDate)) {
            nowDate = new Date();
            try {
                SimpleDateFormat sf = new SimpleDateFormat("MM-dd");
                Calendar c = Calendar.getInstance();
                c.setTime(sf.parse(configGeneral.getYearDate()));
                c.add(5, 1);
                String carryDate = sf.format(c.getTime());
                String sysDate = sf.format(new Date());
                if (!carryDate.equals(sysDate)) {
                    this.logger.info("\u9000\u8d27\u989d\u5ea6\u7ed3\u7b97\u7ed3\u675f\uff0c\u672a\u5230\u7ed3\u7b97\u65e5\u671f\uff0c\u7ed3\u8f6c\u65e5\u671f\u4e3a\uff1a{}", (Object)configGeneral.getYearDate());
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (CollectionUtil.isEmpty(accountEoList = this.returnsQuotaAccountService.queryByCustomerIds(customerIds))) {
            this.logger.info("\u9000\u8d27\u989d\u5ea6\u7ed3\u7b97\u7ed3\u675f\uff0c\u6ca1\u6709\u9000\u8d27\u989d\u5ea6\u8d26\u6237\u4fe1\u606f");
            return;
        }
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.eq((String)"status", (Object)1));
        sqlFilters.add(SqlFilter.in((String)"customer_id", customerIds));
        ReturnsQuotaEo returnsQuotaEo = new ReturnsQuotaEo();
        returnsQuotaEo.setSqlFilters(sqlFilters);
        List returnsQuotaEoList = this.returnsQuotaDas.select((BaseEo)returnsQuotaEo);
        if (CollectionUtil.isEmpty((Collection)returnsQuotaEoList)) {
            this.logger.info("\u65e0\u5e74\u5ea6\u8bb0\u5f55");
            return;
        }
        Map returnsQuotaEoMap = returnsQuotaEoList.stream().collect(Collectors.toMap(ReturnsQuotaEo::getReturnsQuotaAccountId, Function.identity(), (k1, k2) -> k1));
        Map<String, Date> nextDate = this.getDate(nowDate);
        for (ReturnsQuotaAccountEo accountEo : accountEoList) {
            ReturnsQuotaEo returnsQuota = new ReturnsQuotaEo();
            ReturnsQuotaEo returnsQuotaE = (ReturnsQuotaEo)returnsQuotaEoMap.get(accountEo.getId());
            if (!ObjectUtil.isNotEmpty((Object)returnsQuotaE)) {
                this.logger.info("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5e74\u5ea6\u8bb0\u5f55\uff1a{}", (Object)JSON.toJSONString((Object)accountEo));
                continue;
            }
            returnsQuota = returnsQuotaE;
            if (returnsQuota.getId() == null) continue;
            if (this.checkYearEqually(returnsQuota.getStartDate(), nowDate)) {
                this.logger.info("\u5f00\u59cb\u65f6\u95f4\u4e0e\u5f53\u524d\u5e74\u5ea6\u65f6\u95f4\u76f8\u540c\uff0c\u4e0d\u53ef\u91cd\u590d\u7ed3\u8f6c\uff1a{}", (Object)JSON.toJSONString((Object)returnsQuota));
                continue;
            }
            returnsQuota.setYearEndQuota(accountEo.getAdvanceQuota().add(accountEo.getGeneralReturnsQuota()));
            returnsQuota.setYearEndAdvanceQuota(accountEo.getAdvanceQuota());
            returnsQuota.setYearEndUsableAdvanceQuota(accountEo.getAdvanceUnbackQuota());
            returnsQuota.setStatus(Integer.valueOf(0));
            returnsQuota.setCarryDownDate(nowDate);
            ReturnsQuotaEo nextReturnsQuota = new ReturnsQuotaEo();
            BigDecimal defaultValue = new BigDecimal("0.00");
            nextReturnsQuota.setReturnsQuotaAccountId(accountEo.getId());
            nextReturnsQuota.setCustomerId(accountEo.getCustomerId());
            nextReturnsQuota.setStatus(Integer.valueOf(1));
            nextReturnsQuota.setYearInitialQuota(accountEo.getGeneralReturnsQuota().add(accountEo.getAdvanceQuota()));
            nextReturnsQuota.setYearInitialAdvanceQuota(accountEo.getAdvanceQuota());
            nextReturnsQuota.setYearInitialUsableAdvanceQuota(accountEo.getAdvanceUnbackQuota());
            nextReturnsQuota.setStartDate(nextDate.get("startDate"));
            nextReturnsQuota.setEndDate(nextDate.get("endDate"));
            nextReturnsQuota.setOrderAmount(defaultValue);
            nextReturnsQuota.setCumsumGeneralQuota(defaultValue);
            nextReturnsQuota.setCumsumUsableQuota(nextReturnsQuota.getYearInitialQuota());
            nextReturnsQuota.setCumsumUsedQuota(defaultValue);
            nextReturnsQuota.setCumsumAdvanceQuota(defaultValue);
            this.returnsQuotaDas.update((BaseEo)returnsQuota);
            this.returnsQuotaDas.insert((BaseEo)nextReturnsQuota);
        }
    }

    private Map<String, Date> getDate(Date nowDate) {
        HashMap<String, Date> map = new HashMap<String, Date>();
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(nowDate);
            ((Calendar)calendar).add(5, 1);
            String startDateStr = format.format(calendar.getTime());
            calendar.setTime(nowDate);
            ((Calendar)calendar).add(1, 1);
            String endDateStr = format.format(calendar.getTime());
            map.put("startDate", format2.parse(startDateStr + " 00:00:00"));
            map.put("endDate", format2.parse(endDateStr + " 23:59:59"));
        }
        catch (Exception e) {
            this.logger.error("\u9000\u8d27\u989d\u5ea6\u7ed3\u7b97\u7ed3\u675f\uff0c\u83b7\u53d6\u4e0b\u4e00\u5e74\u5ea6\u5f00\u59cb\u4e0e\u7ed3\u675f\u65f6\u95f4\u5931\u8d25\uff1a{}", (Object)nowDate);
        }
        return map;
    }

    private boolean checkYearEqually(Date date, Date nowDate) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
        return simpleDateFormat.format(date).equals(simpleDateFormat.format(nowDate));
    }
}

