/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.rebate.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.UserInfoUtil;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.dto.constant.enums.YesOrNoEnum;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.IPayApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.PayMethodReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.PayRecordRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.trade.ext.api.constants.OrderBizStatusTobEnum;
import com.dtyunxi.yundt.cube.center.trade.ext.api.enums.OrderQueryEnum;
import com.dtyunxi.yundt.cube.center.trade.ext.api.query.IOrderBizQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.UserDto;
import com.dtyunxi.yundt.cube.center.user.api.query.IUserQueryApi;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import com.yx.tcbj.center.rebate.api.dto.request.BatchAuditBalanceBillReqDto;
import com.yx.tcbj.center.rebate.api.dto.request.OfflineBalanceAccountReqDto;
import com.yx.tcbj.center.rebate.api.dto.request.OfflineBalanceBillImportReqDto;
import com.yx.tcbj.center.rebate.api.dto.request.OfflineBalanceBillQueryReqDto;
import com.yx.tcbj.center.rebate.api.dto.request.OfflineBalanceBillReqDto;
import com.yx.tcbj.center.rebate.api.dto.response.AuditBalanceBillRespDto;
import com.yx.tcbj.center.rebate.api.dto.response.OfflineBalanceBillExportDto;
import com.yx.tcbj.center.rebate.api.dto.response.OfflineBalanceBillImportDto;
import com.yx.tcbj.center.rebate.api.dto.response.OfflineBalanceBillImportResultDto;
import com.yx.tcbj.center.rebate.api.dto.response.OfflineBalanceBillRespDto;
import com.yx.tcbj.center.rebate.api.dto.response.OfflineBalanceFlowRespDto;
import com.yx.tcbj.center.rebate.api.enums.OfflineBalanceAccountEnum;
import com.yx.tcbj.center.rebate.api.enums.OfflineBalanceBillAuditStatusEnum;
import com.yx.tcbj.center.rebate.api.enums.OfflineBalanceBillSourceEnum;
import com.yx.tcbj.center.rebate.api.enums.OfflineBalanceBillTypeEnum;
import com.yx.tcbj.center.rebate.api.enums.OfflineBalanceBusinessEnum;
import com.yx.tcbj.center.rebate.api.enums.OfflineBalanceFlowEnum;
import com.yx.tcbj.center.rebate.biz.service.IOfflineBalanceAccountService;
import com.yx.tcbj.center.rebate.biz.service.IOfflineBalanceBillService;
import com.yx.tcbj.center.rebate.biz.utils.BeanPropertyNullUtil;
import com.yx.tcbj.center.rebate.biz.utils.EasyPoiExportUtil;
import com.yx.tcbj.center.rebate.dao.das.OfflineBalanceAccountDas;
import com.yx.tcbj.center.rebate.dao.das.OfflineBalanceBillDas;
import com.yx.tcbj.center.rebate.dao.eo.OfflineBalanceAccountEo;
import com.yx.tcbj.center.rebate.dao.eo.OfflineBalanceBillEo;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OfflineBalanceBillServiceImpl
implements IOfflineBalanceBillService {
    public final Logger logger = LoggerFactory.getLogger(OfflineBalanceBillServiceImpl.class);
    @Resource
    private OfflineBalanceBillDas offlineBalanceBillDas;
    @Resource
    private OfflineBalanceAccountDas offlineBalanceAccountDas;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IOfflineBalanceAccountService offlineBalanceAccountService;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private IOrderBizQueryApi orderBizQueryApi;
    @Resource
    private IPayApi payApi;
    @Resource
    private IUserQueryApi userQueryApi;
    @Resource
    private HttpServletRequest request;
    public static List<String> orderTradeWaitStatus = Lists.newArrayList((Object[])new String[]{OrderBizStatusTobEnum.WAIT_PAY.getCode()});

    public String headerOrgId() {
        String organizationId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        this.logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        return organizationId;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addOfflineBalanceBill(OfflineBalanceBillReqDto addReqDto) {
        this.logger.info("\u65b0\u589e\u6536\u9000\u6b3e\u5355\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)addReqDto));
        AssertUtil.notNull((Object)addReqDto, (String)"\u65b0\u589e\u6536\u9000\u6b3e\u5355\u53c2\u6570\u4e3a\u7a7a");
        AssertUtil.assertNotBlank((String)addReqDto.getBillType(), (String)"\u5fc5\u4f20\u53c2\u6570[billType]\u4e3a\u7a7a");
        AssertUtil.notNull((Object)addReqDto.getBillDate(), (String)"\u5fc5\u4f20\u53c2\u6570[billDate]\u4e3a\u7a7a");
        AssertUtil.assertNotBlank((String)addReqDto.getBusinessContent(), (String)"\u5fc5\u4f20\u53c2\u6570[businessContent]\u4e3a\u7a7a");
        AssertUtil.notNull((Object)addReqDto.getCustomerId(), (String)"\u5fc5\u4f20\u53c2\u6570[customerId]\u4e3a\u7a7a");
        AssertUtil.notNull((Object)addReqDto.getAmount(), (String)"\u5fc5\u4f20\u53c2\u6570[amount]\u4e3a\u7a7a");
        AssertUtil.assertNotBlank((String)addReqDto.getBillSource(), (String)"\u5fc5\u4f20\u53c2\u6570[billSource]\u4e3a\u7a7a");
        AssertUtil.isTrue((addReqDto.getAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)addReqDto.getCustomerCode()) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)addReqDto.getCustomerName())) {
            ArrayList customerIds = Lists.newArrayList((Object[])new Long[]{addReqDto.getCustomerId()});
            this.logger.info("\u6839\u636e\u5ba2\u6237id\u67e5\u8be2\u5ba2\u6237\u4fe1\u606fcustomerIds=={}", (Object)JSON.toJSONString((Object)customerIds));
            List customerRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerListByIds((List)customerIds));
            this.logger.info("\u6839\u636e\u5ba2\u6237id\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)customerRespDtoList));
            if (CollectionUtils.isEmpty((Collection)customerRespDtoList)) {
                throw new BizException("\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            addReqDto.setCustomerCode(((CustomerRespDto)customerRespDtoList.get(0)).getCode());
            addReqDto.setCustomerName(((CustomerRespDto)customerRespDtoList.get(0)).getName());
            addReqDto.setMerchantId(((CustomerRespDto)customerRespDtoList.get(0)).getMerchantId());
        }
        if (Objects.equals(OfflineBalanceBillSourceEnum.MANUAL_INPUT.getCode(), addReqDto.getBillSource()) && OfflineBalanceBillTypeEnum.RECEIPT.getCode().equals(addReqDto.getBillType())) {
            this.checkRelationOrder(addReqDto.getRelationNo(), addReqDto.getAmount(), addReqDto.getCustomerId());
        }
        OfflineBalanceAccountEo accountQueryEo = new OfflineBalanceAccountEo();
        accountQueryEo.setCustomerId(addReqDto.getCustomerId());
        OfflineBalanceAccountEo accountEo = (OfflineBalanceAccountEo)this.offlineBalanceAccountDas.selectOne((BaseEo)accountQueryEo);
        if (Objects.isNull(accountEo)) {
            this.logger.info("\u5ba2\u6237\u4f59\u989d\u8d26\u6237\u4e0d\u5b58\u5728\u521b\u5efa\u8d26\u6237");
            accountEo = new OfflineBalanceAccountEo();
            accountEo.setCustomerCode(addReqDto.getCustomerCode());
            accountEo.setCustomerName(addReqDto.getCustomerName());
            accountEo.setCreateTime(new Date());
            accountEo.setAccountStatus("ENABLED");
            accountEo.setCustomerId(addReqDto.getCustomerId());
            accountEo.setMerchantId(addReqDto.getMerchantId());
            accountEo.setAccountCode("YEZH" + addReqDto.getCustomerCode());
            accountEo.setAgentUse(OfflineBalanceAccountEnum.ENABLED.getValue());
            accountEo.setAgentView(OfflineBalanceAccountEnum.ENABLED.getValue());
            accountEo.setAccountBalance(BigDecimal.ZERO);
            this.offlineBalanceAccountDas.insert((BaseEo)accountEo);
        }
        AssertUtil.isTrue((boolean)Objects.equals(accountEo.getAccountStatus(), "ENABLED"), (String)"\u5ba2\u6237\u4f59\u989d\u8d26\u6237\u672a\u542f\u7528");
        addReqDto.setOfflineBalanceAccountId(accountEo.getId());
        addReqDto.setAuditStatus(OfflineBalanceBillAuditStatusEnum.WAIT_AUDIT.getCode());
        if (Objects.equals(OfflineBalanceBillSourceEnum.ONLINE_PAYMENT.getCode(), addReqDto.getBillSource())) {
            addReqDto.setAuditStatus(OfflineBalanceBillAuditStatusEnum.AUDIT_PASS.getCode());
            addReqDto.setAuditTime(new Date());
        }
        String billCode = this.generateBillCode(this.cacheService, addReqDto.getBillType(), "BILL_CODE");
        addReqDto.setBillCode(billCode);
        OfflineBalanceBillEo offlineBalanceBillEo = new OfflineBalanceBillEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)offlineBalanceBillEo);
        this.logger.info("\u65b0\u589e\u6536\u9000\u6b3e\u5355Eo={}", (Object)JSON.toJSONString((Object)offlineBalanceBillEo));
        this.offlineBalanceBillDas.insert((BaseEo)offlineBalanceBillEo);
        try {
            if (Objects.equals(OfflineBalanceBillSourceEnum.ALTERNATE_REFUND.getCode(), addReqDto.getBillSource())) {
                this.logger.info("\u6765\u6e90\u4e3a\u9694\u5929\u9000\u6b3e\uff0c\u9ed8\u8ba4\u81ea\u52a8\u5ba1\u6838\u901a\u8fc7\uff1a{}", (Object)JSON.toJSONString((Object)offlineBalanceBillEo));
                OfflineBalanceBillReqDto reqDto = new OfflineBalanceBillReqDto();
                reqDto.setId(offlineBalanceBillEo.getId());
                reqDto.setAuditStatus(OfflineBalanceBillAuditStatusEnum.AUDIT_PASS.getCode());
                reqDto.setAuditTime(new Date());
                reqDto.setCustomerId(offlineBalanceBillEo.getCustomerId());
                reqDto.setAmount(offlineBalanceBillEo.getAmount());
                reqDto.setBillType(offlineBalanceBillEo.getBillType());
                this.auditBill(reqDto);
            }
        }
        catch (Exception e) {
            this.logger.error("\u6765\u6e90\u4e3a\u9694\u5929\u9000\u6b3e\uff0c\u9ed8\u8ba4\u81ea\u52a8\u5ba1\u6838\u901a\u8fc7\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return offlineBalanceBillEo.getId();
    }

    private String generateBillCode(ICacheService cacheService, String billType, String key) {
        String prefix = "";
        if (OfflineBalanceBillTypeEnum.RECEIPT.getCode().equals(billType)) {
            prefix = "SK";
        } else if (OfflineBalanceBillTypeEnum.REFUND.getCode().equals(billType)) {
            prefix = "TK";
        }
        return prefix + Long.parseLong(new SimpleDateFormat("yyyyMMddHHmmss").format(new Date())) + String.format("%04d", cacheService.incr(key) % 9999L);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyOfflineBalanceBill(OfflineBalanceBillReqDto modifyReqDto) {
        OfflineBalanceBillEo offlineBalanceBillEo = new OfflineBalanceBillEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)offlineBalanceBillEo);
        this.offlineBalanceBillDas.updateSelective((BaseEo)offlineBalanceBillEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeOfflineBalanceBill(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.offlineBalanceBillDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public OfflineBalanceBillRespDto queryById(Long id) {
        OfflineBalanceBillEo offlineBalanceBillEo = (OfflineBalanceBillEo)this.offlineBalanceBillDas.selectByPrimaryKey(id);
        OfflineBalanceBillRespDto offlineBalanceBillRespDto = new OfflineBalanceBillRespDto();
        DtoHelper.eo2Dto((BaseEo)offlineBalanceBillEo, (BaseVo)offlineBalanceBillRespDto);
        Map<Long, CustomerRespDto> customerInfoMap = this.getCustomerInfoMap(Lists.newArrayList((Object[])new Long[]{offlineBalanceBillRespDto.getCustomerId()}));
        if (!customerInfoMap.isEmpty() && customerInfoMap.containsKey(offlineBalanceBillRespDto.getCustomerId())) {
            CustomerRespDto customerRespDto = customerInfoMap.get(offlineBalanceBillRespDto.getCustomerId());
            offlineBalanceBillRespDto.setCustomerName(customerRespDto.getCustomerName());
        }
        return offlineBalanceBillRespDto;
    }

    @Override
    public PageInfo<OfflineBalanceBillRespDto> queryByPage(OfflineBalanceBillQueryReqDto queryReqDto) {
        OfflineBalanceBillEo offlineBalanceBillEo = new OfflineBalanceBillEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        DtoHelper.dto2Eo((BaseVo)queryReqDto, (BaseEo)offlineBalanceBillEo, (String[])new String[]{"customerCode", "customerName", "billCode", "relationNo"});
        if (Objects.isNull(offlineBalanceBillEo.getMerchantId())) {
            String orgIdStr = this.headerOrgId();
            this.logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)orgIdStr);
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)orgIdStr)) {
                offlineBalanceBillEo.setMerchantId(Long.valueOf(orgIdStr));
            }
        }
        if (StringUtils.isNotEmpty((String)queryReqDto.getCustomerCode())) {
            sqlFilters.add(SqlFilter.like((String)"customer_code", (Object)("%" + queryReqDto.getCustomerCode() + "%")));
        }
        if (StringUtils.isNotEmpty((String)queryReqDto.getCustomerName())) {
            sqlFilters.add(SqlFilter.like((String)"customer_name", (Object)("%" + queryReqDto.getCustomerName() + "%")));
        }
        if (StringUtils.isNotEmpty((String)queryReqDto.getBillCode())) {
            sqlFilters.add(SqlFilter.like((String)"bill_code", (Object)("%" + queryReqDto.getBillCode() + "%")));
        }
        if (StringUtils.isNotEmpty((String)queryReqDto.getRelationNo())) {
            sqlFilters.add(SqlFilter.like((String)"relation_no", (Object)("%" + queryReqDto.getRelationNo() + "%")));
        }
        offlineBalanceBillEo.setSqlFilters(sqlFilters);
        offlineBalanceBillEo.setOrderByDesc("update_time");
        PageInfo eoPageInfo = this.offlineBalanceBillDas.selectPage((BaseEo)offlineBalanceBillEo, queryReqDto.getPageNum(), queryReqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (CollectionUtils.isEmpty((Collection)eoPageInfo.getList())) {
            return dtoPageInfo;
        }
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, OfflineBalanceBillRespDto.class);
        List<Long> customerIdList = dtoList.stream().map(OfflineBalanceBillRespDto::getCustomerId).distinct().collect(Collectors.toList());
        Map<Long, CustomerRespDto> customerInfoMap = this.getCustomerInfoMap(customerIdList);
        for (OfflineBalanceBillRespDto dto : dtoList) {
            if (customerInfoMap.isEmpty() || !customerInfoMap.containsKey(dto.getCustomerId())) continue;
            CustomerRespDto customerRespDto = customerInfoMap.get(dto.getCustomerId());
            dto.setCustomerName(customerRespDto.getName());
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    private Map<Long, CustomerRespDto> getCustomerInfoMap(List<Long> customerIdList) {
        if (CollectionUtils.isEmpty(customerIdList)) {
            return new HashMap<Long, CustomerRespDto>();
        }
        Map<Long, Object> customerInfoMap = new HashMap<Long, CustomerRespDto>(customerIdList.size() * 4 / 3 + 2);
        this.logger.info("\u6839\u636e\u5ba2\u6237id\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5f00\u59cb\u65f6\u95f4\uff1a" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        RestResponse customerRest = this.customerQueryApi.queryCustomerListByIds(customerIdList);
        this.logger.info("\u6839\u636e\u5ba2\u6237id\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u7ed3\u675f\u65f6\u95f4\uff1a" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        if (null != customerRest && null != customerRest.getData()) {
            List customerRespDtoList = (List)customerRest.getData();
            customerInfoMap = customerRespDtoList.stream().collect(Collectors.toMap(BaseRespDto::getId, Function.identity(), (k1, k2) -> k1));
        }
        return customerInfoMap;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void auditBill(OfflineBalanceBillReqDto auditDto) {
        this.logger.info("\u5ba1\u6838\u6536\u9000\u6b3e\u5355\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditDto));
        AssertUtil.notNull((Object)auditDto, (String)"\u5ba1\u6838\u6536\u9000\u6b3e\u5355\u53c2\u6570\u4e3a\u7a7a");
        AssertUtil.notNull((Object)auditDto.getId(), (String)"\u5fc5\u4f20\u53c2\u6570[id]\u4e3a\u7a7a");
        AssertUtil.notNull((Object)auditDto.getAuditStatus(), (String)"\u5fc5\u4f20\u53c2\u6570[auditStatus]\u4e3a\u7a7a");
        OfflineBalanceBillEo offlineBalanceBillEo = (OfflineBalanceBillEo)this.offlineBalanceBillDas.selectByPrimaryKey(auditDto.getId());
        AssertUtil.notNull((Object)offlineBalanceBillEo, (String)"\u6536\u9000\u6b3e\u5355\u4e0d\u5b58\u5728");
        AssertUtil.isTrue((boolean)Objects.equals(OfflineBalanceBillAuditStatusEnum.WAIT_AUDIT.getCode(), offlineBalanceBillEo.getAuditStatus()), (String)"\u5355\u636e\u4e0d\u662f\u5f85\u5ba1\u6838\u72b6\u6001");
        Long auditUserId = auditDto.getAuditUserId();
        if (Objects.isNull(auditUserId)) {
            auditUserId = UserInfoUtil.getUserInfo();
        }
        auditDto.setAuditUserId(auditUserId);
        RestResponse userDtoRestResponse = this.userQueryApi.queryById(auditUserId, null);
        if (null != userDtoRestResponse && null != userDtoRestResponse.getData()) {
            auditDto.setAuditUserName(((UserDto)userDtoRestResponse.getData()).getUserName());
        }
        if (Objects.equals(OfflineBalanceBillAuditStatusEnum.AUDIT_PASS.getCode(), auditDto.getAuditStatus())) {
            if (Objects.equals(OfflineBalanceBillSourceEnum.MANUAL_INPUT.getCode(), offlineBalanceBillEo.getBillSource()) || Objects.equals(OfflineBalanceBillSourceEnum.ALTERNATE_REFUND.getCode(), offlineBalanceBillEo.getBillSource())) {
                OfflineBalanceAccountReqDto balanceAccountReqDto = new OfflineBalanceAccountReqDto();
                balanceAccountReqDto.setBalanceChange(auditDto.getAmount());
                balanceAccountReqDto.setCustomerId(auditDto.getCustomerId());
                balanceAccountReqDto.setRelationNo(offlineBalanceBillEo.getBillCode());
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)offlineBalanceBillEo.getRelationNo())) {
                    balanceAccountReqDto.setRelationNo(offlineBalanceBillEo.getRelationNo());
                }
                if (auditDto.getBillType().equals(OfflineBalanceBillTypeEnum.REFUND.getCode())) {
                    balanceAccountReqDto.setFlowTradeType(OfflineBalanceFlowEnum.REFUND.getValue());
                    balanceAccountReqDto.setChangeStatus("EXPEND");
                } else {
                    balanceAccountReqDto.setFlowTradeType(OfflineBalanceFlowEnum.TRANSFER.getValue());
                    balanceAccountReqDto.setChangeStatus("INCOME");
                }
                this.logger.info("\u5ba1\u6838\u6536\u9000\u6b3e\u5355\u8c03\u7528\u66f4\u4f59\u989d\u8d26\u6237\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)balanceAccountReqDto));
                OfflineBalanceFlowRespDto offlineBalanceFlowRespDto = this.offlineBalanceAccountService.offlineBalanceAccountChange(balanceAccountReqDto);
                this.logger.info("\u5ba1\u6838\u6536\u9000\u6b3e\u5355\u8c03\u7528\u66f4\u4f59\u989d\u8d26\u6237\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)offlineBalanceFlowRespDto));
                auditDto.setOfflineBalanceFlowId(offlineBalanceFlowRespDto.getId());
            }
            if (Objects.equals(OfflineBalanceBillSourceEnum.MANUAL_INPUT.getCode(), offlineBalanceBillEo.getBillSource()) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)offlineBalanceBillEo.getRelationNo()) && auditDto.getBillType().equals(OfflineBalanceBillTypeEnum.RECEIPT.getCode())) {
                this.checkRelationOrder(offlineBalanceBillEo.getRelationNo(), offlineBalanceBillEo.getAmount(), offlineBalanceBillEo.getCustomerId());
                PayMethodReqDto payMethodReqDto = new PayMethodReqDto();
                payMethodReqDto.setOrderNo(offlineBalanceBillEo.getRelationNo());
                HashMap<String, Comparable<BigDecimal>> extfieldsMap = new HashMap<String, Comparable<BigDecimal>>();
                extfieldsMap.put("payAmount", offlineBalanceBillEo.getAmount());
                extfieldsMap.put("payTime", new Date());
                extfieldsMap.put("confirmTime", new Date());
                payMethodReqDto.setExtFields(extfieldsMap);
                this.logger.info("\u751f\u6210\u8ba2\u5355\u4ed8\u6b3e\u8bb0\u5f55\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)payMethodReqDto));
                RestResponse restResponse = this.payApi.addOfflinePayRecord(payMethodReqDto);
                this.logger.info("\u751f\u6210\u8ba2\u5355\u4ed8\u6b3e\u8bb0\u5f55\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)restResponse));
                if (null == restResponse || null == restResponse.getData()) {
                    throw new BizException("\u751f\u6210\u8ba2\u5355\u4ed8\u6b3e\u8bb0\u5f55\u5f02\u5e38");
                }
                offlineBalanceBillEo.setReceiptRecordsNo((String)restResponse.getData());
            }
        } else if (Objects.equals(OfflineBalanceBillAuditStatusEnum.AUDIT_REJECT.getCode(), auditDto.getAuditStatus())) {
            // empty if block
        }
        auditDto.setAuditTime(new Date());
        DtoHelper.dto2Eo((BaseVo)auditDto, (BaseEo)offlineBalanceBillEo);
        this.logger.info("\u5ba1\u6838\u6536\u9000\u6b3e\u5355Eo={}", (Object)JSON.toJSONString((Object)offlineBalanceBillEo));
        this.offlineBalanceBillDas.update((BaseEo)offlineBalanceBillEo);
    }

    @Override
    public List<AuditBalanceBillRespDto> auditBillBatch(BatchAuditBalanceBillReqDto auditDto) {
        this.logger.info("\u6279\u91cf\u5ba1\u6838\u6536\u9000\u6b3e\u5355\uff1a{}", (Object)JSON.toJSONString((Object)auditDto));
        AssertUtil.notNull((Object)auditDto, (String)"\u6279\u91cf\u5ba1\u6838\u6536\u9000\u6b3e\u5355\u53c2\u6570\u4e3a\u7a7a");
        AssertUtil.assertNotEmpty((Collection)auditDto.getIdList(), (String)"\u5fc5\u4f20\u53c2\u6570[idList]\u4e3a\u7a7a");
        AssertUtil.notNull((Object)auditDto.getAuditStatus(), (String)"\u5fc5\u4f20\u53c2\u6570[auditStatus]\u4e3a\u7a7a");
        Long auditUserId = auditDto.getAuditUserId();
        if (Objects.isNull(auditUserId)) {
            auditUserId = UserInfoUtil.getUserInfo();
        }
        auditDto.setAuditUserId(auditUserId);
        RestResponse userDtoRestResponse = this.userQueryApi.queryById(auditUserId, null);
        if (null != userDtoRestResponse && null != userDtoRestResponse.getData()) {
            auditDto.setAuditUserName(((UserDto)userDtoRestResponse.getData()).getUserName());
        }
        List offlineBalanceBillEos = this.offlineBalanceBillDas.selectByIds(auditDto.getIdList());
        offlineBalanceBillEos.stream().sorted(Comparator.comparing(BaseEo::getCreateTime));
        ArrayList resultList = Lists.newArrayList();
        ArrayList updateEoList = Lists.newArrayList();
        for (OfflineBalanceBillEo eo2 : offlineBalanceBillEos) {
            if (!Objects.equals(OfflineBalanceBillAuditStatusEnum.WAIT_AUDIT.getCode(), eo2.getAuditStatus())) {
                AuditBalanceBillRespDto resultDto = new AuditBalanceBillRespDto(eo2.getBillCode(), "\u5904\u7406\u5931\u8d25", "\u5355\u636e\u4e0d\u662f\u5f85\u5ba1\u6838\u72b6\u6001");
                resultList.add(resultDto);
                continue;
            }
            eo2.setAuditTime(new Date());
            eo2.setAuditOpinion(auditDto.getAuditOpinion());
            eo2.setAuditUserId(auditDto.getAuditUserId());
            eo2.setAuditUserName(auditDto.getAuditUserName());
            eo2.setAuditStatus(auditDto.getAuditStatus());
            if (!Objects.equals(OfflineBalanceBillAuditStatusEnum.AUDIT_REJECT.getCode(), auditDto.getAuditStatus()) && Objects.equals(OfflineBalanceBillAuditStatusEnum.AUDIT_PASS.getCode(), auditDto.getAuditStatus())) {
                if (Objects.equals(OfflineBalanceBillSourceEnum.MANUAL_INPUT.getCode(), eo2.getBillSource())) {
                    AuditBalanceBillRespDto resultDto;
                    OfflineBalanceAccountReqDto balanceAccountReqDto = new OfflineBalanceAccountReqDto();
                    balanceAccountReqDto.setBalanceChange(eo2.getAmount());
                    balanceAccountReqDto.setCustomerId(eo2.getCustomerId());
                    balanceAccountReqDto.setRelationNo(eo2.getBillCode());
                    if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)eo2.getRelationNo()) && eo2.getBillType().equals(OfflineBalanceBillTypeEnum.RECEIPT.getCode())) {
                        balanceAccountReqDto.setRelationNo(eo2.getRelationNo());
                        try {
                            this.checkRelationOrder(eo2.getRelationNo(), eo2.getAmount(), eo2.getCustomerId());
                        }
                        catch (Exception e) {
                            this.logger.info("\u6279\u91cf\u5ba1\u6838\u6536\u9000\u6b3e\u5355\u6821\u9a8c\u5355\u53f7\u5f02\u5e38:{}", (Object)e.getMessage());
                            resultDto = new AuditBalanceBillRespDto(eo2.getBillCode(), "\u5904\u7406\u5931\u8d25", e.getMessage());
                            resultList.add(resultDto);
                            continue;
                        }
                    }
                    if (eo2.getBillType().equals(OfflineBalanceBillTypeEnum.REFUND.getCode())) {
                        balanceAccountReqDto.setFlowTradeType(OfflineBalanceFlowEnum.REFUND.getValue());
                        balanceAccountReqDto.setChangeStatus("EXPEND");
                    } else {
                        balanceAccountReqDto.setFlowTradeType(OfflineBalanceFlowEnum.TRANSFER.getValue());
                        balanceAccountReqDto.setChangeStatus("INCOME");
                    }
                    try {
                        this.logger.info("\u6279\u91cf\u5ba1\u6838\u6536\u9000\u6b3e\u5355\u8c03\u7528\u66f4\u4f59\u989d\u8d26\u6237\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)balanceAccountReqDto));
                        OfflineBalanceFlowRespDto offlineBalanceFlowRespDto = this.offlineBalanceAccountService.offlineBalanceAccountChange(balanceAccountReqDto);
                        this.logger.info("\u6279\u91cf\u5ba1\u6838\u6536\u9000\u6b3e\u5355\u8c03\u7528\u66f4\u4f59\u989d\u8d26\u6237\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)offlineBalanceFlowRespDto));
                        eo2.setOfflineBalanceFlowId(offlineBalanceFlowRespDto.getId());
                    }
                    catch (Exception e) {
                        this.logger.info("\u6279\u91cf\u5ba1\u6838\u6536\u9000\u6b3e\u5355\u8c03\u7528\u66f4\u4f59\u989d\u8d26\u6237\u5f02\u5e38:{}", (Object)e.getMessage());
                        resultDto = new AuditBalanceBillRespDto(eo2.getBillCode(), "\u5904\u7406\u5931\u8d25", e.getMessage());
                        resultList.add(resultDto);
                        continue;
                    }
                }
                if (Objects.equals(OfflineBalanceBillSourceEnum.MANUAL_INPUT.getCode(), eo2.getBillSource()) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)eo2.getRelationNo()) && eo2.getBillType().equals(OfflineBalanceBillTypeEnum.RECEIPT.getCode())) {
                    PayMethodReqDto payMethodReqDto = new PayMethodReqDto();
                    payMethodReqDto.setOrderNo(eo2.getRelationNo());
                    HashMap<String, Comparable<BigDecimal>> extfieldsMap = new HashMap<String, Comparable<BigDecimal>>();
                    extfieldsMap.put("payAmount", eo2.getAmount());
                    extfieldsMap.put("payTime", new Date());
                    extfieldsMap.put("confirmTime", new Date());
                    payMethodReqDto.setExtFields(extfieldsMap);
                    this.logger.info("\u751f\u6210\u8ba2\u5355\u4ed8\u6b3e\u8bb0\u5f55\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)payMethodReqDto));
                    RestResponse restResponse = this.payApi.addOfflinePayRecord(payMethodReqDto);
                    this.logger.info("\u751f\u6210\u8ba2\u5355\u4ed8\u6b3e\u8bb0\u5f55\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)restResponse));
                    if (null == restResponse || null == restResponse.getData()) {
                        this.logger.info("\u6279\u91cf\u5ba1\u6838\u6536\u9000\u6b3e\u5355\u8c03\u7528\u751f\u6210\u8ba2\u5355\u4ed8\u6b3e\u8bb0\u5f55\u5f02\u5e38");
                        AuditBalanceBillRespDto resultDto = new AuditBalanceBillRespDto(eo2.getBillCode(), "\u5904\u7406\u5931\u8d25", "\u8c03\u7528\u751f\u6210\u8ba2\u5355\u4ed8\u6b3e\u8bb0\u5f55\u5f02\u5e38");
                        resultList.add(resultDto);
                    } else {
                        eo2.setReceiptRecordsNo((String)restResponse.getData());
                    }
                }
            }
            updateEoList.add(eo2);
        }
        this.logger.info("\u6279\u91cf\u5ba1\u6838\u6536\u9000\u6b3e\u5355\u66f4\u65b0eo={}", (Object)JSON.toJSONString((Object)updateEoList));
        if (CollectionUtils.isNotEmpty((Collection)updateEoList)) {
            updateEoList.forEach(eo -> this.offlineBalanceBillDas.update((BaseEo)eo));
        }
        this.logger.info("\u6279\u91cf\u5ba1\u6838\u6536\u9000\u6b3e\u5355\u8fd4\u56de\u5904\u7406\u5931\u8d25\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)resultList));
        return resultList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void closeBillByPayNo(String receiptRecordsNo) {
        this.logger.info("\u5173\u95ed\u6536\u9000\u6b3e\u5355\u5165\u53c2:{}", (Object)receiptRecordsNo);
        AssertUtil.assertNotBlank((String)receiptRecordsNo, (String)"\u652f\u4ed8\u6d41\u6c34\u5355\u53f7\u4e3a\u7a7a");
        OfflineBalanceBillEo selectEo = OfflineBalanceBillEo.newInstance();
        selectEo.setReceiptRecordsNo(receiptRecordsNo);
        OfflineBalanceBillEo billEo = (OfflineBalanceBillEo)this.offlineBalanceBillDas.selectOne((BaseEo)selectEo);
        if (Objects.isNull(billEo)) {
            throw new BizException("\u652f\u4ed8\u6d41\u6c34\u53f7[" + receiptRecordsNo + "]\u672a\u67e5\u8be2\u5230\u6536\u6b3e\u5355");
        }
        if (!Objects.equals(billEo.getAuditStatus(), OfflineBalanceBillAuditStatusEnum.WAIT_AUDIT.getCode())) {
            throw new BizException("\u6536\u6b3e\u5355[" + billEo.getBillCode() + "]\u72b6\u6001\u672a\u5ba1\u6838\uff0c\u4e0d\u53ef\u5173\u95ed");
        }
        billEo.setAuditStatus(OfflineBalanceBillAuditStatusEnum.CLOSE.getCode());
        this.offlineBalanceBillDas.update((BaseEo)billEo);
    }

    @Override
    public String exportOfflineBalanceBill(OfflineBalanceBillQueryReqDto queryReqDto) {
        this.logger.info("\u5bfc\u51fa\u6536\u9000\u6b3e\u5355\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)queryReqDto));
        OfflineBalanceBillEo offlineBalanceBillEo = OfflineBalanceBillEo.newInstance();
        DtoHelper.dto2Eo((BaseVo)queryReqDto, (BaseEo)offlineBalanceBillEo);
        offlineBalanceBillEo.setOrderByDesc("createTime");
        List offlineBalanceBillEos = this.offlineBalanceBillDas.selectList((BaseEo)offlineBalanceBillEo);
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)offlineBalanceBillEos, OfflineBalanceBillExportDto.class);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List<Long> customerIdList = list.stream().map(OfflineBalanceBillExportDto::getCustomerId).distinct().collect(Collectors.toList());
            Map<Long, CustomerRespDto> customerInfoMap = this.getCustomerInfoMap(customerIdList);
            for (OfflineBalanceBillExportDto dto : list) {
                if (customerInfoMap.isEmpty() || !customerInfoMap.containsKey(dto.getCustomerId())) continue;
                CustomerRespDto customerRespDto = customerInfoMap.get(dto.getCustomerId());
                dto.setCustomerName(customerRespDto.getCustomerName());
            }
        }
        String title = "\u7ebf\u4e0b\u6536\u9000\u6b3e\u5355";
        String fileName = title + System.currentTimeMillis();
        try {
            this.logger.info("\u5bfc\u51fa\u7ebf\u4e0b\u6536\u9000\u6b3e\u5355date\uff1a" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            return EasyPoiExportUtil.getExportUrl(list, OfflineBalanceBillExportDto.class, null, fileName, "xls");
        }
        catch (Exception e) {
            this.logger.info("\u5bfc\u51fa\u7ebf\u4e0b\u6536\u9000\u6b3e\u5355\u5f02\u5e38date\uff1a" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            e.printStackTrace();
            throw new BizException("\u5bfc\u51fa\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public OfflineBalanceBillImportResultDto billImport(OfflineBalanceBillImportReqDto importReqDto) {
        this.logger.info("\u5bfc\u5165\u6536\u9000\u6b3e\u5355url:{}", (Object)importReqDto.getFileUrl());
        String fileUrl = importReqDto.getFileUrl();
        AssertUtil.assertNotBlank((String)fileUrl, (String)"\u5bfc\u5165\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        String orgIdStr = this.headerOrgId();
        this.logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)orgIdStr);
        AssertUtil.assertNotBlank((String)orgIdStr, (String)"\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\u7f3a\u5931");
        Long merchantId = Long.valueOf(orgIdStr);
        List<Object> importDtos = Lists.newArrayList();
        try {
            InputStream is = this.getInputStream(fileUrl);
            ExcelImportResult objectExcelImportResult = EasyPoiExportUtil.importExcel(is, 0, 1, OfflineBalanceBillImportDto.class);
            importDtos = objectExcelImportResult.getList();
            importDtos = BeanPropertyNullUtil.getAllFieldNullList(importDtos);
        }
        catch (Exception e) {
            throw new BizException("\u5bfc\u5165\u6536\u9000\u6b3e\u5355\u89e3\u6790\u5931\u8d25\uff1a" + e.getMessage());
        }
        OfflineBalanceBillImportResultDto resultDto = new OfflineBalanceBillImportResultDto();
        this.logger.info("\u5bfc\u5165\u7684\u6570\u636e==>{}", (Object)JSONObject.toJSONString((Object)importDtos));
        resultDto.setTotalSize(importDtos.size());
        this.initCheckImport(importDtos);
        List successList = importDtos.stream().filter(dto -> org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dto.getErrorReason())).collect(Collectors.toList());
        ArrayList addBillList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(successList)) {
            List customerCodeList = successList.stream().map(OfflineBalanceBillImportDto::getCustomerCode).distinct().collect(Collectors.toList());
            Map<Object, Object> customerInfoMap = new HashMap(customerCodeList.size() * 4 / 3 + 2);
            this.logger.info("\u6839\u636e\u5ba2\u6237code\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5f00\u59cb\u65f6\u95f4\uff1a" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            RestResponse customerRest = this.customerQueryApi.queryCustomerListByCodes(customerCodeList);
            this.logger.info("\u6839\u636e\u5ba2\u6237code\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u7ed3\u675f\u65f6\u95f4\uff1a" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            if (null != customerRest && null != customerRest.getData()) {
                List customerRespDtoList = (List)customerRest.getData();
                customerInfoMap = customerRespDtoList.stream().collect(Collectors.toMap(CustomerRespDto::getCode, Function.identity(), (k1, k2) -> k1));
            }
            OfflineBalanceAccountEo accountQueryEo = new OfflineBalanceAccountEo();
            SqlFilterBuilder sqlFilterBuilder = new SqlFilterBuilder();
            sqlFilterBuilder.in("customerCode", (Object)org.apache.commons.lang3.StringUtils.join((Iterable)customerCodeList, (String)","));
            accountQueryEo.setSqlFilters(sqlFilterBuilder.filters());
            List offlineBalanceAccountEoList = this.offlineBalanceAccountDas.select((BaseEo)accountQueryEo);
            Map<Object, Object> balanceAccountMap = new HashMap(offlineBalanceAccountEoList.size() * 4 / 3 + 2);
            if (CollectionUtils.isNotEmpty((Collection)offlineBalanceAccountEoList)) {
                balanceAccountMap = offlineBalanceAccountEoList.stream().collect(Collectors.toMap(OfflineBalanceAccountEo::getCustomerCode, Function.identity(), (k1, k2) -> k1));
            }
            for (OfflineBalanceBillImportDto offlineBalanceBillImportDto : importDtos) {
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)offlineBalanceBillImportDto.getErrorReason())) continue;
                StringBuffer errorBuffer = new StringBuffer();
                if (customerInfoMap.isEmpty() || !customerInfoMap.containsKey(offlineBalanceBillImportDto.getCustomerCode())) {
                    errorBuffer.append("\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728;");
                } else {
                    CustomerRespDto customerRespDto = (CustomerRespDto)customerInfoMap.get(offlineBalanceBillImportDto.getCustomerCode());
                    offlineBalanceBillImportDto.setCustomerId(customerRespDto.getId());
                    Long customerMerchantId = customerRespDto.getMerchantId() == null ? 0L : customerRespDto.getMerchantId();
                    if (merchantId.compareTo(customerMerchantId) != 0) {
                        errorBuffer.append("\u5ba2\u6237\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u5339\u914d;");
                    } else if (!Objects.equals(customerRespDto.getName(), offlineBalanceBillImportDto.getCustomerName())) {
                        errorBuffer.append("\u5ba2\u6237\u540d\u79f0\u586b\u5199\u4e0d\u6b63\u786e;");
                    }
                }
                if (balanceAccountMap.isEmpty() || !balanceAccountMap.containsKey(offlineBalanceBillImportDto.getCustomerCode())) {
                    errorBuffer.append("\u4f59\u989d\u8d26\u6237\u4e0d\u5b58\u5728;");
                } else {
                    OfflineBalanceAccountEo accountEo = (OfflineBalanceAccountEo)balanceAccountMap.get(offlineBalanceBillImportDto.getCustomerCode());
                    if (Objects.equals(accountEo.getAccountStatus(), "DISABLE")) {
                        errorBuffer.append("\u4f59\u989d\u8d26\u6237\u672a\u542f\u7528;");
                    }
                }
                if (Objects.equals(offlineBalanceBillImportDto.getBillType(), OfflineBalanceBillTypeEnum.RECEIPT.getCode())) {
                    try {
                        this.logger.info("\u5173\u8054\u5355\u53f7:{},\u91d1\u989d:{}", (Object)offlineBalanceBillImportDto.getRelationNo(), (Object)offlineBalanceBillImportDto.getAmount());
                        this.checkRelationOrder(offlineBalanceBillImportDto.getRelationNo(), offlineBalanceBillImportDto.getAmount(), offlineBalanceBillImportDto.getCustomerId());
                    }
                    catch (Exception e) {
                        this.logger.info("\u5bfc\u5165\u6536\u9000\u6b3e\u5355\u6821\u9a8c\u6536\u9000\u6b3e\u5355\u5f02\u5e38:{}", (Object)e.getMessage());
                        errorBuffer.append(e.getMessage() + ";");
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)errorBuffer)) {
                    offlineBalanceBillImportDto.setErrorReason(errorBuffer.toString());
                    continue;
                }
                Long offlineBalanceAccountId = ((OfflineBalanceAccountEo)balanceAccountMap.get(offlineBalanceBillImportDto.getCustomerCode())).getId();
                OfflineBalanceBillEo addBillEo = OfflineBalanceBillEo.newInstance();
                CubeBeanUtils.copyProperties((Object)addBillEo, (Object)offlineBalanceBillImportDto, (String[])new String[]{"billDate"});
                String billCode = this.generateBillCode(this.cacheService, addBillEo.getBillType(), "BILL_CODE");
                addBillEo.setBillCode(billCode);
                addBillEo.setOfflineBalanceAccountId(offlineBalanceAccountId);
                if (Objects.equals(offlineBalanceBillImportDto.getBillType(), OfflineBalanceBillTypeEnum.REFUND.getCode())) {
                    addBillEo.setRelationNo(null);
                }
                addBillEo.setBillSource(OfflineBalanceBillSourceEnum.MANUAL_INPUT.getCode());
                addBillEo.setImportStatus(YesOrNoEnum.YES.getCode());
                addBillEo.setAuditStatus(OfflineBalanceBillAuditStatusEnum.WAIT_AUDIT.getCode());
                addBillEo.setBillDate(DateUtil.parseDate((String)offlineBalanceBillImportDto.getBillDate(), (String)"yyyy-MM-dd"));
                addBillEo.setBusinessContent(offlineBalanceBillImportDto.getBusinessContent());
                addBillEo.setMerchantId(merchantId);
                addBillList.add(addBillEo);
            }
        }
        this.logger.info("\u5bfc\u5165\u6536\u9000\u6b3e\u5355\u751f\u6210\u5355\u636eList:{}", (Object)JSON.toJSONString((Object)addBillList));
        resultDto.setSuccessSize(addBillList.size());
        if (CollectionUtils.isNotEmpty((Collection)addBillList)) {
            this.offlineBalanceBillDas.insertBatch((List)addBillList);
        }
        for (OfflineBalanceBillEo billEo : addBillList) {
            if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)billEo.getRelationNo())) continue;
            this.logger.info("\u5173\u8054\u5355\u53f7\u4e0d\u4e3a\u7a7a,\u5219\u6839\u636e\u5355\u53f7\uff0c\u751f\u6210\u8ba2\u5355\u4ed8\u6b3e\u8bb0\u5f55");
            PayMethodReqDto payMethodReqDto = new PayMethodReqDto();
            payMethodReqDto.setOrderNo(billEo.getRelationNo());
            HashMap<String, Comparable<BigDecimal>> extfieldsMap = new HashMap<String, Comparable<BigDecimal>>();
            extfieldsMap.put("payAmount", billEo.getAmount());
            extfieldsMap.put("payTime", new Date());
            extfieldsMap.put("confirmTime", new Date());
            payMethodReqDto.setExtFields(extfieldsMap);
            this.logger.info("\u751f\u6210\u8ba2\u5355\u4ed8\u6b3e\u8bb0\u5f55\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)payMethodReqDto));
            RestResponse restResponse = this.payApi.addOfflinePayRecord(payMethodReqDto);
            this.logger.info("\u751f\u6210\u8ba2\u5355\u4ed8\u6b3e\u8bb0\u5f55\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)restResponse));
            if (null == restResponse || null == restResponse.getData()) {
                this.logger.info("\u6536\u6b3e\u5355[{}]\u751f\u6210\u8ba2\u5355\u4ed8\u6b3e\u8bb0\u5f55\u5f02\u5e38", (Object)billEo.getBillCode());
                continue;
            }
            billEo.setReceiptRecordsNo((String)restResponse.getData());
            this.offlineBalanceBillDas.update((BaseEo)billEo);
        }
        List list = importDtos.stream().filter(dto -> org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dto.getErrorReason())).collect(Collectors.toList());
        resultDto.setFailSize(list.size());
        if (CollectionUtils.isNotEmpty(list)) {
            String title = "\u5bfc\u5165\u6536\u9000\u6b3e\u5355\u8fd4\u56de\u7ed3\u679c";
            String fileName = title + System.currentTimeMillis();
            try {
                String exportUrl = EasyPoiExportUtil.getExportUrl(list, OfflineBalanceBillImportDto.class, null, fileName, "xls");
                resultDto.setErrorFileUrl(exportUrl);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BizException("\u5bfc\u51fa\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
        return resultDto;
    }

    private InputStream getInputStream(String fileUrl) throws IOException {
        URL url = new URL(fileUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        return conn.getInputStream();
    }

    private void initCheckImport(List<OfflineBalanceBillImportDto> importDtos) {
        if (CollectionUtils.isEmpty(importDtos)) {
            throw new BizException("\u5bfc\u5165\u7684\u8868\u683c\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8868\u683c\u540e\u91cd\u65b0\u5bfc\u5165");
        }
        for (OfflineBalanceBillImportDto importDto : importDtos) {
            StringBuffer errorBuffer = new StringBuffer();
            if (Objects.isNull(importDto)) {
                importDto.setErrorReason("\u6587\u4ef6\u8868\u683c\u5b58\u5728\u7a7a\u767d\u884c;");
                continue;
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)importDto.getBillType())) {
                errorBuffer.append("\u7c7b\u578b\u4e3a\u7a7a;");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)importDto.getBillDate())) {
                errorBuffer.append("\u5355\u636e\u65e5\u671f\u4e3a\u7a7a;");
            } else if (!this.isLegalDate(importDto.getBillDate().length(), importDto.getBillDate(), "yyyy-MM-dd")) {
                errorBuffer.append("\u5355\u636e\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e;");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)importDto.getBusinessContentStr())) {
                errorBuffer.append("\u4e1a\u52a1\u5185\u5bb9\u4e3a\u7a7a;");
            } else {
                String businessContentStr = importDto.getBusinessContentStr();
                if (businessContentStr.equals(OfflineBalanceBusinessEnum.BUSINESS_ORDER.getName())) {
                    importDto.setBusinessContent(OfflineBalanceBusinessEnum.BUSINESS_ORDER.getCode());
                } else if (businessContentStr.equals(OfflineBalanceBusinessEnum.STOP_COOPERATION.getName())) {
                    importDto.setBusinessContent(OfflineBalanceBusinessEnum.STOP_COOPERATION.getCode());
                } else if (businessContentStr.equals(OfflineBalanceBusinessEnum.OTHER.getName())) {
                    importDto.setBusinessContent(OfflineBalanceBusinessEnum.OTHER.getCode());
                } else {
                    importDto.setErrorReason("\u4e1a\u52a1\u5185\u5bb9\u503c\u4e0d\u5339\u914d;");
                }
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)importDto.getCustomerCode())) {
                errorBuffer.append("\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a;");
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)importDto.getCustomerName())) {
                errorBuffer.append("\u5ba2\u6237\u540d\u79f0\u4e3a\u7a7a;");
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)importDto.getAmountStr())) {
                errorBuffer.append("\u6536\u6b3e\u91d1\u989d\u4e3a\u7a7a;");
            } else if (!this.checkAmount(importDto.getAmountStr())) {
                errorBuffer.append("\u6536\u6b3e\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e;");
            } else {
                importDto.setAmount(new BigDecimal(importDto.getAmountStr()));
            }
            if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)errorBuffer.toString())) continue;
            importDto.setErrorReason(errorBuffer.toString());
        }
    }

    private boolean checkAmount(String str) {
        String pattern = "^[0-9]+(.[0-9]{1,2})?$";
        return Pattern.matches(pattern, str);
    }

    public boolean isLegalDate(int length, String sDate, String format) {
        int legalLen = length;
        if (sDate == null || sDate.length() != legalLen) {
            return false;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        try {
            Date date = formatter.parse(sDate);
            return sDate.equals(formatter.format(date));
        }
        catch (Exception e) {
            return false;
        }
    }

    private void checkRelationOrder(String relationNo, BigDecimal amount, Long customerId) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)relationNo) && Objects.nonNull(customerId)) {
            BigDecimal waitPayAmount;
            RestResponse orderDetailRest = this.orderBizQueryApi.getOrderDetail(relationNo, OrderQueryEnum.PAY_RECORD.name());
            if (null == orderDetailRest || null == orderDetailRest.getData()) {
                throw new BizException("\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728\uff0c\u8bf7\u586b\u5199\u5176\u4ed6\u8ba2\u5355\u53f7\u3002");
            }
            OrderDetailRespDto orderDetail = (OrderDetailRespDto)orderDetailRest.getData();
            if (!orderTradeWaitStatus.contains(orderDetail.getOrderTradeStatus())) {
                throw new BizException("\u8ba2\u5355\u53f7\u4e0d\u662f\u5f85\u652f\u4ed8\u72b6\u6001\uff0c\u8bf7\u586b\u5199\u5176\u4ed6\u8ba2\u5355\u53f7\u3002");
            }
            if (!customerId.toString().equals(orderDetail.getCustomerId())) {
                throw new BizException("\u8ba2\u5355\u53f7\u6240\u5c5e\u5ba2\u6237\u4e0d\u5339\u914d\u3002");
            }
            List payRecordList = orderDetail.getPayRecordList();
            BigDecimal actualPayAmount = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)payRecordList)) {
                actualPayAmount = payRecordList.stream().filter(pay -> !"reject".equals(pay.getAuditStatus())).map(PayRecordRespDto::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            if (amount.compareTo(waitPayAmount = orderDetail.getPayAmount().subtract(actualPayAmount)) > 0) {
                throw new BizException("\u6536\u6b3e\u91d1\u989d[" + amount.setScale(2) + "]\u5927\u4e8e\u8ba2\u5355\u5f85\u652f\u4ed8\u91d1\u989d[" + waitPayAmount.setScale(2) + "]");
            }
        }
    }
}

