/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.rebate.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.query.IOrganizationExpandQueryApi;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.user.api.query.IOrganizationQueryExtApi;
import com.github.pagehelper.PageInfo;
import com.yx.tcbj.center.rebate.api.dto.request.OfflineBalanceFlowReqDto;
import com.yx.tcbj.center.rebate.api.dto.response.OfflineBalanceFlowRespDto;
import com.yx.tcbj.center.rebate.api.dto.response.OfflineBalanceFlowStatisticsRespDto;
import com.yx.tcbj.center.rebate.biz.service.IOfflineBalanceFlowService;
import com.yx.tcbj.center.rebate.biz.service.IReturnsQuotaConfigGeneralService;
import com.yx.tcbj.center.rebate.biz.utils.EasyPoiExportUtil;
import com.yx.tcbj.center.rebate.dao.das.OfflineBalanceAccountDas;
import com.yx.tcbj.center.rebate.dao.das.OfflineBalanceFlowDas;
import com.yx.tcbj.center.rebate.dao.eo.OfflineBalanceAccountEo;
import com.yx.tcbj.center.rebate.dao.eo.OfflineBalanceFlowEo;
import com.yx.tcbj.center.rebate.dao.mapper.OfflineBalanceFlowMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OfflineBalanceFlowServiceImpl
implements IOfflineBalanceFlowService {
    @Resource
    private OfflineBalanceFlowDas offlineBalanceFlowDas;
    @Resource
    private OfflineBalanceFlowMapper offlineBalanceFlowMapper;
    @Resource
    private OfflineBalanceAccountDas offlineBalanceAccountDas;
    @Resource
    private IOrganizationQueryExtApi organizationQueryExtApi;
    @Resource
    private IReturnsQuotaConfigGeneralService returnsQuotaConfigGeneralService;
    @Resource
    private HttpServletRequest request;
    @Resource
    private IOrganizationExpandQueryApi organizationExpandQueryApi;

    @Override
    public Long addOfflineBalanceFlow(OfflineBalanceFlowReqDto addReqDto) {
        OfflineBalanceFlowEo offlineBalanceFlowEo = new OfflineBalanceFlowEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)offlineBalanceFlowEo);
        this.offlineBalanceFlowDas.insert((BaseEo)offlineBalanceFlowEo);
        return offlineBalanceFlowEo.getId();
    }

    @Override
    public void modifyOfflineBalanceFlow(OfflineBalanceFlowReqDto modifyReqDto) {
        OfflineBalanceFlowEo offlineBalanceFlowEo = new OfflineBalanceFlowEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)offlineBalanceFlowEo);
        this.offlineBalanceFlowDas.updateSelective((BaseEo)offlineBalanceFlowEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeOfflineBalanceFlow(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.offlineBalanceFlowDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public OfflineBalanceFlowRespDto queryById(Long id) {
        OfflineBalanceFlowEo offlineBalanceFlowEo = (OfflineBalanceFlowEo)this.offlineBalanceFlowDas.selectByPrimaryKey(id);
        OfflineBalanceFlowRespDto offlineBalanceFlowRespDto = new OfflineBalanceFlowRespDto();
        DtoHelper.eo2Dto((BaseEo)offlineBalanceFlowEo, (BaseVo)offlineBalanceFlowRespDto);
        return offlineBalanceFlowRespDto;
    }

    @Override
    public PageInfo<OfflineBalanceFlowRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        OfflineBalanceFlowReqDto offlineBalanceFlowReqDto = (OfflineBalanceFlowReqDto)JSON.parseObject((String)filter, OfflineBalanceFlowReqDto.class);
        PageInfo eoPageInfo = this.offlineBalanceFlowDas.page(offlineBalanceFlowReqDto, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, OfflineBalanceFlowRespDto.class);
        dtoPageInfo.setList(dtoList);
        if (CollectionUtils.isNotEmpty(dtoList)) {
            List accountIds = dtoList.stream().map(e -> e.getOfflineBalanceAccountId()).distinct().collect(Collectors.toList());
            List accountEos = this.offlineBalanceAccountDas.selectByIds(accountIds);
            Map<Long, OfflineBalanceAccountEo> accountEoMap = accountEos.stream().collect(Collectors.toMap(e -> e.getId(), e -> e));
            List merchatIds = accountEos.stream().map(e -> e.getMerchantId()).distinct().collect(Collectors.toList());
            List orgDtoList = (List)RestResponseHelper.extractData((RestResponse)this.organizationExpandQueryApi.queryOrgDtoByIds(merchatIds));
            Map<Long, String> orgMap = orgDtoList.stream().collect(Collectors.toMap(e -> e.getId(), e -> e.getName()));
            for (OfflineBalanceFlowRespDto dto : dtoList) {
                OfflineBalanceAccountEo accountEo = accountEoMap.get(dto.getOfflineBalanceAccountId());
                dto.setAccountCode(accountEo.getAccountCode());
                dto.setCustomerCode(accountEo.getCustomerCode());
                dto.setCustomerName(accountEo.getCustomerName());
                dto.setCustomerCompany(accountEo.getCustomerCompany());
                dto.setCustomerCompany(orgMap.get(accountEo.getMerchantId()));
            }
        }
        return dtoPageInfo;
    }

    @Override
    public PageInfo<OfflineBalanceFlowRespDto> queryByFlowPage(OfflineBalanceFlowReqDto offlineBalanceFlowReqDto) {
        OfflineBalanceAccountEo offlineBalanceAccountEo = new OfflineBalanceAccountEo();
        if (offlineBalanceFlowReqDto.getMerchantId() != null) {
            offlineBalanceAccountEo.setMerchantId(offlineBalanceFlowReqDto.getMerchantId());
        } else {
            offlineBalanceAccountEo.setMerchantId(Long.valueOf(this.getCurrentOrg()));
        }
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotEmpty((String)offlineBalanceFlowReqDto.getCustomerCode())) {
            sqlFilters.add(SqlFilter.like((String)"customer_code", (Object)("%" + offlineBalanceFlowReqDto.getCustomerCode() + "%")));
        }
        if (StringUtils.isNotEmpty((String)offlineBalanceFlowReqDto.getCustomerName())) {
            sqlFilters.add(SqlFilter.like((String)"customer_name", (Object)("%" + offlineBalanceFlowReqDto.getCustomerName() + "%")));
        }
        if (StringUtils.isNotEmpty((String)offlineBalanceFlowReqDto.getAccountCode())) {
            sqlFilters.add(SqlFilter.like((String)"account_code", (Object)("%" + offlineBalanceFlowReqDto.getAccountCode() + "%")));
        }
        offlineBalanceAccountEo.setSqlFilters(sqlFilters);
        List accountList = this.offlineBalanceAccountDas.selectWithColumn((BaseEo)offlineBalanceAccountEo, new String[]{"id"});
        if (CollectionUtils.isNotEmpty((Collection)accountList)) {
            if (CollectionUtils.isEmpty((Collection)offlineBalanceFlowReqDto.getAccountIdList())) {
                offlineBalanceFlowReqDto.setAccountIdList(accountList.stream().map(BaseEo::getId).collect(Collectors.toList()));
            } else {
                offlineBalanceFlowReqDto.getAccountIdList().addAll(accountList.stream().map(BaseEo::getId).collect(Collectors.toList()));
            }
        } else {
            return new PageInfo();
        }
        return this.queryByPage(JSON.toJSONString((Object)offlineBalanceFlowReqDto), offlineBalanceFlowReqDto.getPageNum(), offlineBalanceFlowReqDto.getPageSize());
    }

    @Override
    public OfflineBalanceFlowStatisticsRespDto statisticsChangeAmountByDto(String filter) {
        OfflineBalanceFlowReqDto offlineBalanceFlowReqDto = (OfflineBalanceFlowReqDto)JSON.parseObject((String)filter, OfflineBalanceFlowReqDto.class);
        String flowBudgetType = offlineBalanceFlowReqDto.getFlowBudgetType();
        OfflineBalanceFlowStatisticsRespDto offlineBalanceFlowStatisticsRespDto = new OfflineBalanceFlowStatisticsRespDto();
        if ("EXPEND".equals(flowBudgetType)) {
            offlineBalanceFlowStatisticsRespDto.setIncomeAmount(BigDecimal.ZERO);
            offlineBalanceFlowReqDto.setFlowBudgetType("EXPEND");
            offlineBalanceFlowStatisticsRespDto.setExpendAmount(this.offlineBalanceFlowDas.statisticsChangeAmountByDto(offlineBalanceFlowReqDto));
        } else if ("INCOME".equals(flowBudgetType)) {
            offlineBalanceFlowStatisticsRespDto.setExpendAmount(BigDecimal.ZERO);
            offlineBalanceFlowReqDto.setFlowBudgetType("INCOME");
            offlineBalanceFlowStatisticsRespDto.setIncomeAmount(this.offlineBalanceFlowDas.statisticsChangeAmountByDto(offlineBalanceFlowReqDto));
        } else {
            offlineBalanceFlowReqDto.setFlowBudgetType("INCOME");
            offlineBalanceFlowStatisticsRespDto.setIncomeAmount(this.offlineBalanceFlowDas.statisticsChangeAmountByDto(offlineBalanceFlowReqDto));
            offlineBalanceFlowReqDto.setFlowBudgetType("EXPEND");
            offlineBalanceFlowStatisticsRespDto.setExpendAmount(this.offlineBalanceFlowDas.statisticsChangeAmountByDto(offlineBalanceFlowReqDto));
        }
        return offlineBalanceFlowStatisticsRespDto;
    }

    @Override
    public String exportOfflineBalanceFlow(String filter) {
        try {
            PageInfo<OfflineBalanceFlowRespDto> offlineBalanceFlowRespDtoPageInfo = this.queryByPage(filter, null, null);
            List list = offlineBalanceFlowRespDtoPageInfo.getList();
            String title = "\u7ebf\u4e0b\u8d26\u6237\u4f59\u989d\u6d41\u6c34";
            String fileName = title + System.currentTimeMillis();
            return EasyPoiExportUtil.getExportUrl(list, OfflineBalanceFlowRespDto.class, null, fileName, "xls");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new com.dtyunxi.exceptions.BizException("\u5bfc\u51fa\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    private String getCurrentOrg() {
        String orgId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)orgId)) {
            orgId = this.request.getHeader("yes.req.cus.b2b.organizationId");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)orgId)) {
            throw new BizException("-1", "\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7ec4\u7ec7\u4fe1\u606f");
        }
        return orgId;
    }
}

