/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.rebate.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.ChangeTypeEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.RebateUseLogAddReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.RebateUseLogModifyReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.RebateUseLogQueryReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.RebateUseLogExtRespDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.RebateUseLogRespDto;
import com.dtyunxi.yundt.cube.center.rebate.biz.util.DateUtil;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.RebateUseLogEo;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopDto;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.ShopQueryDto;
import com.dtyunxi.yundt.cube.center.shop.api.query.IShopQueryApi;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yx.tcbj.center.rebate.api.dto.request.RebateUseLogQueryV2ReqDto;
import com.yx.tcbj.center.rebate.api.dto.response.RebateUseLogPageDto;
import com.yx.tcbj.center.rebate.biz.service.IRebateUseLogV2Service;
import com.yx.tcbj.center.rebate.dao.das.RebateUseLogV2Das;
import com.yx.tcbj.center.rebate.dao.vo.RebateUseLogQueryV2Vo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RebateUseLogV2ServiceImpl
implements IRebateUseLogV2Service {
    private static final Logger logger = LoggerFactory.getLogger(RebateUseLogV2ServiceImpl.class);
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private RebateUseLogV2Das rebateUseLogV2Das;
    @Autowired
    private IShopQueryApi shopQueryApi;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addRebateUseLog(RebateUseLogAddReqDto reqDto) {
        RebateUseLogEo rebateUseLogEo = new RebateUseLogEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)rebateUseLogEo);
        this.rebateUseLogV2Das.insert((BaseEo)rebateUseLogEo);
        return rebateUseLogEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyRebateUseLog(RebateUseLogModifyReqDto reqDto) {
        RebateUseLogEo rebateUseLogEo = new RebateUseLogEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)rebateUseLogEo);
        this.rebateUseLogV2Das.updateSelective((BaseEo)rebateUseLogEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeRebateUseLog(String ids) {
        String[] removeIds;
        String[] var3 = removeIds = ids.split(",");
        int var4 = removeIds.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            String id = var3[var5];
            this.rebateUseLogV2Das.logicDeleteById(Long.valueOf(id.trim()));
        }
    }

    @Override
    public RebateUseLogRespDto queryRebateUseLogById(Long id) {
        RebateUseLogEo rebateUseLogEo = (RebateUseLogEo)this.rebateUseLogV2Das.selectByPrimaryKey(id);
        if (rebateUseLogEo == null) {
            return null;
        }
        RebateUseLogRespDto rebateUseLogRespDto = new RebateUseLogRespDto();
        DtoHelper.eo2Dto((BaseEo)rebateUseLogEo, (BaseVo)rebateUseLogRespDto);
        return rebateUseLogRespDto;
    }

    @Override
    public PageInfo<RebateUseLogRespDto> queryRebateUseLogByPage(RebateUseLogQueryReqDto reqDto, Integer pageNum, Integer pageSize) {
        RebateUseLogEo rebateUseLogEo = new RebateUseLogEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)rebateUseLogEo);
        PageInfo eoPageInfo = this.rebateUseLogV2Das.selectPage((BaseEo)rebateUseLogEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, RebateUseLogRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<RebateUseLogPageDto> queryRebateUseLogByPage(RebateUseLogQueryV2ReqDto reqDto) {
        List orgIds;
        Map<Object, Object> customerRespDtoMap = Maps.newHashMap();
        Map<Object, Object> shopRespDtoMap = Maps.newHashMap();
        RebateUseLogQueryV2Vo rebateUseLogQueryVo = this.buildUserLogQueryVo(reqDto, (Map<Long, CustomerRespDto>)customerRespDtoMap);
        if (StringUtils.isNotBlank((CharSequence)reqDto.getUserName())) {
            CustomerSearchReqDto customerSearchReqDto = new CustomerSearchReqDto();
            customerSearchReqDto.setMerchantId(reqDto.getOrganizationId());
            customerSearchReqDto.setInstanceId(Long.valueOf(1254039287584232622L));
            customerSearchReqDto.setTenantId(Long.valueOf(1L));
            if (StringUtils.isNotEmpty((CharSequence)reqDto.getUserName())) {
                customerSearchReqDto.setKeyword(reqDto.getUserName());
            }
            orgIds = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryByList(JSON.toJSONString((Object)customerSearchReqDto)));
            logger.info("[\u6298\u6263\u5145\u503c\u5355\u6d41\u6c34],\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f:{}", (Object)JSON.toJSONString(orgIds));
            if (CollectionUtils.isEmpty(orgIds)) {
                return new PageInfo();
            }
            ArrayList customerIds = Lists.newArrayList();
            for (CustomerRespDto customerRespDto : orgIds) {
                customerRespDtoMap.put(customerRespDto.getId(), customerRespDto);
                customerIds.add(customerRespDto.getId());
            }
            rebateUseLogQueryVo.setCustomerIds((List)customerIds);
        }
        PageHelper.startPage((int)reqDto.getPageNum(), (int)reqDto.getPageSize());
        List rebateUseLogExtRespDtos = this.rebateUseLogV2Das.queryRebateUseLogByPage(rebateUseLogQueryVo);
        if (CollectionUtils.isNotEmpty((Collection)rebateUseLogExtRespDtos)) {
            if (customerRespDtoMap.isEmpty()) {
                orgIds = rebateUseLogExtRespDtos.stream().map(RebateUseLogExtRespDto::getCustomerId).distinct().collect(Collectors.toList());
                List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByCustomerIds(orgIds));
                customerRespDtoMap = customerRespDtos.stream().collect(Collectors.toMap(BaseRespDto::getId, e -> e, (e1, e2) -> e1));
            }
            orgIds = rebateUseLogExtRespDtos.stream().map(RebateUseLogExtRespDto::getOrganizationId).distinct().collect(Collectors.toList());
            ShopQueryDto shopQueryDto = new ShopQueryDto();
            shopQueryDto.setOrganizationIdList(orgIds);
            List shopDtos = (List)RestResponseHelper.extractData((RestResponse)this.shopQueryApi.queryShopListNew(shopQueryDto));
            if (CollectionUtils.isNotEmpty((Collection)shopDtos)) {
                shopRespDtoMap = shopDtos.stream().collect(Collectors.toMap(ShopDto::getOrganizationId, e -> e, (e1, e2) -> e1));
            }
            for (RebateUseLogExtRespDto rebateUseLogExtRespDto : rebateUseLogExtRespDtos) {
                CustomerRespDto customerRespDto;
                ChangeTypeEnum changeTypeEnum;
                ShopDto shopDto = (ShopDto)shopRespDtoMap.get(rebateUseLogExtRespDto.getOrganizationId());
                if (shopDto != null) {
                    rebateUseLogExtRespDto.setOrganizationName(shopDto.getName());
                }
                if ((changeTypeEnum = ChangeTypeEnum.fromCode((String)rebateUseLogExtRespDto.getChangeType())) != null) {
                    rebateUseLogExtRespDto.setChangeTypeName(changeTypeEnum.toName());
                }
                if ((customerRespDto = (CustomerRespDto)customerRespDtoMap.get(rebateUseLogExtRespDto.getCustomerId())) == null) continue;
                rebateUseLogExtRespDto.setCustomerCode(customerRespDto.getCode());
                rebateUseLogExtRespDto.setCustomerName(customerRespDto.getName());
            }
        }
        return new PageInfo(rebateUseLogExtRespDtos);
    }

    private RebateUseLogQueryV2Vo buildUserLogQueryVo(RebateUseLogQueryV2ReqDto reqDto, Map<Long, CustomerRespDto> customerRespDtoMap) {
        if (reqDto.getOrganizationId() == null && CollectionUtils.isEmpty((Collection)reqDto.getCustomerIds())) {
            throw new BizException("\u7ec4\u7ec7Id\u6216\u8005\u5ba2\u6237ID\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        RebateUseLogQueryV2Vo rebateUseLogQueryVo = new RebateUseLogQueryV2Vo();
        rebateUseLogQueryVo.setType(reqDto.getType());
        if (reqDto.getBeginTime() != null) {
            rebateUseLogQueryVo.setBeginTime(DateUtil.getDateFormat((Date)reqDto.getBeginTime(), (String)DateUtil.DEFAULT_PATTERN));
        }
        if (reqDto.getEndTime() != null) {
            rebateUseLogQueryVo.setEndTime(DateUtil.getDateFormat((Date)reqDto.getEndTime(), (String)DateUtil.DEFAULT_PATTERN));
        }
        List<String> changeTypes = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getChangeTypeList())) {
            changeTypes = reqDto.getChangeTypeList();
        } else if (StringUtils.isNotBlank((CharSequence)reqDto.getChangeType())) {
            changeTypes.add(reqDto.getChangeType());
        }
        rebateUseLogQueryVo.setChangeTypes((List)changeTypes);
        rebateUseLogQueryVo.setBusinessNo(reqDto.getBusinessNo());
        rebateUseLogQueryVo.setCustomerIds(reqDto.getCustomerIds());
        rebateUseLogQueryVo.setOrganizationId(reqDto.getOrganizationId());
        rebateUseLogQueryVo.setRebateNo(reqDto.getRebateNo());
        rebateUseLogQueryVo.setRebateAccountNo(reqDto.getRebateAccountNo());
        return rebateUseLogQueryVo;
    }
}

