/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.rebate.biz.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.yx.tcbj.center.rebate.api.dto.request.ReturnsQuotaConfigGeneralReqDto;
import com.yx.tcbj.center.rebate.api.dto.response.ReturnsQuotaConfigGeneralRespDto;
import com.yx.tcbj.center.rebate.biz.service.IReturnsQuotaConfigGeneralService;
import com.yx.tcbj.center.rebate.dao.das.ReturnsQuotaConfigGeneralDas;
import com.yx.tcbj.center.rebate.dao.eo.ReturnsQuotaConfigGeneralEo;
import java.math.BigDecimal;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ReturnsQuotaConfigGeneralServiceImpl
implements IReturnsQuotaConfigGeneralService {
    private static final Logger logger = LoggerFactory.getLogger(ReturnsQuotaConfigGeneralServiceImpl.class);
    @Resource
    private ReturnsQuotaConfigGeneralDas returnsQuotaConfigGeneralDas;
    @Resource
    private HttpServletRequest request;

    @Override
    public Long modifyReturnsQuotaConfigGeneral(ReturnsQuotaConfigGeneralReqDto modifyReqDto) {
        logger.info("\u4fee\u6539\u9000\u8d27\u989d\u5ea6\u89c4\u5219\u901a\u7528\u914d\u7f6e");
        String currentOrg = this.getCurrentOrg();
        if (StringUtils.isBlank((CharSequence)currentOrg)) {
            throw new BizException("-1", "\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7ec4\u7ec7\u4fe1\u606f");
        }
        ReturnsQuotaConfigGeneralRespDto respDto = this.query(currentOrg);
        if (ObjectUtils.isEmpty((Object)respDto)) {
            ReturnsQuotaConfigGeneralEo eo = new ReturnsQuotaConfigGeneralEo();
            eo.setOrgId(modifyReqDto.getOrgId());
            eo.setScale(modifyReqDto.getScale());
            eo.setYearDate(modifyReqDto.getYearDate());
            this.returnsQuotaConfigGeneralDas.insert((BaseEo)eo);
            return eo.getId();
        }
        ReturnsQuotaConfigGeneralEo eo = new ReturnsQuotaConfigGeneralEo();
        DtoHelper.dto2Eo((BaseVo)respDto, (BaseEo)eo);
        eo.setScale(modifyReqDto.getScale());
        eo.setYearDate(modifyReqDto.getYearDate());
        this.returnsQuotaConfigGeneralDas.updateSelective((BaseEo)eo);
        return eo.getId();
    }

    @Override
    public ReturnsQuotaConfigGeneralRespDto query(String orgId) {
        if (StringUtils.isBlank((CharSequence)orgId)) {
            orgId = this.getCurrentOrg();
        }
        ReturnsQuotaConfigGeneralEo params = new ReturnsQuotaConfigGeneralEo();
        params.setOrgId(Long.valueOf(orgId));
        ReturnsQuotaConfigGeneralEo returnsQuotaConfigGeneralEo = (ReturnsQuotaConfigGeneralEo)this.returnsQuotaConfigGeneralDas.selectOne((BaseEo)params);
        if (ObjectUtils.isEmpty((Object)returnsQuotaConfigGeneralEo)) {
            ReturnsQuotaConfigGeneralEo eo = new ReturnsQuotaConfigGeneralEo();
            eo.setOrgId(Long.valueOf(orgId));
            eo.setYearDate("01-01");
            eo.setScale(new BigDecimal("2.00"));
            this.returnsQuotaConfigGeneralDas.insert((BaseEo)eo);
            returnsQuotaConfigGeneralEo = eo;
        }
        ReturnsQuotaConfigGeneralRespDto returnsQuotaConfigGeneralRespDto = new ReturnsQuotaConfigGeneralRespDto();
        DtoHelper.eo2Dto((BaseEo)returnsQuotaConfigGeneralEo, (BaseVo)returnsQuotaConfigGeneralRespDto);
        return returnsQuotaConfigGeneralRespDto;
    }

    @Override
    public List<ReturnsQuotaConfigGeneralRespDto> queryList(String orgId) {
        return this.returnsQuotaConfigGeneralDas.queryList(orgId);
    }

    private String getCurrentOrg() {
        String orgId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        if (StringUtils.isBlank((CharSequence)orgId)) {
            orgId = this.request.getHeader("yes.req.cus.b2b.organizationId");
        }
        if (StringUtils.isBlank((CharSequence)orgId)) {
            throw new BizException("-1", "\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7ec4\u7ec7\u4fe1\u606f");
        }
        return orgId;
    }
}

