/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.rebate.biz.service.impl;

import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.tcbj.api.query.IOrganizationExpandQueryApi;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.request.CustomerSearchReqDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.user.api.dto.OrganizationDto;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yx.tcbj.center.customer.api.dto.response.CustomerIdsRespDto;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import com.yx.tcbj.center.rebate.api.dto.request.BalanceAccountImportReqDto;
import com.yx.tcbj.center.rebate.api.dto.request.OfflineBalanceAccountReqDto;
import com.yx.tcbj.center.rebate.api.dto.request.OfflineBalanceAccountRollBackReqDto;
import com.yx.tcbj.center.rebate.api.dto.response.BalanceAccountImportResultDto;
import com.yx.tcbj.center.rebate.api.dto.response.OfflineBalanceAccountImportDto;
import com.yx.tcbj.center.rebate.api.dto.response.OfflineBalanceAccountRespDto;
import com.yx.tcbj.center.rebate.api.dto.response.OfflineBalanceFlowRespDto;
import com.yx.tcbj.center.rebate.api.dto.response.OfflineBalanceGroupRespDto;
import com.yx.tcbj.center.rebate.api.enums.OfflineBalanceAccountEnum;
import com.yx.tcbj.center.rebate.api.enums.OfflineBalanceFlowEnum;
import com.yx.tcbj.center.rebate.biz.service.IOfflineBalanceAccountService;
import com.yx.tcbj.center.rebate.biz.utils.BeanPropertyNullUtil;
import com.yx.tcbj.center.rebate.biz.utils.EasyPoiExportUtil;
import com.yx.tcbj.center.rebate.dao.das.OfflineBalanceAccountDas;
import com.yx.tcbj.center.rebate.dao.das.OfflineBalanceFlowDas;
import com.yx.tcbj.center.rebate.dao.eo.OfflineBalanceAccountEo;
import com.yx.tcbj.center.rebate.dao.eo.OfflineBalanceFlowEo;
import com.yx.tcbj.center.rebate.dao.mapper.OfflineBalanceAccountMapper;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OfflineBalanceAccountServiceImpl
implements IOfflineBalanceAccountService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private OfflineBalanceAccountDas offlineBalanceAccountDas;
    @Resource
    private OfflineBalanceAccountMapper offlineBalanceAccountMapper;
    @Resource
    private OfflineBalanceFlowDas offlineBalanceFlowDas;
    @Resource
    private ICustomerQueryApi customerQueryApi;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private IContext context;
    @Resource
    private IOrganizationExpandQueryApi organizationExpandQueryApi;
    @Resource
    private HttpServletRequest request;

    public String headerOrgId() {
        String organizationId = this.request.getHeader("yes-req-cus-b2b-organizationId");
        this.logger.info("\u83b7\u53d6\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)organizationId);
        return organizationId;
    }

    @Override
    public PageInfo<OfflineBalanceAccountRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        return this.queryPage(filter, pageNum, pageSize);
    }

    @Override
    public String exportOfflineBalanceAccount(String filter) {
        PageInfo<OfflineBalanceAccountRespDto> offlineBalanceAccountRespDtoPageInfo = this.queryPage(filter, null, null);
        List list = offlineBalanceAccountRespDtoPageInfo.getList();
        String title = "\u7ebf\u4e0b\u8d26\u6237\u4f59\u989d";
        String fileName = title + System.currentTimeMillis();
        try {
            return EasyPoiExportUtil.getExportUrl(list, OfflineBalanceAccountRespDto.class, null, fileName, "xls");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u5bfc\u51fa\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    @Override
    public OfflineBalanceAccountRespDto queryById(Long id) {
        OfflineBalanceAccountEo offlineBalanceAccountEo = (OfflineBalanceAccountEo)this.offlineBalanceAccountDas.selectByPrimaryKey(id);
        OfflineBalanceAccountRespDto offlineBalanceAccountRespDto = new OfflineBalanceAccountRespDto();
        DtoHelper.eo2Dto((BaseEo)offlineBalanceAccountEo, (BaseVo)offlineBalanceAccountRespDto);
        this.setSalesmanNameAndMerchantName(offlineBalanceAccountRespDto);
        return offlineBalanceAccountRespDto;
    }

    @Override
    public Long addOfflineBalanceAccount(OfflineBalanceAccountReqDto addReqDto) {
        OfflineBalanceAccountEo offlineBalanceAccountEo = new OfflineBalanceAccountEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)offlineBalanceAccountEo);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"customer_id", (Object)addReqDto.getCustomerId());
        List balanceAccountEos = this.offlineBalanceAccountMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)balanceAccountEos)) {
            this.logger.info("\u5ba2\u6237\u5df2\u5b58\u5728\u4f59\u989d\u8d26\u6237");
            return ((OfflineBalanceAccountEo)balanceAccountEos.get(0)).getId();
        }
        OfflineBalanceAccountRespDto offlineBalanceAccountRespDto = new OfflineBalanceAccountRespDto();
        offlineBalanceAccountRespDto.setCustomerCode(addReqDto.getCustomerCode());
        this.setSalesmanNameAndMerchantName(offlineBalanceAccountRespDto);
        this.offlineBalanceAccountDas.insert((BaseEo)offlineBalanceAccountEo);
        return offlineBalanceAccountEo.getId();
    }

    @Override
    public void saveBalanceAccountBatch(List<OfflineBalanceAccountReqDto> addReqDtos) {
        this.logger.info("\u6279\u91cf\u65b0\u589e\u4f59\u989d\u8d26\u6237");
        if (CollectionUtils.isEmpty(addReqDtos)) {
            this.logger.info("\u66f4\u65b0\u4f59\u989d\u8d26\u6237\u8bf7\u6c42dto\u4e3a\u7a7a");
            return;
        }
        List customerIdList = addReqDtos.stream().map(OfflineBalanceAccountReqDto::getCustomerId).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"customer_id", customerIdList);
        List balanceAccountEos = this.offlineBalanceAccountMapper.selectList((Wrapper)queryWrapper);
        Map<Object, Object> customerAccountMap = new HashMap(balanceAccountEos.size() * 4 / 3 + 2);
        if (CollectionUtils.isNotEmpty((Collection)balanceAccountEos)) {
            customerAccountMap = balanceAccountEos.stream().collect(Collectors.toMap(OfflineBalanceAccountEo::getCustomerId, Function.identity(), (k1, k2) -> k1));
        }
        ArrayList addEos = Lists.newArrayList();
        for (OfflineBalanceAccountReqDto balanceAccountReqDto : addReqDtos) {
            if (!customerAccountMap.isEmpty() && customerAccountMap.containsKey(balanceAccountReqDto.getCustomerId())) continue;
            OfflineBalanceAccountEo addEo = new OfflineBalanceAccountEo();
            DtoHelper.dto2Eo((BaseVo)balanceAccountReqDto, (BaseEo)addEo);
            addEos.add(addEo);
        }
        this.logger.info("\u65b0\u589e\u4f59\u989d\u8d26\u6237\u96c6\u5408\u5927\u5c0f:{}", (Object)addEos.size());
        if (CollectionUtils.isNotEmpty((Collection)addEos)) {
            this.offlineBalanceAccountDas.insertBatch((List)addEos);
        }
    }

    @Override
    public void modifyOfflineBalanceAccount(OfflineBalanceAccountReqDto modifyReqDto) {
        OfflineBalanceAccountEo offlineBalanceAccountEo = new OfflineBalanceAccountEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)offlineBalanceAccountEo);
        this.offlineBalanceAccountDas.updateSelective((BaseEo)offlineBalanceAccountEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public OfflineBalanceFlowRespDto offlineBalanceAccountChange(OfflineBalanceAccountReqDto offlineBalanceAccountReqDto) {
        this.logger.info("offlineBalanceAccountChange\uff1a{}", (Object)JSON.toJSONString((Object)offlineBalanceAccountReqDto));
        if (Objects.isNull(offlineBalanceAccountReqDto.getCustomerId())) {
            throw new BizException("\u5ba2\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)offlineBalanceAccountReqDto.getRelationNo())) {
            throw new BizException("\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)offlineBalanceAccountReqDto.getChangeStatus()) || StringUtils.isBlank((String)offlineBalanceAccountReqDto.getFlowTradeType())) {
            throw new BizException("\u7ebf\u4e0b\u4f59\u989d\u53d8\u52a8\u72b6\u6001\u6216\u8005\u53d8\u52a8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OfflineBalanceAccountEo offlineBalanceAccountEo = new OfflineBalanceAccountEo();
        offlineBalanceAccountEo.setCustomerId(offlineBalanceAccountReqDto.getCustomerId());
        OfflineBalanceAccountEo exitAccount = (OfflineBalanceAccountEo)this.offlineBalanceAccountDas.selectOne((BaseEo)offlineBalanceAccountEo);
        if (Objects.isNull(exitAccount)) {
            throw new BizException("\u67e5\u8be2\u4e0d\u5230\u8be5\u7528\u6237\u8d26\u6237");
        }
        if (Objects.isNull(offlineBalanceAccountReqDto.getBalanceChange())) {
            offlineBalanceAccountReqDto.setBalanceChange(BigDecimal.ZERO);
        }
        offlineBalanceAccountReqDto.setAccountBalance(exitAccount.getAccountBalance());
        if ("INCOME".equals(offlineBalanceAccountReqDto.getChangeStatus())) {
            exitAccount.setAccountBalance(exitAccount.getAccountBalance().add(offlineBalanceAccountReqDto.getBalanceChange()));
        } else {
            BigDecimal subtract = exitAccount.getAccountBalance().subtract(offlineBalanceAccountReqDto.getBalanceChange());
            if (BigDecimal.ZERO.compareTo(subtract) > 0) {
                throw new BizException("\u8be5\u8d26\u6237\u4e0b\u4f59\u989d\u4e0d\u8db3,\u6263\u51cf\u5931\u8d25,\u8d26\u6237ID\uff1a" + exitAccount.getId() + ",\u6263\u51cf\u91d1\u989d:" + offlineBalanceAccountReqDto.getBalanceChange());
            }
            exitAccount.setAccountBalance(subtract);
        }
        this.offlineBalanceAccountDas.updateSelective((BaseEo)exitAccount);
        OfflineBalanceFlowEo offlineBalanceFlowEo = new OfflineBalanceFlowEo();
        offlineBalanceFlowEo.setBeforeAmount(offlineBalanceAccountReqDto.getAccountBalance());
        offlineBalanceFlowEo.setAfterAmount(exitAccount.getAccountBalance());
        offlineBalanceFlowEo.setChangeAmount(offlineBalanceAccountReqDto.getBalanceChange());
        offlineBalanceFlowEo.setOfflineBalanceAccountId(exitAccount.getId());
        offlineBalanceFlowEo.setChangeTime(new Date());
        offlineBalanceFlowEo.setFlowBudgetType(offlineBalanceAccountReqDto.getChangeStatus());
        offlineBalanceFlowEo.setFlowTradeType(offlineBalanceAccountReqDto.getFlowTradeType());
        offlineBalanceFlowEo.setRelationNo(offlineBalanceAccountReqDto.getRelationNo());
        this.offlineBalanceFlowDas.insert((BaseEo)offlineBalanceFlowEo);
        OfflineBalanceFlowRespDto offlineBalanceFlowRespDto = new OfflineBalanceFlowRespDto();
        DtoHelper.eo2Dto((BaseEo)offlineBalanceFlowEo, (BaseVo)offlineBalanceFlowRespDto);
        return offlineBalanceFlowRespDto;
    }

    @Override
    public OfflineBalanceAccountRespDto queryByCustomerId(Long customerId) {
        OfflineBalanceAccountEo offlineBalanceAccountQueryEo = new OfflineBalanceAccountEo();
        offlineBalanceAccountQueryEo.setCustomerId(customerId);
        OfflineBalanceAccountEo offlineBalanceAccountEo = (OfflineBalanceAccountEo)this.offlineBalanceAccountDas.selectOne((BaseEo)offlineBalanceAccountQueryEo);
        OfflineBalanceAccountRespDto offlineBalanceAccountRespDto = new OfflineBalanceAccountRespDto();
        if (ObjectUtils.isNotEmpty((Object)offlineBalanceAccountEo)) {
            DtoHelper.eo2Dto((BaseEo)offlineBalanceAccountEo, (BaseVo)offlineBalanceAccountRespDto);
            this.setSalesmanNameAndMerchantName(offlineBalanceAccountRespDto);
        }
        return offlineBalanceAccountRespDto;
    }

    @Override
    public List<OfflineBalanceAccountRespDto> accountByCustomerId(List<Long> customerIdList) {
        List offlineBalanceAccountEoList = this.offlineBalanceAccountDas.queryAccountByCustomerId(customerIdList);
        if (CollectionUtils.isEmpty((Collection)offlineBalanceAccountEoList)) {
            return Lists.newArrayList();
        }
        ArrayList dtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)dtoList, (Collection)offlineBalanceAccountEoList, OfflineBalanceAccountRespDto.class);
        return dtoList;
    }

    private PageInfo<OfflineBalanceAccountRespDto> queryPage(String filter, Integer pageNum, Integer pageSize) {
        OfflineBalanceAccountReqDto offlineBalanceAccountReqDto = (OfflineBalanceAccountReqDto)JSON.parseObject((String)filter, OfflineBalanceAccountReqDto.class);
        OfflineBalanceAccountEo offlineBalanceAccountEo = new OfflineBalanceAccountEo();
        DtoHelper.dto2Eo((BaseVo)offlineBalanceAccountReqDto, (BaseEo)offlineBalanceAccountEo, (String[])new String[]{"customerCode", "customerName"});
        if (Objects.isNull(offlineBalanceAccountEo.getMerchantId())) {
            String orgIdStr = this.headerOrgId();
            this.logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)orgIdStr);
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)orgIdStr)) {
                offlineBalanceAccountEo.setMerchantId(Long.valueOf(orgIdStr));
            }
        }
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        if (StringUtils.isNotEmpty((String)offlineBalanceAccountReqDto.getSalesmanName())) {
            CustomerIdsRespDto customerIdsRespDto = (CustomerIdsRespDto)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerIdsBySalesmanName(offlineBalanceAccountReqDto.getSalesmanName()));
            if (Objects.isNull(customerIdsRespDto) || CollectionUtils.isNotEmpty((Collection)customerIdsRespDto.getCustomerIds())) {
                return new PageInfo();
            }
            sqlFilters.add(SqlFilter.in((String)"customer_id", (Object)customerIdsRespDto.getCustomerIds()));
        }
        if (StringUtils.isNotEmpty((String)offlineBalanceAccountReqDto.getCustomerCode())) {
            sqlFilters.add(SqlFilter.like((String)"customer_code", (Object)("%" + offlineBalanceAccountReqDto.getCustomerCode() + "%")));
        }
        if (StringUtils.isNotEmpty((String)offlineBalanceAccountReqDto.getCustomerName())) {
            sqlFilters.add(SqlFilter.like((String)"customer_name", (Object)("%" + offlineBalanceAccountReqDto.getCustomerName() + "%")));
        }
        offlineBalanceAccountEo.setSqlFilters(sqlFilters);
        offlineBalanceAccountEo.setOrderByDesc("update_time");
        PageInfo eoPageInfo = null;
        eoPageInfo = Objects.nonNull(pageNum) && Objects.nonNull(pageSize) ? this.offlineBalanceAccountDas.selectPage((BaseEo)offlineBalanceAccountEo, pageNum, pageSize) : this.offlineBalanceAccountDas.selectPage((BaseEo)offlineBalanceAccountEo, Integer.valueOf(1), Integer.valueOf(Integer.MAX_VALUE));
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList<OfflineBalanceAccountRespDto> dtoList = new ArrayList<OfflineBalanceAccountRespDto>();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, OfflineBalanceAccountRespDto.class);
        this.setSalesmanName(dtoList);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    private void setSalesmanName(List<OfflineBalanceAccountRespDto> offlineBalanceAccountRespDtos) {
        if (CollectionUtils.isEmpty(offlineBalanceAccountRespDtos)) {
            return;
        }
        List merchantIdList = offlineBalanceAccountRespDtos.stream().filter(dto -> Objects.nonNull(dto.getMerchantId())).map(OfflineBalanceAccountRespDto::getMerchantId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(merchantIdList)) {
            return;
        }
        List orgDtoList = (List)RestResponseHelper.extractData((RestResponse)this.organizationExpandQueryApi.queryOrgDtoByIds(merchantIdList));
        if (CollectionUtils.isEmpty((Collection)orgDtoList)) {
            return;
        }
        Map<Long, String> orgNameMap = orgDtoList.stream().collect(Collectors.toMap(OrganizationDto::getId, OrganizationDto::getName, (k1, k2) -> k1));
        for (OfflineBalanceAccountRespDto dto2 : offlineBalanceAccountRespDtos) {
            if (Objects.isNull(dto2.getMerchantId()) || !orgNameMap.containsKey(dto2.getMerchantId())) continue;
            dto2.setCustomerCompany(orgNameMap.get(dto2.getMerchantId()));
        }
    }

    private void setSalesmanNameAndMerchantName(OfflineBalanceAccountRespDto offlineBalanceAccountRespDto) {
        if (StringUtils.isEmpty((String)offlineBalanceAccountRespDto.getCustomerCode())) {
            return;
        }
        RestResponse customerRespDtoRestResponse = this.customerQueryApi.queryCustomerByCode(offlineBalanceAccountRespDto.getCustomerCode());
        if (customerRespDtoRestResponse != null && customerRespDtoRestResponse.getData() != null) {
            offlineBalanceAccountRespDto.setSalesmanName(((CustomerRespDto)customerRespDtoRestResponse.getData()).getSalesmanName());
            offlineBalanceAccountRespDto.setMerchantName(((CustomerRespDto)customerRespDtoRestResponse.getData()).getMerchantName());
            offlineBalanceAccountRespDto.setMerchantId(((CustomerRespDto)customerRespDtoRestResponse.getData()).getMerchantId());
        }
    }

    @Override
    public BalanceAccountImportResultDto balanceAccountImport(BalanceAccountImportReqDto importReqDto) {
        String fileUrl = importReqDto.getFileUrl();
        this.logger.info("\u5bfc\u5165\u521d\u59cb\u5316\u4f59\u989durl:{}", (Object)fileUrl);
        AssertUtil.assertNotBlank((String)fileUrl, (String)"\u5bfc\u5165\u7684\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a");
        String orgIdStr = this.headerOrgId();
        this.logger.info("\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\uff1a{}", (Object)orgIdStr);
        AssertUtil.assertNotBlank((String)orgIdStr, (String)"\u8bf7\u6c42\u5934\u7ec4\u7ec7ID\u7f3a\u5931");
        Long merchantId = Long.valueOf(orgIdStr);
        List<Object> importDtos = Lists.newArrayList();
        BalanceAccountImportResultDto resultDto = new BalanceAccountImportResultDto();
        try {
            InputStream is = this.getInputStream(fileUrl);
            ExcelImportResult objectExcelImportResult = EasyPoiExportUtil.importExcel(is, 0, 1, OfflineBalanceAccountImportDto.class);
            importDtos = objectExcelImportResult.getList();
            importDtos = BeanPropertyNullUtil.getAllFieldNullList(importDtos);
            if (CollectionUtils.isEmpty((Collection)importDtos)) {
                throw new com.dtyunxi.cube.commons.exceptions.BizException("\u5bfc\u5165\u7684\u8868\u683c\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u8868\u683c\u540e\u91cd\u65b0\u5bfc\u5165");
            }
            resultDto.setTotalSize(importDtos.size());
            Integer successSize = 0;
            Integer failSize = 0;
            Map<String, Object> customerInfoMap = new HashMap<String, CustomerRespDto>();
            List customerCodeList = importDtos.stream().map(OfflineBalanceAccountImportDto::getCustomerCode).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(customerCodeList)) {
                this.logger.info("\u6839\u636e\u5ba2\u6237code\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u5f00\u59cb\u65f6\u95f4\uff1a" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                RestResponse customerRest = this.customerQueryApi.queryCustomerListByCodes(customerCodeList);
                this.logger.info("\u6839\u636e\u5ba2\u6237code\u67e5\u8be2\u5ba2\u6237\u4fe1\u606f\u7ed3\u675f\u65f6\u95f4\uff1a" + DateUtil.getDateFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                if (null != customerRest && null != customerRest.getData()) {
                    List list = (List)customerRest.getData();
                    customerInfoMap = list.stream().collect(Collectors.toMap(CustomerRespDto::getCode, Function.identity(), (k1, k2) -> k1));
                }
            }
            for (OfflineBalanceAccountImportDto offlineBalanceAccountImportDto : importDtos) {
                offlineBalanceAccountImportDto.setMerchantId(merchantId);
                this.checkImportDto(offlineBalanceAccountImportDto, customerInfoMap);
                if (this.addBalanceAccountAndFlow(offlineBalanceAccountImportDto)) {
                    successSize = successSize + 1;
                    continue;
                }
                failSize = failSize + 1;
            }
            resultDto.setSuccessSize(successSize.intValue());
            resultDto.setFailSize(failSize.intValue());
        }
        catch (Exception e) {
            throw new com.dtyunxi.cube.commons.exceptions.BizException("\u5bfc\u5165\u521d\u59cb\u5316\u4f59\u989d\u89e3\u6790\u5931\u8d25\uff1a" + e.getMessage());
        }
        List list = importDtos.stream().filter(dto -> org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dto.getErrorReason())).collect(Collectors.toList());
        resultDto.setFailSize(list.size());
        if (CollectionUtils.isNotEmpty(list)) {
            String title = "\u5bfc\u5165\u521d\u59cb\u5316\u4f59\u989d\u8fd4\u56de\u7ed3\u679c";
            String fileName = title + System.currentTimeMillis();
            try {
                String exportUrl = EasyPoiExportUtil.getExportUrl(list, OfflineBalanceAccountImportDto.class, null, fileName, "xls");
                resultDto.setErrorFileUrl(exportUrl);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new com.dtyunxi.cube.commons.exceptions.BizException("\u5bfc\u51fa\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
        return resultDto;
    }

    private InputStream getInputStream(String fileUrl) throws IOException {
        URL url = new URL(fileUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        return conn.getInputStream();
    }

    private void checkImportDto(OfflineBalanceAccountImportDto dto, Map<String, CustomerRespDto> customerInfoMap) {
        StringBuilder errorMsg = new StringBuilder();
        if (StringUtils.isEmpty((String)dto.getCustomerCode())) {
            errorMsg.append("\u5ba2\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a;");
        } else if (customerInfoMap.isEmpty() || !customerInfoMap.containsKey(dto.getCustomerCode())) {
            errorMsg.append("\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728;");
        } else {
            CustomerRespDto customerRespDto = customerInfoMap.get(dto.getCustomerCode());
            dto.setCustomerId(customerRespDto.getId());
            Long customerMerchantId = customerRespDto.getMerchantId() == null ? 0L : customerRespDto.getMerchantId();
            if (dto.getMerchantId().compareTo(customerMerchantId) != 0) {
                errorMsg.append("\u5ba2\u6237\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u5339\u914d;");
            } else if (StringUtils.isNotEmpty((String)dto.getCustomerName()) && !Objects.equals(customerRespDto.getName(), dto.getCustomerName())) {
                errorMsg.append("\u5ba2\u6237\u540d\u79f0\u586b\u5199\u4e0d\u6b63\u786e;");
            }
        }
        if (StringUtils.isEmpty((String)dto.getCustomerName())) {
            errorMsg.append("\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;");
        }
        if (StringUtils.isEmpty((String)dto.getAccountBalanceStr())) {
            errorMsg.append("\u521d\u59cb\u5316\u4f59\u989d\u4e0d\u80fd\u4e3a\u7a7a;");
        } else if (!this.checkAmount(dto.getAccountBalanceStr())) {
            errorMsg.append("\u521d\u59cb\u5316\u4f59\u989d\u683c\u5f0f\u4e0d\u6b63\u786e;");
        } else {
            dto.setAccountBalance(new BigDecimal(dto.getAccountBalanceStr()));
        }
        if (dto.getCustomerId() == null) {
            errorMsg.append("\u5ba2\u6237code\u67e5\u8be2id\u4e0d\u5b58\u5728;");
        }
        dto.setErrorReason(errorMsg.toString());
    }

    private boolean checkAmount(String str) {
        String pattern = "^[0-9]+(.[0-9]{1,2})?$";
        return Pattern.matches(pattern, str);
    }

    private boolean addBalanceAccountAndFlow(OfflineBalanceAccountImportDto dto) {
        int updateCount;
        if (StringUtils.isNotEmpty((String)dto.getErrorReason())) {
            return false;
        }
        OfflineBalanceAccountEo queryOfflineBalanceAccountEo = new OfflineBalanceAccountEo();
        queryOfflineBalanceAccountEo.setCustomerCode(dto.getCustomerCode());
        OfflineBalanceAccountEo offlineBalanceAccountEo = (OfflineBalanceAccountEo)this.offlineBalanceAccountDas.selectOne((BaseEo)queryOfflineBalanceAccountEo);
        BigDecimal accountBalance = dto.getAccountBalance() == null ? BigDecimal.ZERO : dto.getAccountBalance();
        OfflineBalanceFlowEo offlineBalanceFlowEo = new OfflineBalanceFlowEo();
        BigDecimal changeAmount = BigDecimal.ZERO;
        if (offlineBalanceAccountEo != null) {
            BigDecimal oldAccountBalance = offlineBalanceAccountEo.getAccountBalance() == null ? BigDecimal.ZERO : offlineBalanceAccountEo.getAccountBalance();
            OfflineBalanceAccountEo updateOfflineBalanceAccountEo = new OfflineBalanceAccountEo();
            updateOfflineBalanceAccountEo.setAccountBalance(accountBalance);
            updateOfflineBalanceAccountEo.setId(offlineBalanceAccountEo.getId());
            updateCount = this.offlineBalanceAccountDas.updateSelective((BaseEo)updateOfflineBalanceAccountEo);
            offlineBalanceFlowEo.setBeforeAmount(oldAccountBalance);
            offlineBalanceFlowEo.setOfflineBalanceAccountId(offlineBalanceAccountEo.getId());
            BigDecimal subAmount = oldAccountBalance.subtract(accountBalance);
            if (subAmount.compareTo(BigDecimal.ZERO) > 0) {
                changeAmount = subAmount;
                offlineBalanceFlowEo.setFlowBudgetType("EXPEND");
            } else {
                changeAmount = subAmount.negate();
                offlineBalanceFlowEo.setFlowBudgetType("INCOME");
            }
        } else {
            OfflineBalanceAccountEo addOfflineBalanceAccountEo = new OfflineBalanceAccountEo();
            addOfflineBalanceAccountEo.setCustomerCode(dto.getCustomerCode());
            addOfflineBalanceAccountEo.setCustomerName(dto.getCustomerName());
            addOfflineBalanceAccountEo.setCreateTime(new Date());
            addOfflineBalanceAccountEo.setAccountStatus("ENABLED");
            addOfflineBalanceAccountEo.setCustomerId(dto.getCustomerId());
            addOfflineBalanceAccountEo.setMerchantId(dto.getMerchantId());
            addOfflineBalanceAccountEo.setAccountCode("YEZH" + dto.getCustomerCode());
            addOfflineBalanceAccountEo.setAgentUse(OfflineBalanceAccountEnum.ENABLED.getValue());
            addOfflineBalanceAccountEo.setAgentView(OfflineBalanceAccountEnum.ENABLED.getValue());
            addOfflineBalanceAccountEo.setAccountBalance(accountBalance);
            updateCount = this.offlineBalanceAccountDas.insert((BaseEo)addOfflineBalanceAccountEo);
            offlineBalanceFlowEo.setBeforeAmount(BigDecimal.ZERO);
            changeAmount = accountBalance;
            offlineBalanceFlowEo.setOfflineBalanceAccountId(addOfflineBalanceAccountEo.getId());
            offlineBalanceFlowEo.setFlowBudgetType("INCOME");
        }
        if (updateCount > 0) {
            offlineBalanceFlowEo.setAfterAmount(accountBalance);
            offlineBalanceFlowEo.setChangeAmount(changeAmount);
            offlineBalanceFlowEo.setChangeTime(new Date());
            offlineBalanceFlowEo.setFlowTradeType(OfflineBalanceFlowEnum.INITIALIZATION.getValue());
            offlineBalanceFlowEo.setRelationNo(UUID.randomUUID().toString());
            return this.offlineBalanceFlowDas.insert((BaseEo)offlineBalanceFlowEo) > 0;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public OfflineBalanceFlowRespDto offlineBalanceAccountRollBack(OfflineBalanceAccountRollBackReqDto offlineBalanceAccountRollBackReqDto) {
        this.logger.info("\u8c03\u7528\u8d26\u6237\u56de\u6eda\u8bf7\u6c42\uff0c\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)offlineBalanceAccountRollBackReqDto));
        OfflineBalanceAccountEo offlineBalanceAccountEo = new OfflineBalanceAccountEo();
        offlineBalanceAccountEo.setCustomerId(offlineBalanceAccountRollBackReqDto.getCustomerId());
        OfflineBalanceAccountEo exitAccount = (OfflineBalanceAccountEo)this.offlineBalanceAccountDas.selectOne((BaseEo)offlineBalanceAccountEo);
        OfflineBalanceFlowRespDto reslutDto = new OfflineBalanceFlowRespDto();
        if (Objects.isNull(exitAccount)) {
            this.logger.info("\u67e5\u8be2\u4e0d\u5230\u8be5\u7528\u6237\u8d26\u6237:{}", (Object)offlineBalanceAccountRollBackReqDto.getCustomerId());
            throw new BizException("\u67e5\u8be2\u4e0d\u5230\u8be5\u7528\u6237\u8d26\u6237");
        }
        OfflineBalanceFlowEo offlineBalanceFlowEo = new OfflineBalanceFlowEo();
        offlineBalanceFlowEo.setOfflineBalanceAccountId(exitAccount.getId());
        offlineBalanceFlowEo.setRelationNo(offlineBalanceAccountRollBackReqDto.getRelationNo());
        offlineBalanceFlowEo.setFlowTradeType(OfflineBalanceFlowEnum.ORDER_ROLL_BACK.getValue());
        OfflineBalanceFlowEo rollBackOfflineBalanceFlow = (OfflineBalanceFlowEo)this.offlineBalanceFlowDas.selectOne((BaseEo)offlineBalanceFlowEo);
        if (ObjectUtils.isNotEmpty((Object)rollBackOfflineBalanceFlow)) {
            this.logger.info("\u8be5\u7b14\u8ba2\u5355\u5df2\u56de\u6eda:{}", (Object)offlineBalanceAccountRollBackReqDto.getRelationNo());
            throw new BizException("\u8be5\u7b14\u8ba2\u5355\u5df2\u56de\u6eda");
        }
        offlineBalanceFlowEo = new OfflineBalanceFlowEo();
        offlineBalanceFlowEo.setOfflineBalanceAccountId(exitAccount.getId());
        offlineBalanceFlowEo.setRelationNo(offlineBalanceAccountRollBackReqDto.getRelationNo());
        offlineBalanceFlowEo.setFlowTradeType(OfflineBalanceFlowEnum.ORDER_TRANSFER.getValue());
        OfflineBalanceFlowEo orderTransferOfflineBalanceFlow = (OfflineBalanceFlowEo)this.offlineBalanceFlowDas.selectOne((BaseEo)offlineBalanceFlowEo);
        if (ObjectUtils.isNotEmpty((Object)orderTransferOfflineBalanceFlow)) {
            BigDecimal changeAmount;
            OfflineBalanceAccountEo updateOfflineBalanceAccountEo = new OfflineBalanceAccountEo();
            updateOfflineBalanceAccountEo.setId(exitAccount.getId());
            BigDecimal accountBalance = exitAccount.getAccountBalance() == null ? BigDecimal.ZERO : exitAccount.getAccountBalance();
            BigDecimal bigDecimal = changeAmount = orderTransferOfflineBalanceFlow.getChangeAmount() == null ? BigDecimal.ZERO : orderTransferOfflineBalanceFlow.getChangeAmount();
            if (Objects.equals(orderTransferOfflineBalanceFlow.getFlowBudgetType(), "INCOME")) {
                changeAmount = changeAmount.negate();
            }
            updateOfflineBalanceAccountEo.setAccountBalance(accountBalance.add(changeAmount));
            int updateCount = this.offlineBalanceAccountDas.updateSelective((BaseEo)updateOfflineBalanceAccountEo);
            if (updateCount > 0) {
                OfflineBalanceFlowEo updateOfflineBalanceFlowEo = new OfflineBalanceFlowEo();
                BeanUtils.copyProperties((Object)orderTransferOfflineBalanceFlow, (Object)updateOfflineBalanceFlowEo, (String[])new String[]{"id"});
                updateOfflineBalanceFlowEo.setFlowTradeType(OfflineBalanceFlowEnum.ORDER_ROLL_BACK.getValue());
                updateOfflineBalanceFlowEo.setChangeAmount(changeAmount);
                updateOfflineBalanceFlowEo.setBeforeAmount(exitAccount.getAccountBalance());
                updateOfflineBalanceFlowEo.setAfterAmount(updateOfflineBalanceAccountEo.getAccountBalance());
                this.offlineBalanceFlowDas.insert((BaseEo)updateOfflineBalanceFlowEo);
                BeanUtils.copyProperties((Object)updateOfflineBalanceFlowEo, (Object)reslutDto);
            }
        }
        return reslutDto;
    }

    @Override
    public OfflineBalanceGroupRespDto queryBalanceAccountByOrgId() {
        OfflineBalanceGroupRespDto result = new OfflineBalanceGroupRespDto();
        result.setTotalAmount(BigDecimal.ZERO);
        Long userId = this.context.userId();
        List customers = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryCustomerIdsByUserId(userId));
        this.logger.info("\u5ba2\u6237id\uff1a{}", (Object)JSON.toJSONString((Object)customers));
        List customerRespDtoList = (List)RestResponseHelper.extractData((RestResponse)this.customerExtQueryApi.queryListByCustomerIds(customers));
        Map<Long, CustomerRespDto> customerHashMap = customerRespDtoList.stream().collect(Collectors.toMap(BaseRespDto::getId, item -> item, (oldVal, newVal) -> newVal));
        List merchantIds = customerRespDtoList.stream().map(CustomerRespDto::getMerchantId).collect(Collectors.toList());
        CustomerSearchReqDto searchReqDto = new CustomerSearchReqDto();
        searchReqDto.setOrgInfoIds(merchantIds);
        RestResponse merchantResponse = this.customerExtQueryApi.queryByList(JSON.toJSONString((Object)searchReqDto));
        List merchantList = (List)RestResponseHelper.extractData((RestResponse)merchantResponse);
        Map<Long, CustomerRespDto> merchantHashMap = merchantList.stream().collect(Collectors.toMap(CustomerRespDto::getOrgInfoId, item -> item, (oldVal, newVal) -> newVal));
        List<OfflineBalanceAccountRespDto> balanceAccountList = this.accountByCustomerId(customers);
        if (CollectionUtils.isEmpty(balanceAccountList)) {
            return result;
        }
        for (OfflineBalanceAccountRespDto dto : balanceAccountList) {
            CustomerRespDto merchantDto;
            CustomerRespDto customerRespDto = customerHashMap.get(dto.getCustomerId());
            if (customerRespDto == null || (merchantDto = merchantHashMap.get(customerRespDto.getMerchantId())) == null) continue;
            dto.setMerchantId(merchantDto.getOrgInfoId());
            dto.setMerchantName(merchantDto.getName());
        }
        BigDecimal totalAmount = balanceAccountList.stream().map(OfflineBalanceAccountRespDto::getAccountBalance).reduce(BigDecimal.ZERO, BigDecimal::add);
        result.setTotalAmount(totalAmount);
        result.setCustomerBalanceList(balanceAccountList);
        return result;
    }
}

