/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.rebate.biz.service.impl;

import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.google.common.collect.Sets;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.icommerce.utils.RestResponseHelper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.BaseRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.dto.response.CustomerRespDto;
import com.dtyunxi.yundt.cube.center.customer.api.customer.query.ICustomerExtQueryApi;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.CustomerDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yx.tcbj.center.customer.api.query.ICustomerQueryApi;
import com.yx.tcbj.center.rebate.api.dto.request.BatchReturnsQuotaConfigSpecialReqDto;
import com.yx.tcbj.center.rebate.api.dto.request.ReturnQuotaImportReqDto;
import com.yx.tcbj.center.rebate.api.dto.request.ReturnQuotaInfoReqDto;
import com.yx.tcbj.center.rebate.api.dto.request.ReturnsQuotaConfigSpecialReqDto;
import com.yx.tcbj.center.rebate.api.dto.response.ReturnQuotaImportRespDto;
import com.yx.tcbj.center.rebate.api.dto.response.ReturnQuotaInfoRespDto;
import com.yx.tcbj.center.rebate.api.dto.response.ReturnsQuotaConfigSpecialRespDto;
import com.yx.tcbj.center.rebate.biz.service.IReturnsQuotaConfigSpecialService;
import com.yx.tcbj.center.rebate.biz.utils.BeanPropertyNullUtil;
import com.yx.tcbj.center.rebate.biz.utils.EasyPoiExportUtil;
import com.yx.tcbj.center.rebate.dao.das.ReturnsQuotaConfigSpecialDas;
import com.yx.tcbj.center.rebate.dao.eo.ReturnsQuotaConfigSpecialEo;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReturnsQuotaConfigSpecialServiceImpl
implements IReturnsQuotaConfigSpecialService {
    private static final Logger logger = LoggerFactory.getLogger(ReturnsQuotaConfigSpecialServiceImpl.class);
    private static final Integer pageSize = 1000;
    @Resource
    private ReturnsQuotaConfigSpecialDas returnsQuotaConfigSpecialDas;
    @Resource
    private ICustomerExtQueryApi customerExtQueryApi;
    @Resource
    private ICustomerQueryApi customerQueryApi;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchAddReturnsQuotaConfigSpecial(BatchReturnsQuotaConfigSpecialReqDto reqDto) {
        ArrayList<ReturnsQuotaConfigSpecialEo> eoList = new ArrayList<ReturnsQuotaConfigSpecialEo>();
        List customerIds = reqDto.getCustomerDtoList().stream().map(CustomerDto::getCustomerId).collect(Collectors.toList());
        ReturnsQuotaConfigSpecialEo returnsQuotaConfigSpecialEo = new ReturnsQuotaConfigSpecialEo();
        ArrayList<SqlFilter> list = new ArrayList<SqlFilter>();
        list.add(SqlFilter.in((String)"customer_id", customerIds));
        returnsQuotaConfigSpecialEo.setSqlFilters(list);
        List configSpecialEoList = this.returnsQuotaConfigSpecialDas.select((BaseEo)returnsQuotaConfigSpecialEo);
        for (CustomerDto customer : reqDto.getCustomerDtoList()) {
            boolean isNew = true;
            if (CollectionUtil.isNotEmpty((Collection)configSpecialEoList)) {
                for (ReturnsQuotaConfigSpecialEo eo : configSpecialEoList) {
                    if (customer.getCustomerId().longValue() != eo.getCustomerId().longValue()) continue;
                    isNew = false;
                    eo.setScale(reqDto.getScale());
                    this.returnsQuotaConfigSpecialDas.update((BaseEo)eo);
                    break;
                }
            }
            if (!isNew) continue;
            ReturnsQuotaConfigSpecialEo eo = new ReturnsQuotaConfigSpecialEo();
            eo.setCustomerId(customer.getCustomerId());
            eo.setScale(reqDto.getScale());
            eoList.add(eo);
        }
        this.returnsQuotaConfigSpecialDas.insertBatch(eoList);
    }

    @Override
    public void modifyReturnsQuotaConfigSpecial(ReturnsQuotaConfigSpecialReqDto modifyReqDto) {
        ReturnsQuotaConfigSpecialEo returnsQuotaConfigSpecialEo = new ReturnsQuotaConfigSpecialEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)returnsQuotaConfigSpecialEo);
        this.returnsQuotaConfigSpecialDas.updateSelective((BaseEo)returnsQuotaConfigSpecialEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeReturnsQuotaConfigSpecial(List<Long> ids) {
        this.returnsQuotaConfigSpecialDas.logicDeleteByIds(ids);
    }

    @Override
    public PageInfo<ReturnsQuotaConfigSpecialRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        List ids = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerIds());
        if (CollectionUtil.isEmpty((Collection)ids)) {
            return new PageInfo(new ArrayList());
        }
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"customer_id", (Object)ids));
        ReturnsQuotaConfigSpecialReqDto returnsQuotaConfigSpecialReqDto = (ReturnsQuotaConfigSpecialReqDto)JSON.parseObject((String)filter, ReturnsQuotaConfigSpecialReqDto.class);
        ReturnsQuotaConfigSpecialEo returnsQuotaConfigSpecialEo = new ReturnsQuotaConfigSpecialEo();
        DtoHelper.dto2Eo((BaseVo)returnsQuotaConfigSpecialReqDto, (BaseEo)returnsQuotaConfigSpecialEo);
        returnsQuotaConfigSpecialEo.setSqlFilters(sqlFilters);
        returnsQuotaConfigSpecialEo.setOrderByDesc("create_time");
        PageInfo eoPageInfo = this.returnsQuotaConfigSpecialDas.selectPage((BaseEo)returnsQuotaConfigSpecialEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ReturnsQuotaConfigSpecialRespDto.class);
        List customerIds = dtoList.stream().map(ReturnsQuotaConfigSpecialRespDto::getCustomerId).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(customerIds)) {
            Map map = StringUtils.isNotEmpty((CharSequence)filter) ? (Map)JSON.parseObject((String)filter, Map.class) : new HashMap();
            map.put("idList", customerIds);
            map.put("type", 3);
            map.put("channel", 2);
            filter = JSON.toJSONString(map);
            RestResponse pageInfoRestResponse = this.customerExtQueryApi.queryByPage(filter, Integer.valueOf(1), Integer.valueOf(1000));
            if (CollectionUtil.isNotEmpty((Collection)((PageInfo)pageInfoRestResponse.getData()).getList())) {
                block0: for (ReturnsQuotaConfigSpecialRespDto dto : dtoList) {
                    for (CustomerRespDto customer : ((PageInfo)pageInfoRestResponse.getData()).getList()) {
                        if (dto.getCustomerId().longValue() != customer.getId().longValue()) continue;
                        dto.setCustomerName(customer.getName());
                        dto.setCustomerCode(customer.getCode());
                        dto.setCustomerTypeName(customer.getCustomerTypeName());
                        dto.setCustomerRegionName(customer.getRegionNames());
                        continue block0;
                    }
                }
            }
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public ReturnQuotaImportRespDto returnsConfigSpecialImport(ReturnQuotaImportReqDto returnQuotaImportReqDto) {
        ReturnQuotaImportRespDto returnQuotaImportRespDto = new ReturnQuotaImportRespDto();
        returnQuotaImportRespDto.setOrganizationId(returnQuotaImportReqDto.getOrganizationId());
        try {
            InputStream is = EasyPoiExportUtil.getInputStream(returnQuotaImportReqDto.getFileUrl());
            ImportParams params = new ImportParams();
            params.setTitleRows(0);
            params.setHeadRows(1);
            List importList = ExcelImportUtil.importExcel((InputStream)is, ReturnQuotaInfoReqDto.class, (ImportParams)params);
            importList = BeanPropertyNullUtil.getAllFieldNullList(importList);
            if (CollectionUtil.isEmpty(importList)) {
                throw new BizException("\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            }
            AtomicInteger lineNo = new AtomicInteger(1);
            ArrayList errorList = Lists.newArrayList();
            HashSet singleCustomerCodes = Sets.newHashSet();
            List finalImportList = importList;
            Stream.iterate(0, n -> n + 1).limit(ReturnsQuotaConfigSpecialServiceImpl.getCount(importList.size()).intValue()).forEach(page -> {
                List<ReturnQuotaInfoReqDto> list = finalImportList.stream().skip(page * pageSize).limit(pageSize.intValue()).collect(Collectors.toList());
                this.executeImport(returnQuotaImportReqDto.getOrganizationId(), list, errorList, singleCustomerCodes, lineNo);
            });
            if (CollectionUtil.isNotEmpty((Collection)errorList)) {
                returnQuotaImportRespDto.setFailNum(Integer.valueOf(errorList.size()));
                String title = "\u7279\u6b8a\u989d\u5ea6\u914d\u7f6e\u9519\u8bef\u4fe1\u606f";
                String fileName = title + DateUtil.getDateFormat((Date)new Date(), (String)"yyyyMMddHHmmssSSS");
                String exportUrl = EasyPoiExportUtil.getExportUrl(errorList, ReturnQuotaInfoRespDto.class, null, fileName, "xls");
                returnQuotaImportRespDto.setErrorFile(exportUrl);
            }
            returnQuotaImportRespDto.setNum(Integer.valueOf(importList.size()));
            returnQuotaImportRespDto.setSuccessNum(Integer.valueOf(returnQuotaImportRespDto.getNum() - returnQuotaImportRespDto.getFailNum()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("\u6587\u4ef6\u89e3\u6790\u5931\u8d25\uff0c" + e.getMessage());
        }
        return returnQuotaImportRespDto;
    }

    private void executeImport(Long organizationId, List<ReturnQuotaInfoReqDto> list, List<ReturnQuotaInfoRespDto> errorList, Set<String> singleCustomerCodes, AtomicInteger lineNo) {
        List customerRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.customerQueryApi.queryCustomerListByCodes(list.stream().map(ReturnQuotaInfoReqDto::getCustomerCode).filter(Objects::nonNull).collect(Collectors.toList())));
        Map customerRespDtoMap = customerRespDtos.stream().collect(Collectors.toMap(CustomerRespDto::getCode, Function.identity(), (e1, e2) -> e1));
        Map<Object, Object> specialEoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty((Collection)customerRespDtos)) {
            List customerIds = customerRespDtos.stream().map(BaseRespDto::getId).collect(Collectors.toList());
            List specialEos = ((ExtQueryChainWrapper)this.returnsQuotaConfigSpecialDas.filter().in((Object)"customer_id", customerIds)).list();
            specialEoMap = specialEos.stream().collect(Collectors.toMap(ReturnsQuotaConfigSpecialEo::getCustomerId, Function.identity(), (e1, e2) -> e1));
        }
        ArrayList addEos = Lists.newArrayList();
        for (ReturnQuotaInfoReqDto returnQuotaInfoReqDto : list) {
            StringBuilder sb = new StringBuilder(80);
            if (!singleCustomerCodes.add(returnQuotaInfoReqDto.getCustomerCode())) {
                sb.append("\u5bfc\u5165\u5ba2\u6237\u7f16\u53f7\u91cd\u590d\uff1b");
            }
            if (StringUtil.isEmpty((String)returnQuotaInfoReqDto.getCustomerCode())) {
                sb.append("\u5ba2\u6237\u7f16\u53f7\u4e3a\u7a7a\uff1b");
            }
            if (!NumberUtil.isNumber((CharSequence)returnQuotaInfoReqDto.getRate())) {
                sb.append("\u9000\u8d27\u989d\u5ea6\u6bd4\u4f8b\u5fc5\u987b\u8f93\u5165\u6570\u5b57\uff1b");
            } else {
                BigDecimal rate = new BigDecimal(returnQuotaInfoReqDto.getRate());
                if (rate.compareTo(BigDecimal.ZERO) <= 0) {
                    sb.append("\u9000\u8d27\u989d\u5ea6\u6bd4\u4f8b\u5fc5\u987b\u4e3a\u6b63\u6574\u6570\u5e76\u4e14\u5c0f\u4e8e\u7b49\u4e8e100\uff1b");
                }
                if (rate.stripTrailingZeros().scale() > 2) {
                    sb.append("\u9000\u8d27\u989d\u5ea6\u6bd4\u4f8b\u4e0d\u80fd\u5927\u4e8e\u4e24\u4f4d\u5c0f\u6570\uff1b");
                }
                if (rate.compareTo(new BigDecimal("100")) > 0) {
                    sb.append("\u9000\u8d27\u989d\u5ea6\u6bd4\u4f8b\u4e0d\u80fd\u5927\u4e8e100%\uff1b");
                }
            }
            CustomerRespDto customerRespDto = (CustomerRespDto)customerRespDtoMap.get(returnQuotaInfoReqDto.getCustomerCode());
            if (customerRespDto == null || !Objects.equals(customerRespDto.getMerchantId(), organizationId)) {
                sb.append("\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728\uff1b");
            }
            if (StringUtil.isBlank((String)sb.toString())) {
                BigDecimal rate = new BigDecimal(returnQuotaInfoReqDto.getRate());
                ReturnsQuotaConfigSpecialEo configSpecialEo = (ReturnsQuotaConfigSpecialEo)specialEoMap.get(customerRespDto.getId());
                if (configSpecialEo != null) {
                    configSpecialEo.setScale(rate);
                    this.returnsQuotaConfigSpecialDas.updateSelective((BaseEo)configSpecialEo);
                    continue;
                }
                configSpecialEo = new ReturnsQuotaConfigSpecialEo();
                configSpecialEo.setCustomerId(customerRespDto.getId());
                configSpecialEo.setScale(rate);
                addEos.add(configSpecialEo);
                continue;
            }
            ReturnQuotaInfoRespDto returnQuotaInfoRespDto = new ReturnQuotaInfoRespDto();
            BeanUtil.copyProperties((Object)returnQuotaInfoReqDto, (Object)returnQuotaInfoRespDto, (String[])new String[0]);
            returnQuotaInfoRespDto.setErrorMsg(String.format("\u7b2c%s\u884c\u6570\u636e\u9519\u8bef\uff1a%s", lineNo.incrementAndGet(), sb));
            errorList.add(returnQuotaInfoRespDto);
        }
        if (CollectionUtil.isNotEmpty((Collection)addEos)) {
            this.returnsQuotaConfigSpecialDas.insertBatch((List)addEos);
        }
    }

    private static Integer getCount(Integer size) {
        return (pageSize + size - 1) / pageSize;
    }
}

