/*
 * Decompiled with CFR 0.152.
 */
package com.yx.tcbj.center.rebate.dao.das;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.yundt.cube.center.rebate.api.constants.RebateOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.OrderDetailVO;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.request.RebateOrderCountReqDto;
import com.dtyunxi.yundt.cube.center.rebate.api.dto.response.RebateOrderCountRespDto;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.OrderEo;
import com.dtyunxi.yundt.cube.center.rebate.dao.eo.StdOrderEo;
import com.yx.tcbj.center.rebate.api.dto.request.RebateOrderNoOffsetReqDto;
import com.yx.tcbj.center.rebate.dao.das.base.AbstractBaseDas;
import com.yx.tcbj.center.rebate.dao.mapper.OrderV2Mapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;

@Repository(value="orderV2Das")
public class OrderV2Das
extends AbstractBaseDas<OrderEo, Long> {
    @Resource
    private OrderV2Mapper orderV2Mapper;

    public List<OrderEo> getEffectOrderEos(Long userId) {
        Date date = new Date();
        return this.orderV2Mapper.getEffectOrderEos(date, RebateOrderStatusEnum.ISSUED.getCode(), userId);
    }

    public int useBalanceById(Long id, BigDecimal useAmount) {
        return this.orderV2Mapper.useBalanceById(id, useAmount);
    }

    public int releaseBalanceById(Long id, BigDecimal releaseAmount, Integer version, Integer type) {
        return this.orderV2Mapper.releaseBalanceById(id, releaseAmount, version, type);
    }

    public Map<String, List<OrderEo>> getOrderMapByOrderNos(Set<String> rebateNoCollect) {
        OrderEo selectItemOrder = new OrderEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"rebate_no", rebateNoCollect));
        selectItemOrder.setSqlFilters(sqlFilterList);
        selectItemOrder.setOrderBy("effect_end_time");
        List orderEos = this.select((BaseEo)selectItemOrder);
        Map<String, List<OrderEo>> orderEoMapGroupByRebateNo = orderEos.stream().collect(Collectors.groupingBy(StdOrderEo::getRebateNo, Collectors.toList()));
        return orderEoMapGroupByRebateNo;
    }

    public List<OrderDetailVO> selectPageListById(Long id, Long tenantId, Long instanceId) {
        return this.orderV2Mapper.selectPageListById(id, tenantId, instanceId);
    }

    public Integer existOrderByCategoryIds(List<Long> categoryIds) {
        return this.orderV2Mapper.existOrderByCategoryIds(categoryIds);
    }

    public List<OrderEo> selectExpiredOrderEos() {
        Date date = new Date();
        return this.orderV2Mapper.selectExpiredOrderEos(date, RebateOrderStatusEnum.ISSUED.getCode());
    }

    public int useBalanceByCAS(Long id, Integer version, BigDecimal useAmount, Integer type) {
        return this.orderV2Mapper.useBalanceByCAS(id, version, useAmount, type);
    }

    public RebateOrderCountRespDto queryOrderCount(RebateOrderCountReqDto reqDto) {
        return this.orderV2Mapper.queryOrderCount(reqDto);
    }

    public List<OrderEo> selectByUserId(Long userId, Boolean isIncrease) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(StdOrderEo::getUserId, (Object)userId);
        wrapper.eq(StdOrderEo::getStatus, (Object)RebateOrderStatusEnum.ISSUED.getCode());
        wrapper.eq(BaseEo::getDr, (Object)0);
        if (isIncrease.booleanValue()) {
            wrapper.lt(StdOrderEo::getBalance, (Object)0);
        } else {
            wrapper.gt(StdOrderEo::getBalance, (Object)0);
        }
        wrapper.and(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.ge(StdOrderEo::getEffectEndTime, (Object)new Date())).or()).isNull(StdOrderEo::getEffectEndTime);
        });
        wrapper.last("order by effect_end_time is null,effect_end_time asc");
        return this.orderV2Mapper.selectList((Wrapper)wrapper);
    }

    public List<OrderEo> dealNegateMoney(RebateOrderNoOffsetReqDto reqDto) {
        return this.orderV2Mapper.dealNegateMoney(reqDto);
    }
}

