package com.yx.tcbj.center.shop.api.dto.request;

import cn.afterturn.easypoi.excel.annotation.Excel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
* 导入商家是否切换主数据dto
*
* @author jianshi
* @since 2021-11-11
*/
@ApiModel(value = "SellerImportDto", description = "导入商家是否切换主数据dto")
public class SellerImportDto {

    @Excel(name = "*商家编码",orderNum = "1")
    @ApiModelProperty(name = "sellerCode", value = "商家编码")
    private String sellerCode;

    @Excel(name = "*是否切换主数据",orderNum = "2")
    @ApiModelProperty(name = "isSwitchMasterDataStr", value = "是否切换主数据")
    private String isSwitchMasterDataStr;

    @ApiModelProperty(name = "failMsg", value = "失败信息")
    @Excel(name = "失败信息")
    private String failMsg = "数据有误";

    private Long id;
    private Integer isSwitchMasterData;


    public String getSellerCode() {
        return sellerCode;
    }

    public void setSellerCode(String sellerCode) {
        this.sellerCode = sellerCode;
    }

    public String getIsSwitchMasterDataStr() {
        return isSwitchMasterDataStr;
    }

    public void setIsSwitchMasterDataStr(String isSwitchMasterDataStr) {
        this.isSwitchMasterDataStr = isSwitchMasterDataStr;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getIsSwitchMasterData() {
        return isSwitchMasterData;
    }

    public void setIsSwitchMasterData(Integer isSwitchMasterData) {
        this.isSwitchMasterData = isSwitchMasterData;
    }

    public String getFailMsg() {
        return failMsg;
    }

    public void setFailMsg(String failMsg) {
        this.failMsg = failMsg;
    }
}
