package com.yx.tcbj.center.shop.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerRespDto;
import com.github.pagehelper.PageInfo;
import com.yx.tcbj.center.shop.api.dto.request.SellerExtQueryReqDto;
import com.yx.tcbj.center.shop.api.dto.request.SellerOrgQueryReqDto;
import com.yx.tcbj.center.shop.api.dto.response.SellerOrgRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @Author: xiuji
 * @Date: 2022/2/16 4:54 PM
 */
@Api(tags = {"店铺中心：商家管理扩展查询"})
@FeignClient(
        contextId = "com-yx-tcbj-center-shop-api-query-ISellerExpandQueryApi",
        name = "${yundt.cube.center.shop.api.name:yundt-cube-center-shop}",
        path = "/v2/sellerExpand",
        url = "${yundt.cube.center.shop.api:}"
)
public interface ISellerExpandQueryApi {

    /**
     * 批量查询商家信息
     * @param queryReqDto
     * @return
     */
    @PostMapping("/queryBatchSellerList")
    @ApiOperation(value = "批量查询商家信息", notes = "批量查询商家信息")
    RestResponse<List<SellerRespDto>> queryBatchSellerList(@RequestBody SellerExtQueryReqDto queryReqDto);


    /**
     * 主数据多商家维护列表
     * @param queryReqDto
     * @return
     */
    @PostMapping("/querySellerOrgPage")
    @ApiOperation(value = "主数据多商家维护列表", notes = "主数据多商家维护列表")
    RestResponse<List<SellerOrgRespDto>> querySellerOrgPage(@RequestBody SellerOrgQueryReqDto queryReqDto);
}
