package com.yx.demo.center.xx.api.query;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.dto.response.SellerToBListRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;

import java.util.List;

@Api(tags = {"店铺中心: 商家管理（定制）"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-cube-center-shop-api-ISellerExtendsQueryApi",
        name = "${yundt.cube.center.shop.api.name:yundt-cube-center-shop}",
        url = "${yundt.cube.center.shop.api:}",
        path = "/v1/sellerExtends"
)
public interface ISellerExtendsQueryApi {

    /**
     * 获取当前品牌方下的经销商商家集合
     * @return 请求结果
     */
    @GetMapping("/queryByCurrentBrand")
    @ApiOperation(value = "获取当前品牌方下的经销商商家集合", notes = "获取当前品牌方下的经销商商家集合")
    RestResponse<List<SellerToBListRespDto>> queryByCurrentBrand();
}
