package com.yx.tcbj.center.shop.api;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.shop.api.dto.request.SellerAreaDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @Author: xiuji
 * @Date: 2022/2/16 4:54 PM
 */
@Api(tags = {"店铺中心：商家管理扩展"})
@FeignClient(
        name = "${yundt.cube.center.shop.api.name:yundt-cube-center-shop}",
        path = "/v2/sellerExpand",
        url = "${yundt.cube.center.shop.api:}"
)
public interface ISellerExpandApi {

    /**
     * 更新商家销售区域
     * @return
     */
    @PostMapping("/updateSellerAreaBatch")
    @ApiOperation(value = "更新商家销售区域", notes = "更新商家销售区域")
    RestResponse<Void> updateSellerAreaBatch(@RequestBody List<SellerAreaDto> sellerAreaDtoList);


}
