//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by FernFlower decompiler)
//

package com.yx.tcbj.center.shop.api.dto.request;

import com.dtyunxi.vo.BaseVo;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotEmpty;

public class ShopQueryV3Dto extends BaseVo {
    @ApiModelProperty(
            name = "sellerId",
            value = "商户ID"
    )
    private Long sellerId;
    @ApiModelProperty(
            name = "name",
            value = "店铺名称，支持模糊查询，需要自己拼%"
    )
    private String name;
    @ApiModelProperty(
            name = "code",
            value = "店铺编码"
    )
    private String code;
    @ApiModelProperty(
            name = "codes",
            value = "店铺编码列表"
    )
    private @NotEmpty(
            message = "店铺编码列表不能为空"
    ) List<String> codes;
    @ApiModelProperty(
            name = "type",
            value = "店铺类型"
    )
    private Long type;
    @ApiModelProperty(
            name = "manageType",
            value = "运营类型：1-直营；2- 加盟"
    )
    private Integer manageType;
    @ApiModelProperty(
            name = "level",
            value = "店铺等级"
    )
    private Integer level;
    @ApiModelProperty(
            name = "status",
            value = "店铺状态"
    )
    private String status;
    @ApiModelProperty(
            name = "channelCode",
            value = "所属渠道code"
    )
    private String channelCode;
    @ApiModelProperty(
            name = "authStatus",
            value = "店铺授权状态，0：未授权（默认）；1：授权"
    )
    private Integer authStatus;
    @ApiModelProperty(
            name = "tenantId",
            value = "租户ID"
    )
    private Long tenantId;
    @ApiModelProperty(
            name = "instanceId",
            value = "实例ID"
    )
    private Long instanceId;
    @ApiModelProperty(
            name = "isWxacodeDownload",
            value = "店铺是否已经下载过小程序码：1是，0否"
    )
    private Integer isWxacodeDownload;
    @ApiModelProperty(
            name = "updatePerson",
            value = "修改人"
    )
    private String updatePerson;
    @ApiModelProperty(
            name = "updateTimeStart",
            value = "更新开始日期 yyyy-MM-dd HH:mm:ss"
    )
    private String updateTimeStart;
    @ApiModelProperty(
            name = "updateTimeEnd",
            value = "更新结束日期 yyyy-MM-dd HH:mm:ss"
    )
    private String updateTimeEnd;
    @ApiModelProperty(
            name = "provinceCode",
            value = "省编码"
    )
    private String provinceCode;
    @ApiModelProperty(
            name = "cityCode",
            value = "市编码"
    )
    private String cityCode;
    @ApiModelProperty(
            name = "regionCode",
            value = "区编码"
    )
    private String regionCode;
    @ApiModelProperty(
            name = "id",
            value = "店铺id, 修改店铺时必传"
    )
    private Long id;
    @ApiModelProperty(
            name = "organizationName",
            value = "组织名称"
    )
    private String organizationName;
    @ApiModelProperty(
            name = "organizationId",
            value = "组织id"
    )
    private Long organizationId;
    @ApiModelProperty(
            name = "organizationIds",
            value = "组织id-List"
    )
    private List<Long> organizationIdList;
    @ApiModelProperty(
            name = "sellerIdList",
            value = "商户ID-List"
    )
    private List<Long> sellerIdList;
    @ApiModelProperty(
            name = "organizationCode",
            value = "组织code"
    )
    private String organizationCode;
    @ApiModelProperty(
            name = "contactPhone",
            value = "联系电话",
            hidden = true
    )
    private String contactPhone;

    public ShopQueryV3Dto() {
    }

    public Integer getIsWxacodeDownload() {
        return this.isWxacodeDownload;
    }

    public void setIsWxacodeDownload(Integer isWxacodeDownload) {
        this.isWxacodeDownload = isWxacodeDownload;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOrganizationName() {
        return this.organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getContactPhone() {
        return this.contactPhone;
    }

    public void setContactPhone(String contactPhone) {
        this.contactPhone = contactPhone;
    }

    public String getUpdatePerson() {
        return this.updatePerson;
    }

    public void setUpdatePerson(String updatePerson) {
        this.updatePerson = updatePerson;
    }

    public Long getSellerId() {
        return this.sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getLevel() {
        return this.level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getChannelCode() {
        return this.channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public Long getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public Long getType() {
        return this.type;
    }

    public void setType(Long type) {
        this.type = type;
    }

    @JsonIgnore
    public @AssertTrue(
            message = "商户、实例、租户不可同时为NULL"
    ) boolean isLegal() {
        return null != this.sellerId || null != this.tenantId || null != this.instanceId;
    }

    public Integer getManageType() {
        return this.manageType;
    }

    public void setManageType(Integer manageType) {
        this.manageType = manageType;
    }

    public String getUpdateTimeStart() {
        return this.updateTimeStart;
    }

    public void setUpdateTimeStart(String updateTimeStart) {
        this.updateTimeStart = updateTimeStart;
    }

    public String getUpdateTimeEnd() {
        return this.updateTimeEnd;
    }

    public void setUpdateTimeEnd(String updateTimeEnd) {
        this.updateTimeEnd = updateTimeEnd;
    }

    public String getProvinceCode() {
        return this.provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getCityCode() {
        return this.cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getRegionCode() {
        return this.regionCode;
    }

    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }

    public Integer getAuthStatus() {
        return this.authStatus;
    }

    public void setAuthStatus(Integer authStatus) {
        this.authStatus = authStatus;
    }

    public List<String> getCodes() {
        return this.codes;
    }

    public void setCodes(List<String> codes) {
        this.codes = codes;
    }

    public Long getOrganizationId() {
        return this.organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public List<Long> getSellerIdList() {
        return this.sellerIdList;
    }

    public void setSellerIdList(List<Long> sellerIdList) {
        this.sellerIdList = sellerIdList;
    }

    public List<Long> getOrganizationIdList() {
        return this.organizationIdList;
    }

    public void setOrganizationIdList(List<Long> organizationIdList) {
        this.organizationIdList = organizationIdList;
    }

    public String getOrganizationCode() {
        return this.organizationCode;
    }

    public void setOrganizationCode(String organizationCode) {
        this.organizationCode = organizationCode;
    }
}
